/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.network;

import java.io.UnsupportedEncodingException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.HmacUtils;
import org.apache.inlong.sdk.dataproxy.network.ProxysdkException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger logger = LoggerFactory.getLogger(Utils.class);
    private static String userIp = Utils.getLocalIp();

    public static String getLocalIp() {
        if (userIp != null) {
            return userIp;
        }
        String ip = "127.0.0.1";
        try (DatagramSocket socket = new DatagramSocket();){
            socket.connect(InetAddress.getByName("8.8.8.8"), 10002);
            ip = socket.getLocalAddress().getHostAddress();
        }
        catch (Exception ignored) {
            logger.warn("getLocalIp ", (Throwable)ignored);
        }
        userIp = ip;
        return ip;
    }

    public static boolean validLocalIp(String currLocalHost) throws ProxysdkException {
        String ip = "127.0.0.1";
        try (DatagramSocket socket = new DatagramSocket();){
            socket.connect(InetAddress.getByName("8.8.8.8"), 10002);
            ip = socket.getLocalAddress().getHostAddress();
        }
        catch (Exception ex) {
            logger.error("error while get local ip", (Throwable)ex);
        }
        if (!ip.equals(currLocalHost)) {
            logger.warn("ip is not equal {} {}", (Object)currLocalHost, (Object)ip);
        }
        userIp = ip;
        return true;
    }

    public static boolean isNotBlank(String str) {
        return !Utils.isBlank(str);
    }

    public static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static byte[] toBytes(String ipAddr) {
        byte[] ret = new byte[4];
        try {
            String[] ipArr = ipAddr.split("\\.");
            ret[0] = (byte)(Integer.parseInt(ipArr[0]) & 0xFF);
            ret[1] = (byte)(Integer.parseInt(ipArr[1]) & 0xFF);
            ret[2] = (byte)(Integer.parseInt(ipArr[2]) & 0xFF);
            ret[3] = (byte)(Integer.parseInt(ipArr[3]) & 0xFF);
            return ret;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(ipAddr + " is invalid IP");
        }
    }

    public static int bytesToInt(byte[] bytes) {
        int addr = bytes[3] & 0xFF;
        addr |= bytes[2] << 8 & 0xFF00;
        addr |= bytes[1] << 16 & 0xFF0000;
        return addr |= bytes[0] << 24 & 0xFF000000;
    }

    public static String convertListToString(List<String> list, Character ch) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<String> itr = list.iterator();
        sb.append((Object)itr.next());
        while (itr.hasNext()) {
            sb.append(ch).append((Object)itr.next());
        }
        return sb.toString();
    }

    public static String generateSignature(String secureId, long timestamp, int randomValue, String secureKey) {
        Base64 base64 = new Base64();
        byte[] baseStr = base64.encode(HmacUtils.hmacSha1((String)secureKey, (String)(secureId + timestamp + randomValue)));
        String result = "";
        try {
            result = URLEncoder.encode(new String(baseStr), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String getAuthorizenInfo(String secretId, String secretKey, long timestamp, int nonce) {
        String signature = Utils.generateSignature(secretId, timestamp, nonce, secretKey);
        return "manager " + secretId + " " + timestamp + " " + nonce + " " + signature;
    }

    public static String convertSetToString(Set<String> list, Character ch) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<String> itr = list.iterator();
        sb.append((Object)itr.next());
        while (itr.hasNext()) {
            sb.append(ch).append((Object)itr.next());
        }
        return sb.toString();
    }
}

