/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.network;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class TimeScanObject {
    private AtomicInteger count = new AtomicInteger(0);
    private AtomicLong time = new AtomicLong(0L);

    public TimeScanObject() {
        this.count.set(0);
        this.time.set(System.currentTimeMillis());
    }

    public int incrementAndGet() {
        this.time.set(System.currentTimeMillis());
        return this.count.incrementAndGet();
    }

    public long getTime() {
        return this.time.get();
    }

    public void updateCountToZero() {
        long oldValue = this.time.get();
        int oldCnt = this.count.get();
        if (System.currentTimeMillis() > oldValue && this.time.compareAndSet(oldValue, System.currentTimeMillis())) {
            this.count.compareAndSet(oldCnt, 0);
        }
    }

    public int getCurTimeoutCount() {
        return this.count.get();
    }
}

