/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.network;

import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.inlong.dataproxy.shaded.io.netty.channel.ChannelFuture;
import org.apache.inlong.sdk.dataproxy.codec.EncodeObject;
import org.apache.inlong.sdk.dataproxy.common.SendResult;
import org.apache.inlong.sdk.dataproxy.network.NettyClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncMessageCallable
implements Callable<SendResult> {
    private static final Logger logger = LoggerFactory.getLogger(SyncMessageCallable.class);
    private final NettyClient client;
    private final CountDownLatch awaitLatch = new CountDownLatch(1);
    private final EncodeObject encodeObject;
    private final long timeout;
    private final TimeUnit timeUnit;
    private SendResult message;

    public SyncMessageCallable(NettyClient client, EncodeObject encodeObject, long timeout, TimeUnit timeUnit) {
        this.client = client;
        this.encodeObject = encodeObject;
        this.timeout = timeout;
        this.timeUnit = timeUnit;
    }

    public void update(SendResult message) {
        this.message = message;
        this.awaitLatch.countDown();
    }

    @Override
    public SendResult call() throws Exception {
        try {
            ChannelFuture channelFuture = this.client.write(this.encodeObject);
            this.awaitLatch.await(this.timeout, this.timeUnit);
        }
        catch (Exception e) {
            logger.error("SendResult call", (Throwable)e);
            e.printStackTrace();
            return SendResult.UNKOWN_ERROR;
        }
        return this.message;
    }

    public NettyClient getClient() {
        return this.client;
    }
}

