/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.network;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.collections.MapUtils;
import org.apache.inlong.dataproxy.shaded.io.netty.channel.Channel;
import org.apache.inlong.dataproxy.shaded.org.apache.commons.lang3.ObjectUtils;
import org.apache.inlong.dataproxy.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.inlong.sdk.dataproxy.ProxyClientConfig;
import org.apache.inlong.sdk.dataproxy.codec.EncodeObject;
import org.apache.inlong.sdk.dataproxy.common.FileCallback;
import org.apache.inlong.sdk.dataproxy.common.SendMessageCallback;
import org.apache.inlong.sdk.dataproxy.common.SendResult;
import org.apache.inlong.sdk.dataproxy.config.ProxyConfigEntry;
import org.apache.inlong.sdk.dataproxy.network.ClientMgr;
import org.apache.inlong.sdk.dataproxy.network.NettyClient;
import org.apache.inlong.sdk.dataproxy.network.ProxysdkException;
import org.apache.inlong.sdk.dataproxy.network.QueueObject;
import org.apache.inlong.sdk.dataproxy.network.SyncMessageCallable;
import org.apache.inlong.sdk.dataproxy.network.Utils;
import org.apache.inlong.sdk.dataproxy.threads.MetricWorkerThread;
import org.apache.inlong.sdk.dataproxy.threads.TimeoutScanThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sender {
    private static final Logger LOGGER = LoggerFactory.getLogger(Sender.class);
    private final ConcurrentHashMap<Channel, ConcurrentHashMap<String, QueueObject>> callbacks = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, SyncMessageCallable> syncCallables = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, NettyClient> chooseProxy = new ConcurrentHashMap();
    private final ReentrantLock stateLock = new ReentrantLock();
    private final ExecutorService threadPool;
    private final int asyncCallbackMaxSize;
    private final AtomicInteger currentBufferSize = new AtomicInteger(0);
    private final TimeoutScanThread scanThread;
    private final ClientMgr clientMgr;
    private final ProxyClientConfig configure;
    private final boolean isFile;
    private final MetricWorkerThread metricWorker;
    private int clusterId = -1;

    public Sender(ProxyClientConfig configure) throws Exception {
        this(configure, null);
    }

    public Sender(ProxyClientConfig configure, ThreadFactory selfDefineFactory) throws Exception {
        this.configure = configure;
        this.asyncCallbackMaxSize = configure.getTotalAsyncCallbackSize();
        this.threadPool = Executors.newCachedThreadPool();
        this.clientMgr = new ClientMgr(configure, this, selfDefineFactory);
        ProxyConfigEntry proxyConfigEntry = null;
        try {
            proxyConfigEntry = this.clientMgr.getGroupIdConfigureInfo();
            this.setClusterId(proxyConfigEntry.getClusterId());
        }
        catch (Throwable e) {
            if (configure.isReadProxyIPFromLocal()) {
                throw new Exception("Get local proxy configure failure!", e.getCause());
            }
            throw new Exception("Visit manager error!", e.getCause());
        }
        if (!proxyConfigEntry.isInterVisit()) {
            if (!configure.isNeedAuthentication()) {
                throw new Exception("In OutNetwork isNeedAuthentication must be true!");
            }
            if (!configure.isNeedDataEncry()) {
                throw new Exception("In OutNetwork isNeedDataEncry must be true!");
            }
        }
        this.isFile = configure.isFile();
        this.scanThread = new TimeoutScanThread(this.callbacks, this.currentBufferSize, configure, this.clientMgr);
        this.scanThread.start();
        this.metricWorker = new MetricWorkerThread(configure, this);
        this.metricWorker.start();
        LOGGER.info("proxy sdk is starting!");
    }

    private void checkCallbackList() {
        LOGGER.info("checking call back list before close, current size is {}", (Object)this.currentBufferSize.get());
        try {
            for (int count = 0; this.currentBufferSize.get() > 0 && count < 60; ++count) {
                TimeUnit.SECONDS.sleep(1L);
            }
            if (this.currentBufferSize.get() > 0) {
                LOGGER.warn("callback not empty {}, please check it", (Object)this.currentBufferSize.get());
            }
        }
        catch (Exception ex) {
            LOGGER.error("exception while checking callback list", (Throwable)ex);
        }
    }

    public void close() {
        this.checkCallbackList();
        this.scanThread.shutDown();
        this.clientMgr.shutDown();
        this.threadPool.shutdown();
        this.metricWorker.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getExceptionStack(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        String exceptStr = null;
        try {
            e.printStackTrace(pw);
            exceptStr = sw.toString();
        }
        catch (Exception ex) {
            LOGGER.error(this.getExceptionStack(ex));
        }
        finally {
            try {
                pw.close();
                sw.close();
            }
            catch (Exception ex) {
                LOGGER.error(this.getExceptionStack(ex));
            }
        }
        return exceptStr;
    }

    public void notifyCallback(Channel channel, String messageId, SendResult result) {
        LOGGER.debug("Channel = {} , ack messageId = {}", (Object)channel, (Object)messageId);
        if (channel == null) {
            return;
        }
        ConcurrentHashMap<String, QueueObject> callBackMap = this.callbacks.get(channel);
        if (callBackMap == null) {
            return;
        }
        QueueObject callback = callBackMap.remove(messageId);
        if (callback == null) {
            return;
        }
        if (this.isFile) {
            String proxyip = channel.remoteAddress().toString();
            ((FileCallback)callback.getCallback()).onMessageAck(result.toString() + "=" + proxyip.substring(1, proxyip.indexOf(58)));
            this.currentBufferSize.addAndGet(-callback.getSize());
        } else {
            callback.getCallback().onMessageAck(result);
            this.currentBufferSize.decrementAndGet();
        }
    }

    private SendResult syncSendInternalMessage(NettyClient client, EncodeObject encodeObject, String msgUUID, long timeout, TimeUnit timeUnit) throws ExecutionException, InterruptedException, TimeoutException {
        if (client == null) {
            return SendResult.NO_CONNECTION;
        }
        if (this.isNotValidateAttr(encodeObject.getCommonattr(), encodeObject.getAttributes())) {
            LOGGER.error("error attr format {} {}", (Object)encodeObject.getCommonattr(), (Object)encodeObject.getAttributes());
            return SendResult.INVALID_ATTRIBUTES;
        }
        if (encodeObject.getMsgtype() == 7) {
            int groupIdnum = 0;
            int streamIdnum = 0;
            if (encodeObject.getGroupId().equals(this.clientMgr.getGroupId())) {
                groupIdnum = this.clientMgr.getGroupIdNum();
                streamIdnum = this.clientMgr.getStreamIdMap().get(encodeObject.getStreamId()) != null ? this.clientMgr.getStreamIdMap().get(encodeObject.getStreamId()) : 0;
            }
            encodeObject.setGroupIdNum(groupIdnum);
            encodeObject.setStreamIdNum(streamIdnum);
            if (groupIdnum == 0 || streamIdnum == 0) {
                encodeObject.setGroupIdTransfer(false);
            }
        }
        if (this.configure.isNeedDataEncry()) {
            encodeObject.setEncryptEntry(true, this.configure.getUserName(), this.clientMgr.getEncryptConfigEntry());
        } else {
            encodeObject.setEncryptEntry(false, null, null);
        }
        encodeObject.setMsgUUID(msgUUID);
        SyncMessageCallable callable = new SyncMessageCallable(client, encodeObject, timeout, timeUnit);
        this.syncCallables.put(encodeObject.getMessageId(), callable);
        Future<SendResult> future = this.threadPool.submit(callable);
        return future.get(timeout, timeUnit);
    }

    public SendResult syncSendMessage(EncodeObject encodeObject, String msgUUID, long timeout, TimeUnit timeUnit) {
        this.metricWorker.recordNumByKey(encodeObject.getMessageId(), encodeObject.getGroupId(), encodeObject.getStreamId(), Utils.getLocalIp(), encodeObject.getDt(), encodeObject.getPackageTime(), encodeObject.getRealCnt());
        NettyClient client = this.clientMgr.getClient(this.clientMgr.getLoadBalance(), encodeObject);
        SendResult message = null;
        try {
            message = this.syncSendInternalMessage(client, encodeObject, msgUUID, timeout, timeUnit);
        }
        catch (InterruptedException e) {
            LOGGER.error("send message error {} ", (Object)this.getExceptionStack(e));
            this.syncCallables.remove(encodeObject.getMessageId());
            return SendResult.THREAD_INTERRUPT;
        }
        catch (ExecutionException e) {
            LOGGER.error("ExecutionException {} ", (Object)this.getExceptionStack(e));
            this.syncCallables.remove(encodeObject.getMessageId());
            return SendResult.UNKOWN_ERROR;
        }
        catch (TimeoutException e) {
            Channel curChannel;
            NettyClient tmpClient;
            LOGGER.error("TimeoutException {} ", (Object)this.getExceptionStack(e));
            SyncMessageCallable syncMessageCallable = this.syncCallables.remove(encodeObject.getMessageId());
            if (syncMessageCallable != null && (tmpClient = syncMessageCallable.getClient()) != null && (curChannel = tmpClient.getChannel()) != null) {
                LOGGER.error("channel maybe busy {}", (Object)curChannel);
                this.scanThread.addTimeoutChannel(curChannel);
            }
            return SendResult.TIMEOUT;
        }
        catch (Throwable e) {
            LOGGER.error("syncSendMessage exception {} ", (Object)this.getExceptionStack(e));
            this.syncCallables.remove(encodeObject.getMessageId());
            return SendResult.UNKOWN_ERROR;
        }
        if (message == null) {
            this.syncCallables.remove(encodeObject.getMessageId());
            return SendResult.UNKOWN_ERROR;
        }
        if (client != null) {
            this.scanThread.resetTimeoutChannel(client.getChannel());
        }
        if (message == SendResult.OK) {
            this.metricWorker.recordSuccessByMessageId(encodeObject.getMessageId());
        }
        return message;
    }

    private SendResult syncSendMessageIndexInternal(NettyClient client, EncodeObject encodeObject, String msgUUID, long timeout, TimeUnit timeUnit) throws ExecutionException, InterruptedException, TimeoutException {
        if (client == null || !client.isActive()) {
            this.chooseProxy.remove(encodeObject.getMessageId());
            client = this.clientMgr.getClientByRoundRobin();
            if (client == null) {
                return SendResult.NO_CONNECTION;
            }
            this.chooseProxy.put(encodeObject.getMessageId(), client);
        }
        if (encodeObject.getMsgtype() == 7) {
            int groupIdnum = 0;
            int streamIdnum = 0;
            if (encodeObject.getGroupId().equals(this.clientMgr.getGroupId())) {
                groupIdnum = this.clientMgr.getGroupIdNum();
                streamIdnum = this.clientMgr.getStreamIdMap().get(encodeObject.getStreamId()) != null ? this.clientMgr.getStreamIdMap().get(encodeObject.getStreamId()) : 0;
            }
            encodeObject.setGroupIdNum(groupIdnum);
            encodeObject.setStreamIdNum(streamIdnum);
            if (groupIdnum == 0 || streamIdnum == 0) {
                encodeObject.setGroupIdTransfer(false);
            }
        }
        if (this.configure.isNeedDataEncry()) {
            encodeObject.setEncryptEntry(true, this.configure.getUserName(), this.clientMgr.getEncryptConfigEntry());
        } else {
            encodeObject.setEncryptEntry(false, null, null);
        }
        encodeObject.setMsgUUID(msgUUID);
        SyncMessageCallable callable = new SyncMessageCallable(client, encodeObject, timeout, timeUnit);
        this.syncCallables.put(encodeObject.getMessageId(), callable);
        Future<SendResult> future = this.threadPool.submit(callable);
        return future.get(timeout, timeUnit);
    }

    public String syncSendMessageIndex(EncodeObject encodeObject, String msgUUID, long timeout, TimeUnit timeUnit) {
        try {
            SendResult message = null;
            NettyClient client = this.chooseProxy.get(encodeObject.getMessageId());
            String proxyip = encodeObject.getProxyIp();
            if (proxyip != null && proxyip.length() != 0) {
                client = this.clientMgr.getContainProxy(proxyip);
            }
            if (this.isNotValidateAttr(encodeObject.getCommonattr(), encodeObject.getAttributes())) {
                LOGGER.error("error attr format {} {}", (Object)encodeObject.getCommonattr(), (Object)encodeObject.getAttributes());
                return SendResult.INVALID_ATTRIBUTES.toString();
            }
            try {
                message = this.syncSendMessageIndexInternal(client, encodeObject, msgUUID, timeout, timeUnit);
            }
            catch (InterruptedException e) {
                LOGGER.error("send message error {}", (Object)this.getExceptionStack(e));
                this.syncCallables.remove(encodeObject.getMessageId());
                return SendResult.THREAD_INTERRUPT.toString();
            }
            catch (ExecutionException e) {
                LOGGER.error("ExecutionException {}", (Object)this.getExceptionStack(e));
                this.syncCallables.remove(encodeObject.getMessageId());
                return SendResult.UNKOWN_ERROR.toString();
            }
            catch (TimeoutException e) {
                Channel curChannel;
                NettyClient tmpClient;
                LOGGER.error("TimeoutException {}", (Object)this.getExceptionStack(e));
                SyncMessageCallable syncMessageCallable = this.syncCallables.remove(encodeObject.getMessageId());
                if (syncMessageCallable != null && (tmpClient = syncMessageCallable.getClient()) != null && (curChannel = tmpClient.getChannel()) != null) {
                    LOGGER.error("channel maybe busy {}", (Object)curChannel);
                    this.scanThread.addTimeoutChannel(curChannel);
                }
                return SendResult.TIMEOUT.toString();
            }
            catch (Throwable e) {
                LOGGER.error("syncSendMessage exception {}", (Object)this.getExceptionStack(e));
                this.syncCallables.remove(encodeObject.getMessageId());
                return SendResult.UNKOWN_ERROR.toString();
            }
            this.scanThread.resetTimeoutChannel(client.getChannel());
            return message.toString() + "=" + client.getServerIP();
        }
        catch (Exception e) {
            LOGGER.error("agent send error {}", (Object)this.getExceptionStack(e));
            this.syncCallables.remove(encodeObject.getMessageId());
            return SendResult.UNKOWN_ERROR.toString();
        }
    }

    public void asyncSendMessageIndex(EncodeObject encodeObject, FileCallback callback, String msgUUID, long timeout, TimeUnit timeUnit) throws ProxysdkException {
        NettyClient client = this.chooseProxy.get(encodeObject.getMessageId());
        String proxyip = encodeObject.getProxyIp();
        if (proxyip != null && proxyip.length() != 0) {
            client = this.clientMgr.getContainProxy(proxyip);
        }
        if (client == null || !client.isActive()) {
            this.chooseProxy.remove(encodeObject.getMessageId());
            client = this.clientMgr.getClientByRoundRobin();
            if (client == null) {
                throw new ProxysdkException(SendResult.NO_CONNECTION.toString());
            }
            this.chooseProxy.put(encodeObject.getMessageId(), client);
        }
        if (this.currentBufferSize.get() >= this.asyncCallbackMaxSize) {
            throw new ProxysdkException("ASYNC_CALLBACK_BUFFER_FULL");
        }
        int size = 1;
        if (this.isFile) {
            if (encodeObject.getBodyBytes() != null) {
                size = encodeObject.getBodyBytes().length;
            } else {
                for (byte[] bytes : encodeObject.getBodylist()) {
                    size += bytes.length;
                }
            }
            if (this.currentBufferSize.addAndGet(size) >= this.asyncCallbackMaxSize) {
                this.currentBufferSize.addAndGet(-size);
                throw new ProxysdkException("ASYNC_CALLBACK_BUFFER_FULL");
            }
        } else if (this.currentBufferSize.incrementAndGet() >= this.asyncCallbackMaxSize) {
            this.currentBufferSize.decrementAndGet();
            throw new ProxysdkException("ASYNC_CALLBACK_BUFFER_FULL");
        }
        ConcurrentHashMap tmpCallBackMap = new ConcurrentHashMap();
        ConcurrentHashMap<String, QueueObject> msgQueueMap = this.callbacks.putIfAbsent(client.getChannel(), tmpCallBackMap);
        if (msgQueueMap == null) {
            msgQueueMap = tmpCallBackMap;
        }
        msgQueueMap.put(encodeObject.getMessageId(), new QueueObject(System.currentTimeMillis(), callback, size, timeout, timeUnit));
        if (encodeObject.getMsgtype() == 7) {
            int groupIdnum = 0;
            int streamIdnum = 0;
            if (this.clientMgr.getGroupId().length() != 0 && encodeObject.getGroupId().equals(this.clientMgr.getGroupId())) {
                groupIdnum = this.clientMgr.getGroupIdNum();
                streamIdnum = this.clientMgr.getStreamIdMap().get(encodeObject.getStreamId()) != null ? this.clientMgr.getStreamIdMap().get(encodeObject.getStreamId()) : 0;
            }
            encodeObject.setGroupIdNum(groupIdnum);
            encodeObject.setStreamIdNum(streamIdnum);
            if (groupIdnum == 0 || streamIdnum == 0) {
                encodeObject.setGroupIdTransfer(false);
            }
        }
        if (this.configure.isNeedDataEncry()) {
            encodeObject.setEncryptEntry(true, this.configure.getUserName(), this.clientMgr.getEncryptConfigEntry());
        } else {
            encodeObject.setEncryptEntry(false, null, null);
        }
        encodeObject.setMsgUUID(msgUUID);
        client.write(encodeObject);
    }

    private boolean isNotValidateAttr(String commonAttr, String oldAttr) {
        if (!StringUtils.isEmpty(commonAttr) && !this.validAttribute(commonAttr)) {
            return true;
        }
        return !StringUtils.isEmpty(oldAttr) && !this.validAttribute(oldAttr);
    }

    private boolean validAttribute(String attr) {
        boolean needEqual = true;
        boolean needAnd = false;
        for (int i = 0; i < attr.length(); ++i) {
            char item = attr.charAt(i);
            if (item == '=') {
                if (!needEqual) {
                    return false;
                }
                needEqual = false;
                needAnd = true;
                continue;
            }
            if (item != '&') continue;
            if (!needAnd) {
                return false;
            }
            needAnd = false;
            needEqual = true;
        }
        return !needEqual;
    }

    public void asyncSendMessage(EncodeObject encodeObject, SendMessageCallback callback, String msgUUID, long timeout, TimeUnit timeUnit) throws ProxysdkException {
        ConcurrentHashMap msgQueueMap;
        QueueObject queueObject;
        this.metricWorker.recordNumByKey(encodeObject.getMessageId(), encodeObject.getGroupId(), encodeObject.getStreamId(), Utils.getLocalIp(), encodeObject.getPackageTime(), encodeObject.getDt(), encodeObject.getRealCnt());
        NettyClient client = this.clientMgr.getClient(this.clientMgr.getLoadBalance(), encodeObject);
        if (client == null) {
            throw new ProxysdkException(SendResult.NO_CONNECTION.toString());
        }
        if (this.currentBufferSize.get() >= this.asyncCallbackMaxSize) {
            throw new ProxysdkException("ASYNC_CALLBACK_BUFFER_FULL");
        }
        if (this.isNotValidateAttr(encodeObject.getCommonattr(), encodeObject.getAttributes())) {
            LOGGER.error("error attr format {} {}", (Object)encodeObject.getCommonattr(), (Object)encodeObject.getAttributes());
            throw new ProxysdkException(SendResult.INVALID_ATTRIBUTES.toString());
        }
        int size = 1;
        if (this.isFile) {
            if (encodeObject.getBodyBytes() != null) {
                size = encodeObject.getBodyBytes().length;
            } else {
                for (byte[] bytes : encodeObject.getBodylist()) {
                    size += bytes.length;
                }
            }
            if (this.currentBufferSize.addAndGet(size) >= this.asyncCallbackMaxSize) {
                this.currentBufferSize.addAndGet(-size);
                throw new ProxysdkException("ASYNC_CALLBACK_BUFFER_FULL");
            }
        } else if (this.currentBufferSize.incrementAndGet() >= this.asyncCallbackMaxSize) {
            this.currentBufferSize.decrementAndGet();
            throw new ProxysdkException("ASYNC_CALLBACK_BUFFER_FULL");
        }
        if ((queueObject = (msgQueueMap = this.callbacks.computeIfAbsent(client.getChannel(), k -> new ConcurrentHashMap())).putIfAbsent(encodeObject.getMessageId(), new QueueObject(System.currentTimeMillis(), callback, size, timeout, timeUnit))) != null) {
            LOGGER.warn("message id {} has existed.", (Object)encodeObject.getMessageId());
        }
        if (encodeObject.getMsgtype() == 7) {
            int groupIdnum = 0;
            int streamIdnum = 0;
            if (this.clientMgr.getGroupId().length() != 0 && encodeObject.getGroupId().equals(this.clientMgr.getGroupId())) {
                groupIdnum = this.clientMgr.getGroupIdNum();
                streamIdnum = this.clientMgr.getStreamIdMap().get(encodeObject.getStreamId()) != null ? this.clientMgr.getStreamIdMap().get(encodeObject.getStreamId()) : 0;
            }
            encodeObject.setGroupIdNum(groupIdnum);
            encodeObject.setStreamIdNum(streamIdnum);
            if (groupIdnum == 0 || streamIdnum == 0) {
                encodeObject.setGroupIdTransfer(false);
            }
        }
        if (this.configure.isNeedDataEncry()) {
            encodeObject.setEncryptEntry(true, this.configure.getUserName(), this.clientMgr.getEncryptConfigEntry());
        } else {
            encodeObject.setEncryptEntry(false, null, null);
        }
        encodeObject.setMsgUUID(msgUUID);
        client.write(encodeObject);
    }

    public void notifyFeedback(Channel channel, EncodeObject response) {
        String messageId = response.getMessageId();
        this.chooseProxy.remove(messageId);
        SyncMessageCallable callable = this.syncCallables.remove(messageId);
        SendResult result = response.getSendResult();
        if (result == SendResult.OK) {
            this.metricWorker.recordSuccessByMessageId(messageId);
        } else {
            LOGGER.error("{} exception happens, error message {}", (Object)channel, (Object)response.getErrMsg());
        }
        if (callable != null) {
            callable.update(result);
        }
        this.notifyCallback(channel, messageId, result);
    }

    public void notifyConnectionDisconnected(Channel channel) {
        if (channel == null) {
            return;
        }
        LOGGER.info("channel {} connection is disconnected!", (Object)channel);
        try {
            ConcurrentHashMap<String, QueueObject> msgQueueMap = this.callbacks.remove(channel);
            if (msgQueueMap != null) {
                for (String messageId : msgQueueMap.keySet()) {
                    QueueObject queueObject = msgQueueMap.remove(messageId);
                    if (queueObject == null) continue;
                    if (this.isFile) {
                        ((FileCallback)queueObject.getCallback()).onMessageAck(SendResult.CONNECTION_BREAK.toString());
                        this.currentBufferSize.addAndGet(-queueObject.getSize());
                        continue;
                    }
                    queueObject.getCallback().onMessageAck(SendResult.CONNECTION_BREAK);
                    this.currentBufferSize.decrementAndGet();
                }
                msgQueueMap.clear();
            }
        }
        catch (Throwable e2) {
            LOGGER.info("process channel {} disconnected callbacks throw error,", (Object)channel, (Object)e2);
        }
        try {
            for (String messageId : this.syncCallables.keySet()) {
                Channel netChannel1;
                NettyClient nettyClient;
                SyncMessageCallable messageCallable;
                if (messageId == null || (messageCallable = this.syncCallables.get(messageId)) == null || (nettyClient = messageCallable.getClient()) == null || (netChannel1 = nettyClient.getChannel()) == null || !netChannel1.id().equals(channel.id())) continue;
                messageCallable.update(SendResult.CONNECTION_BREAK);
                this.syncCallables.remove(messageId);
                break;
            }
        }
        catch (Throwable e) {
            LOGGER.info("process channel {} disconnected syncCallables throw error,", (Object)channel, (Object)e);
        }
    }

    public void waitForAckForChannel(Channel channel) {
        if (channel == null) {
            return;
        }
        LOGGER.info("wait for ack for channel {}", (Object)channel);
        try {
            ConcurrentHashMap<String, QueueObject> queueObjMap = this.callbacks.get(channel);
            if (queueObjMap != null) {
                while (true) {
                    if (queueObjMap.isEmpty()) {
                        LOGGER.info("this channel {} is empty!", (Object)channel);
                        break;
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        LOGGER.error("wait for ack for channel {}, error {}", (Object)channel, (Object)e.getMessage());
                        e.printStackTrace();
                    }
                }
            }
            LOGGER.info("waitForAckForChannel finished , channel is {}", (Object)channel);
        }
        catch (Throwable e) {
            LOGGER.error("waitForAckForChannel exception, channel is {}", (Object)channel, (Object)e);
        }
    }

    public void clearCallBack() {
        this.currentBufferSize.set(0);
        this.callbacks.clear();
    }

    public int getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(int clusterId) {
        this.clusterId = clusterId;
    }

    public boolean isIdleClient(NettyClient client) {
        Channel channel = client.getChannel();
        if (this.callbacks.contains(channel) && MapUtils.isNotEmpty((Map)this.callbacks.get(channel))) {
            return false;
        }
        for (SyncMessageCallable syncCallBack : this.syncCallables.values()) {
            if (!ObjectUtils.equals(client, syncCallBack.getClient())) continue;
            return false;
        }
        return true;
    }
}

