/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.network;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.inlong.sdk.dataproxy.ConfigConstants;
import org.apache.inlong.sdk.dataproxy.config.HostInfo;
import org.apache.inlong.sdk.dataproxy.utils.ConsistencyHashUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashRing {
    private static final Logger LOGGER = LoggerFactory.getLogger(HashRing.class);
    private static volatile HashRing instance;
    private int virtualNode = ConfigConstants.DEFAULT_VIRTUAL_NODE;
    private TreeMap<String, HostInfo> virtualNode2RealNode = new TreeMap();
    private List<HostInfo> nodeList = new ArrayList<HostInfo>();

    private HashRing() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HashRing getInstance() {
        if (instance != null) return instance;
        Class<HashRing> clazz = HashRing.class;
        synchronized (HashRing.class) {
            if (instance != null) return instance;
            instance = new HashRing();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public TreeMap<String, HostInfo> getVirtualNode2RealNode() {
        return this.virtualNode2RealNode;
    }

    public String node2VirtualNode(HostInfo node, int index) {
        return "virtual&&" + index + "&&" + node.toString();
    }

    public void setVirtualNode(int virtualNode) {
        this.virtualNode = virtualNode;
    }

    public HostInfo getNode(String key) {
        String hash = ConsistencyHashUtil.hashMurMurHash(key);
        SortedMap<String, HostInfo> tailMap = this.virtualNode2RealNode.tailMap(hash);
        HostInfo node = tailMap.isEmpty() ? this.virtualNode2RealNode.get(this.virtualNode2RealNode.firstKey()) : this.virtualNode2RealNode.get(tailMap.firstKey());
        LOGGER.info("{} located to {}", (Object)key, (Object)node);
        return node;
    }

    private synchronized void extendNode(List<HostInfo> nodes) {
        this.nodeList.addAll(nodes);
        for (HostInfo host : this.nodeList) {
            for (int i = 0; i < this.virtualNode; ++i) {
                String key = this.node2VirtualNode(host, i);
                String hash = ConsistencyHashUtil.hashMurMurHash(key);
                this.virtualNode2RealNode.put(hash, host);
            }
        }
        LOGGER.info("append node list {}", nodes);
    }

    private synchronized void removeNode(List<HostInfo> hosts) {
        for (HostInfo host : hosts) {
            this.nodeList.remove(host);
            for (int i = 0; i < this.virtualNode; ++i) {
                String hash = ConsistencyHashUtil.hashMurMurHash(this.node2VirtualNode(host, i));
                this.virtualNode2RealNode.remove(hash);
            }
        }
        LOGGER.info("remove node list {}", hosts);
    }

    public synchronized void updateNode(List<HostInfo> nodes) {
        ArrayList<HostInfo> newHosts = new ArrayList<HostInfo>(nodes);
        ArrayList<HostInfo> oldHosts = new ArrayList<HostInfo>(this.nodeList);
        List<HostInfo> append = newHosts.stream().filter(host -> !oldHosts.contains(host)).collect(Collectors.toList());
        List<HostInfo> remove = oldHosts.stream().filter(host -> !newHosts.contains(host)).collect(Collectors.toList());
        this.extendNode(append);
        this.removeNode(remove);
    }
}

