/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.metric;

import java.util.concurrent.atomic.AtomicLong;

public class MetricTimeNumSummary {
    private final AtomicLong send10msBelow = new AtomicLong(0L);
    private final AtomicLong sendBetween10msAnd100ms = new AtomicLong(0L);
    private final AtomicLong sendBetween100msAnd500ms = new AtomicLong(0L);
    private final AtomicLong sendBetween500msAnd1s = new AtomicLong(0L);
    private final AtomicLong send1sAbove = new AtomicLong(0L);
    private final AtomicLong successNum = new AtomicLong(0L);
    private final AtomicLong failedNum = new AtomicLong(0L);
    private final long startCalculateTime;

    public MetricTimeNumSummary(long startCalculateTime) {
        this.startCalculateTime = startCalculateTime;
    }

    public long getSummaryTime() {
        return System.currentTimeMillis() - this.startCalculateTime;
    }

    public void recordSuccessSendTime(long sendTimeInMs, int sendNum) {
        if (sendTimeInMs < 10L) {
            this.send10msBelow.addAndGet(sendNum);
        } else if (sendTimeInMs < 100L) {
            this.sendBetween10msAnd100ms.addAndGet(sendNum);
        } else if (sendTimeInMs < 500L) {
            this.sendBetween100msAnd500ms.addAndGet(sendNum);
        } else if (sendTimeInMs < 1000L) {
            this.sendBetween500msAnd1s.addAndGet(sendNum);
        } else {
            this.send1sAbove.addAndGet(sendNum);
        }
        this.increaseSuccessNum(sendNum);
    }

    public void increaseSuccessNum(int sendNum) {
        this.successNum.addAndGet(sendNum);
    }

    public void increaseFailedNum(int sendNum) {
        this.failedNum.addAndGet(sendNum);
    }

    public long getFailedNum() {
        return this.failedNum.get();
    }

    public long getSuccessNum() {
        return this.successNum.get();
    }

    public long getTotalNum() {
        return this.failedNum.get() + this.successNum.get();
    }

    public String getTimeString() {
        return this.send10msBelow.get() + "#" + this.sendBetween10msAnd100ms.get() + "#" + this.sendBetween100msAnd500ms.get() + "#" + this.sendBetween500msAnd1s.get() + "#" + this.send1sAbove.get();
    }

    public long getStartCalculateTime() {
        return this.startCalculateTime;
    }
}

