/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.example;

import java.io.UnsupportedEncodingException;
import java.util.concurrent.TimeUnit;
import org.apache.inlong.dataproxy.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.inlong.sdk.dataproxy.DefaultMessageSender;
import org.apache.inlong.sdk.dataproxy.ProxyClientConfig;
import org.apache.inlong.sdk.dataproxy.common.SendResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpClientExample {
    private static final Logger logger = LoggerFactory.getLogger(TcpClientExample.class);
    public static String localIP = "127.0.0.1";

    public static void main(String[] args) throws InterruptedException {
        String inlongGroupId = "test_test";
        String inlongStreamId = "test_test";
        String configBasePath = "/data/inlong/config";
        String inLongManagerAddr = "127.0.0.1";
        String inLongManagerPort = "8000";
        int msgType = 7;
        String messageBody = "inglong-message-random-body!";
        TcpClientExample tcpClientExample = new TcpClientExample();
        DefaultMessageSender sender = tcpClientExample.getMessageSender(localIP, inLongManagerAddr, inLongManagerPort, inlongGroupId, false, false, configBasePath, msgType);
        tcpClientExample.sendTcpMessage(sender, inlongGroupId, inlongStreamId, messageBody, System.currentTimeMillis());
    }

    public DefaultMessageSender getMessageSender(String localIP, String inLongManagerAddr, String inLongManagerPort, String inlongGroupId, boolean isLocalVisit, boolean isReadProxyIPFromLocal, String configBasePath, int msgType) {
        ProxyClientConfig dataProxyConfig = null;
        DefaultMessageSender messageSender = null;
        try {
            dataProxyConfig = new ProxyClientConfig(localIP, isLocalVisit, inLongManagerAddr, Integer.valueOf(inLongManagerPort), inlongGroupId, "test", "123456");
            if (StringUtils.isNotEmpty(configBasePath)) {
                dataProxyConfig.setConfStoreBasePath(configBasePath);
            }
            dataProxyConfig.setReadProxyIPFromLocal(isReadProxyIPFromLocal);
            dataProxyConfig.setProtocolType("TCP");
            messageSender = DefaultMessageSender.generateSenderByClusterId(dataProxyConfig);
            messageSender.setMsgtype(msgType);
        }
        catch (Exception e) {
            logger.error("getMessageSender has exception e = {}", (Throwable)e);
        }
        return messageSender;
    }

    public void sendTcpMessage(DefaultMessageSender sender, String inlongGroupId, String inlongStreamId, String messageBody, long dt) {
        SendResult result = null;
        try {
            result = sender.sendMessage(messageBody.getBytes("utf8"), inlongGroupId, inlongStreamId, 0L, String.valueOf(dt), 20L, TimeUnit.SECONDS);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        logger.info("messageSender {}", result);
    }
}

