/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.example;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.inlong.sdk.dataproxy.DefaultMessageSender;
import org.apache.inlong.sdk.dataproxy.common.SendResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendMsgThread
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(SendMsgThread.class);
    private DefaultMessageSender messageSender = null;

    public SendMsgThread(DefaultMessageSender messageSender) {
        this.messageSender = messageSender;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        FileReader reader = null;
        try {
            reader = new FileReader("/data/work/jessey/d5.txt");
            BufferedReader br = new BufferedReader(reader);
            String line = null;
            while ((line = br.readLine()) != null) {
                long startTime = System.currentTimeMillis();
                SendResult result = this.messageSender.sendMessage("hhhh".getBytes("utf8"), "b_test", "n_test1", 0L, String.valueOf(System.currentTimeMillis()), 1L, TimeUnit.MILLISECONDS);
                long endTime = System.currentTimeMillis();
                if (result == SendResult.OK) {
                    logger.info("this msg is ok time {}", (Object)(endTime - startTime));
                    continue;
                }
                logger.info("this msg is error ,{}", (Object)result);
            }
        }
        catch (Exception e) {
            logger.error("{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

