/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.example;

import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.inlong.sdk.dataproxy.ProxyClientConfig;
import org.apache.inlong.sdk.dataproxy.common.SendMessageCallback;
import org.apache.inlong.sdk.dataproxy.example.MyMessageCallBack;
import org.apache.inlong.sdk.dataproxy.network.HttpProxySender;
import org.apache.inlong.sdk.dataproxy.network.ProxysdkException;

public class HttpClientExample {
    public static void main(String[] args) {
        String inlongGroupId = "test_group_id";
        String inlongStreamId = "test_stream_id";
        String configBasePath = "/data/inlong/dataproxy/conf";
        String inLongManagerAddr = "127.0.0.1";
        String inLongManagerPort = "8080";
        String localIP = "127.0.0.1";
        String messageBody = "inlong message body!";
        HttpProxySender sender = HttpClientExample.getMessageSender(localIP, inLongManagerAddr, inLongManagerPort, inlongGroupId, false, false, configBasePath);
        HttpClientExample.sendHttpMessage(sender, inlongGroupId, inlongStreamId, messageBody);
    }

    public static HttpProxySender getMessageSender(String localIP, String inLongManagerAddr, String inLongManagerPort, String inlongGroupId, boolean isLocalVisit, boolean isReadProxyIPFromLocal, String configBasePath) {
        ProxyClientConfig proxyConfig = null;
        HttpProxySender sender = null;
        try {
            proxyConfig = new ProxyClientConfig(localIP, isLocalVisit, inLongManagerAddr, Integer.valueOf(inLongManagerPort), inlongGroupId, "test", "123456");
            proxyConfig.setInlongGroupId(inlongGroupId);
            proxyConfig.setConfStoreBasePath(configBasePath);
            proxyConfig.setReadProxyIPFromLocal(isReadProxyIPFromLocal);
            proxyConfig.setDiscardOldMessage(true);
            proxyConfig.setProtocolType("HTTP");
            sender = new HttpProxySender(proxyConfig);
        }
        catch (ProxysdkException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sender;
    }

    public static void sendHttpMessage(HttpProxySender sender, String inlongGroupId, String inlongStreamId, String messageBody) {
        ArrayList<String> bodyList = new ArrayList<String>();
        bodyList.add(messageBody);
        sender.asyncSendMessage(bodyList, inlongGroupId, inlongStreamId, System.currentTimeMillis(), 20L, TimeUnit.SECONDS, (SendMessageCallback)new MyMessageCallBack());
    }
}

