/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.config;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.net.ssl.SSLContext;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;
import org.apache.inlong.common.pojo.dataproxy.DataProxyNodeInfo;
import org.apache.inlong.common.pojo.dataproxy.DataProxyNodeResponse;
import org.apache.inlong.common.util.BasicAuth;
import org.apache.inlong.dataproxy.shaded.org.apache.commons.lang3.ObjectUtils;
import org.apache.inlong.dataproxy.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.inlong.sdk.dataproxy.LoadBalance;
import org.apache.inlong.sdk.dataproxy.ProxyClientConfig;
import org.apache.inlong.sdk.dataproxy.config.EncryptConfigEntry;
import org.apache.inlong.sdk.dataproxy.config.HostInfo;
import org.apache.inlong.sdk.dataproxy.config.ProxyClusterConfig;
import org.apache.inlong.sdk.dataproxy.config.ProxyConfigEntry;
import org.apache.inlong.sdk.dataproxy.network.ClientMgr;
import org.apache.inlong.sdk.dataproxy.network.HashRing;
import org.apache.inlong.sdk.dataproxy.network.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyConfigManager
extends Thread {
    public static final String APPLICATION_JSON = "application/json";
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxyConfigManager.class);
    private final ProxyClientConfig clientConfig;
    private final String localIP;
    private final ClientMgr clientManager;
    private final ReentrantReadWriteLock rw = new ReentrantReadWriteLock();
    private final JsonParser jsonParser = new JsonParser();
    private final Gson gson = new Gson();
    private final HashRing hashRing = HashRing.getInstance();
    private List<HostInfo> proxyInfoList = new ArrayList<HostInfo>();
    private int oldStat = 0;
    private String inlongGroupId;
    private String localMd5;
    private boolean bShutDown = false;
    private long doworkTime = 0L;
    private EncryptConfigEntry userEncryConfigEntry;

    public ProxyConfigManager(ProxyClientConfig configure, String localIP, ClientMgr clientManager) {
        this.clientConfig = configure;
        this.localIP = localIP;
        this.clientManager = clientManager;
        this.hashRing.setVirtualNode(configure.getVirtualNode());
    }

    public String getInlongGroupId() {
        return this.inlongGroupId;
    }

    public void setInlongGroupId(String inlongGroupId) {
        this.inlongGroupId = inlongGroupId;
    }

    public void shutDown() {
        LOGGER.info("Begin to shut down ProxyConfigManager!");
        this.bShutDown = true;
    }

    @Override
    public void run() {
        while (!this.bShutDown) {
            try {
                this.doProxyEntryQueryWork();
                this.updateEncryptConfigEntry();
                LOGGER.info("ProxyConf update!");
            }
            catch (Throwable e) {
                LOGGER.error("Refresh proxy ip list runs into exception {}, {}", (Object)e.toString(), (Object)e.getStackTrace());
                e.printStackTrace();
            }
            try {
                int proxyUpdateIntervalSec;
                Random random = new Random();
                int sleepTimeSec = proxyUpdateIntervalSec = this.clientConfig.getProxyUpdateIntervalMinutes() * 60;
                if (proxyUpdateIntervalSec > 5) {
                    sleepTimeSec = proxyUpdateIntervalSec + random.nextInt() % (proxyUpdateIntervalSec / 5);
                }
                LOGGER.info("sleep time {}", (Object)sleepTimeSec);
                Thread.sleep(sleepTimeSec * 1000);
            }
            catch (Throwable throwable) {}
        }
        LOGGER.info("ProxyConfigManager worker existed!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProxyConfigEntry tryToReadCacheProxyEntry(String configCachePath) {
        this.rw.readLock().lock();
        try {
            File file = new File(configCachePath);
            long diffTime = System.currentTimeMillis() - file.lastModified();
            if (diffTime < this.clientConfig.getMaxProxyCacheTimeInMs()) {
                JsonReader reader = new JsonReader((Reader)new FileReader(configCachePath));
                ProxyConfigEntry proxyConfigEntry = (ProxyConfigEntry)this.gson.fromJson(reader, ProxyConfigEntry.class);
                LOGGER.info("{} has a backup! {}", (Object)this.inlongGroupId, (Object)proxyConfigEntry);
                ProxyConfigEntry proxyConfigEntry2 = proxyConfigEntry;
                return proxyConfigEntry2;
            }
        }
        catch (Exception ex) {
            LOGGER.warn("try to read local cache, caught {}", (Object)ex.getMessage());
        }
        finally {
            this.rw.readLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryToWriteCacheProxyEntry(ProxyConfigEntry entry, String configCachePath) {
        this.rw.writeLock().lock();
        try {
            File file = new File(configCachePath);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            LOGGER.info("try to write {}} to local cache {}", (Object)entry, (Object)configCachePath);
            FileWriter fileWriter = new FileWriter(configCachePath);
            this.gson.toJson((Object)entry, (Appendable)fileWriter);
            fileWriter.flush();
            fileWriter.close();
        }
        catch (Exception ex) {
            LOGGER.warn("try to write local cache, caught {}", (Object)ex.getMessage());
        }
        finally {
            this.rw.writeLock().unlock();
        }
    }

    private ProxyConfigEntry requestProxyEntryQuietly() {
        try {
            return this.requestProxyList(this.clientConfig.getProxyIPServiceURL());
        }
        catch (Exception e) {
            LOGGER.warn("try to request proxy list by http, caught {}", (Object)e.getMessage());
            return null;
        }
    }

    public ProxyConfigEntry getGroupIdConfigure() throws Exception {
        ProxyConfigEntry proxyEntry;
        String configAddr = this.clientConfig.getConfStoreBasePath() + this.inlongGroupId;
        if (this.clientConfig.isReadProxyIPFromLocal()) {
            configAddr = configAddr + ".local";
            proxyEntry = this.getLocalProxyListFromFile(configAddr);
        } else {
            proxyEntry = this.tryToReadCacheProxyEntry(configAddr = configAddr + ".proxyip");
            if (proxyEntry == null) {
                proxyEntry = this.requestProxyEntryQuietly();
                for (int requestCount = 0; requestCount < 3 && proxyEntry == null; ++requestCount) {
                    proxyEntry = this.requestProxyEntryQuietly();
                    if (proxyEntry != null) continue;
                    TimeUnit.MILLISECONDS.sleep(500L);
                }
            }
            if (proxyEntry == null) {
                throw new Exception("Visit manager error, please check log!");
            }
            this.tryToWriteCacheProxyEntry(proxyEntry, configAddr);
        }
        return proxyEntry;
    }

    public void doProxyEntryQueryWork() throws Exception {
        if (this.localMd5 == null) {
            this.localMd5 = this.calcHostInfoMd5(this.proxyInfoList);
        }
        ProxyConfigEntry proxyEntry = null;
        String configAddr = this.clientConfig.getConfStoreBasePath() + this.inlongGroupId;
        if (this.clientConfig.isReadProxyIPFromLocal()) {
            configAddr = configAddr + ".local";
            proxyEntry = this.getLocalProxyListFromFile(configAddr);
        } else {
            configAddr = configAddr + ".managerip";
            for (int retryCount = 1; proxyEntry == null && retryCount < this.clientConfig.getProxyUpdateMaxRetry(); ++retryCount) {
                proxyEntry = this.requestProxyEntryQuietly();
                if (proxyEntry != null) continue;
                TimeUnit.SECONDS.sleep(1L);
            }
            if (proxyEntry != null) {
                this.tryToWriteCacheProxyEntry(proxyEntry, configAddr);
            }
            if (this.localMd5 == null && proxyEntry == null) {
                LOGGER.error("Can't connect manager at the start of proxy API {}", (Object)this.clientConfig.getProxyIPServiceURL());
                proxyEntry = this.tryToReadCacheProxyEntry(configAddr);
            }
            if (this.localMd5 != null && proxyEntry == null && this.proxyInfoList != null) {
                StringBuffer s = new StringBuffer();
                for (HostInfo tmp : this.proxyInfoList) {
                    s.append(tmp.getHostName()).append(";").append(tmp.getPortNumber()).append(",");
                }
                LOGGER.warn("Backup proxyEntry [{}]", (Object)s);
            }
        }
        if (this.localMd5 == null && proxyEntry == null && this.proxyInfoList == null) {
            if (this.clientConfig.isReadProxyIPFromLocal()) {
                throw new Exception("Local proxy address configure read failure, please check first!");
            }
            throw new Exception("Connect Manager failure, please check first!");
        }
        this.compareProxyList(proxyEntry);
    }

    private void compareProxyList(ProxyConfigEntry proxyEntry) {
        if (proxyEntry != null) {
            LOGGER.info("{}", (Object)proxyEntry.toString());
            if (proxyEntry.getSize() != 0) {
                this.clientManager.setLoadThreshold(proxyEntry.getLoad());
                ArrayList<HostInfo> newProxyInfoList = new ArrayList<HostInfo>();
                for (Map.Entry<String, HostInfo> entry : proxyEntry.getHostMap().entrySet()) {
                    newProxyInfoList.add(entry.getValue());
                }
                String newMd5 = this.calcHostInfoMd5(newProxyInfoList);
                String oldMd5 = this.calcHostInfoMd5(this.proxyInfoList);
                if (newMd5 != null && !newMd5.equals(oldMd5)) {
                    LOGGER.info("old md5 {} new md5 {}", (Object)oldMd5, (Object)newMd5);
                    this.proxyInfoList.clear();
                    this.proxyInfoList = newProxyInfoList;
                    this.clientManager.setProxyInfoList(this.proxyInfoList);
                    this.doworkTime = System.currentTimeMillis();
                } else if (proxyEntry.getSwitchStat() != this.oldStat) {
                    this.oldStat = proxyEntry.getSwitchStat();
                    if (System.currentTimeMillis() - this.doworkTime > 180000L) {
                        LOGGER.info("switch the cluster!");
                        this.proxyInfoList.clear();
                        this.proxyInfoList = newProxyInfoList;
                        this.clientManager.setProxyInfoList(this.proxyInfoList);
                    } else {
                        LOGGER.info("only change oldStat ");
                    }
                } else {
                    newProxyInfoList.clear();
                    LOGGER.info("proxy IP list doesn't change, load {}", (Object)proxyEntry.getLoad());
                }
                if (this.clientConfig.getLoadBalance() == LoadBalance.CONSISTENCY_HASH) {
                    this.updateHashRing(this.proxyInfoList);
                }
            } else {
                LOGGER.error("proxyEntry's size is zero");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EncryptConfigEntry getEncryptConfigEntry(String userName) {
        if (Utils.isBlank(userName)) {
            return null;
        }
        EncryptConfigEntry encryptEntry = this.userEncryConfigEntry;
        if (encryptEntry == null) {
            encryptEntry = this.requestPubKey(this.clientConfig.getRsaPubKeyUrl(), userName, false);
            for (int retryCount = 0; encryptEntry == null && retryCount < this.clientConfig.getProxyUpdateMaxRetry(); ++retryCount) {
                encryptEntry = this.requestPubKey(this.clientConfig.getRsaPubKeyUrl(), userName, false);
            }
            if (encryptEntry == null) {
                encryptEntry = this.getStoredPubKeyEntry(userName);
                if (encryptEntry != null) {
                    encryptEntry.getRsaEncryptedKey();
                    ProxyConfigManager proxyConfigManager = this;
                    synchronized (proxyConfigManager) {
                        if (this.userEncryConfigEntry == null) {
                            this.userEncryConfigEntry = encryptEntry;
                        } else {
                            encryptEntry = this.userEncryConfigEntry;
                        }
                    }
                }
            } else {
                ProxyConfigManager proxyConfigManager = this;
                synchronized (proxyConfigManager) {
                    if (this.userEncryConfigEntry == null || this.userEncryConfigEntry != encryptEntry) {
                        this.storePubKeyEntry(encryptEntry);
                        encryptEntry.getRsaEncryptedKey();
                        this.userEncryConfigEntry = encryptEntry;
                    } else {
                        encryptEntry = this.userEncryConfigEntry;
                    }
                }
            }
        }
        return encryptEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEncryptConfigEntry() {
        if (Utils.isBlank(this.clientConfig.getUserName())) {
            return;
        }
        EncryptConfigEntry encryptConfigEntry = this.requestPubKey(this.clientConfig.getRsaPubKeyUrl(), this.clientConfig.getUserName(), false);
        for (int retryCount = 0; encryptConfigEntry == null && retryCount < this.clientConfig.getProxyUpdateMaxRetry(); ++retryCount) {
            encryptConfigEntry = this.requestPubKey(this.clientConfig.getRsaPubKeyUrl(), this.clientConfig.getUserName(), false);
        }
        if (encryptConfigEntry == null) {
            return;
        }
        ProxyConfigManager proxyConfigManager = this;
        synchronized (proxyConfigManager) {
            if (this.userEncryConfigEntry == null || this.userEncryConfigEntry != encryptConfigEntry) {
                this.storePubKeyEntry(encryptConfigEntry);
                encryptConfigEntry.getRsaEncryptedKey();
                this.userEncryConfigEntry = encryptConfigEntry;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EncryptConfigEntry getStoredPubKeyEntry(String userName) {
        if (Utils.isBlank(userName)) {
            LOGGER.warn(" userName(" + userName + ") is not available");
            return null;
        }
        FileInputStream fis = null;
        ObjectInputStream is = null;
        this.rw.readLock().lock();
        try {
            File file = new File(this.clientConfig.getConfStoreBasePath() + userName + ".pubKey");
            if (file.exists()) {
                fis = new FileInputStream(file);
                is = new ObjectInputStream(fis);
                EncryptConfigEntry entry = (EncryptConfigEntry)is.readObject();
                fis.close();
                EncryptConfigEntry encryptConfigEntry = entry;
                return encryptConfigEntry;
            }
            EncryptConfigEntry encryptConfigEntry = null;
            return encryptConfigEntry;
        }
        catch (Throwable e1) {
            LOGGER.error("Read " + userName + " stored PubKeyEntry error ", e1);
            EncryptConfigEntry encryptConfigEntry = null;
            return encryptConfigEntry;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Throwable throwable) {}
            }
            this.rw.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storePubKeyEntry(EncryptConfigEntry entry) {
        FileOutputStream fos = null;
        ObjectOutputStream p = null;
        this.rw.writeLock().lock();
        try {
            File file = new File(this.clientConfig.getConfStoreBasePath() + entry.getUserName() + ".pubKey");
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdir();
            }
            if (!file.exists()) {
                file.createNewFile();
            }
            fos = new FileOutputStream(file);
            p = new ObjectOutputStream(fos);
            p.writeObject(entry);
            p.flush();
        }
        catch (Throwable e) {
            LOGGER.error("store EncryptConfigEntry " + entry.toString() + " exception ", e);
            e.printStackTrace();
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Throwable file) {}
            }
            this.rw.writeLock().unlock();
        }
    }

    private String calcHostInfoMd5(List<HostInfo> hostInfoList) {
        if (hostInfoList == null || hostInfoList.isEmpty()) {
            return null;
        }
        Collections.sort(hostInfoList);
        StringBuffer hostInfoMd5 = new StringBuffer();
        for (HostInfo hostInfo : hostInfoList) {
            if (hostInfo == null) continue;
            hostInfoMd5.append(hostInfo.getHostName());
            hostInfoMd5.append(";");
            hostInfoMd5.append(hostInfo.getPortNumber());
            hostInfoMd5.append(";");
        }
        return DigestUtils.md5Hex((String)hostInfoMd5.toString());
    }

    private EncryptConfigEntry requestPubKey(String pubKeyUrl, String userName, boolean needGet) {
        if (Utils.isBlank(userName)) {
            LOGGER.error("Queried userName is null!");
            return null;
        }
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("operation", "query"));
        params.add(new BasicNameValuePair("username", userName));
        String returnStr = this.requestConfiguration(pubKeyUrl, params);
        if (Utils.isBlank(returnStr)) {
            LOGGER.info("No public key information returned from manager");
            return null;
        }
        JsonObject pubKeyConf = this.jsonParser.parse(returnStr).getAsJsonObject();
        if (pubKeyConf == null) {
            LOGGER.info("No public key information returned from manager");
            return null;
        }
        if (!pubKeyConf.has("resultCode")) {
            LOGGER.info("Parse pubKeyConf failure: No resultCode key information returned from manager");
            return null;
        }
        int resultCode = pubKeyConf.get("resultCode").getAsInt();
        if (resultCode != 0) {
            LOGGER.info("query pubKeyConf failure, error code is " + resultCode + ", errInfo is " + pubKeyConf.get("message").getAsString());
            return null;
        }
        if (!pubKeyConf.has("resultData")) {
            LOGGER.info("Parse pubKeyConf failure: No resultData key information returned from manager");
            return null;
        }
        JsonObject resultData = pubKeyConf.get("resultData").getAsJsonObject();
        if (resultData != null) {
            String publicKey = resultData.get("publicKey").getAsString();
            if (Utils.isBlank(publicKey)) {
                return null;
            }
            String username = resultData.get("username").getAsString();
            if (Utils.isBlank(username)) {
                return null;
            }
            String versionStr = resultData.get("version").getAsString();
            if (Utils.isBlank(versionStr)) {
                return null;
            }
            return new EncryptConfigEntry(username, versionStr, publicKey);
        }
        return null;
    }

    public ProxyConfigEntry getLocalProxyListFromFile(String filePath) throws Exception {
        DataProxyNodeResponse proxyCluster;
        try {
            byte[] fileBytes = Files.readAllBytes(Paths.get(filePath, new String[0]));
            proxyCluster = (DataProxyNodeResponse)this.gson.fromJson(new String(fileBytes), DataProxyNodeResponse.class);
        }
        catch (Throwable e) {
            throw new Exception("Read local proxyList File failure by " + filePath + ", reason is " + e.getCause());
        }
        if (ObjectUtils.isEmpty(proxyCluster)) {
            LOGGER.warn("no proxyCluster configure from local file");
            return null;
        }
        return this.getProxyConfigEntry(proxyCluster);
    }

    private Map<String, Integer> getStreamIdMap(JsonObject localProxyAddrJson) {
        HashMap<String, Integer> streamIdMap = new HashMap<String, Integer>();
        if (localProxyAddrJson.has("tsn")) {
            JsonArray jsonStreamId = localProxyAddrJson.getAsJsonArray("tsn");
            for (int i = 0; i < jsonStreamId.size(); ++i) {
                JsonObject jsonItem = jsonStreamId.get(i).getAsJsonObject();
                if (jsonItem == null || !jsonItem.has("streamId") || !jsonItem.has("sn")) continue;
                streamIdMap.put(jsonItem.get("streamId").getAsString(), jsonItem.get("sn").getAsInt());
            }
        }
        return streamIdMap;
    }

    public ProxyConfigEntry requestProxyList(String url) {
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("ip", this.localIP));
        params.add(new BasicNameValuePair("protocolType", this.clientConfig.getProtocolType()));
        LOGGER.info("Begin to get configure from manager {}, param is {}", (Object)url, params);
        String resultStr = this.requestConfiguration(url, params);
        ProxyClusterConfig clusterConfig = (ProxyClusterConfig)this.gson.fromJson(resultStr, ProxyClusterConfig.class);
        if (clusterConfig == null || !clusterConfig.isSuccess() || clusterConfig.getData() == null) {
            return null;
        }
        DataProxyNodeResponse proxyCluster = clusterConfig.getData();
        return this.getProxyConfigEntry(proxyCluster);
    }

    private ProxyConfigEntry getProxyConfigEntry(DataProxyNodeResponse proxyCluster) {
        List<DataProxyNodeInfo> nodeList = proxyCluster.getNodeList();
        if (CollectionUtils.isEmpty(nodeList)) {
            LOGGER.error("dataproxy nodeList is empty in DataProxyNodeResponse!");
            return null;
        }
        Map<String, HostInfo> hostMap = this.formatHostInfoMap(nodeList);
        if (MapUtils.isEmpty(hostMap)) {
            return null;
        }
        int clusterId = -1;
        if (ObjectUtils.isNotEmpty(proxyCluster.getClusterId())) {
            clusterId = proxyCluster.getClusterId();
        }
        int load = 0;
        if (ObjectUtils.isNotEmpty(proxyCluster.getLoad())) {
            load = proxyCluster.getLoad() > 200 ? 200 : Math.max(proxyCluster.getLoad(), 0);
        }
        boolean isIntranet = true;
        if (ObjectUtils.isNotEmpty(proxyCluster.getIsSwitch())) {
            isIntranet = proxyCluster.getIsIntranet() == 1;
        }
        int isSwitch = 0;
        if (ObjectUtils.isNotEmpty(proxyCluster.getIsSwitch())) {
            isSwitch = proxyCluster.getIsSwitch();
        }
        ProxyConfigEntry proxyEntry = new ProxyConfigEntry();
        proxyEntry.setClusterId(clusterId);
        proxyEntry.setGroupId(this.clientConfig.getInlongGroupId());
        proxyEntry.setInterVisit(isIntranet);
        proxyEntry.setHostMap(hostMap);
        proxyEntry.setSwitchStat(isSwitch);
        proxyEntry.setLoad(load);
        proxyEntry.setSize(nodeList.size());
        return proxyEntry;
    }

    private Map<String, HostInfo> formatHostInfoMap(List<DataProxyNodeInfo> nodeList) {
        HashMap<String, HostInfo> hostMap = new HashMap<String, HostInfo>();
        for (DataProxyNodeInfo proxy : nodeList) {
            if (ObjectUtils.isEmpty(proxy.getId()) || StringUtils.isEmpty(proxy.getIp()) || ObjectUtils.isEmpty(proxy.getPort()) || proxy.getPort() < 0) {
                LOGGER.error("invalid proxy node, id:{}, ip:{}, port:{}", new Object[]{proxy.getId(), proxy.getIp(), proxy.getPort()});
                continue;
            }
            String refId = proxy.getIp() + ":" + proxy.getPort();
            hostMap.put(refId, new HostInfo(refId, proxy.getIp(), proxy.getPort()));
        }
        if (hostMap.isEmpty()) {
            LOGGER.error("Parse proxyList failure: address is empty for response from manager!");
            return null;
        }
        return hostMap;
    }

    private String updateUrl(String url, int tryIdx, String localManagerIpList) {
        if (tryIdx == 0) {
            return url;
        }
        int headerIdx = url.indexOf("://");
        if (headerIdx == -1) {
            return null;
        }
        String header = "";
        header = url.substring(0, headerIdx + 3);
        String tmpUrl = url.substring(headerIdx + 3);
        int tailerIdx = tmpUrl.indexOf("/");
        if (tailerIdx == -1) {
            return null;
        }
        String tailer = "";
        tailer = tmpUrl.substring(tailerIdx);
        String[] managerIps = localManagerIpList.split(",");
        String currentManagerIp = "";
        int idx = 1;
        for (String managerIp : managerIps) {
            if (idx++ != tryIdx) continue;
            currentManagerIp = managerIp;
            break;
        }
        if (!currentManagerIp.equals("")) {
            return header + currentManagerIp + ":" + this.clientConfig.getManagerPort() + tailer;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String requestConfiguration(String url, List<BasicNameValuePair> params) {
        if (Utils.isBlank(url)) {
            LOGGER.error("request url is null");
            return null;
        }
        String localManagerIps = "";
        int tryIdx = 0;
        while (true) {
            HttpPost httpPost = null;
            String returnStr = null;
            BasicHttpParams myParams = new BasicHttpParams();
            HttpConnectionParams.setConnectionTimeout((HttpParams)myParams, (int)10000);
            HttpConnectionParams.setSoTimeout((HttpParams)myParams, (int)this.clientConfig.getManagerSocketTimeout());
            DefaultHttpClient httpClient = null;
            if (this.clientConfig.isLocalVisit()) {
                httpClient = new DefaultHttpClient((HttpParams)myParams);
            } else {
                try {
                    httpClient = this.getCloseableHttpClient(params);
                }
                catch (Throwable eHttps) {
                    LOGGER.error("Create Https cliet failure, error 1 is ", eHttps);
                    eHttps.printStackTrace();
                    return null;
                }
            }
            if (!this.clientConfig.isEnableSaveManagerVIps() && tryIdx > 0) {
                return null;
            }
            if ((url = this.updateUrl(url, tryIdx, localManagerIps)) == null) {
                return null;
            }
            ++tryIdx;
            LOGGER.info("Request url : " + url + ", localManagerIps : " + localManagerIps);
            try {
                httpPost = new HttpPost(url);
                httpPost.addHeader("authorization", BasicAuth.genBasicAuthCredential(this.clientConfig.getAuthSecretId(), this.clientConfig.getAuthSecretKey()));
                UrlEncodedFormEntity urlEncodedFormEntity = new UrlEncodedFormEntity(params, "UTF-8");
                httpPost.setEntity((HttpEntity)urlEncodedFormEntity);
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                returnStr = EntityUtils.toString((HttpEntity)response.getEntity());
                if (Utils.isNotBlank(returnStr) && response.getStatusLine().getStatusCode() == 200) {
                    LOGGER.info("Get configure from manager is " + returnStr);
                    String string = returnStr;
                    return string;
                }
                if (this.clientConfig.isLocalVisit()) continue;
                String string = null;
                return string;
            }
            catch (Throwable e) {
                String string;
                LOGGER.error("Connect Manager error, message: {}, url is {}", (Object)e.getMessage(), (Object)url);
                if (!this.clientConfig.isLocalVisit()) {
                    string = null;
                    return string;
                }
                localManagerIps = this.getLocalManagerIps();
                if (localManagerIps != null) continue;
                string = null;
                return string;
            }
            finally {
                if (httpPost != null) {
                    httpPost.releaseConnection();
                }
                if (httpClient == null) continue;
                httpClient.getConnectionManager().shutdown();
                continue;
            }
            break;
        }
    }

    private StringEntity getEntity(List<BasicNameValuePair> params) throws UnsupportedEncodingException {
        JsonObject jsonObject = new JsonObject();
        for (BasicNameValuePair pair : params) {
            jsonObject.addProperty(pair.getName(), pair.getValue());
        }
        StringEntity se = new StringEntity(jsonObject.toString());
        se.setContentType(APPLICATION_JSON);
        return se;
    }

    private CloseableHttpClient getCloseableHttpClient(List<BasicNameValuePair> params) throws NoSuchAlgorithmException, KeyManagementException {
        ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>();
        for (BasicNameValuePair paramItem : params) {
            headers.add(new BasicHeader(paramItem.getName(), paramItem.getValue()));
        }
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(10000).setSocketTimeout(this.clientConfig.getManagerSocketTimeout()).build();
        SSLContext sslContext = SSLContexts.custom().build();
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, new String[]{"TLSv1"}, null, SSLConnectionSocketFactory.getDefaultHostnameVerifier());
        CloseableHttpClient httpClient = HttpClients.custom().setDefaultHeaders(headers).setDefaultRequestConfig(requestConfig).setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
        return httpClient;
    }

    private String getLocalManagerIps() {
        String localManagerIps;
        try {
            File localManagerIpsFile = new File(this.clientConfig.getManagerIpLocalPath());
            if (localManagerIpsFile.exists()) {
                byte[] serialized = FileUtils.readFileToByteArray((File)localManagerIpsFile);
                if (serialized == null) {
                    LOGGER.error("Local managerIp file is empty, file path : " + this.clientConfig.getManagerIpLocalPath());
                    return null;
                }
                localManagerIps = new String(serialized, "UTF-8");
            } else {
                if (!localManagerIpsFile.getParentFile().exists()) {
                    localManagerIpsFile.getParentFile().mkdirs();
                }
                localManagerIps = "";
                LOGGER.error("Get local managerIpList not exist, file path : " + this.clientConfig.getManagerIpLocalPath());
            }
        }
        catch (Throwable t) {
            localManagerIps = "";
            LOGGER.error("Get local managerIpList occur exception,", t);
        }
        return localManagerIps;
    }

    public void updateHashRing(List<HostInfo> newHosts) {
        this.hashRing.updateNode(newHosts);
        LOGGER.debug("update hash ring {}", this.hashRing.getVirtualNode2RealNode());
    }
}

