/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.codec;

import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.inlong.dataproxy.shaded.io.netty.buffer.ByteBuf;
import org.apache.inlong.dataproxy.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.inlong.dataproxy.shaded.io.netty.handler.codec.MessageToMessageDecoder;
import org.apache.inlong.sdk.dataproxy.codec.EncodeObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolDecoder
extends MessageToMessageDecoder<ByteBuf> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtocolDecoder.class);

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) throws Exception {
        buffer.markReaderIndex();
        int totalLen = buffer.readInt();
        LOGGER.debug("decode totalLen : {}", (Object)totalLen);
        if (totalLen != buffer.readableBytes()) {
            LOGGER.error("totalLen is not equal readableBytes.total:" + totalLen + ";readableBytes:" + buffer.readableBytes());
            buffer.resetReaderIndex();
            throw new Exception("totalLen is not equal readableBytes.total");
        }
        int msgType = buffer.readByte() & 0x1F;
        if (msgType == 4) {
            LOGGER.info("debug decode");
        }
        if (msgType == 3 | msgType == 5) {
            int bodyLength = buffer.readInt();
            if (bodyLength >= totalLen) {
                LOGGER.error("bodyLen is greater than totalLen.totalLen:" + totalLen + ";bodyLen:" + bodyLength);
                buffer.resetReaderIndex();
                throw new Exception("bodyLen is greater than totalLen.totalLen");
            }
            byte[] bodyBytes = null;
            if (bodyLength > 0) {
                bodyBytes = new byte[bodyLength];
                buffer.readBytes(bodyBytes);
            }
            int attrLength = buffer.readInt();
            byte[] attrBytes = null;
            if (attrLength > 0) {
                attrBytes = new byte[attrLength];
                buffer.readBytes(attrBytes);
            }
            EncodeObject object = new EncodeObject(bodyBytes, new String(attrBytes, StandardCharsets.UTF_8));
            object.setMsgtype(5);
            out.add(object);
        } else if (msgType == 7) {
            int seqId = buffer.readInt();
            short attrLen = buffer.readShort();
            byte[] attrBytes = null;
            if (attrLen > 0) {
                attrBytes = new byte[attrLen];
                buffer.readBytes(attrBytes);
            }
            EncodeObject object = new EncodeObject(new String(attrBytes, StandardCharsets.UTF_8));
            object.setMessageId(String.valueOf(seqId));
            buffer.readShort();
            object.setMsgtype(msgType);
            out.add(object);
        } else if (msgType == 8) {
            buffer.skipBytes(9);
            short load = buffer.readShort();
            short attrLen = buffer.readShort();
            byte[] attrBytes = null;
            if (attrLen > 0) {
                attrBytes = new byte[attrLen];
                buffer.readBytes(attrBytes);
            }
            buffer.skipBytes(2);
            String attrs = attrBytes == null ? "" : new String(attrBytes, StandardCharsets.UTF_8);
            EncodeObject object = new EncodeObject(attrs);
            object.setMsgtype(8);
            object.setLoad(load);
            out.add(object);
        }
    }
}

