/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.temporal;

import org.apache.flink.api.common.functions.Function;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.streaming.api.operators.InternalTimer;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.util.RowDataUtil;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.table.runtime.generated.GeneratedJoinCondition;
import org.apache.flink.table.runtime.generated.JoinCondition;
import org.apache.flink.table.runtime.operators.join.temporal.BaseTwoInputStreamOperatorWithStateRetention;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;

public class TemporalProcessTimeJoinOperator
extends BaseTwoInputStreamOperatorWithStateRetention {
    private static final long serialVersionUID = -5182289624027523612L;
    private final boolean isLeftOuterJoin;
    private final InternalTypeInfo<RowData> rightType;
    private final GeneratedJoinCondition generatedJoinCondition;
    private transient ValueState<RowData> rightState;
    private transient JoinCondition joinCondition;
    private transient JoinedRowData outRow;
    private transient GenericRowData rightNullRow;
    private transient TimestampedCollector<RowData> collector;

    public TemporalProcessTimeJoinOperator(InternalTypeInfo<RowData> rightType, GeneratedJoinCondition generatedJoinCondition, long minRetentionTime, long maxRetentionTime, boolean isLeftOuterJoin) {
        super(minRetentionTime, maxRetentionTime);
        this.rightType = rightType;
        this.generatedJoinCondition = generatedJoinCondition;
        this.isLeftOuterJoin = isLeftOuterJoin;
    }

    @Override
    public void open() throws Exception {
        super.open();
        this.joinCondition = (JoinCondition)this.generatedJoinCondition.newInstance(this.getRuntimeContext().getUserCodeClassLoader());
        FunctionUtils.setFunctionRuntimeContext((Function)this.joinCondition, (RuntimeContext)this.getRuntimeContext());
        FunctionUtils.openFunction((Function)this.joinCondition, (Configuration)new Configuration());
        ValueStateDescriptor rightStateDesc = new ValueStateDescriptor("right", this.rightType);
        this.rightState = this.getRuntimeContext().getState(rightStateDesc);
        this.collector = new TimestampedCollector(this.output);
        this.outRow = new JoinedRowData();
        this.rightNullRow = new GenericRowData(this.rightType.toRowSize());
        super.processWatermark2(Watermark.MAX_WATERMARK);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processElement1(StreamRecord<RowData> element) throws Exception {
        RowData leftSideRow = (RowData)element.getValue();
        RowData rightSideRow = (RowData)this.rightState.value();
        if (rightSideRow == null) {
            if (!this.isLeftOuterJoin) return;
            this.collectJoinedRow(leftSideRow, (RowData)this.rightNullRow);
            return;
        } else {
            if (this.joinCondition.apply(leftSideRow, rightSideRow)) {
                this.collectJoinedRow(leftSideRow, rightSideRow);
            } else if (this.isLeftOuterJoin) {
                this.collectJoinedRow(leftSideRow, (RowData)this.rightNullRow);
            }
            this.registerProcessingCleanupTimer();
        }
    }

    private void collectJoinedRow(RowData leftRow, RowData rightRow) {
        this.outRow.setRowKind(leftRow.getRowKind());
        this.outRow.replace(leftRow, rightRow);
        this.collector.collect((Object)this.outRow);
    }

    public void processElement2(StreamRecord<RowData> element) throws Exception {
        if (RowDataUtil.isAccumulateMsg((RowData)element.getValue())) {
            this.rightState.update(element.getValue());
            this.registerProcessingCleanupTimer();
        } else {
            this.rightState.clear();
            this.cleanupLastTimer();
        }
    }

    public void close() throws Exception {
        FunctionUtils.closeFunction((Function)this.joinCondition);
    }

    @Override
    public void cleanupState(long time) {
        this.rightState.clear();
    }

    public void onEventTime(InternalTimer<Object, VoidNamespace> timer) throws Exception {
    }
}

