/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.utils.file;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import org.apache.inlong.agent.utils.file.FileFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUtils.class);

    public static FileFinder find(String baseDirectory) {
        return FileUtils.find(new File(baseDirectory));
    }

    public static FileFinder find(File baseDirectory) {
        return new FileFinder(baseDirectory);
    }

    public static long getFileCreationTime(String fileName) {
        long creationTime = 0L;
        try {
            creationTime = Files.readAttributes(Paths.get(fileName, new String[0]), BasicFileAttributes.class, new LinkOption[0]).creationTime().toMillis();
        }
        catch (IOException e) {
            LOGGER.error("getFileCreationTime error {}", (Object)e.getMessage());
        }
        return creationTime;
    }

    public static long getFileLastModifyTime(String fileName) {
        long lastModify = 0L;
        try {
            lastModify = Files.getLastModifiedTime(Paths.get(fileName, new String[0]), new LinkOption[0]).toMillis();
        }
        catch (IOException e) {
            LOGGER.error("getFileLastModifyTime error {}", (Object)e.getMessage());
        }
        return lastModify;
    }
}

