/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.apache.inlong.agent.conf.AgentConfiguration;
import org.apache.inlong.common.util.BasicAuth;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpManager.class);
    private static final Gson gson;
    private static final AgentConfiguration agentConf;
    private final CloseableHttpClient httpClient;
    private final String secretId;
    private final String secretKey;

    public HttpManager(AgentConfiguration conf) {
        this.httpClient = this.constructHttpClient(conf.getInt("agent.manager.request.timeout", 30));
        this.secretId = conf.get("agent.manager.auth.secretId");
        this.secretKey = conf.get("agent.manager.auth.secretKey");
    }

    public static String buildBaseUrl() {
        return "http://" + agentConf.get("agent.manager.vip.http.host") + ":" + agentConf.get("agent.manager.vip.http.port") + agentConf.get("agent.manager.vip.http.prefix.path", "/inlong/manager/openapi");
    }

    private synchronized CloseableHttpClient constructHttpClient(int timeout) {
        if (this.httpClient != null) {
            return this.httpClient;
        }
        long timeoutInMs = TimeUnit.SECONDS.toMillis(timeout);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout((int)timeoutInMs).setSocketTimeout((int)timeoutInMs).build();
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        httpClientBuilder.setDefaultRequestConfig(requestConfig);
        return httpClientBuilder.build();
    }

    public String doSentPost(String url, Object dto) {
        try {
            HttpPost post = this.getHttpPost(url);
            post.addHeader("authorization", BasicAuth.genBasicAuthCredential((String)this.secretId, (String)this.secretKey));
            StringEntity stringEntity = new StringEntity(this.toJsonStr(dto), Charset.forName("UTF-8"));
            stringEntity.setContentType("application/json");
            post.setEntity((HttpEntity)stringEntity);
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)post);
            String returnStr = EntityUtils.toString((HttpEntity)response.getEntity());
            if (returnStr != null && !returnStr.isEmpty() && response.getStatusLine().getStatusCode() == 200) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("request url {}, dto: {}, return str {}", new Object[]{url, dto, returnStr});
                }
                return returnStr;
            }
        }
        catch (Exception e) {
            LOGGER.error("request url {}, request dto {} error :" + e.getMessage(), (Object)url, dto);
            return null;
        }
        return null;
    }

    public String toJsonStr(Object obj) {
        return gson.toJson(obj);
    }

    public String doSendPost(String url) {
        try {
            HttpPost post = this.getHttpPost(url);
            post.addHeader("authorization", BasicAuth.genBasicAuthCredential((String)this.secretId, (String)this.secretKey));
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)post);
            String returnStr = EntityUtils.toString((HttpEntity)response.getEntity());
            if (returnStr != null && !returnStr.isEmpty() && response.getStatusLine().getStatusCode() == 200) {
                return returnStr;
            }
        }
        catch (Exception e) {
            LOGGER.error("request url {} error :" + e.getMessage(), (Object)url);
            return null;
        }
        return null;
    }

    private HttpPost getHttpPost(String url) {
        return new HttpPost(url);
    }

    private HttpGet getHttpGet(String url) {
        return new HttpGet(url);
    }

    static {
        agentConf = AgentConfiguration.getAgentConf();
        GsonBuilder gsonBuilder = new GsonBuilder().setDateFormat("yyyy-MM-dd HH:mm:ss");
        gson = gsonBuilder.create();
    }
}

