/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateTransUtils {
    private static final Logger logger = LoggerFactory.getLogger(DateTransUtils.class);

    public static String millSecConvertToTimeStr(long time, String cycleUnit) {
        return DateTransUtils.millSecConvertToTimeStr(time, cycleUnit, TimeZone.getDefault());
    }

    public static long timeStrConvertToMillSec(String time, String cycleUnit) throws ParseException {
        return DateTransUtils.timeStrConvertToMillSec(time, cycleUnit, TimeZone.getDefault());
    }

    public static long timeStrConvertToMillSec(String time, String cycleUnit, TimeZone timeZone) throws ParseException {
        long retTime = 0L;
        SimpleDateFormat df = null;
        if (cycleUnit.equals("Y") && time.length() == 4) {
            df = new SimpleDateFormat("yyyy");
        } else if (cycleUnit.equals("M") && time.length() == 6) {
            df = new SimpleDateFormat("yyyyMM");
        } else if (cycleUnit.equals("D") && time.length() == 8) {
            df = new SimpleDateFormat("yyyyMMdd");
        } else if (cycleUnit.equalsIgnoreCase("h") && time.length() == 10) {
            df = new SimpleDateFormat("yyyyMMddHH");
        } else if (cycleUnit.contains("m") && time.length() == 12) {
            df = new SimpleDateFormat("yyyyMMddHHmm");
        } else {
            logger.error("time {}, cycleUnit {} can't parse!", (Object)time, (Object)cycleUnit);
            throw new ParseException(time, 0);
        }
        try {
            df.setTimeZone(timeZone);
            retTime = df.parse(time).getTime();
        }
        catch (ParseException e) {
            logger.error("convert time string error. ", (Throwable)e);
        }
        return retTime;
    }

    public static String millSecConvertToTimeStr(long time, String cycleUnit, TimeZone tz) {
        String retTime = null;
        Calendar calendarInstance = Calendar.getInstance();
        calendarInstance.setTimeInMillis(time);
        Date dateTime = calendarInstance.getTime();
        SimpleDateFormat df = null;
        if ("Y".equalsIgnoreCase(cycleUnit)) {
            df = new SimpleDateFormat("yyyy");
        } else if ("M".equals(cycleUnit)) {
            df = new SimpleDateFormat("yyyyMM");
        } else if ("D".equalsIgnoreCase(cycleUnit)) {
            df = new SimpleDateFormat("yyyyMMdd");
        } else if ("h".equalsIgnoreCase(cycleUnit)) {
            df = new SimpleDateFormat("yyyyMMddHH");
        } else if (cycleUnit.contains("m")) {
            df = new SimpleDateFormat("yyyyMMddHHmm");
        } else {
            logger.error("cycleUnit {} can't parse!", (Object)cycleUnit);
            df = new SimpleDateFormat("yyyyMMddHH");
        }
        df.setTimeZone(tz);
        retTime = df.format(dateTime);
        if (cycleUnit.contains("m")) {
            int cycleNum = Integer.parseInt(cycleUnit.substring(0, cycleUnit.length() - 1));
            int mmTime = Integer.parseInt(retTime.substring(retTime.length() - 2, retTime.length()));
            String realMMTime = "";
            realMMTime = cycleNum * (mmTime / cycleNum) <= 0 ? "0" + cycleNum * (mmTime / cycleNum) : "" + cycleNum * (mmTime / cycleNum);
            retTime = retTime.substring(0, retTime.length() - 2) + realMMTime;
        }
        return retTime;
    }

    public static long calcOffset(String timeOffset) {
        int startIndex;
        int symbol;
        if (timeOffset.length() == 0) {
            return 0L;
        }
        String offsetUnit = timeOffset.substring(timeOffset.length() - 1);
        if (timeOffset.charAt(0) == '-') {
            symbol = -1;
            startIndex = 1;
        } else {
            symbol = 1;
            startIndex = 0;
        }
        String strOffset = timeOffset.substring(startIndex, timeOffset.length() - 1);
        if (strOffset.length() == 0) {
            return 0L;
        }
        int offsetTime = Integer.parseInt(strOffset);
        if ("d".equalsIgnoreCase(offsetUnit)) {
            return offsetTime * 24 * 3600 * 1000 * symbol;
        }
        if ("h".equalsIgnoreCase(offsetUnit)) {
            return offsetTime * 3600 * 1000 * symbol;
        }
        if ("m".equalsIgnoreCase(offsetUnit)) {
            return offsetTime * 60 * 1000 * symbol;
        }
        return 0L;
    }
}

