/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.pojo;

import com.google.gson.Gson;
import java.util.Objects;
import org.apache.inlong.agent.conf.AgentConfiguration;
import org.apache.inlong.agent.conf.TaskProfile;
import org.apache.inlong.agent.pojo.BinlogJob;
import org.apache.inlong.agent.pojo.FileTask;
import org.apache.inlong.agent.pojo.KafkaJob;
import org.apache.inlong.agent.pojo.MongoJob;
import org.apache.inlong.agent.pojo.MqttJob;
import org.apache.inlong.agent.pojo.OracleJob;
import org.apache.inlong.agent.pojo.PostgreSQLJob;
import org.apache.inlong.agent.pojo.RedisJob;
import org.apache.inlong.agent.pojo.SqlServerJob;
import org.apache.inlong.common.enums.DataReportTypeEnum;
import org.apache.inlong.common.enums.TaskTypeEnum;
import org.apache.inlong.common.pojo.agent.DataConfig;
import org.apache.inlong.common.pojo.dataproxy.MQClusterInfo;

public class TaskProfileDto {
    public static final String DEFAULT_FILE_TASK = "org.apache.inlong.agent.plugin.task.filecollect.LogFileCollectTask";
    public static final String DEFAULT_CHANNEL = "org.apache.inlong.agent.plugin.channel.MemoryChannel";
    public static final String MANAGER_JOB = "MANAGER_JOB";
    public static final String DEFAULT_DATAPROXY_SINK = "org.apache.inlong.agent.plugin.sinks.ProxySink";
    public static final String FILE_DATAPROXY_SINK = "org.apache.inlong.agent.plugin.sinks.filecollect.ProxySink";
    public static final String PULSAR_SINK = "org.apache.inlong.agent.plugin.sinks.PulsarSink";
    public static final String KAFKA_SINK = "org.apache.inlong.agent.plugin.sinks.KafkaSink";
    public static final String DEFAULT_SOURCE = "org.apache.inlong.agent.plugin.sources.LogFileSource";
    public static final String BINLOG_SOURCE = "org.apache.inlong.agent.plugin.sources.BinlogSource";
    public static final String KAFKA_SOURCE = "org.apache.inlong.agent.plugin.sources.KafkaSource";
    public static final String POSTGRESQL_SOURCE = "org.apache.inlong.agent.plugin.sources.PostgreSQLSource";
    public static final String MONGO_SOURCE = "org.apache.inlong.agent.plugin.sources.MongoDBSource";
    public static final String ORACLE_SOURCE = "org.apache.inlong.agent.plugin.sources.OracleSource";
    public static final String REDIS_SOURCE = "org.apache.inlong.agent.plugin.sources.RedisSource";
    public static final String MQTT_SOURCE = "org.apache.inlong.agent.plugin.sources.MqttSource";
    public static final String SQLSERVER_SOURCE = "org.apache.inlong.agent.plugin.sources.SQLServerSource";
    private static final Gson GSON = new Gson();
    private Task task;
    private Proxy proxy;

    private static BinlogJob getBinlogJob(DataConfig dataConfigs) {
        BinlogJob.BinlogJobTaskConfig binlogJobTaskConfig = (BinlogJob.BinlogJobTaskConfig)GSON.fromJson(dataConfigs.getExtParams(), BinlogJob.BinlogJobTaskConfig.class);
        BinlogJob binlogJob = new BinlogJob();
        binlogJob.setHostname(binlogJobTaskConfig.getHostname());
        binlogJob.setPassword(binlogJobTaskConfig.getPassword());
        binlogJob.setUser(binlogJobTaskConfig.getUser());
        binlogJob.setTableWhiteList(binlogJobTaskConfig.getTableWhiteList());
        binlogJob.setDatabaseWhiteList(binlogJobTaskConfig.getDatabaseWhiteList());
        binlogJob.setSchema(binlogJobTaskConfig.getIncludeSchema());
        binlogJob.setPort(binlogJobTaskConfig.getPort());
        binlogJob.setOffsets(dataConfigs.getSnapshot());
        binlogJob.setDdl(binlogJobTaskConfig.getMonitoredDdl());
        binlogJob.setServerTimezone(binlogJobTaskConfig.getServerTimezone());
        BinlogJob.Offset offset = new BinlogJob.Offset();
        offset.setIntervalMs(binlogJobTaskConfig.getIntervalMs());
        offset.setFilename(binlogJobTaskConfig.getOffsetFilename());
        offset.setSpecificOffsetFile(binlogJobTaskConfig.getSpecificOffsetFile());
        offset.setSpecificOffsetPos(binlogJobTaskConfig.getSpecificOffsetPos());
        binlogJob.setOffset(offset);
        BinlogJob.Snapshot snapshot = new BinlogJob.Snapshot();
        snapshot.setMode(binlogJobTaskConfig.getSnapshotMode());
        binlogJob.setSnapshot(snapshot);
        BinlogJob.History history = new BinlogJob.History();
        history.setFilename(binlogJobTaskConfig.getHistoryFilename());
        binlogJob.setHistory(history);
        return binlogJob;
    }

    private static FileTask getFileJob(DataConfig dataConfig) {
        FileTask fileTask = new FileTask();
        fileTask.setId(dataConfig.getTaskId());
        FileTask.FileTaskConfig taskConfig = (FileTask.FileTaskConfig)GSON.fromJson(dataConfig.getExtParams(), FileTask.FileTaskConfig.class);
        FileTask.Dir dir = new FileTask.Dir();
        dir.setPatterns(taskConfig.getPattern());
        dir.setBlackList(taskConfig.getBlackList());
        fileTask.setDir(dir);
        fileTask.setCollectType(taskConfig.getCollectType());
        fileTask.setContentCollectType(taskConfig.getContentCollectType());
        fileTask.setDataContentStyle(taskConfig.getDataContentStyle());
        fileTask.setDataSeparator(taskConfig.getDataSeparator());
        fileTask.setMaxFileCount(taskConfig.getMaxFileCount());
        fileTask.setRetry(taskConfig.getRetry());
        fileTask.setCycleUnit(taskConfig.getCycleUnit());
        fileTask.setStartTime(taskConfig.getStartTime());
        fileTask.setEndTime(taskConfig.getEndTime());
        fileTask.setProperties(GSON.toJson(taskConfig.getProperties()));
        if (taskConfig.getTimeOffset() != null) {
            fileTask.setTimeOffset(taskConfig.getTimeOffset());
        }
        if (taskConfig.getTimeZone() != null) {
            fileTask.setTimeZone(taskConfig.getTimeZone());
        }
        if (taskConfig.getAdditionalAttr() != null) {
            fileTask.setAddictiveString(taskConfig.getAdditionalAttr());
        }
        if (null != taskConfig.getLineEndPattern()) {
            FileTask.Line line = new FileTask.Line();
            line.setEndPattern(taskConfig.getLineEndPattern());
            fileTask.setLine(line);
        }
        if (null != taskConfig.getEnvList()) {
            fileTask.setEnvList(taskConfig.getEnvList());
        }
        if (null != taskConfig.getMetaFields()) {
            fileTask.setMetaFields(GSON.toJson(taskConfig.getMetaFields()));
        }
        if (null != taskConfig.getFilterMetaByLabels()) {
            fileTask.setFilterMetaByLabels(GSON.toJson(taskConfig.getFilterMetaByLabels()));
        }
        if (null != taskConfig.getMonitorInterval()) {
            fileTask.setMonitorInterval(taskConfig.getMonitorInterval());
        }
        if (null != taskConfig.getMonitorStatus()) {
            fileTask.setMonitorStatus(taskConfig.getMonitorStatus());
        }
        return fileTask;
    }

    private static KafkaJob getKafkaJob(DataConfig dataConfigs) {
        KafkaJob.KafkaJobTaskConfig kafkaJobTaskConfig = (KafkaJob.KafkaJobTaskConfig)GSON.fromJson(dataConfigs.getExtParams(), KafkaJob.KafkaJobTaskConfig.class);
        KafkaJob kafkaJob = new KafkaJob();
        KafkaJob.Bootstrap bootstrap = new KafkaJob.Bootstrap();
        bootstrap.setServers(kafkaJobTaskConfig.getBootstrapServers());
        kafkaJob.setBootstrap(bootstrap);
        KafkaJob.Partition partition = new KafkaJob.Partition();
        partition.setOffset(dataConfigs.getSnapshot());
        kafkaJob.setPartition(partition);
        KafkaJob.Group group = new KafkaJob.Group();
        group.setId(kafkaJobTaskConfig.getGroupId());
        kafkaJob.setGroup(group);
        KafkaJob.RecordSpeed recordSpeed = new KafkaJob.RecordSpeed();
        recordSpeed.setLimit(kafkaJobTaskConfig.getRecordSpeedLimit());
        kafkaJob.setRecordSpeed(recordSpeed);
        KafkaJob.ByteSpeed byteSpeed = new KafkaJob.ByteSpeed();
        byteSpeed.setLimit(kafkaJobTaskConfig.getByteSpeedLimit());
        kafkaJob.setByteSpeed(byteSpeed);
        kafkaJob.setAutoOffsetReset(kafkaJobTaskConfig.getAutoOffsetReset());
        kafkaJob.setTopic(kafkaJobTaskConfig.getTopic());
        return kafkaJob;
    }

    private static PostgreSQLJob getPostgresJob(DataConfig dataConfigs) {
        PostgreSQLJob.PostgreSQLJobConfig config = (PostgreSQLJob.PostgreSQLJobConfig)GSON.fromJson(dataConfigs.getExtParams(), PostgreSQLJob.PostgreSQLJobConfig.class);
        PostgreSQLJob postgreSQLJob = new PostgreSQLJob();
        postgreSQLJob.setUser(config.getUsername());
        postgreSQLJob.setPassword(config.getPassword());
        postgreSQLJob.setHostname(config.getHostname());
        postgreSQLJob.setPort(config.getPort());
        postgreSQLJob.setDbname(config.getDatabase());
        postgreSQLJob.setServername(config.getSchema());
        postgreSQLJob.setPluginname(config.getDecodingPluginName());
        postgreSQLJob.setTableNameList(config.getTableNameList());
        postgreSQLJob.setServerTimeZone(config.getServerTimeZone());
        postgreSQLJob.setScanStartupMode(config.getScanStartupMode());
        postgreSQLJob.setPrimaryKey(config.getPrimaryKey());
        return postgreSQLJob;
    }

    private static RedisJob getRedisJob(DataConfig dataConfig) {
        RedisJob.RedisJobConfig config = (RedisJob.RedisJobConfig)GSON.fromJson(dataConfig.getExtParams(), RedisJob.RedisJobConfig.class);
        RedisJob redisJob = new RedisJob();
        redisJob.setAuthUser(config.getUsername());
        redisJob.setAuthPassword(config.getPassword());
        redisJob.setHostname(config.getHostname());
        redisJob.setPort(config.getPort());
        redisJob.setSsl(config.getSsl());
        redisJob.setReadTimeout(config.getTimeout());
        redisJob.setQueueSize(config.getQueueSize());
        redisJob.setReplId(config.getReplId());
        return redisJob;
    }

    private static MongoJob getMongoJob(DataConfig dataConfigs) {
        MongoJob.MongoJobTaskConfig config = (MongoJob.MongoJobTaskConfig)GSON.fromJson(dataConfigs.getExtParams(), MongoJob.MongoJobTaskConfig.class);
        MongoJob mongoJob = new MongoJob();
        mongoJob.setHosts(config.getHosts());
        mongoJob.setUser(config.getUsername());
        mongoJob.setPassword(config.getPassword());
        mongoJob.setDatabaseIncludeList(config.getDatabaseIncludeList());
        mongoJob.setDatabaseExcludeList(config.getDatabaseExcludeList());
        mongoJob.setCollectionIncludeList(config.getCollectionIncludeList());
        mongoJob.setCollectionExcludeList(config.getCollectionExcludeList());
        mongoJob.setFieldExcludeList(config.getFieldExcludeList());
        mongoJob.setConnectTimeoutInMs(config.getConnectTimeoutInMs());
        mongoJob.setQueueSize(config.getQueueSize());
        mongoJob.setCursorMaxAwaitTimeInMs(config.getCursorMaxAwaitTimeInMs());
        mongoJob.setSocketTimeoutInMs(config.getSocketTimeoutInMs());
        mongoJob.setSelectionTimeoutInMs(config.getSelectionTimeoutInMs());
        mongoJob.setFieldRenames(config.getFieldRenames());
        mongoJob.setMembersAutoDiscover(config.getMembersAutoDiscover());
        mongoJob.setConnectMaxAttempts(config.getConnectMaxAttempts());
        mongoJob.setConnectBackoffMaxDelayInMs(config.getConnectBackoffMaxDelayInMs());
        mongoJob.setConnectBackoffInitialDelayInMs(config.getConnectBackoffInitialDelayInMs());
        mongoJob.setInitialSyncMaxThreads(config.getInitialSyncMaxThreads());
        mongoJob.setSslInvalidHostnameAllowed(config.getSslInvalidHostnameAllowed());
        mongoJob.setSslEnabled(config.getSslEnabled());
        mongoJob.setPollIntervalInMs(config.getPollIntervalInMs());
        MongoJob.Offset offset = new MongoJob.Offset();
        offset.setFilename(config.getOffsetFilename());
        offset.setSpecificOffsetFile(config.getSpecificOffsetFile());
        offset.setSpecificOffsetPos(config.getSpecificOffsetPos());
        mongoJob.setOffset(offset);
        MongoJob.Snapshot snapshot = new MongoJob.Snapshot();
        snapshot.setMode(config.getSnapshotMode());
        mongoJob.setSnapshot(snapshot);
        MongoJob.History history = new MongoJob.History();
        history.setFilename(config.getHistoryFilename());
        mongoJob.setHistory(history);
        return mongoJob;
    }

    private static OracleJob getOracleJob(DataConfig dataConfigs) {
        OracleJob.OracleJobConfig config = (OracleJob.OracleJobConfig)GSON.fromJson(dataConfigs.getExtParams(), OracleJob.OracleJobConfig.class);
        OracleJob oracleJob = new OracleJob();
        oracleJob.setUser(config.getUser());
        oracleJob.setHostname(config.getHostname());
        oracleJob.setPassword(config.getPassword());
        oracleJob.setPort(config.getPort());
        oracleJob.setServerName(config.getServerName());
        oracleJob.setDbname(config.getDbname());
        OracleJob.Offset offset = new OracleJob.Offset();
        offset.setFilename(config.getOffsetFilename());
        offset.setSpecificOffsetFile(config.getSpecificOffsetFile());
        offset.setSpecificOffsetPos(config.getSpecificOffsetPos());
        oracleJob.setOffset(offset);
        OracleJob.Snapshot snapshot = new OracleJob.Snapshot();
        snapshot.setMode(config.getSnapshotMode());
        oracleJob.setSnapshot(snapshot);
        OracleJob.History history = new OracleJob.History();
        history.setFilename(config.getHistoryFilename());
        oracleJob.setHistory(history);
        return oracleJob;
    }

    private static SqlServerJob getSqlServerJob(DataConfig dataConfigs) {
        SqlServerJob.SqlserverJobConfig config = (SqlServerJob.SqlserverJobConfig)GSON.fromJson(dataConfigs.getExtParams(), SqlServerJob.SqlserverJobConfig.class);
        SqlServerJob sqlServerJob = new SqlServerJob();
        sqlServerJob.setUser(config.getUsername());
        sqlServerJob.setHostname(config.getHostname());
        sqlServerJob.setPassword(config.getPassword());
        sqlServerJob.setPort(config.getPort());
        sqlServerJob.setServerName(config.getSchemaName());
        sqlServerJob.setDbname(config.getDatabase());
        SqlServerJob.Offset offset = new SqlServerJob.Offset();
        offset.setFilename(config.getOffsetFilename());
        offset.setSpecificOffsetFile(config.getSpecificOffsetFile());
        offset.setSpecificOffsetPos(config.getSpecificOffsetPos());
        sqlServerJob.setOffset(offset);
        SqlServerJob.Snapshot snapshot = new SqlServerJob.Snapshot();
        snapshot.setMode(config.getSnapshotMode());
        sqlServerJob.setSnapshot(snapshot);
        SqlServerJob.History history = new SqlServerJob.History();
        history.setFilename(config.getHistoryFilename());
        sqlServerJob.setHistory(history);
        return sqlServerJob;
    }

    public static MqttJob getMqttJob(DataConfig dataConfigs) {
        MqttJob.MqttJobConfig config = (MqttJob.MqttJobConfig)GSON.fromJson(dataConfigs.getExtParams(), MqttJob.MqttJobConfig.class);
        MqttJob mqttJob = new MqttJob();
        mqttJob.setServerURI(config.getServerURI());
        mqttJob.setUserName(config.getUsername());
        mqttJob.setPassword(config.getPassword());
        mqttJob.setTopic(config.getTopic());
        mqttJob.setConnectionTimeOut(config.getConnectionTimeOut());
        mqttJob.setKeepAliveInterval(config.getKeepAliveInterval());
        mqttJob.setQos(config.getQos());
        mqttJob.setCleanSession(config.getCleanSession());
        mqttJob.setClientIdPrefix(config.getClientId());
        mqttJob.setQueueSize(config.getQueueSize());
        mqttJob.setAutomaticReconnect(config.getAutomaticReconnect());
        mqttJob.setMqttVersion(config.getMqttVersion());
        return mqttJob;
    }

    private static Proxy getProxy(DataConfig dataConfigs) {
        Proxy proxy = new Proxy();
        Manager manager = new Manager();
        AgentConfiguration agentConf = AgentConfiguration.getAgentConf();
        manager.setHost(agentConf.get("agent.manager.vip.http.host"));
        manager.setPort(agentConf.get("agent.manager.vip.http.port"));
        proxy.setInlongGroupId(dataConfigs.getInlongGroupId());
        proxy.setInlongStreamId(dataConfigs.getInlongStreamId());
        proxy.setManager(manager);
        if (null != dataConfigs.getSyncSend()) {
            proxy.setSync(dataConfigs.getSyncSend() == 1);
        }
        if (null != dataConfigs.getSyncPartitionKey()) {
            proxy.setPartitionKey(dataConfigs.getSyncPartitionKey());
        }
        return proxy;
    }

    public static TaskProfile convertToTaskProfile(DataConfig dataConfig) {
        if (!dataConfig.isValid()) {
            throw new IllegalArgumentException("input dataConfig" + dataConfig + "is invalid please check");
        }
        TaskProfileDto profileDto = new TaskProfileDto();
        Proxy proxy = TaskProfileDto.getProxy(dataConfig);
        profileDto.setProxy(proxy);
        Task task = new Task();
        task.setId(String.valueOf(dataConfig.getTaskId()));
        task.setGroupId(dataConfig.getInlongGroupId());
        task.setStreamId(dataConfig.getInlongStreamId());
        task.setChannel(DEFAULT_CHANNEL);
        task.setIp(dataConfig.getIp());
        task.setOp(dataConfig.getOp());
        task.setDeliveryTime(dataConfig.getDeliveryTime());
        task.setUuid(dataConfig.getUuid());
        task.setVersion(dataConfig.getVersion());
        task.setState(dataConfig.getState());
        task.setPredefinedFields(dataConfig.getPredefinedFields());
        if (dataConfig.getDataReportType().intValue() == DataReportTypeEnum.NORMAL_SEND_TO_DATAPROXY.ordinal()) {
            task.setSink(FILE_DATAPROXY_SINK);
            task.setProxySend(false);
        } else if (dataConfig.getDataReportType() == 1) {
            task.setSink(FILE_DATAPROXY_SINK);
            task.setProxySend(true);
        } else {
            String mqType = ((MQClusterInfo)dataConfig.getMqClusters().get(0)).getMqType();
            task.setMqClusters(GSON.toJson((Object)dataConfig.getMqClusters()));
            task.setTopicInfo(GSON.toJson((Object)dataConfig.getTopicInfo()));
            if (mqType.equals("PULSAR")) {
                task.setSink(PULSAR_SINK);
            } else if (mqType.equals("KAFKA")) {
                task.setSink(KAFKA_SINK);
            } else {
                throw new IllegalArgumentException("input dataConfig" + dataConfig + "is invalid please check");
            }
        }
        TaskTypeEnum taskType = TaskTypeEnum.getTaskType((int)dataConfig.getTaskType());
        switch (Objects.requireNonNull(taskType)) {
            case SQL: 
            case BINLOG: {
                BinlogJob binlogJob = TaskProfileDto.getBinlogJob(dataConfig);
                task.setBinlogJob(binlogJob);
                task.setSource(BINLOG_SOURCE);
                profileDto.setTask(task);
                break;
            }
            case FILE: {
                task.setTaskClass(DEFAULT_FILE_TASK);
                FileTask fileTask = TaskProfileDto.getFileJob(dataConfig);
                task.setFileTask(fileTask);
                task.setSource(DEFAULT_SOURCE);
                profileDto.setTask(task);
                break;
            }
            case KAFKA: {
                KafkaJob kafkaJob = TaskProfileDto.getKafkaJob(dataConfig);
                task.setKafkaJob(kafkaJob);
                task.setSource(KAFKA_SOURCE);
                profileDto.setTask(task);
                break;
            }
            case POSTGRES: {
                PostgreSQLJob postgreSQLJob = TaskProfileDto.getPostgresJob(dataConfig);
                task.setPostgreSQLJob(postgreSQLJob);
                task.setSource(POSTGRESQL_SOURCE);
                profileDto.setTask(task);
                break;
            }
            case ORACLE: {
                OracleJob oracleJob = TaskProfileDto.getOracleJob(dataConfig);
                task.setOracleJob(oracleJob);
                task.setSource(ORACLE_SOURCE);
                profileDto.setTask(task);
                break;
            }
            case SQLSERVER: {
                SqlServerJob sqlserverJob = TaskProfileDto.getSqlServerJob(dataConfig);
                task.setSqlserverJob(sqlserverJob);
                task.setSource(SQLSERVER_SOURCE);
                profileDto.setTask(task);
                break;
            }
            case MONGODB: {
                MongoJob mongoJob = TaskProfileDto.getMongoJob(dataConfig);
                task.setMongoJob(mongoJob);
                task.setSource(MONGO_SOURCE);
                profileDto.setTask(task);
                break;
            }
            case REDIS: {
                RedisJob redisJob = TaskProfileDto.getRedisJob(dataConfig);
                task.setRedisJob(redisJob);
                task.setSource(REDIS_SOURCE);
                profileDto.setTask(task);
                break;
            }
            case MQTT: {
                MqttJob mqttJob = TaskProfileDto.getMqttJob(dataConfig);
                task.setMqttJob(mqttJob);
                task.setSource(MQTT_SOURCE);
                profileDto.setTask(task);
                break;
            }
            case MOCK: {
                profileDto.setTask(task);
                break;
            }
        }
        return TaskProfile.parseJsonStr(GSON.toJson((Object)profileDto));
    }

    public Task getTask() {
        return this.task;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setTask(Task task) {
        this.task = task;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskProfileDto)) {
            return false;
        }
        TaskProfileDto other = (TaskProfileDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Task this$task = this.getTask();
        Task other$task = other.getTask();
        if (this$task == null ? other$task != null : !((Object)this$task).equals(other$task)) {
            return false;
        }
        Proxy this$proxy = this.getProxy();
        Proxy other$proxy = other.getProxy();
        return !(this$proxy == null ? other$proxy != null : !((Object)this$proxy).equals(other$proxy));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TaskProfileDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Task $task = this.getTask();
        result = result * 59 + ($task == null ? 43 : ((Object)$task).hashCode());
        Proxy $proxy = this.getProxy();
        result = result * 59 + ($proxy == null ? 43 : ((Object)$proxy).hashCode());
        return result;
    }

    public String toString() {
        return "TaskProfileDto(task=" + this.getTask() + ", proxy=" + this.getProxy() + ")";
    }

    public static class Proxy {
        private String inlongGroupId;
        private String inlongStreamId;
        private Manager manager;
        private Boolean sync;
        private String partitionKey;

        public String getInlongGroupId() {
            return this.inlongGroupId;
        }

        public String getInlongStreamId() {
            return this.inlongStreamId;
        }

        public Manager getManager() {
            return this.manager;
        }

        public Boolean getSync() {
            return this.sync;
        }

        public String getPartitionKey() {
            return this.partitionKey;
        }

        public void setInlongGroupId(String inlongGroupId) {
            this.inlongGroupId = inlongGroupId;
        }

        public void setInlongStreamId(String inlongStreamId) {
            this.inlongStreamId = inlongStreamId;
        }

        public void setManager(Manager manager) {
            this.manager = manager;
        }

        public void setSync(Boolean sync) {
            this.sync = sync;
        }

        public void setPartitionKey(String partitionKey) {
            this.partitionKey = partitionKey;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Proxy)) {
                return false;
            }
            Proxy other = (Proxy)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$sync = this.getSync();
            Boolean other$sync = other.getSync();
            if (this$sync == null ? other$sync != null : !((Object)this$sync).equals(other$sync)) {
                return false;
            }
            String this$inlongGroupId = this.getInlongGroupId();
            String other$inlongGroupId = other.getInlongGroupId();
            if (this$inlongGroupId == null ? other$inlongGroupId != null : !this$inlongGroupId.equals(other$inlongGroupId)) {
                return false;
            }
            String this$inlongStreamId = this.getInlongStreamId();
            String other$inlongStreamId = other.getInlongStreamId();
            if (this$inlongStreamId == null ? other$inlongStreamId != null : !this$inlongStreamId.equals(other$inlongStreamId)) {
                return false;
            }
            Manager this$manager = this.getManager();
            Manager other$manager = other.getManager();
            if (this$manager == null ? other$manager != null : !((Object)this$manager).equals(other$manager)) {
                return false;
            }
            String this$partitionKey = this.getPartitionKey();
            String other$partitionKey = other.getPartitionKey();
            return !(this$partitionKey == null ? other$partitionKey != null : !this$partitionKey.equals(other$partitionKey));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Proxy;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $sync = this.getSync();
            result = result * 59 + ($sync == null ? 43 : ((Object)$sync).hashCode());
            String $inlongGroupId = this.getInlongGroupId();
            result = result * 59 + ($inlongGroupId == null ? 43 : $inlongGroupId.hashCode());
            String $inlongStreamId = this.getInlongStreamId();
            result = result * 59 + ($inlongStreamId == null ? 43 : $inlongStreamId.hashCode());
            Manager $manager = this.getManager();
            result = result * 59 + ($manager == null ? 43 : ((Object)$manager).hashCode());
            String $partitionKey = this.getPartitionKey();
            result = result * 59 + ($partitionKey == null ? 43 : $partitionKey.hashCode());
            return result;
        }

        public String toString() {
            return "TaskProfileDto.Proxy(inlongGroupId=" + this.getInlongGroupId() + ", inlongStreamId=" + this.getInlongStreamId() + ", manager=" + this.getManager() + ", sync=" + this.getSync() + ", partitionKey=" + this.getPartitionKey() + ")";
        }
    }

    public static class Manager {
        private String port;
        private String host;

        public String getPort() {
            return this.port;
        }

        public String getHost() {
            return this.host;
        }

        public void setPort(String port) {
            this.port = port;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Manager)) {
                return false;
            }
            Manager other = (Manager)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$port = this.getPort();
            String other$port = other.getPort();
            if (this$port == null ? other$port != null : !this$port.equals(other$port)) {
                return false;
            }
            String this$host = this.getHost();
            String other$host = other.getHost();
            return !(this$host == null ? other$host != null : !this$host.equals(other$host));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Manager;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $port = this.getPort();
            result = result * 59 + ($port == null ? 43 : $port.hashCode());
            String $host = this.getHost();
            result = result * 59 + ($host == null ? 43 : $host.hashCode());
            return result;
        }

        public String toString() {
            return "TaskProfileDto.Manager(port=" + this.getPort() + ", host=" + this.getHost() + ")";
        }
    }

    public static class Task {
        private String id;
        private String groupId;
        private String streamId;
        private String ip;
        private String source;
        private String sink;
        private String channel;
        private String name;
        private String op;
        private String retryTime;
        private String deliveryTime;
        private String uuid;
        private Integer version;
        private boolean proxySend;
        private String mqClusters;
        private String topicInfo;
        private String taskClass;
        private String predefinedFields;
        private Integer state;
        private FileTask fileTask;
        private BinlogJob binlogJob;
        private KafkaJob kafkaJob;
        private PostgreSQLJob postgreSQLJob;
        private OracleJob oracleJob;
        private MongoJob mongoJob;
        private RedisJob redisJob;
        private MqttJob mqttJob;
        private SqlServerJob sqlserverJob;

        public String getId() {
            return this.id;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getStreamId() {
            return this.streamId;
        }

        public String getIp() {
            return this.ip;
        }

        public String getSource() {
            return this.source;
        }

        public String getSink() {
            return this.sink;
        }

        public String getChannel() {
            return this.channel;
        }

        public String getName() {
            return this.name;
        }

        public String getOp() {
            return this.op;
        }

        public String getRetryTime() {
            return this.retryTime;
        }

        public String getDeliveryTime() {
            return this.deliveryTime;
        }

        public String getUuid() {
            return this.uuid;
        }

        public Integer getVersion() {
            return this.version;
        }

        public boolean isProxySend() {
            return this.proxySend;
        }

        public String getMqClusters() {
            return this.mqClusters;
        }

        public String getTopicInfo() {
            return this.topicInfo;
        }

        public String getTaskClass() {
            return this.taskClass;
        }

        public String getPredefinedFields() {
            return this.predefinedFields;
        }

        public Integer getState() {
            return this.state;
        }

        public FileTask getFileTask() {
            return this.fileTask;
        }

        public BinlogJob getBinlogJob() {
            return this.binlogJob;
        }

        public KafkaJob getKafkaJob() {
            return this.kafkaJob;
        }

        public PostgreSQLJob getPostgreSQLJob() {
            return this.postgreSQLJob;
        }

        public OracleJob getOracleJob() {
            return this.oracleJob;
        }

        public MongoJob getMongoJob() {
            return this.mongoJob;
        }

        public RedisJob getRedisJob() {
            return this.redisJob;
        }

        public MqttJob getMqttJob() {
            return this.mqttJob;
        }

        public SqlServerJob getSqlserverJob() {
            return this.sqlserverJob;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public void setStreamId(String streamId) {
            this.streamId = streamId;
        }

        public void setIp(String ip) {
            this.ip = ip;
        }

        public void setSource(String source) {
            this.source = source;
        }

        public void setSink(String sink) {
            this.sink = sink;
        }

        public void setChannel(String channel) {
            this.channel = channel;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setOp(String op) {
            this.op = op;
        }

        public void setRetryTime(String retryTime) {
            this.retryTime = retryTime;
        }

        public void setDeliveryTime(String deliveryTime) {
            this.deliveryTime = deliveryTime;
        }

        public void setUuid(String uuid) {
            this.uuid = uuid;
        }

        public void setVersion(Integer version) {
            this.version = version;
        }

        public void setProxySend(boolean proxySend) {
            this.proxySend = proxySend;
        }

        public void setMqClusters(String mqClusters) {
            this.mqClusters = mqClusters;
        }

        public void setTopicInfo(String topicInfo) {
            this.topicInfo = topicInfo;
        }

        public void setTaskClass(String taskClass) {
            this.taskClass = taskClass;
        }

        public void setPredefinedFields(String predefinedFields) {
            this.predefinedFields = predefinedFields;
        }

        public void setState(Integer state) {
            this.state = state;
        }

        public void setFileTask(FileTask fileTask) {
            this.fileTask = fileTask;
        }

        public void setBinlogJob(BinlogJob binlogJob) {
            this.binlogJob = binlogJob;
        }

        public void setKafkaJob(KafkaJob kafkaJob) {
            this.kafkaJob = kafkaJob;
        }

        public void setPostgreSQLJob(PostgreSQLJob postgreSQLJob) {
            this.postgreSQLJob = postgreSQLJob;
        }

        public void setOracleJob(OracleJob oracleJob) {
            this.oracleJob = oracleJob;
        }

        public void setMongoJob(MongoJob mongoJob) {
            this.mongoJob = mongoJob;
        }

        public void setRedisJob(RedisJob redisJob) {
            this.redisJob = redisJob;
        }

        public void setMqttJob(MqttJob mqttJob) {
            this.mqttJob = mqttJob;
        }

        public void setSqlserverJob(SqlServerJob sqlserverJob) {
            this.sqlserverJob = sqlserverJob;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Task)) {
                return false;
            }
            Task other = (Task)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isProxySend() != other.isProxySend()) {
                return false;
            }
            Integer this$version = this.getVersion();
            Integer other$version = other.getVersion();
            if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
                return false;
            }
            Integer this$state = this.getState();
            Integer other$state = other.getState();
            if (this$state == null ? other$state != null : !((Object)this$state).equals(other$state)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$groupId = this.getGroupId();
            String other$groupId = other.getGroupId();
            if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
                return false;
            }
            String this$streamId = this.getStreamId();
            String other$streamId = other.getStreamId();
            if (this$streamId == null ? other$streamId != null : !this$streamId.equals(other$streamId)) {
                return false;
            }
            String this$ip = this.getIp();
            String other$ip = other.getIp();
            if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
                return false;
            }
            String this$source = this.getSource();
            String other$source = other.getSource();
            if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
                return false;
            }
            String this$sink = this.getSink();
            String other$sink = other.getSink();
            if (this$sink == null ? other$sink != null : !this$sink.equals(other$sink)) {
                return false;
            }
            String this$channel = this.getChannel();
            String other$channel = other.getChannel();
            if (this$channel == null ? other$channel != null : !this$channel.equals(other$channel)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$op = this.getOp();
            String other$op = other.getOp();
            if (this$op == null ? other$op != null : !this$op.equals(other$op)) {
                return false;
            }
            String this$retryTime = this.getRetryTime();
            String other$retryTime = other.getRetryTime();
            if (this$retryTime == null ? other$retryTime != null : !this$retryTime.equals(other$retryTime)) {
                return false;
            }
            String this$deliveryTime = this.getDeliveryTime();
            String other$deliveryTime = other.getDeliveryTime();
            if (this$deliveryTime == null ? other$deliveryTime != null : !this$deliveryTime.equals(other$deliveryTime)) {
                return false;
            }
            String this$uuid = this.getUuid();
            String other$uuid = other.getUuid();
            if (this$uuid == null ? other$uuid != null : !this$uuid.equals(other$uuid)) {
                return false;
            }
            String this$mqClusters = this.getMqClusters();
            String other$mqClusters = other.getMqClusters();
            if (this$mqClusters == null ? other$mqClusters != null : !this$mqClusters.equals(other$mqClusters)) {
                return false;
            }
            String this$topicInfo = this.getTopicInfo();
            String other$topicInfo = other.getTopicInfo();
            if (this$topicInfo == null ? other$topicInfo != null : !this$topicInfo.equals(other$topicInfo)) {
                return false;
            }
            String this$taskClass = this.getTaskClass();
            String other$taskClass = other.getTaskClass();
            if (this$taskClass == null ? other$taskClass != null : !this$taskClass.equals(other$taskClass)) {
                return false;
            }
            String this$predefinedFields = this.getPredefinedFields();
            String other$predefinedFields = other.getPredefinedFields();
            if (this$predefinedFields == null ? other$predefinedFields != null : !this$predefinedFields.equals(other$predefinedFields)) {
                return false;
            }
            FileTask this$fileTask = this.getFileTask();
            FileTask other$fileTask = other.getFileTask();
            if (this$fileTask == null ? other$fileTask != null : !((Object)this$fileTask).equals(other$fileTask)) {
                return false;
            }
            BinlogJob this$binlogJob = this.getBinlogJob();
            BinlogJob other$binlogJob = other.getBinlogJob();
            if (this$binlogJob == null ? other$binlogJob != null : !((Object)this$binlogJob).equals(other$binlogJob)) {
                return false;
            }
            KafkaJob this$kafkaJob = this.getKafkaJob();
            KafkaJob other$kafkaJob = other.getKafkaJob();
            if (this$kafkaJob == null ? other$kafkaJob != null : !((Object)this$kafkaJob).equals(other$kafkaJob)) {
                return false;
            }
            PostgreSQLJob this$postgreSQLJob = this.getPostgreSQLJob();
            PostgreSQLJob other$postgreSQLJob = other.getPostgreSQLJob();
            if (this$postgreSQLJob == null ? other$postgreSQLJob != null : !((Object)this$postgreSQLJob).equals(other$postgreSQLJob)) {
                return false;
            }
            OracleJob this$oracleJob = this.getOracleJob();
            OracleJob other$oracleJob = other.getOracleJob();
            if (this$oracleJob == null ? other$oracleJob != null : !((Object)this$oracleJob).equals(other$oracleJob)) {
                return false;
            }
            MongoJob this$mongoJob = this.getMongoJob();
            MongoJob other$mongoJob = other.getMongoJob();
            if (this$mongoJob == null ? other$mongoJob != null : !((Object)this$mongoJob).equals(other$mongoJob)) {
                return false;
            }
            RedisJob this$redisJob = this.getRedisJob();
            RedisJob other$redisJob = other.getRedisJob();
            if (this$redisJob == null ? other$redisJob != null : !((Object)this$redisJob).equals(other$redisJob)) {
                return false;
            }
            MqttJob this$mqttJob = this.getMqttJob();
            MqttJob other$mqttJob = other.getMqttJob();
            if (this$mqttJob == null ? other$mqttJob != null : !((Object)this$mqttJob).equals(other$mqttJob)) {
                return false;
            }
            SqlServerJob this$sqlserverJob = this.getSqlserverJob();
            SqlServerJob other$sqlserverJob = other.getSqlserverJob();
            return !(this$sqlserverJob == null ? other$sqlserverJob != null : !((Object)this$sqlserverJob).equals(other$sqlserverJob));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Task;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isProxySend() ? 79 : 97);
            Integer $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
            Integer $state = this.getState();
            result = result * 59 + ($state == null ? 43 : ((Object)$state).hashCode());
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $groupId = this.getGroupId();
            result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
            String $streamId = this.getStreamId();
            result = result * 59 + ($streamId == null ? 43 : $streamId.hashCode());
            String $ip = this.getIp();
            result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
            String $source = this.getSource();
            result = result * 59 + ($source == null ? 43 : $source.hashCode());
            String $sink = this.getSink();
            result = result * 59 + ($sink == null ? 43 : $sink.hashCode());
            String $channel = this.getChannel();
            result = result * 59 + ($channel == null ? 43 : $channel.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $op = this.getOp();
            result = result * 59 + ($op == null ? 43 : $op.hashCode());
            String $retryTime = this.getRetryTime();
            result = result * 59 + ($retryTime == null ? 43 : $retryTime.hashCode());
            String $deliveryTime = this.getDeliveryTime();
            result = result * 59 + ($deliveryTime == null ? 43 : $deliveryTime.hashCode());
            String $uuid = this.getUuid();
            result = result * 59 + ($uuid == null ? 43 : $uuid.hashCode());
            String $mqClusters = this.getMqClusters();
            result = result * 59 + ($mqClusters == null ? 43 : $mqClusters.hashCode());
            String $topicInfo = this.getTopicInfo();
            result = result * 59 + ($topicInfo == null ? 43 : $topicInfo.hashCode());
            String $taskClass = this.getTaskClass();
            result = result * 59 + ($taskClass == null ? 43 : $taskClass.hashCode());
            String $predefinedFields = this.getPredefinedFields();
            result = result * 59 + ($predefinedFields == null ? 43 : $predefinedFields.hashCode());
            FileTask $fileTask = this.getFileTask();
            result = result * 59 + ($fileTask == null ? 43 : ((Object)$fileTask).hashCode());
            BinlogJob $binlogJob = this.getBinlogJob();
            result = result * 59 + ($binlogJob == null ? 43 : ((Object)$binlogJob).hashCode());
            KafkaJob $kafkaJob = this.getKafkaJob();
            result = result * 59 + ($kafkaJob == null ? 43 : ((Object)$kafkaJob).hashCode());
            PostgreSQLJob $postgreSQLJob = this.getPostgreSQLJob();
            result = result * 59 + ($postgreSQLJob == null ? 43 : ((Object)$postgreSQLJob).hashCode());
            OracleJob $oracleJob = this.getOracleJob();
            result = result * 59 + ($oracleJob == null ? 43 : ((Object)$oracleJob).hashCode());
            MongoJob $mongoJob = this.getMongoJob();
            result = result * 59 + ($mongoJob == null ? 43 : ((Object)$mongoJob).hashCode());
            RedisJob $redisJob = this.getRedisJob();
            result = result * 59 + ($redisJob == null ? 43 : ((Object)$redisJob).hashCode());
            MqttJob $mqttJob = this.getMqttJob();
            result = result * 59 + ($mqttJob == null ? 43 : ((Object)$mqttJob).hashCode());
            SqlServerJob $sqlserverJob = this.getSqlserverJob();
            result = result * 59 + ($sqlserverJob == null ? 43 : ((Object)$sqlserverJob).hashCode());
            return result;
        }

        public String toString() {
            return "TaskProfileDto.Task(id=" + this.getId() + ", groupId=" + this.getGroupId() + ", streamId=" + this.getStreamId() + ", ip=" + this.getIp() + ", source=" + this.getSource() + ", sink=" + this.getSink() + ", channel=" + this.getChannel() + ", name=" + this.getName() + ", op=" + this.getOp() + ", retryTime=" + this.getRetryTime() + ", deliveryTime=" + this.getDeliveryTime() + ", uuid=" + this.getUuid() + ", version=" + this.getVersion() + ", proxySend=" + this.isProxySend() + ", mqClusters=" + this.getMqClusters() + ", topicInfo=" + this.getTopicInfo() + ", taskClass=" + this.getTaskClass() + ", predefinedFields=" + this.getPredefinedFields() + ", state=" + this.getState() + ", fileTask=" + this.getFileTask() + ", binlogJob=" + this.getBinlogJob() + ", kafkaJob=" + this.getKafkaJob() + ", postgreSQLJob=" + this.getPostgreSQLJob() + ", oracleJob=" + this.getOracleJob() + ", mongoJob=" + this.getMongoJob() + ", redisJob=" + this.getRedisJob() + ", mqttJob=" + this.getMqttJob() + ", sqlserverJob=" + this.getSqlserverJob() + ")";
        }
    }
}

