/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.db;

import java.util.ArrayList;
import java.util.List;
import org.apache.inlong.agent.conf.TaskProfile;
import org.apache.inlong.agent.db.Db;
import org.apache.inlong.agent.db.KeyValueEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskProfileDb {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskProfileDb.class);
    private final Db db;

    public TaskProfileDb(Db db) {
        this.db = db;
    }

    public List<TaskProfile> getTasks() {
        List<KeyValueEntity> result = this.db.findAll(this.getKey());
        ArrayList<TaskProfile> taskList = new ArrayList<TaskProfile>();
        for (KeyValueEntity entity : result) {
            taskList.add(entity.getAsTaskProfile());
        }
        return taskList;
    }

    public void storeTask(TaskProfile task) {
        if (task.allRequiredKeyExist()) {
            String keyName = this.getKeyByTaskId(task.getTaskId());
            KeyValueEntity entity = new KeyValueEntity(keyName, task.toJsonStr(), task.get("task.fileTask.dir.patterns"));
            this.db.put(entity);
        }
    }

    public TaskProfile getTask(String taskId) {
        KeyValueEntity result = this.db.get(this.getKeyByTaskId(taskId));
        if (result == null) {
            return null;
        }
        return result.getAsTaskProfile();
    }

    public void deleteTask(String taskId) {
        this.db.remove(this.getKeyByTaskId(taskId));
    }

    private String getKey() {
        return "task_";
    }

    private String getKeyByTaskId(String taskId) {
        return "task_" + taskId;
    }
}

