/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.db;

import java.util.ArrayList;
import java.util.List;
import org.apache.inlong.agent.conf.OffsetProfile;
import org.apache.inlong.agent.db.Db;
import org.apache.inlong.agent.db.KeyValueEntity;
import org.apache.inlong.agent.db.RocksDbImp;
import org.apache.inlong.agent.utils.AgentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OffsetDb {
    private static final Logger LOGGER = LoggerFactory.getLogger(OffsetDb.class);
    private final Db db;

    public OffsetDb(Db db) {
        this.db = db;
    }

    private Db initDb(String childPath) {
        try {
            return new RocksDbImp(childPath);
        }
        catch (Exception ex) {
            throw new UnsupportedClassVersionError(ex.getMessage());
        }
    }

    public List<OffsetProfile> listAllOffsets() {
        List<KeyValueEntity> result = this.db.findAll("");
        ArrayList<OffsetProfile> offsetList = new ArrayList<OffsetProfile>();
        for (KeyValueEntity entity : result) {
            offsetList.add(entity.getAsOffsetProfile());
        }
        return offsetList;
    }

    public OffsetProfile getOffset(String taskId, String instanceId) {
        KeyValueEntity result = this.db.get(this.getKey(taskId, instanceId));
        if (result == null) {
            return null;
        }
        return result.getAsOffsetProfile();
    }

    public void deleteOffset(String taskId, String instanceId) {
        this.db.remove(this.getKey(taskId, instanceId));
    }

    public void setOffset(OffsetProfile offsetProfile) {
        offsetProfile.setLastUpdateTime(AgentUtils.getCurrentTime());
        if (offsetProfile.allRequiredKeyExist()) {
            String keyName = this.getKey(offsetProfile.getTaskId(), offsetProfile.getInstanceId());
            KeyValueEntity entity = new KeyValueEntity(keyName, offsetProfile.toJsonStr(), offsetProfile.get("instance.id"));
            this.db.put(entity);
        }
    }

    private String getKey(String taskId, String instanceId) {
        return "offset_" + taskId + "_" + instanceId;
    }
}

