/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.db;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.inlong.agent.conf.JobProfile;
import org.apache.inlong.agent.db.Db;
import org.apache.inlong.agent.db.KeyValueEntity;
import org.apache.inlong.agent.db.StateSearchKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobProfileDb {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobProfileDb.class);
    private final Db db;

    public JobProfileDb(Db db) {
        this.db = db;
    }

    @Deprecated
    public List<JobProfile> getRestartJobs() {
        List<JobProfile> jobsByState = this.getJobsByState(StateSearchKey.ACCEPTED);
        jobsByState.addAll(this.getJobsByState(StateSearchKey.RUNNING));
        LOGGER.info("try to get restart jobs from db {}", jobsByState);
        return jobsByState;
    }

    public void updateJobState(String jobInstanceId, StateSearchKey stateSearchKey) {
        KeyValueEntity entity = this.db.get(jobInstanceId);
        if (entity != null) {
            entity.setStateSearchKey(stateSearchKey);
            this.db.put(entity);
        }
    }

    public void storeJobFirstTime(JobProfile jobProfile) {
        if (jobProfile.allRequiredKeyExist()) {
            String keyName = jobProfile.get("job.instance.id");
            jobProfile.setLong("job.store.time", System.currentTimeMillis());
            KeyValueEntity entity = new KeyValueEntity(keyName, jobProfile.toJsonStr(), jobProfile.get("job.fileJob.dir.patterns", ""));
            entity.setStateSearchKey(StateSearchKey.ACCEPTED);
            LOGGER.info("store job {} to db", (Object)jobProfile.toJsonStr());
            this.db.put(entity);
        }
    }

    public void updateJobProfile(JobProfile jobProfile) {
        String instanceId = jobProfile.getInstanceId();
        KeyValueEntity entity = this.db.get(instanceId);
        if (entity == null) {
            LOGGER.warn("job profile {} doesn't exist, update job profile fail {}", (Object)instanceId, (Object)jobProfile.toJsonStr());
            return;
        }
        entity.setJsonValue(jobProfile.toJsonStr());
        this.db.put(entity);
    }

    public boolean checkJobfinished(JobProfile jobProfile) {
        KeyValueEntity entity = this.db.get(jobProfile.getInstanceId());
        if (entity == null) {
            LOGGER.info("job profile {} doesn't exist", (Object)jobProfile.getInstanceId());
            return true;
        }
        return entity.checkFinished();
    }

    public void deleteJob(String keyName) {
        this.db.remove(keyName);
    }

    public JobProfile getJobById(String jobId) {
        KeyValueEntity keyValueEntity = this.db.get(jobId);
        if (keyValueEntity != null) {
            return keyValueEntity.getAsJobProfile();
        }
        return null;
    }

    public void removeExpireJobs(long expireTime) {
        List<KeyValueEntity> successEntityList = this.db.search(StateSearchKey.SUCCESS);
        List<KeyValueEntity> failedEntityList = this.db.search(StateSearchKey.FAILED);
        ArrayList<KeyValueEntity> entityList = new ArrayList<KeyValueEntity>(successEntityList);
        entityList.addAll(failedEntityList);
        for (KeyValueEntity entity : entityList) {
            if (!entity.getKey().startsWith("job_")) continue;
            JobProfile profile = entity.getAsJobProfile();
            long storeTime = profile.getLong("job.store.time", 0L);
            long currentTime = System.currentTimeMillis();
            if (storeTime != 0L && currentTime - storeTime <= expireTime) continue;
            LOGGER.info("delete job {} because of timeout store time: {}, expire time: {}", new Object[]{entity.getKey(), storeTime, expireTime});
            this.deleteJob(entity.getKey());
        }
    }

    public JobProfile getJob(StateSearchKey stateSearchKey) {
        KeyValueEntity entity = this.db.searchOne(stateSearchKey);
        if (entity != null && entity.getKey().startsWith("job_")) {
            return entity.getAsJobProfile();
        }
        return null;
    }

    public JobProfile getJobByFileName(String fileName) {
        KeyValueEntity entity = this.db.searchOne(fileName);
        if (entity != null && entity.getKey().startsWith("job_")) {
            return entity.getAsJobProfile();
        }
        return null;
    }

    @Deprecated
    public List<JobProfile> getJobsByState(StateSearchKey stateSearchKey) {
        List<KeyValueEntity> entityList = this.db.searchWithKeyPrefix(stateSearchKey, "job_");
        ArrayList<JobProfile> profileList = new ArrayList<JobProfile>();
        for (KeyValueEntity entity : entityList) {
            profileList.add(entity.getAsJobProfile());
        }
        return profileList;
    }

    public List<JobProfile> getJobsByState(Set<StateSearchKey> stateSearchKeys) {
        return stateSearchKeys.stream().flatMap(stateSearchKey -> this.db.searchWithKeyPrefix((StateSearchKey)((Object)stateSearchKey), "job_").stream()).map(KeyValueEntity::getAsJobProfile).collect(Collectors.toList());
    }

    public List<JobProfile> getAllJobs() {
        return this.getJobsByState(Stream.of(StateSearchKey.values()).collect(Collectors.toSet()));
    }

    public Map<String, List<String>> getJobsState() {
        List<KeyValueEntity> entityList = this.db.search(Arrays.asList(StateSearchKey.values()));
        HashMap<String, List<String>> jobStateMap = new HashMap<String, List<String>>();
        for (KeyValueEntity entity : entityList) {
            ArrayList<String> tmpList = new ArrayList<String>();
            JobProfile jobProfile = entity.getAsJobProfile();
            String jobState = entity.getStateSearchKey().name().concat(":").concat(jobProfile.toJsonStr());
            tmpList.add(jobState);
            List jobStates = jobStateMap.putIfAbsent(jobProfile.get("job.id"), tmpList);
            if (!Objects.nonNull(jobStates) || jobStates.contains(jobState)) continue;
            jobStates.addAll(tmpList);
            jobStateMap.put(jobProfile.get("job.id"), jobStates);
        }
        return jobStateMap;
    }
}

