/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.db;

import java.util.ArrayList;
import java.util.List;
import org.apache.inlong.agent.conf.InstanceProfile;
import org.apache.inlong.agent.db.Db;
import org.apache.inlong.agent.db.KeyValueEntity;
import org.apache.inlong.agent.db.TaskProfileDb;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceDb {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskProfileDb.class);
    private final Db db;

    public InstanceDb(Db db) {
        this.db = db;
    }

    public List<InstanceProfile> getInstances(String taskId) {
        List<KeyValueEntity> result = this.db.findAll(this.getKeyByTaskId(taskId));
        ArrayList<InstanceProfile> instanceList = new ArrayList<InstanceProfile>();
        for (KeyValueEntity entity : result) {
            instanceList.add(entity.getAsInstanceProfile());
        }
        return instanceList;
    }

    public void storeInstance(InstanceProfile instance) {
        if (instance.allRequiredKeyExist()) {
            String keyName = this.getKeyByTaskAndInstanceId(instance.get("task.id"), instance.get("instance.id"));
            KeyValueEntity entity = new KeyValueEntity(keyName, instance.toJsonStr(), instance.get("instance.id"));
            this.db.put(entity);
        } else {
            LOGGER.error("instance profile invalid!");
        }
    }

    public InstanceProfile getInstance(String taskId, String instanceId) {
        KeyValueEntity result = this.db.get(this.getKeyByTaskAndInstanceId(taskId, instanceId));
        if (result == null) {
            return null;
        }
        return result.getAsInstanceProfile();
    }

    public void deleteInstance(String taskId, String instanceId) {
        this.db.remove(this.getKeyByTaskAndInstanceId(taskId, instanceId));
    }

    private String getKey() {
        return "ins_";
    }

    private String getKeyByTaskId(String taskId) {
        return "ins_" + taskId;
    }

    private String getKeyByTaskAndInstanceId(String taskId, String instanceId) {
        return "ins_" + taskId + "_" + instanceId;
    }
}

