/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.conf;

import com.google.gson.Gson;
import java.text.ParseException;
import java.util.TimeZone;
import org.apache.inlong.agent.conf.AbstractConfiguration;
import org.apache.inlong.agent.conf.InstanceProfile;
import org.apache.inlong.agent.pojo.TaskProfileDto;
import org.apache.inlong.agent.utils.AgentUtils;
import org.apache.inlong.agent.utils.DateTransUtils;
import org.apache.inlong.common.enums.InstanceStateEnum;
import org.apache.inlong.common.enums.TaskStateEnum;
import org.apache.inlong.common.pojo.agent.DataConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskProfile
extends AbstractConfiguration {
    private static final Gson GSON = new Gson();
    private static final Logger logger = LoggerFactory.getLogger(TaskProfile.class);

    public static TaskProfile convertToTaskProfile(DataConfig dataConfig) {
        if (dataConfig == null) {
            return null;
        }
        return TaskProfileDto.convertToTaskProfile(dataConfig);
    }

    public String getTaskId() {
        return this.get("task.id");
    }

    public String getCycleUnit() {
        return this.get("task.fileTask.cycleUnit");
    }

    public String getTimeOffset() {
        return this.get("task.fileTask.timeOffset", "");
    }

    public String getTimeZone() {
        return this.get("task.fileTask.timeZone");
    }

    public TaskStateEnum getState() {
        return TaskStateEnum.getTaskState((int)this.getInt("task.state"));
    }

    public void setState(TaskStateEnum state) {
        this.setInt("task.state", state.ordinal());
    }

    public boolean isRetry() {
        return this.getBoolean("task.fileTask.retry", false);
    }

    public String getTaskClass() {
        return this.get("task.taskClass");
    }

    public void setTaskClass(String className) {
        this.set("task.taskClass", className);
    }

    public String getInlongGroupId() {
        return this.get("proxy.inlongGroupId", "default_inlong_group_id");
    }

    public String getInlongStreamId() {
        return this.get("proxy.inlongStreamId", "default_inlong_stream_id");
    }

    public static TaskProfile parseJsonStr(String jsonStr) {
        TaskProfile conf = new TaskProfile();
        conf.loadJsonStrResource(jsonStr);
        return conf;
    }

    @Override
    public boolean allRequiredKeyExist() {
        return this.hasKey("task.id") && this.hasKey("task.source") && this.hasKey("task.sink") && this.hasKey("task.channel") && this.hasKey("task.groupId") && this.hasKey("task.streamId") && this.hasKey("task.fileTask.cycleUnit") && this.hasKey("task.fileTask.timeZone");
    }

    public String toJsonStr() {
        return GSON.toJson(this.getConfigStorage());
    }

    public InstanceProfile createInstanceProfile(String instanceClass, String fileName, String cycleUnit, String dataTime, long fileUpdateTime) {
        InstanceProfile instanceProfile = InstanceProfile.parseJsonStr(this.toJsonStr());
        instanceProfile.setInstanceClass(instanceClass);
        instanceProfile.setInstanceId(fileName);
        instanceProfile.setSourceDataTime(dataTime);
        Long sinkDataTime = 0L;
        try {
            sinkDataTime = DateTransUtils.timeStrConvertToMillSec(dataTime, cycleUnit, TimeZone.getTimeZone(this.getTimeZone()));
        }
        catch (ParseException e) {
            logger.error("createInstanceProfile ParseException error: ", (Throwable)e);
            return null;
        }
        catch (Exception e) {
            logger.error("createInstanceProfile Exception error: ", (Throwable)e);
            return null;
        }
        instanceProfile.setSinkDataTime(sinkDataTime);
        instanceProfile.setCreateTime(AgentUtils.getCurrentTime());
        instanceProfile.setModifyTime(AgentUtils.getCurrentTime());
        instanceProfile.setState(InstanceStateEnum.DEFAULT);
        instanceProfile.setFileUpdateTime(fileUpdateTime);
        return instanceProfile;
    }
}

