/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.conf;

import com.google.gson.Gson;
import org.apache.inlong.agent.conf.AbstractConfiguration;
import org.apache.inlong.agent.constant.TaskConstants;

public class OffsetProfile
extends AbstractConfiguration {
    private static final Gson GSON = new Gson();

    public static OffsetProfile parseJsonStr(String jsonStr) {
        OffsetProfile offsetProfile = new OffsetProfile();
        offsetProfile.loadJsonStrResource(jsonStr);
        return offsetProfile;
    }

    public OffsetProfile() {
    }

    public OffsetProfile(String taskId, String instanceId, long offset, String inodeInfo) {
        this.setTaskId(taskId);
        this.setInstanceId(instanceId);
        this.setOffset(offset);
        this.setInodeInfo(inodeInfo);
    }

    public String toJsonStr() {
        return GSON.toJson(this.getConfigStorage());
    }

    public String getTaskId() {
        return this.get("task.id");
    }

    public void setTaskId(String taskId) {
        this.set("task.id", taskId);
    }

    public String getInstanceId() {
        return this.get("instance.id");
    }

    public void setInstanceId(String instanceId) {
        this.set("instance.id", instanceId);
    }

    public long getLastUpdateTime() {
        return this.getLong("lastUpdateTime", 0L);
    }

    public void setLastUpdateTime(long lastUpdateTime) {
        this.setLong("lastUpdateTime", lastUpdateTime);
    }

    public Long getOffset() {
        return this.getLong("offset", TaskConstants.DEFAULT_OFFSET);
    }

    public void setOffset(Long offset) {
        this.setLong("offset", offset);
    }

    public String getInodeInfo() {
        return this.get("inodeInfo");
    }

    public void setInodeInfo(String inodeInfo) {
        this.set("inodeInfo", inodeInfo);
    }

    @Override
    public boolean allRequiredKeyExist() {
        return this.hasKey("task.id") && this.hasKey("instance.id") && this.hasKey("inodeInfo") && this.hasKey("offset") && this.hasKey("lastUpdateTime");
    }
}

