/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.conf;

import com.google.common.collect.ComparisonChain;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.agent.conf.AbstractConfiguration;
import org.apache.inlong.agent.utils.file.FileUtils;
import org.apache.inlong.common.enums.InstanceStateEnum;
import org.apache.inlong.common.pojo.dataproxy.DataProxyTopicInfo;
import org.apache.inlong.common.pojo.dataproxy.MQClusterInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceProfile
extends AbstractConfiguration
implements Comparable<InstanceProfile> {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstanceProfile.class);
    private static final Gson GSON = new Gson();

    public static InstanceProfile parseJsonStr(String jsonStr) {
        InstanceProfile conf = new InstanceProfile();
        conf.loadJsonStrResource(jsonStr);
        return conf;
    }

    public String toJsonStr() {
        return GSON.toJson(this.getConfigStorage());
    }

    public void setInstanceClass(String className) {
        this.set("task.instance.class", className);
    }

    public String getInstanceClass() {
        return this.get("task.instance.class");
    }

    public String getTaskId() {
        return this.get("task.id");
    }

    public String getInstanceId() {
        return this.get("instance.id");
    }

    public String getSourceClass() {
        return this.get("task.source");
    }

    public String getSinkClass() {
        return this.get("task.sink");
    }

    public InstanceStateEnum getState() {
        int value = this.getInt("instance.state", InstanceStateEnum.DEFAULT.ordinal());
        return InstanceStateEnum.getTaskState((int)value);
    }

    public void setState(InstanceStateEnum state) {
        this.setInt("instance.state", state.ordinal());
    }

    public long getFileUpdateTime() {
        return this.getLong("fileUpdateTime", 0L);
    }

    public void setFileUpdateTime(long lastUpdateTime) {
        this.setLong("fileUpdateTime", lastUpdateTime);
    }

    public String getPredefineFields() {
        return this.get("task.predefinedFields", "");
    }

    public String getInlongGroupId() {
        return this.get("proxy.inlongGroupId", "default_inlong_group_id");
    }

    public String getInlongStreamId() {
        return this.get("proxy.inlongStreamId", "default_inlong_stream_id");
    }

    @Override
    public boolean allRequiredKeyExist() {
        return this.hasKey("fileUpdateTime");
    }

    public List<MQClusterInfo> getMqClusters() {
        List result = null;
        String mqClusterStr = this.get("job.mqClusters");
        if (StringUtils.isNotBlank((CharSequence)mqClusterStr)) {
            result = (List)GSON.fromJson(mqClusterStr, new TypeToken<List<MQClusterInfo>>(){}.getType());
        }
        return result;
    }

    public DataProxyTopicInfo getMqTopic() {
        DataProxyTopicInfo result = null;
        String topicStr = this.get("job.topicInfo");
        if (StringUtils.isNotBlank((CharSequence)topicStr)) {
            result = (DataProxyTopicInfo)GSON.fromJson(topicStr, DataProxyTopicInfo.class);
        }
        return result;
    }

    public void setCreateTime(Long time) {
        this.setLong("instance.createTime", time);
    }

    public Long getCreateTime() {
        return this.getLong("instance.createTime", 0L);
    }

    public void setModifyTime(Long time) {
        this.setLong("instance.modifyTime", time);
    }

    public Long getModifyTime() {
        return this.getLong("instance.modifyTime", 0L);
    }

    public void setInstanceId(String instanceId) {
        this.set("instance.id", instanceId);
    }

    public void setSourceDataTime(String dataTime) {
        this.set("source.dataTime", dataTime);
    }

    public String getSourceDataTime() {
        return this.get("source.dataTime");
    }

    public void setSinkDataTime(Long dataTime) {
        this.setLong("sink.dataTime", dataTime);
    }

    public Long getSinkDataTime() {
        return this.getLong("sink.dataTime", 0L);
    }

    @Override
    public int compareTo(InstanceProfile object) {
        int ret = ComparisonChain.start().compare((Comparable)((Object)this.getSourceDataTime()), (Comparable)((Object)object.getSourceDataTime())).compare(FileUtils.getFileCreationTime(this.getInstanceId()), FileUtils.getFileCreationTime(object.getInstanceId())).compare(FileUtils.getFileLastModifyTime(this.getInstanceId()), FileUtils.getFileLastModifyTime(object.getInstanceId())).result();
        return ret;
    }

    public boolean isRetry() {
        return this.getBoolean("task.fileTask.retry", false);
    }
}

