/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.service.consume;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.audit.config.MessageQueueConfig;
import org.apache.inlong.audit.config.StoreConfig;
import org.apache.inlong.audit.service.InsertData;
import org.apache.inlong.audit.service.consume.BaseConsume;
import org.apache.inlong.audit.service.consume.TubeConsume;
import org.apache.inlong.tubemq.client.config.ConsumerConfig;
import org.apache.inlong.tubemq.client.config.TubeClientConfig;
import org.apache.inlong.tubemq.client.consumer.ConsumePosition;
import org.apache.inlong.tubemq.client.consumer.PullMessageConsumer;
import org.apache.inlong.tubemq.client.exception.TubeClientException;
import org.apache.inlong.tubemq.client.factory.TubeMultiSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TubeConsume
extends BaseConsume {
    private static final Logger LOG = LoggerFactory.getLogger(TubeConsume.class);
    private PullMessageConsumer pullConsumer;
    private TubeMultiSessionFactory sessionFactory;
    private String masterUrl;
    private String topic;
    private int fetchThreadCnt = 4;

    public TubeConsume(List<InsertData> insertServiceList, StoreConfig storeConfig, MessageQueueConfig mqConfig) {
        super(insertServiceList, storeConfig, mqConfig);
    }

    public void start() {
        this.masterUrl = this.mqConfig.getTubeMasterList();
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)this.masterUrl), (Object)"no tube masterUrlList specified");
        this.topic = this.mqConfig.getTubeTopic();
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)this.topic), (Object)"no tube topic specified");
        this.fetchThreadCnt = this.mqConfig.getTubeThreadNum();
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)this.mqConfig.getTubeConsumerGroupName()), (Object)"no tube consumer groupName specified");
        this.initConsumer();
        Thread[] fetchRunners = new Thread[this.fetchThreadCnt];
        for (int i = 0; i < this.fetchThreadCnt; ++i) {
            fetchRunners[i] = new Thread((Runnable)new Fetcher(this, this.pullConsumer, this.topic), "TubeConsume_Fetcher_Thread_" + i);
            fetchRunners[i].start();
        }
    }

    private void initConsumer() {
        LOG.info("init tube consumer, topic:{}, masterList:{}", (Object)this.topic, (Object)this.masterUrl);
        ConsumerConfig consumerConfig = new ConsumerConfig(this.masterUrl, this.mqConfig.getTubeConsumerGroupName());
        consumerConfig.setConsumePosition(ConsumePosition.CONSUMER_FROM_LATEST_OFFSET);
        try {
            this.sessionFactory = new TubeMultiSessionFactory((TubeClientConfig)consumerConfig);
            this.pullConsumer = this.sessionFactory.createPullConsumer(consumerConfig);
            this.pullConsumer.subscribe(this.topic, null);
            this.pullConsumer.completeSubscribe();
        }
        catch (TubeClientException e) {
            LOG.error("init tube consumer error {}", (Object)e.getMessage());
        }
    }

    static /* synthetic */ Logger access$000() {
        return LOG;
    }
}

