/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.service;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.inlong.audit.config.ElasticsearchConfig;
import org.apache.inlong.audit.db.entities.ESDataPo;
import org.apache.inlong.audit.protocol.AuditData;
import org.apache.inlong.audit.service.InsertData;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.rest.RestStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class ElasticsearchService
implements InsertData,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticsearchService.class);
    private static ScheduledExecutorService timerService = Executors.newScheduledThreadPool(1);
    private final Semaphore semaphore = new Semaphore(1);
    private List<ESDataPo> datalist = new ArrayList();
    @Autowired
    @Qualifier(value="restClient")
    private RestHighLevelClient client;
    @Autowired
    private ElasticsearchConfig esConfig;

    public void startTimerRoutine() {
        timerService.scheduleAtFixedRate((Runnable)new /* Unavailable Anonymous Inner Class!! */, 1L, 1L, TimeUnit.DAYS);
        timerService.scheduleWithFixedDelay((Runnable)new /* Unavailable Anonymous Inner Class!! */, this.esConfig.getBulkInterval(), this.esConfig.getBulkInterval(), TimeUnit.SECONDS);
    }

    public void insertData(ESDataPo data) {
        if (this.datalist.size() >= this.esConfig.getBulkThreshold()) {
            try {
                if (this.bulkInsert()) {
                    LOG.info("success bulk insert {} docs", (Object)this.esConfig.getBulkThreshold());
                } else {
                    LOG.error("failed to bulk insert");
                }
            }
            catch (IOException e) {
                LOG.error("bulkInsert has err: ", (Throwable)e);
            }
        }
        try {
            this.semaphore.acquire();
            this.datalist.add(data);
            this.semaphore.release();
        }
        catch (InterruptedException e) {
            LOG.error("datalist semaphore has err: ", (Throwable)e);
        }
    }

    protected boolean createIndex(String index) throws IOException {
        if (this.existsIndex(index)) {
            return true;
        }
        CreateIndexRequest createIndexRequest = new CreateIndexRequest(index);
        createIndexRequest.settings(Settings.builder().put("index.number_of_shards", this.esConfig.getShardsNum()).put("index.number_of_replicas", this.esConfig.getReplicaNum()));
        createIndexRequest.mapping("_doc", this.generateBuilder());
        CreateIndexResponse response = this.client.indices().create(createIndexRequest, RequestOptions.DEFAULT);
        boolean res = response.isAcknowledged();
        if (res) {
            LOG.info("success creating index {}", (Object)index);
        } else {
            LOG.info("fail to create index {}", (Object)index);
        }
        return res;
    }

    protected boolean existsIndex(String index) throws IOException {
        GetIndexRequest getIndexRequest = new GetIndexRequest();
        getIndexRequest.indices(new String[]{index});
        return this.client.indices().exists(getIndexRequest, RequestOptions.DEFAULT);
    }

    protected boolean bulkInsert() throws IOException {
        if (this.datalist.isEmpty()) {
            return true;
        }
        BulkRequest bulkRequest = new BulkRequest();
        try {
            this.semaphore.acquire();
            for (ESDataPo esDataPo : this.datalist) {
                SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
                String index = formatter.format(esDataPo.getLogTs()) + "_" + esDataPo.getAuditId();
                GsonBuilder gsonBuilder = new GsonBuilder();
                gsonBuilder.setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setDateFormat("yyyy-MM-dd HH:mm:ss");
                Gson gson = gsonBuilder.create();
                String esJson = gson.toJson((Object)esDataPo);
                if (!this.createIndex(index)) {
                    LOG.error("fail to create index {}", (Object)index);
                    continue;
                }
                IndexRequest indexRequest = this.esConfig.isEnableCustomDocId() ? new IndexRequest(index).type("_doc").id(esDataPo.getDocId()).source(esJson, XContentType.JSON) : new IndexRequest(index).type("_doc").source(esJson, XContentType.JSON);
                bulkRequest.add(indexRequest);
            }
            BulkResponse bulkResponse = this.client.bulk(bulkRequest, RequestOptions.DEFAULT);
            this.datalist.clear();
            this.semaphore.release();
            return bulkResponse.status().equals((Object)RestStatus.OK);
        }
        catch (InterruptedException e) {
            LOG.error("datalist semaphore has err: ", (Throwable)e);
            return false;
        }
    }

    protected void deleteTimeoutIndices() throws IOException {
        List auditIdList = this.esConfig.getAuditIdList();
        if (auditIdList.isEmpty()) {
            return;
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -this.esConfig.getIndexDeleteDay());
        Date deleteDay = calendar.getTime();
        String preIndex = formatter.format(deleteDay);
        for (String auditId : auditIdList) {
            String index = preIndex + "_" + auditId;
            this.deleteSingleIndex(index);
        }
    }

    protected boolean deleteSingleIndex(String index) throws IOException {
        if (!this.existsIndex(index)) {
            return true;
        }
        DeleteIndexRequest deleteIndexRequest = new DeleteIndexRequest(index);
        AcknowledgedResponse deleteIndexResponse = this.client.indices().delete(deleteIndexRequest, RequestOptions.DEFAULT);
        boolean res = deleteIndexResponse.isAcknowledged();
        if (res) {
            LOG.info("success deleting index {}", (Object)index);
        } else {
            LOG.error("fail to delete index {}", (Object)index);
        }
        return res;
    }

    @Override
    public void close() {
        try {
            this.bulkInsert();
        }
        catch (IOException e) {
            LOG.error("bulkInsert has err: ", (Throwable)e);
        }
        timerService.shutdown();
    }

    protected XContentBuilder generateBuilder() throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder();
        builder.startObject();
        builder.startObject("properties");
        builder.startObject("audit_id");
        builder.field("type", "keyword");
        builder.endObject();
        builder.startObject("audit_tag");
        builder.field("type", "keyword");
        builder.endObject();
        builder.startObject("inlong_group_id");
        builder.field("type", "keyword");
        builder.endObject();
        builder.startObject("inlong_stream_id");
        builder.field("type", "keyword");
        builder.endObject();
        builder.startObject("docker_id");
        builder.field("type", "keyword");
        builder.endObject();
        builder.startObject("thread_id");
        builder.field("type", "keyword");
        builder.endObject();
        builder.startObject("ip");
        builder.field("type", "keyword");
        builder.endObject();
        builder.startObject("log_ts");
        builder.field("type", "keyword");
        builder.endObject();
        builder.startObject("sdk_ts");
        builder.field("type", "long");
        builder.endObject();
        builder.startObject("count");
        builder.field("type", "long");
        builder.endObject();
        builder.startObject("size");
        builder.field("type", "long");
        builder.endObject();
        builder.startObject("delay");
        builder.field("type", "long");
        builder.endObject();
        builder.startObject("packet_id");
        builder.field("type", "long");
        builder.endObject();
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public void insert(AuditData msgBody) {
        ESDataPo esPo = new ESDataPo();
        esPo.setIp(msgBody.getIp());
        esPo.setThreadId(msgBody.getThreadId());
        esPo.setDockerId(msgBody.getDockerId());
        esPo.setSdkTs(new Date(msgBody.getSdkTs()).getTime());
        esPo.setLogTs(new Date(msgBody.getLogTs()));
        esPo.setAuditId(msgBody.getAuditId());
        esPo.setAuditTag(msgBody.getAuditTag());
        esPo.setCount(msgBody.getCount());
        esPo.setDelay(msgBody.getDelay());
        esPo.setInlongGroupId(msgBody.getInlongGroupId());
        esPo.setInlongStreamId(msgBody.getInlongStreamId());
        esPo.setSize(msgBody.getSize());
        esPo.setPacketId(msgBody.getPacketId());
        this.insertData(esPo);
    }

    static /* synthetic */ Logger access$000() {
        return LOG;
    }
}

