/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.service;

import com.google.gson.Gson;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.apache.inlong.audit.config.ClickHouseConfig;
import org.apache.inlong.audit.config.MessageQueueConfig;
import org.apache.inlong.audit.config.StoreConfig;
import org.apache.inlong.audit.db.dao.AuditDataDao;
import org.apache.inlong.audit.file.RemoteConfigJson;
import org.apache.inlong.audit.service.ClickHouseService;
import org.apache.inlong.audit.service.ElasticsearchService;
import org.apache.inlong.audit.service.InsertData;
import org.apache.inlong.audit.service.MySqlService;
import org.apache.inlong.audit.service.consume.KafkaConsume;
import org.apache.inlong.audit.service.consume.PulsarConsume;
import org.apache.inlong.audit.service.consume.TubeConsume;
import org.apache.inlong.common.pojo.audit.AuditConfigRequest;
import org.apache.inlong.common.pojo.audit.MQInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AuditMsgConsumerServer
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(AuditMsgConsumerServer.class);
    @Autowired
    private MessageQueueConfig mqConfig;
    @Autowired
    private AuditDataDao auditDataDao;
    @Autowired
    private ElasticsearchService esService;
    @Autowired
    private StoreConfig storeConfig;
    @Autowired
    private ClickHouseConfig chConfig;
    private ClickHouseService ckService;
    private static final String DEFAULT_CONFIG_PROPERTIES = "application.properties";
    private static final int INTERVAL_MS = 5000;
    private final CloseableHttpClient httpClient = HttpClientBuilder.create().build();
    private final Gson gson = new Gson();

    public void afterPropertiesSet() {
        List mqInfoList = this.getClusterFromManager();
        PulsarConsume mqConsume = null;
        List insertServiceList = this.getInsertServiceList();
        for (MQInfo mqInfo : mqInfoList) {
            if (this.mqConfig.isPulsar() && "PULSAR".equals(mqInfo.getMqType())) {
                this.mqConfig.setPulsarServerUrl(mqInfo.getUrl());
                mqConsume = new PulsarConsume(insertServiceList, this.storeConfig, this.mqConfig);
                break;
            }
            if (this.mqConfig.isTube() && "TUBEMQ".equals(mqInfo.getMqType())) {
                this.mqConfig.setTubeMasterList(mqInfo.getUrl());
                mqConsume = new TubeConsume(insertServiceList, this.storeConfig, this.mqConfig);
                break;
            }
            if (!this.mqConfig.isKafka() || !"KAFKA".equals(mqInfo.getMqType())) continue;
            this.mqConfig.setKafkaServerUrl(mqInfo.getUrl());
            mqConsume = new KafkaConsume(insertServiceList, this.storeConfig, this.mqConfig);
            break;
        }
        if (mqConsume == null) {
            LOG.error("Unknown MessageQueue {}", (Object)this.mqConfig.getMqType());
        }
        if (this.storeConfig.isElasticsearchStore()) {
            this.esService.startTimerRoutine();
        }
        if (this.storeConfig.isClickHouseStore()) {
            this.ckService.start();
        }
        mqConsume.start();
    }

    private List<InsertData> getInsertServiceList() {
        ArrayList<InsertData> insertServiceList = new ArrayList<InsertData>();
        if (this.storeConfig.isMysqlStore()) {
            insertServiceList.add((InsertData)new MySqlService(this.auditDataDao));
        }
        if (this.storeConfig.isElasticsearchStore()) {
            insertServiceList.add((InsertData)this.esService);
        }
        if (this.storeConfig.isClickHouseStore()) {
            this.ckService = new ClickHouseService(this.chConfig);
            insertServiceList.add((InsertData)this.ckService);
        }
        return insertServiceList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<MQInfo> getClusterFromManager() {
        Properties properties = new Properties();
        try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(DEFAULT_CONFIG_PROPERTIES);){
            String[] hostList;
            properties.load(inputStream);
            String managerHosts = properties.getProperty("manager.hosts");
            String clusterTag = properties.getProperty("proxy.cluster.tag");
            String[] stringArray = hostList = StringUtils.split((String)managerHosts, (String)",");
            int n = stringArray.length;
            int n2 = 0;
            if (n2 >= n) return null;
            String host = stringArray[n2];
            while (true) {
                List mqConfig;
                if (ObjectUtils.isNotEmpty((Object)(mqConfig = this.getMQConfig(host, clusterTag)))) {
                    List list = mqConfig;
                    return list;
                }
                LOG.info("MQ config may not be registered yet, wait for 5s and try again");
                Thread.sleep(5000L);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MQInfo> getMQConfig(String host, String clusterTag) {
        HttpPost httpPost = null;
        try {
            List mqInfoList;
            String url = "http://" + host + "/inlong/manager/openapi" + "/audit/getConfig";
            LOG.info("start to request {} to get config info", (Object)url);
            httpPost = new HttpPost(url);
            httpPost.addHeader("Connection", "close");
            AuditConfigRequest request = new AuditConfigRequest();
            request.setClusterTag(clusterTag);
            StringEntity stringEntity = new StringEntity(this.gson.toJson((Object)request));
            stringEntity.setContentType("application/json");
            httpPost.setEntity((HttpEntity)stringEntity);
            LOG.info("start to request {} to get config info with params {}", (Object)url, (Object)request);
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);
            String returnStr = EntityUtils.toString((HttpEntity)response.getEntity());
            RemoteConfigJson configJson = (RemoteConfigJson)this.gson.fromJson(returnStr, RemoteConfigJson.class);
            if (configJson.isSuccess() && configJson.getData() != null && (mqInfoList = configJson.getData().getMqInfoList()) != null && !mqInfoList.isEmpty()) {
                List list = mqInfoList;
                return list;
            }
        }
        catch (Exception ex) {
            LOG.error("Failed to get MQ config from manager, please check it", (Throwable)ex);
            List<MQInfo> list = null;
            return list;
        }
        finally {
            if (httpPost != null) {
                httpPost.releaseConnection();
            }
        }
        return null;
    }
}

