/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.db;

import com.alibaba.druid.pool.DruidDataSource;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.inlong.audit.config.StoreConfig;
import org.apache.inlong.audit.db.DruidDataSourceProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={DruidDataSourceProperties.class})
public class DruidConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(DruidConfig.class);
    @Autowired
    protected StoreConfig storeConfig;
    @Autowired
    private DruidDataSourceProperties properties;

    @Bean
    @ConditionalOnMissingBean
    public DataSource druidDataSource() {
        LOGGER.info("druidDataSource url = {} ", (Object)this.properties.getUrl());
        DruidDataSource druidDataSource = new DruidDataSource();
        druidDataSource.setDriverClassName(this.properties.getDriverClassName());
        druidDataSource.setUrl(this.properties.getUrl());
        druidDataSource.setUsername(this.properties.getUsername());
        druidDataSource.setPassword(this.properties.getPassword());
        druidDataSource.setInitialSize(this.properties.getInitialSize());
        druidDataSource.setMinIdle(this.properties.getMinIdle());
        druidDataSource.setMaxActive(this.properties.getMaxActive());
        druidDataSource.setMaxWait(this.properties.getMaxWait());
        druidDataSource.setTimeBetweenEvictionRunsMillis(this.properties.getTimeBetweenEvictionRunsMillis());
        druidDataSource.setMinEvictableIdleTimeMillis(this.properties.getMinEvictableIdleTimeMillis());
        druidDataSource.setValidationQuery(this.properties.getValidationQuery());
        druidDataSource.setTestWhileIdle(this.properties.isTestWhileIdle());
        druidDataSource.setTestOnBorrow(this.properties.isTestOnBorrow());
        druidDataSource.setTestOnReturn(this.properties.isTestOnReturn());
        druidDataSource.setPoolPreparedStatements(this.properties.isPoolPreparedStatements());
        druidDataSource.setMaxPoolPreparedStatementPerConnectionSize(this.properties.getMaxPoolPreparedStatementPerConnectionSize());
        try {
            druidDataSource.setFilters(this.properties.getFilters());
            if (this.storeConfig.isMysqlStore()) {
                druidDataSource.init();
            }
        }
        catch (SQLException e) {
            LOGGER.error("init druidDataSource failed: ", (Throwable)e);
        }
        return druidDataSource;
    }
}

