/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class MessageQueueConfig {
    @Value(value="${audit.pulsar.server.url:}")
    private String pulsarServerUrl;
    @Value(value="${audit.pulsar.topic:}")
    private String pulsarTopic;
    @Value(value="${audit.pulsar.consumer.sub.name:}")
    private String pulsarConsumerSubName;
    @Value(value="${audit.pulsar.consumer.enable.retry:false}")
    private boolean pulsarConsumerEnableRetry = false;
    @Value(value="${audit.pulsar.token:}")
    private String pulsarToken;
    @Value(value="${audit.pulsar.enable.auth:false}")
    private boolean pulsarEnableAuth;
    @Value(value="${audit.pulsar.consumer.receive.queue.size:1000}")
    private int consumerReceiveQueueSize = 1000;
    @Value(value="${audit.pulsar.client.operation.timeout.second:30}")
    private int clientOperationTimeoutSecond = 30;
    @Value(value="${audit.pulsar.client.concurrent.consumer.num:1}")
    private int concurrentConsumerNum = 1;
    @Value(value="${audit.tube.masterlist:}")
    private String tubeMasterList;
    @Value(value="${audit.tube.topic:}")
    private String tubeTopic;
    @Value(value="${audit.tube.consumer.group.name:}")
    private String tubeConsumerGroupName;
    @Value(value="${audit.tube.consumer.thread.num:4}")
    private int tubeThreadNum;
    @Value(value="${audit.kafka.server.url:}")
    private String kafkaServerUrl;
    @Value(value="${audit.kafka.topic:}")
    private String kafkaTopic;
    @Value(value="${audit.kafka.topic.numPartitions:3}")
    private String numPartitions;
    @Value(value="${audit.kafka.topic.replicationFactor:2}")
    private String replicationFactor;
    @Value(value="${audit.kafka.consumer.name:}")
    private String kafkaConsumerName;
    @Value(value="${audit.kafka.group.id:audit-consumer-group}")
    private String kafkaGroupId;
    @Value(value="${audit.kafka.enable.auto.commit:true}")
    private String enableAutoCommit;
    @Value(value="${audit.kafka.auto.commit.interval.ms:1000}")
    private String autoCommitIntervalMs;
    @Value(value="${audit.kafka.fetch.wait.ms:100}")
    private long fetchWaitMs = 100L;
    @Value(value="${audit.kafka.auto.offset.reset:earliest}")
    private String autoOffsetReset;
    @Value(value="${audit.config.proxy.type:pulsar}")
    private String mqType;

    public boolean isPulsar() {
        return this.mqType.trim().equalsIgnoreCase("pulsar");
    }

    public boolean isTube() {
        return this.mqType.trim().equalsIgnoreCase("tube");
    }

    public boolean isKafka() {
        return this.mqType.trim().equalsIgnoreCase("kafka");
    }

    public String getPulsarServerUrl() {
        return this.pulsarServerUrl;
    }

    public String getPulsarTopic() {
        return this.pulsarTopic;
    }

    public String getPulsarConsumerSubName() {
        return this.pulsarConsumerSubName;
    }

    public boolean isPulsarConsumerEnableRetry() {
        return this.pulsarConsumerEnableRetry;
    }

    public String getPulsarToken() {
        return this.pulsarToken;
    }

    public boolean isPulsarEnableAuth() {
        return this.pulsarEnableAuth;
    }

    public int getConsumerReceiveQueueSize() {
        return this.consumerReceiveQueueSize;
    }

    public int getClientOperationTimeoutSecond() {
        return this.clientOperationTimeoutSecond;
    }

    public int getConcurrentConsumerNum() {
        return this.concurrentConsumerNum;
    }

    public String getTubeMasterList() {
        return this.tubeMasterList;
    }

    public String getTubeTopic() {
        return this.tubeTopic;
    }

    public String getTubeConsumerGroupName() {
        return this.tubeConsumerGroupName;
    }

    public int getTubeThreadNum() {
        return this.tubeThreadNum;
    }

    public String getKafkaServerUrl() {
        return this.kafkaServerUrl;
    }

    public String getKafkaTopic() {
        return this.kafkaTopic;
    }

    public String getNumPartitions() {
        return this.numPartitions;
    }

    public String getReplicationFactor() {
        return this.replicationFactor;
    }

    public String getKafkaConsumerName() {
        return this.kafkaConsumerName;
    }

    public String getKafkaGroupId() {
        return this.kafkaGroupId;
    }

    public String getEnableAutoCommit() {
        return this.enableAutoCommit;
    }

    public String getAutoCommitIntervalMs() {
        return this.autoCommitIntervalMs;
    }

    public long getFetchWaitMs() {
        return this.fetchWaitMs;
    }

    public String getAutoOffsetReset() {
        return this.autoOffsetReset;
    }

    public String getMqType() {
        return this.mqType;
    }

    public void setPulsarServerUrl(String pulsarServerUrl) {
        this.pulsarServerUrl = pulsarServerUrl;
    }

    public void setPulsarTopic(String pulsarTopic) {
        this.pulsarTopic = pulsarTopic;
    }

    public void setPulsarConsumerSubName(String pulsarConsumerSubName) {
        this.pulsarConsumerSubName = pulsarConsumerSubName;
    }

    public void setPulsarConsumerEnableRetry(boolean pulsarConsumerEnableRetry) {
        this.pulsarConsumerEnableRetry = pulsarConsumerEnableRetry;
    }

    public void setPulsarToken(String pulsarToken) {
        this.pulsarToken = pulsarToken;
    }

    public void setPulsarEnableAuth(boolean pulsarEnableAuth) {
        this.pulsarEnableAuth = pulsarEnableAuth;
    }

    public void setConsumerReceiveQueueSize(int consumerReceiveQueueSize) {
        this.consumerReceiveQueueSize = consumerReceiveQueueSize;
    }

    public void setClientOperationTimeoutSecond(int clientOperationTimeoutSecond) {
        this.clientOperationTimeoutSecond = clientOperationTimeoutSecond;
    }

    public void setConcurrentConsumerNum(int concurrentConsumerNum) {
        this.concurrentConsumerNum = concurrentConsumerNum;
    }

    public void setTubeMasterList(String tubeMasterList) {
        this.tubeMasterList = tubeMasterList;
    }

    public void setTubeTopic(String tubeTopic) {
        this.tubeTopic = tubeTopic;
    }

    public void setTubeConsumerGroupName(String tubeConsumerGroupName) {
        this.tubeConsumerGroupName = tubeConsumerGroupName;
    }

    public void setTubeThreadNum(int tubeThreadNum) {
        this.tubeThreadNum = tubeThreadNum;
    }

    public void setKafkaServerUrl(String kafkaServerUrl) {
        this.kafkaServerUrl = kafkaServerUrl;
    }

    public void setKafkaTopic(String kafkaTopic) {
        this.kafkaTopic = kafkaTopic;
    }

    public void setNumPartitions(String numPartitions) {
        this.numPartitions = numPartitions;
    }

    public void setReplicationFactor(String replicationFactor) {
        this.replicationFactor = replicationFactor;
    }

    public void setKafkaConsumerName(String kafkaConsumerName) {
        this.kafkaConsumerName = kafkaConsumerName;
    }

    public void setKafkaGroupId(String kafkaGroupId) {
        this.kafkaGroupId = kafkaGroupId;
    }

    public void setEnableAutoCommit(String enableAutoCommit) {
        this.enableAutoCommit = enableAutoCommit;
    }

    public void setAutoCommitIntervalMs(String autoCommitIntervalMs) {
        this.autoCommitIntervalMs = autoCommitIntervalMs;
    }

    public void setFetchWaitMs(long fetchWaitMs) {
        this.fetchWaitMs = fetchWaitMs;
    }

    public void setAutoOffsetReset(String autoOffsetReset) {
        this.autoOffsetReset = autoOffsetReset;
    }

    public void setMqType(String mqType) {
        this.mqType = mqType;
    }
}

