/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ElasticsearchConfig {
    @Value(value="${elasticsearch.host}")
    private String host;
    @Value(value="${elasticsearch.port}")
    private int port;
    @Value(value="${elasticsearch.connTimeout:3000}")
    private int connTimeout;
    @Value(value="${elasticsearch.socketTimeout:5000}")
    private int socketTimeout;
    @Value(value="${elasticsearch.connectionRequestTimeout:500}")
    private int connectionRequestTimeout;
    @Value(value="${elasticsearch.authEnable:false}")
    private boolean authEnable;
    @Value(value="${elasticsearch.username}")
    private String username;
    @Value(value="${elasticsearch.password}")
    private String password;
    @Value(value="${elasticsearch.shardsNum:5}")
    private int shardsNum;
    @Value(value="${elasticsearch.replicaNum:1}")
    private int replicaNum;
    @Value(value="${elasticsearch.indexDeleteDay:5}")
    private int indexDeleteDay;
    @Value(value="${elasticsearch.enableCustomDocId:true}")
    private boolean enableCustomDocId;
    @Value(value="${elasticsearch.bulkInterval:10}")
    private int bulkInterval;
    @Value(value="${elasticsearch.bulkThreshold:5000}")
    private int bulkThreshold;
    @Value(value="${elasticsearch.auditIdSet}")
    private String auditIdSet;

    @Bean(destroyMethod="close", name={"restClient"})
    public RestHighLevelClient initRestClient() {
        String[] hostArrays;
        ArrayList<HttpHost> hosts = new ArrayList<HttpHost>();
        for (String host : hostArrays = this.host.split(",")) {
            if (!StringUtils.isNotEmpty((CharSequence)host)) continue;
            hosts.add(new HttpHost(host.trim(), this.port, "http"));
        }
        RestClientBuilder restClientBuilder = RestClient.builder((HttpHost[])hosts.toArray(new HttpHost[0]));
        if (this.authEnable) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.username, this.password));
            restClientBuilder.setHttpClientConfigCallback(arg_0 -> ElasticsearchConfig.lambda$initRestClient$0((CredentialsProvider)credentialsProvider, arg_0));
        }
        restClientBuilder.setRequestConfigCallback(requestConfigBuilder -> requestConfigBuilder.setConnectTimeout(this.connTimeout).setSocketTimeout(this.socketTimeout).setConnectionRequestTimeout(this.connectionRequestTimeout));
        return new RestHighLevelClient(restClientBuilder);
    }

    public List<String> getAuditIdList() {
        List<String> auditIdList = new ArrayList<String>();
        if (!StringUtils.isEmpty((CharSequence)this.auditIdSet)) {
            auditIdList = Arrays.asList(this.auditIdSet.split(","));
        }
        return auditIdList;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getConnTimeout() {
        return this.connTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public int getConnectionRequestTimeout() {
        return this.connectionRequestTimeout;
    }

    public boolean isAuthEnable() {
        return this.authEnable;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public int getShardsNum() {
        return this.shardsNum;
    }

    public int getReplicaNum() {
        return this.replicaNum;
    }

    public int getIndexDeleteDay() {
        return this.indexDeleteDay;
    }

    public boolean isEnableCustomDocId() {
        return this.enableCustomDocId;
    }

    public int getBulkInterval() {
        return this.bulkInterval;
    }

    public int getBulkThreshold() {
        return this.bulkThreshold;
    }

    public String getAuditIdSet() {
        return this.auditIdSet;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setConnTimeout(int connTimeout) {
        this.connTimeout = connTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public void setConnectionRequestTimeout(int connectionRequestTimeout) {
        this.connectionRequestTimeout = connectionRequestTimeout;
    }

    public void setAuthEnable(boolean authEnable) {
        this.authEnable = authEnable;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setShardsNum(int shardsNum) {
        this.shardsNum = shardsNum;
    }

    public void setReplicaNum(int replicaNum) {
        this.replicaNum = replicaNum;
    }

    public void setIndexDeleteDay(int indexDeleteDay) {
        this.indexDeleteDay = indexDeleteDay;
    }

    public void setEnableCustomDocId(boolean enableCustomDocId) {
        this.enableCustomDocId = enableCustomDocId;
    }

    public void setBulkInterval(int bulkInterval) {
        this.bulkInterval = bulkInterval;
    }

    public void setBulkThreshold(int bulkThreshold) {
        this.bulkThreshold = bulkThreshold;
    }

    public void setAuditIdSet(String auditIdSet) {
        this.auditIdSet = auditIdSet;
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$initRestClient$0(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpAsyncClientBuilder) {
        return httpAsyncClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
    }
}

