/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nonnull;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.blob.BlobWriter;
import org.apache.flink.runtime.execution.librarycache.BlobLibraryCacheManager;
import org.apache.flink.runtime.execution.librarycache.FlinkUserCodeClassLoaders;
import org.apache.flink.runtime.execution.librarycache.LibraryCacheManager;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.util.ExecutorThreadFactory;
import org.apache.flink.runtime.util.Hardware;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;

public class JobManagerSharedServices {
    private final ScheduledExecutorService scheduledExecutorService;
    private final LibraryCacheManager libraryCacheManager;
    @Nonnull
    private final BlobWriter blobWriter;

    public JobManagerSharedServices(ScheduledExecutorService scheduledExecutorService, LibraryCacheManager libraryCacheManager, @Nonnull BlobWriter blobWriter) {
        this.scheduledExecutorService = (ScheduledExecutorService)Preconditions.checkNotNull((Object)scheduledExecutorService);
        this.libraryCacheManager = (LibraryCacheManager)Preconditions.checkNotNull((Object)libraryCacheManager);
        this.blobWriter = blobWriter;
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    public LibraryCacheManager getLibraryCacheManager() {
        return this.libraryCacheManager;
    }

    @Nonnull
    public BlobWriter getBlobWriter() {
        return this.blobWriter;
    }

    public void shutdown() throws Exception {
        Throwable firstException = null;
        try {
            this.scheduledExecutorService.shutdownNow();
        }
        catch (Throwable t) {
            firstException = t;
        }
        this.libraryCacheManager.shutdown();
        if (firstException != null) {
            ExceptionUtils.rethrowException((Throwable)firstException, (String)"Error while shutting down JobManager services");
        }
    }

    public static JobManagerSharedServices fromConfiguration(Configuration config, BlobServer blobServer, FatalErrorHandler fatalErrorHandler) {
        Preconditions.checkNotNull((Object)config);
        Preconditions.checkNotNull((Object)blobServer);
        String classLoaderResolveOrder = config.getString(CoreOptions.CLASSLOADER_RESOLVE_ORDER);
        String[] alwaysParentFirstLoaderPatterns = CoreOptions.getParentFirstLoaderPatterns((Configuration)config);
        boolean failOnJvmMetaspaceOomError = config.getBoolean(CoreOptions.FAIL_ON_USER_CLASS_LOADING_METASPACE_OOM);
        boolean checkClassLoaderLeak = config.getBoolean(CoreOptions.CHECK_LEAKED_CLASSLOADER);
        BlobLibraryCacheManager libraryCacheManager = new BlobLibraryCacheManager(blobServer, BlobLibraryCacheManager.defaultClassLoaderFactory(FlinkUserCodeClassLoaders.ResolveOrder.fromString(classLoaderResolveOrder), alwaysParentFirstLoaderPatterns, failOnJvmMetaspaceOomError ? fatalErrorHandler : null, checkClassLoaderLeak));
        ScheduledExecutorService futureExecutor = Executors.newScheduledThreadPool(Hardware.getNumberCPUCores(), new ExecutorThreadFactory("jobmanager-future"));
        return new JobManagerSharedServices(futureExecutor, libraryCacheManager, blobServer);
    }
}

