/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import javax.annotation.Nullable;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.partition.BoundedBlockingSubpartition;
import org.apache.flink.runtime.io.network.partition.BoundedData;
import org.apache.flink.runtime.io.network.partition.BufferReaderWriterUtil;
import org.apache.flink.runtime.io.network.partition.ResultSubpartition;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionView;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.Preconditions;

public class BoundedBlockingSubpartitionDirectTransferReader
implements ResultSubpartitionView {
    private final BoundedBlockingSubpartition parent;
    private final BoundedData.Reader dataReader;
    private int numDataBuffers;
    private int numDataAndEventBuffers;
    private boolean isReleased;
    private int sequenceNumber;

    BoundedBlockingSubpartitionDirectTransferReader(BoundedBlockingSubpartition parent, Path filePath, int numDataBuffers, int numDataAndEventBuffers) throws IOException {
        this.parent = (BoundedBlockingSubpartition)Preconditions.checkNotNull((Object)parent);
        Preconditions.checkNotNull((Object)filePath);
        this.dataReader = new FileRegionReader(filePath);
        Preconditions.checkArgument((numDataBuffers >= 0 ? 1 : 0) != 0);
        this.numDataBuffers = numDataBuffers;
        Preconditions.checkArgument((numDataAndEventBuffers >= 0 ? 1 : 0) != 0);
        this.numDataAndEventBuffers = numDataAndEventBuffers;
    }

    @Override
    @Nullable
    public ResultSubpartition.BufferAndBacklog getNextBuffer() throws IOException {
        if (this.isReleased) {
            return null;
        }
        Buffer current = this.dataReader.nextBuffer();
        if (current == null) {
            return null;
        }
        this.updateStatistics(current);
        Buffer.DataType nextDataType = this.numDataAndEventBuffers > 0 ? Buffer.DataType.DATA_BUFFER : Buffer.DataType.NONE;
        return ResultSubpartition.BufferAndBacklog.fromBufferAndLookahead(current, nextDataType, this.numDataBuffers, this.sequenceNumber++);
    }

    private void updateStatistics(Buffer buffer) {
        if (buffer.isBuffer()) {
            --this.numDataBuffers;
        }
        --this.numDataAndEventBuffers;
    }

    @Override
    public boolean isAvailable(int numCreditsAvailable) {
        return numCreditsAvailable > 0 && this.numDataAndEventBuffers > 0;
    }

    @Override
    public void releaseAllResources() throws IOException {
        this.isReleased = true;
        IOUtils.closeQuietly((AutoCloseable)this.dataReader);
        this.parent.releaseReaderReference(this);
    }

    @Override
    public boolean isReleased() {
        return this.isReleased;
    }

    @Override
    public Throwable getFailureCause() {
        return null;
    }

    @Override
    public int unsynchronizedGetNumberOfQueuedBuffers() {
        return this.parent.unsynchronizedGetNumberOfQueuedBuffers();
    }

    @Override
    public void notifyDataAvailable() {
        throw new UnsupportedOperationException("Method should never be called.");
    }

    @Override
    public void resumeConsumption() {
        throw new UnsupportedOperationException("Method should never be called.");
    }

    public String toString() {
        return String.format("Blocking Subpartition Reader: ID=%s, index=%d", this.parent.parent.getPartitionId(), this.parent.getSubPartitionIndex());
    }

    static final class FileRegionReader
    implements BoundedData.Reader {
        private final FileChannel fileChannel;
        private final ByteBuffer headerBuffer;

        FileRegionReader(Path filePath) throws IOException {
            this.fileChannel = FileChannel.open(filePath, StandardOpenOption.READ);
            this.headerBuffer = BufferReaderWriterUtil.allocatedHeaderBuffer();
        }

        @Override
        @Nullable
        public Buffer nextBuffer() throws IOException {
            return BufferReaderWriterUtil.readFileRegionFromByteChannel(this.fileChannel, this.headerBuffer);
        }

        @Override
        public void close() throws IOException {
            this.fileChannel.close();
        }
    }
}

