/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.concurrent;

import java.time.Duration;
import org.apache.flink.runtime.concurrent.RetryStrategy;
import org.apache.flink.util.Preconditions;

public class FixedRetryStrategy
implements RetryStrategy {
    private final int remainingRetries;
    private final Duration retryDelay;

    public FixedRetryStrategy(int remainingRetries, Duration retryDelay) {
        Preconditions.checkArgument((remainingRetries >= 0 ? 1 : 0) != 0, (Object)"The number of retries must be greater or equal to 0.");
        this.remainingRetries = remainingRetries;
        Preconditions.checkArgument((retryDelay.toMillis() >= 0L ? 1 : 0) != 0, (Object)"The retryDelay must be positive");
        this.retryDelay = retryDelay;
    }

    @Override
    public int getNumRemainingRetries() {
        return this.remainingRetries;
    }

    @Override
    public Duration getRetryDelay() {
        return this.retryDelay;
    }

    @Override
    public RetryStrategy getNextRetryStrategy() {
        int nextRemainingRetries = this.remainingRetries - 1;
        Preconditions.checkState((nextRemainingRetries >= 0 ? 1 : 0) != 0, (Object)"The number of remaining retries must not be negative");
        return new FixedRetryStrategy(nextRemainingRetries, this.retryDelay);
    }
}

