/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.checkpoint.Checkpoint;
import org.apache.flink.runtime.checkpoint.CheckpointProperties;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStats;
import org.apache.flink.runtime.checkpoint.MasterState;
import org.apache.flink.runtime.checkpoint.OperatorState;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.state.CompletedCheckpointStorageLocation;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.runtime.state.StateUtil;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompletedCheckpoint
implements Serializable,
Checkpoint {
    private static final Logger LOG = LoggerFactory.getLogger(CompletedCheckpoint.class);
    private static final long serialVersionUID = -8360248179615702014L;
    private final JobID job;
    private final long checkpointID;
    private final long timestamp;
    private final long duration;
    private final Map<OperatorID, OperatorState> operatorStates;
    private final CheckpointProperties props;
    private final Collection<MasterState> masterHookStates;
    private final CompletedCheckpointStorageLocation storageLocation;
    private final StreamStateHandle metadataHandle;
    private final String externalPointer;
    @Nullable
    private volatile transient CompletedCheckpointStats.DiscardCallback discardCallback;

    public CompletedCheckpoint(JobID job, long checkpointID, long timestamp, long completionTimestamp, Map<OperatorID, OperatorState> operatorStates, @Nullable Collection<MasterState> masterHookStates, CheckpointProperties props2, CompletedCheckpointStorageLocation storageLocation) {
        Preconditions.checkArgument((checkpointID >= 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((timestamp >= 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((completionTimestamp >= 0L ? 1 : 0) != 0);
        this.job = (JobID)Preconditions.checkNotNull((Object)job);
        this.checkpointID = checkpointID;
        this.timestamp = timestamp;
        this.duration = completionTimestamp - timestamp;
        this.operatorStates = new HashMap<OperatorID, OperatorState>((Map)Preconditions.checkNotNull(operatorStates));
        this.masterHookStates = masterHookStates == null || masterHookStates.isEmpty() ? Collections.emptyList() : new ArrayList<MasterState>(masterHookStates);
        this.props = (CheckpointProperties)Preconditions.checkNotNull((Object)props2);
        this.storageLocation = (CompletedCheckpointStorageLocation)Preconditions.checkNotNull((Object)storageLocation);
        this.metadataHandle = storageLocation.getMetadataHandle();
        this.externalPointer = storageLocation.getExternalPointer();
    }

    public JobID getJobId() {
        return this.job;
    }

    @Override
    public long getCheckpointID() {
        return this.checkpointID;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getDuration() {
        return this.duration;
    }

    public CheckpointProperties getProperties() {
        return this.props;
    }

    public Map<OperatorID, OperatorState> getOperatorStates() {
        return this.operatorStates;
    }

    public Collection<MasterState> getMasterHookStates() {
        return Collections.unmodifiableCollection(this.masterHookStates);
    }

    public StreamStateHandle getMetadataHandle() {
        return this.metadataHandle;
    }

    public String getExternalPointer() {
        return this.externalPointer;
    }

    public long getStateSize() {
        long result = 0L;
        for (OperatorState operatorState : this.operatorStates.values()) {
            result += operatorState.getStateSize();
        }
        return result;
    }

    public void registerSharedStatesAfterRestored(SharedStateRegistry sharedStateRegistry) {
        sharedStateRegistry.registerAll(this.operatorStates.values());
    }

    public void discardOnFailedStoring() throws Exception {
        this.discard();
    }

    public boolean discardOnSubsume() throws Exception {
        if (this.shouldBeDiscardedOnSubsume()) {
            this.discard();
            return true;
        }
        return false;
    }

    public boolean discardOnShutdown(JobStatus jobStatus) throws Exception {
        if (this.shouldBeDiscardedOnShutdown(jobStatus)) {
            this.discard();
            return true;
        }
        LOG.info("Checkpoint with ID {} at '{}' not discarded.", (Object)this.checkpointID, (Object)this.externalPointer);
        return false;
    }

    @Override
    public void discard() throws Exception {
        LOG.trace("Executing discard procedure for {}.", (Object)this);
        try {
            Exception exception = null;
            try {
                this.metadataHandle.discardState();
            }
            catch (Exception e) {
                exception = e;
            }
            try {
                StateUtil.bestEffortDiscardAllStateObjects(this.operatorStates.values());
            }
            catch (Exception e) {
                exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)exception);
            }
            try {
                this.storageLocation.disposeStorageLocation();
            }
            catch (Exception e) {
                exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)exception);
            }
            if (exception != null) {
                throw exception;
            }
        }
        finally {
            this.operatorStates.clear();
            CompletedCheckpointStats.DiscardCallback discardCallback = this.discardCallback;
            if (discardCallback != null) {
                discardCallback.notifyDiscardedCheckpoint();
            }
        }
    }

    public boolean shouldBeDiscardedOnSubsume() {
        return this.props.discardOnSubsumed();
    }

    public boolean shouldBeDiscardedOnShutdown(JobStatus jobStatus) {
        return jobStatus == JobStatus.FINISHED && this.props.discardOnJobFinished() || jobStatus == JobStatus.CANCELED && this.props.discardOnJobCancelled() || jobStatus == JobStatus.FAILED && this.props.discardOnJobFailed() || jobStatus == JobStatus.SUSPENDED && this.props.discardOnJobSuspended();
    }

    public static boolean checkpointsMatch(Collection<CompletedCheckpoint> first, Collection<CompletedCheckpoint> second) {
        if (first.size() != second.size()) {
            return false;
        }
        ArrayList<Tuple2> firstInterestingFields = new ArrayList<Tuple2>(first.size());
        for (CompletedCheckpoint checkpoint : first) {
            firstInterestingFields.add(new Tuple2((Object)checkpoint.getCheckpointID(), (Object)checkpoint.getJobId()));
        }
        ArrayList<Tuple2> secondInterestingFields = new ArrayList<Tuple2>(second.size());
        for (CompletedCheckpoint checkpoint : second) {
            secondInterestingFields.add(new Tuple2((Object)checkpoint.getCheckpointID(), (Object)checkpoint.getJobId()));
        }
        return firstInterestingFields.equals(secondInterestingFields);
    }

    void setDiscardCallback(@Nullable CompletedCheckpointStats.DiscardCallback discardCallback) {
        this.discardCallback = discardCallback;
    }

    public String toString() {
        return String.format("%s %d @ %d for %s located at %s", this.props.getCheckpointType().getName(), this.checkpointID, this.timestamp, this.job, this.externalPointer);
    }
}

