/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.workflow.core.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.inlong.manager.common.exceptions.WorkflowException;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.core.ProcessorExecutor;
import org.apache.inlong.manager.workflow.definition.Element;
import org.apache.inlong.manager.workflow.processor.ElementProcessor;
import org.apache.inlong.manager.workflow.processor.EndEventProcessor;
import org.apache.inlong.manager.workflow.processor.ServiceTaskProcessor;
import org.apache.inlong.manager.workflow.processor.StartEventProcessor;
import org.apache.inlong.manager.workflow.processor.UserTaskProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProcessorExecutorImpl
implements ProcessorExecutor {
    private static final Logger log = LoggerFactory.getLogger(ProcessorExecutorImpl.class);
    private ImmutableMap<Class<? extends Element>, ElementProcessor<? extends Element>> elementProcessor;
    @Autowired
    private StartEventProcessor startEventProcessor;
    @Autowired
    private EndEventProcessor endEventProcessor;
    @Autowired
    private UserTaskProcessor userTaskProcessor;
    @Autowired
    private ServiceTaskProcessor serviceTaskProcessor;

    @PostConstruct
    private void initProcessors() {
        ArrayList processors = Lists.newArrayList();
        processors.add(this.startEventProcessor);
        processors.add(this.endEventProcessor);
        processors.add(this.userTaskProcessor);
        processors.add(this.serviceTaskProcessor);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        processors.forEach(processor -> builder.put(processor.watch(), processor));
        this.elementProcessor = builder.build();
    }

    private ElementProcessor<? extends Element> getProcessor(Class<? extends Element> elementClazz) {
        if (!this.elementProcessor.containsKey(elementClazz)) {
            throw new WorkflowException("element executor not found " + elementClazz.getName());
        }
        return (ElementProcessor)this.elementProcessor.get(elementClazz);
    }

    @Override
    public void executeStart(Element element, WorkflowContext context) {
        ElementProcessor<? extends Element> processor = this.getProcessor(element.getClass());
        context.setCurrentElement(element);
        if (!processor.create(element, context)) {
            return;
        }
        if (processor.pendingForAction(context)) {
            return;
        }
        this.executeComplete(element, context);
    }

    @Override
    public void executeComplete(Element element, WorkflowContext context) {
        ElementProcessor<? extends Element> processor = this.getProcessor(element.getClass());
        context.setCurrentElement(element);
        if (!processor.complete(context)) {
            return;
        }
        List<Element> nextElements = processor.next(element, context);
        for (Element next : nextElements) {
            this.executeStart(next, context);
        }
    }
}

