/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.web.action.screen.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.inlong.tubemq.corebase.cluster.BrokerInfo;
import org.apache.inlong.tubemq.corebase.cluster.TopicInfo;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.corebase.utils.Tuple3;
import org.apache.inlong.tubemq.server.master.TMaster;
import org.apache.inlong.tubemq.server.master.nodemanage.nodebroker.BrokerRunManager;
import org.apache.inlong.tubemq.server.master.web.common.BrokerQueryResult;
import org.apache.inlong.tubemq.server.master.web.model.BrokerVO;
import org.apache.inlong.tubemq.server.master.web.simplemvc.Action;
import org.apache.inlong.tubemq.server.master.web.simplemvc.RequestContext;

public class BrokerList
implements Action {
    private final TMaster master;

    public BrokerList(TMaster master) {
        this.master = master;
    }

    @Override
    public void execute(RequestContext context) {
        int totalPage;
        HttpServletRequest req = context.getReq();
        String strPageNum = req.getParameter("page_num");
        String strPageSize = req.getParameter("page_size");
        int pageNum = TStringUtils.isNotEmpty((String)strPageNum) ? Integer.parseInt(strPageNum) : 1;
        pageNum = pageNum <= 0 ? 1 : pageNum;
        int pageSize = TStringUtils.isNotEmpty((String)strPageSize) ? Integer.parseInt(strPageSize) : 10;
        pageSize = Math.max(pageSize, 10);
        BrokerRunManager brokerRunManager = this.master.getBrokerRunManager();
        ArrayList<BrokerInfo> brokerInfoList = new ArrayList<BrokerInfo>(brokerRunManager.getBrokerInfoMap(null).values());
        for (int i = 0; i < 95; ++i) {
            BrokerInfo info = new BrokerInfo(i, "127.0.0.1", 8123);
            brokerInfoList.add(info);
        }
        int n = totalPage = brokerInfoList.size() % pageSize == 0 ? brokerInfoList.size() / pageSize : brokerInfoList.size() / pageSize + 1;
        if (pageNum > totalPage) {
            pageNum = totalPage;
        }
        if (pageNum < 1) {
            pageNum = 1;
        }
        ArrayList<BrokerVO> brokerVOList = null;
        if (!brokerInfoList.isEmpty()) {
            Collections.sort(brokerInfoList, new BrokerComparator());
            int fromIndex = pageSize * (pageNum - 1);
            int toIndex = Math.min(fromIndex + pageSize, brokerInfoList.size());
            Tuple3 topicInfoTuple = new Tuple3();
            List firstPageList = brokerInfoList.subList(fromIndex, toIndex);
            brokerVOList = new ArrayList<BrokerVO>(brokerInfoList.size());
            for (BrokerInfo brokerInfo : firstPageList) {
                BrokerVO brokerVO = new BrokerVO();
                brokerVO.setId(brokerInfo.getBrokerId());
                brokerVO.setIp(brokerInfo.getHost());
                brokerRunManager.getPubBrokerPushedTopicInfo(brokerInfo.getBrokerId(), (Tuple3<Boolean, Boolean, List<TopicInfo>>)topicInfoTuple);
                brokerVO.setTopicCount(((List)topicInfoTuple.getF2()).size());
                int totalPartitionNum = 0;
                for (TopicInfo topicInfo : (List)topicInfoTuple.getF2()) {
                    totalPartitionNum += topicInfo.getPartitionNum();
                }
                brokerVO.setPartitionCount(totalPartitionNum);
                brokerVO.setReadable((Boolean)topicInfoTuple.getF1());
                brokerVO.setWritable((Boolean)topicInfoTuple.getF0());
                brokerVO.setVersion("1.10.0");
                brokerVO.setStatus(1);
                brokerVO.setLastOpTime(new Date());
                brokerVOList.add(brokerVO);
            }
        }
        BrokerQueryResult brokerQueryResult = new BrokerQueryResult();
        brokerQueryResult.setResultList(brokerVOList);
        brokerQueryResult.setCurrentPage(pageNum);
        brokerQueryResult.setTotalPage(totalPage);
        brokerQueryResult.setTotalCount(brokerInfoList.size());
        brokerQueryResult.setPageSize(pageSize);
        context.put("queryResult", brokerQueryResult);
        context.put("page", "brokerList");
    }

    public class BrokerComparator
    implements Comparator<BrokerInfo> {
        @Override
        public int compare(BrokerInfo o1, BrokerInfo o2) {
            return o1.getBrokerId() - o2.getBrokerId();
        }
    }
}

