/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.broker.offset;

import java.util.Map;
import org.apache.inlong.tubemq.corebase.daemon.AbstractDaemonService;
import org.apache.inlong.tubemq.corebase.utils.AddressUtils;
import org.apache.inlong.tubemq.corebase.utils.ServiceStatusHolder;
import org.apache.inlong.tubemq.server.broker.TubeBroker;
import org.apache.inlong.tubemq.server.broker.metadata.TopicMetadata;
import org.apache.inlong.tubemq.server.broker.msgstore.MessageStoreManager;
import org.apache.inlong.tubemq.server.broker.offset.OffsetHistoryInfo;
import org.apache.inlong.tubemq.server.broker.offset.OffsetService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OffsetRecordService
extends AbstractDaemonService {
    private static final Logger logger = LoggerFactory.getLogger(OffsetRecordService.class);
    private final TubeBroker broker;
    private final MessageStoreManager storeManager;
    private final OffsetService offsetManager;
    private final int brokerAddrId;

    public OffsetRecordService(TubeBroker broker, long scanIntervalMs) {
        super("History-Offset", scanIntervalMs);
        this.broker = broker;
        this.storeManager = this.broker.getStoreManager();
        this.offsetManager = this.broker.getOffsetManager();
        this.brokerAddrId = AddressUtils.ipToInt((String)broker.getTubeConfig().getHostName());
        super.start();
    }

    protected void loopProcess(StringBuilder strBuff) {
        try {
            this.storeRecord2LocalTopic(strBuff);
        }
        catch (Throwable throwable) {
            logger.error("[Offset Record] Daemon commit thread throw error ", throwable);
        }
    }

    public void close() {
        if (super.stop()) {
            return;
        }
        StringBuilder strBuff = new StringBuilder(2048);
        this.storeRecord2LocalTopic(strBuff);
        logger.info("[Offset-Record Service] offset-record service stopped!");
    }

    private void storeRecord2LocalTopic(StringBuilder strBuff) {
        if (ServiceStatusHolder.isWriteServiceStop()) {
            return;
        }
        TopicMetadata topicMetadata = this.storeManager.getMetadataManager().getTopicMetadata("__offset_history__");
        if (topicMetadata == null || !topicMetadata.isAcceptPublish()) {
            return;
        }
        Map<String, OffsetHistoryInfo> groupOffsetMap = this.offsetManager.getOnlineGroupOffsetInfo();
        if (groupOffsetMap == null || groupOffsetMap.isEmpty()) {
            return;
        }
        this.storeManager.getTopicPublishInfos(groupOffsetMap);
        this.broker.getBrokerServiceServer().appendGroupOffsetInfo(groupOffsetMap, this.brokerAddrId, System.currentTimeMillis(), 10, 3L, strBuff);
    }
}

