/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.broker.msgstore;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.corebase.utils.ThreadUtils;
import org.apache.inlong.tubemq.server.broker.BrokerConfig;
import org.apache.inlong.tubemq.server.broker.TubeBroker;
import org.apache.inlong.tubemq.server.broker.exception.StartupException;
import org.apache.inlong.tubemq.server.broker.metadata.MetadataManager;
import org.apache.inlong.tubemq.server.broker.metadata.TopicMetadata;
import org.apache.inlong.tubemq.server.broker.msgstore.MessageStore;
import org.apache.inlong.tubemq.server.broker.msgstore.StoreService;
import org.apache.inlong.tubemq.server.broker.msgstore.disk.GetMessageResult;
import org.apache.inlong.tubemq.server.broker.nodeinfo.ConsumerNodeInfo;
import org.apache.inlong.tubemq.server.broker.offset.OffsetCsmRecord;
import org.apache.inlong.tubemq.server.broker.offset.OffsetHistoryInfo;
import org.apache.inlong.tubemq.server.broker.utils.TopicPubStoreInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageStoreManager
implements StoreService {
    private static final Logger logger = LoggerFactory.getLogger(MessageStoreManager.class);
    private final BrokerConfig tubeConfig;
    private final TubeBroker tubeBroker;
    private final MetadataManager metadataManager;
    private final ConcurrentHashMap<String, ConcurrentHashMap<Integer, MessageStore>> dataStores = new ConcurrentHashMap();
    private final AtomicBoolean stopped = new AtomicBoolean(false);
    private final ScheduledExecutorService logClearScheduler;
    private final ScheduledExecutorService unFlushDiskScheduler;
    private final ScheduledExecutorService unFlushMemScheduler;
    private final int maxMsgTransferSize;
    private final AtomicBoolean isRemovingTopic = new AtomicBoolean(false);

    public MessageStoreManager(TubeBroker tubeBroker, BrokerConfig tubeConfig) throws IOException {
        this.tubeConfig = tubeConfig;
        this.tubeBroker = tubeBroker;
        this.metadataManager = this.tubeBroker.getMetadataManager();
        this.isRemovingTopic.set(false);
        this.maxMsgTransferSize = Math.min(tubeConfig.getTransferSize(), 0x100000);
        this.metadataManager.addPropertyChangeListener("topicConfigMap", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Map oldTopicConfigMap = (Map)evt.getOldValue();
                Map newTopicConfigMap = (Map)evt.getNewValue();
                MessageStoreManager.this.refreshMessageStoresHoldVals(oldTopicConfigMap, newTopicConfigMap);
            }
        });
        this.logClearScheduler = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "Broker Log Clear Thread");
            }
        });
        this.unFlushDiskScheduler = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "Broker Log Disk Flush Thread");
            }
        });
        this.unFlushMemScheduler = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "Broker Log Mem Flush Thread");
            }
        });
    }

    @Override
    public void start() {
        try {
            this.loadMessageStores(this.tubeConfig);
        }
        catch (IOException e) {
            logger.error("[Store Manager] load message stores failed", (Throwable)e);
            throw new StartupException("Initialize message store manager failed", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.logClearScheduler.scheduleWithFixedDelay(new LogClearRunner(), this.tubeConfig.getLogClearupDurationMs(), this.tubeConfig.getLogClearupDurationMs(), TimeUnit.MILLISECONDS);
        this.unFlushDiskScheduler.scheduleWithFixedDelay(new DiskUnFlushRunner(), this.tubeConfig.getLogFlushDiskDurMs(), this.tubeConfig.getLogFlushDiskDurMs(), TimeUnit.MILLISECONDS);
        this.unFlushMemScheduler.scheduleWithFixedDelay(new MemUnFlushRunner(), this.tubeConfig.getLogFlushMemDurMs(), this.tubeConfig.getLogFlushMemDurMs(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void close() {
        if (this.stopped.get()) {
            return;
        }
        if (this.stopped.compareAndSet(false, true)) {
            logger.info("[Store Manager] begin close store manager......");
            this.logClearScheduler.shutdownNow();
            this.unFlushDiskScheduler.shutdownNow();
            this.unFlushMemScheduler.shutdownNow();
            for (Map.Entry<String, ConcurrentHashMap<Integer, MessageStore>> entry : this.dataStores.entrySet()) {
                if (entry.getValue() == null) continue;
                ConcurrentHashMap<Integer, MessageStore> subMap = entry.getValue();
                for (Map.Entry<Integer, MessageStore> subEntry : subMap.entrySet()) {
                    if (subEntry.getValue() == null) continue;
                    try {
                        subEntry.getValue().close();
                    }
                    catch (Throwable e) {
                        logger.error(new StringBuilder(512).append("[Store Manager] Try to run close  ").append(subEntry.getValue().getStoreKey()).append(" failed").toString(), e);
                    }
                }
            }
            this.dataStores.clear();
            logger.info("[Store Manager] Store Manager stopped!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> removeTopicStore() {
        if (this.isRemovingTopic.get()) {
            return null;
        }
        if (!this.isRemovingTopic.compareAndSet(false, true)) {
            return null;
        }
        try {
            Object object;
            ArrayList<String> removedTopics = new ArrayList<String>();
            Map<String, TopicMetadata> removedTopicMap = this.metadataManager.getRemovedTopicConfigMap();
            if (removedTopicMap.isEmpty()) {
                ArrayList<String> arrayList = removedTopics;
                return arrayList;
            }
            HashSet<String> targetTopics = new HashSet<String>();
            for (Map.Entry<String, TopicMetadata> entry : removedTopicMap.entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null || entry.getValue().getStatusId() != 2) continue;
                targetTopics.add(entry.getKey());
            }
            if (targetTopics.isEmpty()) {
                object = removedTopics;
                return object;
            }
            logger.info("[Remove Topic] start remove topics : {}", targetTopics);
            for (String tmpTopic : targetTopics) {
                TopicMetadata tmpTopicConf;
                ConcurrentHashMap<Integer, MessageStore> topicStores = this.dataStores.get(tmpTopic);
                if (topicStores != null) {
                    Set storeIds = topicStores.keySet();
                    for (Integer storeId : storeIds) {
                        try {
                            MessageStore tmpStore = topicStores.remove(storeId);
                            tmpStore.close();
                            if (!topicStores.isEmpty()) continue;
                            this.dataStores.remove(tmpTopic);
                        }
                        catch (Throwable ee) {
                            logger.error(new StringBuilder(512).append("[Remove Topic] Close removed store failure, storeKey=").append(tmpTopic).append("-").append(storeId).toString(), ee);
                        }
                    }
                }
                if ((tmpTopicConf = removedTopicMap.get(tmpTopic)) != null) {
                    StringBuilder sBuilder = new StringBuilder(512);
                    for (int storeId = 0; storeId < tmpTopicConf.getNumTopicStores(); ++storeId) {
                        String storeDir = sBuilder.append(this.tubeConfig.getPrimaryPath()).append(File.separator).append(tmpTopic).append("-").append(storeId).toString();
                        sBuilder.delete(0, sBuilder.length());
                        logger.info("[Remove Topic] remove topic files : {}", (Object)storeDir);
                        try {
                            this.delTopicFiles(storeDir);
                        }
                        catch (Throwable e) {
                            logger.error("[Remove Topic] remove topic files error : ", e);
                        }
                        ThreadUtils.sleep((long)50L);
                    }
                    tmpTopicConf.setStatusId(3);
                    removedTopics.add(tmpTopic);
                }
                ThreadUtils.sleep((long)100L);
            }
            logger.info("[Remove Topic] finished remove topics : {}", removedTopics);
            object = removedTopics;
            return object;
        }
        finally {
            this.isRemovingTopic.set(false);
        }
    }

    @Override
    public Collection<MessageStore> getMessageStoresByTopic(String topic) {
        ConcurrentHashMap<Integer, MessageStore> map = this.dataStores.get(topic);
        if (map == null) {
            return Collections.emptyList();
        }
        return map.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageStore getOrCreateMessageStore(String topic, int partition) throws Throwable {
        MessageStore messageStore;
        ConcurrentHashMap tmpTopicMap;
        StringBuilder sBuilder = new StringBuilder(512);
        int storeId = partition < 10000 ? 0 : partition / 10000;
        int realPartition = partition < 10000 ? partition : partition % 10000;
        String dataStoreToken = sBuilder.append("tube_store_manager_").append(topic).toString();
        sBuilder.delete(0, sBuilder.length());
        if (realPartition < 0 || realPartition >= this.metadataManager.getNumPartitions(topic)) {
            throw new IllegalArgumentException(sBuilder.append("Wrong partition value ").append(partition).append(",valid partitions in (0,").append(this.metadataManager.getNumPartitions(topic) - 1).append(")").toString());
        }
        ConcurrentHashMap<Integer, MessageStore> dataMap = this.dataStores.get(topic);
        if (dataMap == null && (dataMap = this.dataStores.putIfAbsent(topic, tmpTopicMap = new ConcurrentHashMap())) == null) {
            dataMap = tmpTopicMap;
        }
        if ((messageStore = dataMap.get(storeId)) == null) {
            String string = dataStoreToken.intern();
            synchronized (string) {
                messageStore = dataMap.get(storeId);
                if (messageStore == null) {
                    TopicMetadata topicMetadata = this.metadataManager.getTopicMetadata(topic);
                    MessageStore tmpMessageStore = new MessageStore(this, topicMetadata, storeId, this.tubeConfig, 0L, this.maxMsgTransferSize);
                    messageStore = dataMap.putIfAbsent(storeId, tmpMessageStore);
                    if (messageStore == null) {
                        messageStore = tmpMessageStore;
                        logger.info(sBuilder.append("[Store Manager] Created a new message storage, storeKey=").append(topic).append("-").append(storeId).toString());
                    } else {
                        tmpMessageStore.close();
                    }
                }
            }
        }
        return messageStore;
    }

    public TubeBroker getTubeBroker() {
        return this.tubeBroker;
    }

    public GetMessageResult getMessages(MessageStore msgStore, String topic, int partitionId, int msgCount, Set<String> filterCondSet) throws IOException {
        long requestOffset = 0L;
        try {
            long maxOffset = msgStore.getIndexMaxOffset();
            ConsumerNodeInfo consumerNodeInfo = new ConsumerNodeInfo(this.tubeBroker.getStoreManager(), "visit", "visit", filterCondSet, "", System.currentTimeMillis(), "", "");
            int maxIndexReadSize = (msgCount + 1) * 28 * msgStore.getPartitionNum();
            if (filterCondSet != null && !filterCondSet.isEmpty()) {
                maxIndexReadSize *= 5;
            }
            requestOffset = maxOffset - (long)maxIndexReadSize < 0L ? 0L : maxOffset - (long)maxIndexReadSize;
            return msgStore.getMessages(303, requestOffset, partitionId, consumerNodeInfo, topic, this.maxMsgTransferSize, 0L);
        }
        catch (Throwable e1) {
            return new GetMessageResult(false, 500, requestOffset, 0, "Get message failure, errMsg=" + e1.getMessage());
        }
    }

    public MetadataManager getMetadataManager() {
        return this.tubeBroker.getMetadataManager();
    }

    public int getMaxMsgTransferSize() {
        return this.maxMsgTransferSize;
    }

    public Map<String, ConcurrentHashMap<Integer, MessageStore>> getMessageStores() {
        return Collections.unmodifiableMap(this.dataStores);
    }

    @Override
    public Map<String, Map<Integer, TopicPubStoreInfo>> getTopicPublishInfos(Set<String> topicSet) {
        MessageStore store = null;
        TopicMetadata topicMetadata = null;
        HashSet<String> qryTopicSet = new HashSet<String>();
        HashMap<String, Map<Integer, TopicPubStoreInfo>> topicPubStoreInfoMap = new HashMap<String, Map<Integer, TopicPubStoreInfo>>();
        Map<String, TopicMetadata> confTopicInfo = this.metadataManager.getTopicConfigMap();
        if (topicSet == null || topicSet.isEmpty()) {
            qryTopicSet.addAll(confTopicInfo.keySet());
        } else {
            for (String topic : topicSet) {
                if (!confTopicInfo.containsKey(topic)) continue;
                qryTopicSet.add(topic);
            }
        }
        if (qryTopicSet.isEmpty()) {
            return topicPubStoreInfoMap;
        }
        for (String topic : qryTopicSet) {
            Map storeMap;
            topicMetadata = confTopicInfo.get(topic);
            if (topicMetadata == null || (storeMap = (Map)this.dataStores.get(topic)) == null) continue;
            HashMap<Integer, TopicPubStoreInfo> storeInfoMap = new HashMap<Integer, TopicPubStoreInfo>();
            for (Map.Entry entry : storeMap.entrySet()) {
                if (entry == null || entry.getKey() == null || entry.getValue() == null) continue;
                store = (MessageStore)entry.getValue();
                for (Integer partitionId : topicMetadata.getPartIdsByStoreId((Integer)entry.getKey())) {
                    storeInfoMap.put(partitionId, new TopicPubStoreInfo(topic, (Integer)entry.getKey(), partitionId, store.getIndexMinOffset(), store.getIndexMaxOffset(), store.getDataMinOffset(), store.getDataMaxOffset()));
                }
            }
            topicPubStoreInfoMap.put(topic, storeInfoMap);
        }
        return topicPubStoreInfoMap;
    }

    @Override
    public void getTopicPublishInfos(Map<String, OffsetHistoryInfo> groupOffsetMap) {
        MessageStore store = null;
        for (Map.Entry<String, OffsetHistoryInfo> entry : groupOffsetMap.entrySet()) {
            if (entry == null || entry.getKey() == null || entry.getValue() == null) continue;
            Map<String, Map<Integer, OffsetCsmRecord>> topicOffsetMap = entry.getValue().getOffsetMap();
            for (Map.Entry<String, Map<Integer, OffsetCsmRecord>> entryTopic : topicOffsetMap.entrySet()) {
                Map storeMap;
                if (entryTopic == null || entryTopic.getKey() == null || entryTopic.getValue() == null || (storeMap = (Map)this.dataStores.get(entryTopic.getKey())) == null) continue;
                for (Map.Entry<Integer, OffsetCsmRecord> entryRcd : entryTopic.getValue().entrySet()) {
                    store = (MessageStore)storeMap.get(entryRcd.getValue().getStoreId());
                    if (store == null) continue;
                    entryRcd.getValue().addStoreInfo(store.getIndexMinOffset(), store.getIndexMaxOffset(), store.getDataMinOffset(), store.getDataMaxOffset());
                }
            }
        }
    }

    private Set<File> getLogDirSet(BrokerConfig tubeConfig) throws IOException {
        TopicMetadata topicMetadata = null;
        HashSet<String> paths = new HashSet<String>();
        paths.add(tubeConfig.getPrimaryPath());
        for (String topic : this.metadataManager.getTopics()) {
            topicMetadata = this.metadataManager.getTopicMetadata(topic);
            if (topicMetadata == null || !TStringUtils.isNotBlank((String)topicMetadata.getDataPath())) continue;
            paths.add(topicMetadata.getDataPath());
        }
        HashSet<File> fileSet = new HashSet<File>();
        for (String path : paths) {
            File dir = new File(path);
            if (!dir.exists() && !dir.mkdirs()) {
                throw new IOException(new StringBuilder(512).append("Could not make Log directory ").append(dir.getAbsolutePath()).toString());
            }
            if (!dir.isDirectory() || !dir.canRead()) {
                throw new IOException(new StringBuilder(512).append("Log path ").append(dir.getAbsolutePath()).append(" is not a readable directory").toString());
            }
            fileSet.add(dir);
        }
        return fileSet;
    }

    private void loadMessageStores(final BrokerConfig tubeConfig) throws IOException, InterruptedException {
        StringBuilder sBuilder = new StringBuilder(512);
        logger.info(sBuilder.append("[Store Manager] Begin to load message stores from path ").append(tubeConfig.getPrimaryPath()).toString());
        sBuilder.delete(0, sBuilder.length());
        long start = System.currentTimeMillis();
        final AtomicInteger errCnt = new AtomicInteger(0);
        final AtomicInteger finishCnt = new AtomicInteger(0);
        ArrayList<Callable<MessageStore>> tasks = new ArrayList<Callable<MessageStore>>();
        for (File dir : this.getLogDirSet(tubeConfig)) {
            File[] ls;
            if (dir == null || (ls = dir.listFiles()) == null) continue;
            for (final File subDir : ls) {
                if (subDir == null || !subDir.isDirectory()) continue;
                String name = subDir.getName();
                int index = name.lastIndexOf(45);
                if (index < 0) {
                    logger.warn(sBuilder.append("[Store Manager] Ignore invalid directory:").append(subDir.getAbsolutePath()).toString());
                    sBuilder.delete(0, sBuilder.length());
                    continue;
                }
                String topic = name.substring(0, index);
                final TopicMetadata topicMetadata = this.metadataManager.getTopicMetadata(topic);
                if (topicMetadata == null) {
                    logger.warn(sBuilder.append("[Store Manager] No valid topic config for topic data directories:").append(topic).toString());
                    sBuilder.delete(0, sBuilder.length());
                    continue;
                }
                final int storeId = Integer.parseInt(name.substring(index + 1));
                final MessageStoreManager messageStoreManager = this;
                tasks.add(new Callable<MessageStore>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public MessageStore call() throws Exception {
                        MessageStore msgStore = null;
                        try {
                            MessageStore oldMsgStore;
                            msgStore = new MessageStore(messageStoreManager, topicMetadata, storeId, tubeConfig, MessageStoreManager.this.maxMsgTransferSize);
                            ConcurrentHashMap<Integer, MessageStore> map = (ConcurrentHashMap<Integer, MessageStore>)MessageStoreManager.this.dataStores.get(msgStore.getTopic());
                            if (map == null) {
                                map = new ConcurrentHashMap<Integer, MessageStore>();
                                ConcurrentHashMap oldmap = MessageStoreManager.this.dataStores.putIfAbsent(msgStore.getTopic(), map);
                                if (oldmap != null) {
                                    map = oldmap;
                                }
                            }
                            if ((oldMsgStore = map.putIfAbsent(msgStore.getStoreId(), msgStore)) != null) {
                                try {
                                    msgStore.close();
                                    logger.info(new StringBuilder(512).append("[Store Manager] Close duplicated messageStore ").append(msgStore.getStoreKey()).toString());
                                }
                                catch (Throwable e2) {
                                    logger.info("[Store Manager] Close duplicated messageStore failure", e2);
                                }
                            }
                        }
                        catch (Throwable e2) {
                            errCnt.incrementAndGet();
                            logger.error(new StringBuilder(512).append("[Store Manager] Loaded ").append(subDir.getAbsolutePath()).append("message store failure:").toString(), e2);
                        }
                        finally {
                            finishCnt.incrementAndGet();
                        }
                        return null;
                    }
                });
            }
        }
        this.loadStoresInParallel(tasks);
        tasks.clear();
        if (errCnt.get() > 0) {
            throw new RuntimeException("[Store Manager] failure to load message stores, please check load logger and fix first!");
        }
        logger.info(sBuilder.append("[Store Manager] End to load message stores in ").append((System.currentTimeMillis() - start) / 1000L).append(" secs").toString());
    }

    private void loadStoresInParallel(List<Callable<MessageStore>> tasks) throws InterruptedException {
        ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() + 1);
        ExecutorCompletionService<MessageStore> completionService = new ExecutorCompletionService<MessageStore>(executor);
        for (Callable<MessageStore> task : tasks) {
            completionService.submit(task);
        }
        for (int i = 0; i < tasks.size(); ++i) {
            try {
                completionService.take().get();
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        executor.shutdown();
    }

    private void delTopicFiles(String filepath) throws IOException {
        File targetFile = new File(filepath);
        if (targetFile.exists()) {
            File[] files;
            if (targetFile.isFile()) {
                targetFile.delete();
            } else if (targetFile.isDirectory() && (files = targetFile.listFiles()) != null) {
                for (int i = 0; i < files.length; ++i) {
                    this.delTopicFiles(files[i].getAbsolutePath());
                }
            }
            targetFile.delete();
        }
    }

    public void refreshMessageStoresHoldVals(Map<String, TopicMetadata> oldTopicConfigMap, Map<String, TopicMetadata> newTopicConfigMap) {
        if (newTopicConfigMap == null || newTopicConfigMap.isEmpty() || oldTopicConfigMap == null || oldTopicConfigMap.isEmpty()) {
            return;
        }
        StringBuilder sBuilder = new StringBuilder(512);
        for (TopicMetadata newTopicMetadata : newTopicConfigMap.values()) {
            ConcurrentHashMap<Integer, MessageStore> messageStores;
            TopicMetadata oldTopicMetadata = oldTopicConfigMap.get(newTopicMetadata.getTopic());
            if (oldTopicMetadata == null || oldTopicMetadata.isPropertyEquals(newTopicMetadata) || (messageStores = this.dataStores.get(newTopicMetadata.getTopic())) == null || messageStores.isEmpty()) continue;
            for (Map.Entry<Integer, MessageStore> entry : messageStores.entrySet()) {
                if (entry.getValue() == null) continue;
                try {
                    entry.getValue().refreshUnflushThreshold(newTopicMetadata);
                }
                catch (Throwable ee) {
                    logger.error(sBuilder.append("[Store Manager] refresh ").append(entry.getValue().getStoreKey()).append("'s parameter error,").toString(), ee);
                    sBuilder.delete(0, sBuilder.length());
                }
            }
        }
    }

    private class MemUnFlushRunner
    implements Runnable {
        @Override
        public void run() {
            StringBuilder sBuilder = new StringBuilder(256);
            for (Map storeMap : MessageStoreManager.this.dataStores.values()) {
                if (storeMap == null || storeMap.isEmpty()) continue;
                for (MessageStore msgStore : storeMap.values()) {
                    if (msgStore == null) continue;
                    try {
                        msgStore.flushMemCacheData();
                    }
                    catch (Throwable e) {
                        logger.error(sBuilder.append("[Store Manager] Try to flush ").append(msgStore.getStoreKey()).append("'s mem-store failed : ").toString(), e);
                        sBuilder.delete(0, sBuilder.length());
                    }
                }
            }
        }
    }

    private class DiskUnFlushRunner
    implements Runnable {
        @Override
        public void run() {
            StringBuilder sBuilder = new StringBuilder(256);
            for (Map storeMap : MessageStoreManager.this.dataStores.values()) {
                if (storeMap == null || storeMap.isEmpty()) continue;
                for (MessageStore msgStore : storeMap.values()) {
                    if (msgStore == null) continue;
                    try {
                        msgStore.flushFile();
                    }
                    catch (Throwable e) {
                        logger.error(sBuilder.append("[Store Manager] Try to flush ").append(msgStore.getStoreKey()).append("'s file-store failed : ").toString(), e);
                        sBuilder.delete(0, sBuilder.length());
                    }
                }
            }
        }
    }

    private class LogClearRunner
    implements Runnable {
        @Override
        public void run() {
            long dltTime;
            StringBuilder sBuilder = new StringBuilder(256);
            long startTime = System.currentTimeMillis();
            Set<String> expiredTopic = this.getExpiredTopicSet(sBuilder);
            if (!expiredTopic.isEmpty()) {
                logger.info(sBuilder.append("Found ").append(expiredTopic.size()).append(" files expired, start delete files!").toString());
                sBuilder.delete(0, sBuilder.length());
                for (String topicName : expiredTopic) {
                    Map storeMap;
                    if (topicName == null || (storeMap = (Map)MessageStoreManager.this.dataStores.get(topicName)) == null || storeMap.isEmpty()) continue;
                    for (Map.Entry entry : storeMap.entrySet()) {
                        if (entry.getValue() == null) continue;
                        try {
                            ((MessageStore)entry.getValue()).runClearupPolicy(false);
                        }
                        catch (Throwable e) {
                            logger.error(sBuilder.append("Try to run delete policy with ").append(((MessageStore)entry.getValue()).getStoreKey()).append("'s log file  failed").toString(), e);
                            sBuilder.delete(0, sBuilder.length());
                        }
                    }
                }
                logger.info("Log Clear Scheduler finished file delete!");
            }
            if ((dltTime = System.currentTimeMillis() - startTime) >= MessageStoreManager.this.tubeConfig.getLogClearupDurationMs()) {
                logger.warn(sBuilder.append("Log Clear up task continue over the clearup duration, ").append("used ").append(dltTime).append(", configure value is ").append(MessageStoreManager.this.tubeConfig.getLogClearupDurationMs()).toString());
                sBuilder.delete(0, sBuilder.length());
            }
        }

        private Set<String> getExpiredTopicSet(StringBuilder sb) {
            HashSet<String> expiredTopic = new HashSet<String>();
            for (Map storeMap : MessageStoreManager.this.dataStores.values()) {
                if (storeMap == null || storeMap.isEmpty()) continue;
                for (MessageStore msgStore : storeMap.values()) {
                    if (msgStore == null) continue;
                    try {
                        if (!msgStore.runClearupPolicy(true)) continue;
                        expiredTopic.add(msgStore.getTopic());
                    }
                    catch (Throwable e) {
                        logger.error(sb.append("Try to run delete policy with ").append(msgStore.getStoreKey()).append("'s log file failed").toString(), e);
                        sb.delete(0, sb.length());
                    }
                }
            }
            return expiredTopic;
        }
    }
}

