/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.broker.metadata;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.inlong.tubemq.corebase.policies.FlowCtrlRuleHandler;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.server.broker.metadata.BrokerDefMetadata;
import org.apache.inlong.tubemq.server.broker.metadata.MetadataManager;
import org.apache.inlong.tubemq.server.broker.metadata.TopicMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerMetadataManager
implements MetadataManager {
    private static final Logger logger = LoggerFactory.getLogger(BrokerMetadataManager.class);
    protected final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private final FlowCtrlRuleHandler flowCtrlRuleHandler = new FlowCtrlRuleHandler(true);
    private int brokerConfCheckSumId = 0;
    private long brokerMetadataConfId = 0L;
    private String brokerDefMetaConfInfo = "";
    private List<String> topicMetaConfInfoLst = new ArrayList<String>();
    private List<String> topics = new ArrayList<String>();
    private BrokerDefMetadata brokerDefMetadata = new BrokerDefMetadata();
    private ConcurrentHashMap<String, TopicMetadata> topicConfigMap = new ConcurrentHashMap();
    private Map<String, Integer> closedTopicMap = new ConcurrentHashMap<String, Integer>();
    private final Map<String, TopicMetadata> removedTopicConfigMap = new ConcurrentHashMap<String, TopicMetadata>();
    private long lastRptBrokerMetaConfId = 0L;

    @Override
    public void close(long waitTimeMs) {
    }

    @Override
    public int getBrokerConfCheckSumId() {
        return this.brokerConfCheckSumId;
    }

    @Override
    public long getBrokerMetadataConfId() {
        return this.brokerMetadataConfId;
    }

    @Override
    public String getBrokerDefMetaConfInfo() {
        return this.brokerDefMetaConfInfo;
    }

    @Override
    public List<String> getTopicMetaConfInfoLst() {
        return this.topicMetaConfInfoLst;
    }

    @Override
    public FlowCtrlRuleHandler getFlowCtrlRuleHandler() {
        return this.flowCtrlRuleHandler;
    }

    @Override
    public List<String> getTopics() {
        return this.topics;
    }

    @Override
    public String getDefDeletePolicy() {
        return this.brokerDefMetadata.getDeletePolicy();
    }

    @Override
    public String getTopicDeletePolicy(String topic) {
        TopicMetadata metadata = this.topicConfigMap.get(topic);
        if (metadata == null) {
            return this.brokerDefMetadata.getDeletePolicy();
        }
        return metadata.getDeletePolicy();
    }

    @Override
    public int getNumPartitions(String topic) {
        TopicMetadata topicMetadata = this.topicConfigMap.get(topic);
        return topicMetadata != null ? topicMetadata.getNumPartitions() : this.brokerDefMetadata.getNumPartitions();
    }

    @Override
    public int getNumTopicStores(String topic) {
        TopicMetadata topicMetadata = this.topicConfigMap.get(topic);
        return topicMetadata != null ? topicMetadata.getNumTopicStores() : this.brokerDefMetadata.getNumTopicStores();
    }

    @Override
    public BrokerDefMetadata getBrokerDefMetadata() {
        return this.brokerDefMetadata;
    }

    @Override
    public TopicMetadata getTopicMetadata(String topic) {
        return this.topicConfigMap.get(topic);
    }

    @Override
    public Map<String, TopicMetadata> getTopicConfigMap() {
        return this.topicConfigMap;
    }

    @Override
    public boolean isClosedTopic(String topic) {
        return this.closedTopicMap.get(topic) != null;
    }

    @Override
    public Integer getClosedTopicStatusId(String topic) {
        return this.closedTopicMap.get(topic);
    }

    public Map<String, Integer> getClosedTopicMap() {
        return this.closedTopicMap;
    }

    @Override
    public Map<String, TopicMetadata> getRemovedTopicConfigMap() {
        return this.removedTopicConfigMap;
    }

    @Override
    public List<String> getHardRemovedTopics() {
        ArrayList<String> targetTopics = new ArrayList<String>();
        for (Map.Entry<String, TopicMetadata> entry : this.removedTopicConfigMap.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null || entry.getValue().getStatusId() != 3) continue;
            targetTopics.add(entry.getKey());
        }
        return targetTopics;
    }

    @Override
    public boolean isBrokerMetadataChanged() {
        return this.brokerMetadataConfId != this.lastRptBrokerMetaConfId;
    }

    @Override
    public long getLastRptBrokerMetaConfId() {
        return this.lastRptBrokerMetaConfId;
    }

    @Override
    public void setLastRptBrokerMetaConfId(long lastRptBrokerMetaConfId) {
        this.lastRptBrokerMetaConfId = lastRptBrokerMetaConfId;
    }

    @Override
    public void updateBrokerTopicConfigMap(long newBrokerMetaConfId, int newConfCheckSumId, String newBrokerDefMetaConfInfo, List<String> newTopicMetaConfInfoLst, boolean isForce, StringBuilder sb) {
        if (!isForce && this.brokerMetadataConfId == newBrokerMetaConfId && this.brokerConfCheckSumId == newConfCheckSumId) {
            logger.info(sb.append("[Metadata Manage] Broker topic configure is equal, not update! curBrokerConfId is ").append(this.brokerMetadataConfId).append("received newBrokerMetaConfId is ").append(newBrokerMetaConfId).toString());
            sb.delete(0, sb.length());
            return;
        }
        if (TStringUtils.isBlank((String)newBrokerDefMetaConfInfo)) {
            logger.error("[Metadata Manage] received broker default configure is Blank, not update");
            return;
        }
        this.brokerDefMetadata = new BrokerDefMetadata(newBrokerDefMetaConfInfo);
        this.brokerDefMetaConfInfo = newBrokerDefMetaConfInfo;
        this.brokerMetadataConfId = newBrokerMetaConfId;
        this.brokerConfCheckSumId = newConfCheckSumId;
        if (newTopicMetaConfInfoLst == null || newTopicMetaConfInfoLst.isEmpty()) {
            logger.error("[Metadata Manage] received broker topic info is Blank, not update");
            return;
        }
        ArrayList<String> newTopics = new ArrayList<String>();
        ConcurrentHashMap<String, Integer> tmpInvalidTopicMap = new ConcurrentHashMap<String, Integer>();
        ConcurrentHashMap<String, TopicMetadata> newTopicConfigMap = new ConcurrentHashMap<String, TopicMetadata>();
        for (String strTopicConfInfo : newTopicMetaConfInfoLst) {
            if (TStringUtils.isBlank((String)strTopicConfInfo)) continue;
            TopicMetadata topicMetadata = new TopicMetadata(this.brokerDefMetadata, strTopicConfInfo);
            if (!topicMetadata.isValidTopic()) {
                tmpInvalidTopicMap.put(topicMetadata.getTopic(), topicMetadata.getStatusId());
            }
            newTopics.add(topicMetadata.getTopic());
            newTopicConfigMap.put(topicMetadata.getTopic(), topicMetadata);
        }
        this.addSysHisOffsetTopic(this.brokerDefMetadata, newTopics, newTopicConfigMap);
        this.topicMetaConfInfoLst = newTopicMetaConfInfoLst;
        this.closedTopicMap = tmpInvalidTopicMap;
        Collections.sort(newTopics);
        if (!newTopicConfigMap.equals(this.topicConfigMap)) {
            ConcurrentHashMap<String, TopicMetadata> oldTopicConfigMap = this.topicConfigMap;
            this.topics = newTopics;
            this.topicConfigMap = newTopicConfigMap;
            this.propertyChangeSupport.firePropertyChange("topicConfigMap", oldTopicConfigMap, newTopicConfigMap);
        }
        this.propertyChangeSupport.firePropertyChange("unflushInterval", null, null);
    }

    @Override
    public boolean updateBrokerRemoveTopicMap(boolean isTakeRemoveTopics, List<String> rmvTopicMetaConfInfoLst, StringBuilder sb) {
        boolean needProcess = false;
        if (isTakeRemoveTopics) {
            ArrayList<String> origTopics = new ArrayList<String>();
            if (rmvTopicMetaConfInfoLst != null && !rmvTopicMetaConfInfoLst.isEmpty()) {
                for (String tmpTopicMetaConfInfo : rmvTopicMetaConfInfoLst) {
                    if (TStringUtils.isBlank((String)tmpTopicMetaConfInfo)) continue;
                    TopicMetadata topicMetadata = new TopicMetadata(this.brokerDefMetadata, tmpTopicMetaConfInfo);
                    if (topicMetadata.getStatusId() > 1) {
                        this.removedTopicConfigMap.putIfAbsent(topicMetadata.getTopic(), topicMetadata);
                        needProcess = true;
                    }
                    origTopics.add(topicMetadata.getTopic());
                }
            }
            ArrayList<String> tmpTopics = new ArrayList<String>();
            for (Map.Entry<String, TopicMetadata> entry : this.removedTopicConfigMap.entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null || origTopics.contains(entry.getKey()) || entry.getValue().getStatusId() <= 2) continue;
                tmpTopics.add(entry.getKey());
            }
            if (!tmpTopics.isEmpty()) {
                for (String tmpTopic : tmpTopics) {
                    TopicMetadata topicMetadata = this.removedTopicConfigMap.get(tmpTopic);
                    if (topicMetadata == null || topicMetadata.getStatusId() <= 2) continue;
                    this.removedTopicConfigMap.remove(tmpTopic);
                    logger.info(sb.append("[Metadata Manage] Master removed topic, the broker sync removes topic ").append(tmpTopic).toString());
                    sb.delete(0, sb.length());
                }
            }
        }
        if (this.removedTopicConfigMap.isEmpty()) {
            needProcess = false;
        }
        return needProcess;
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    private void addSysHisOffsetTopic(BrokerDefMetadata brokerDefMeta, List<String> newTopics, ConcurrentHashMap<String, TopicMetadata> topicConfigMap) {
        if (newTopics.contains("__offset_history__")) {
            return;
        }
        TopicMetadata topicMetadata = topicConfigMap.get("__offset_history__");
        if (topicMetadata != null) {
            return;
        }
        topicMetadata = new TopicMetadata(brokerDefMeta, "__offset_history__", 1, 10);
        newTopics.add("__offset_history__");
        topicConfigMap.put("__offset_history__", topicMetadata);
    }
}

