/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.broker;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.inlong.tubemq.corebase.Message;
import org.apache.inlong.tubemq.corebase.cluster.Partition;
import org.apache.inlong.tubemq.corebase.config.TLSConfig;
import org.apache.inlong.tubemq.corebase.protobuf.generated.ClientBroker;
import org.apache.inlong.tubemq.corebase.rv.ProcessResult;
import org.apache.inlong.tubemq.corebase.utils.AddressUtils;
import org.apache.inlong.tubemq.corebase.utils.CheckSum;
import org.apache.inlong.tubemq.corebase.utils.DataConverterUtil;
import org.apache.inlong.tubemq.corebase.utils.DateTimeConvertUtils;
import org.apache.inlong.tubemq.corebase.utils.ServiceStatusHolder;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.corerpc.RpcConfig;
import org.apache.inlong.tubemq.corerpc.service.BrokerReadService;
import org.apache.inlong.tubemq.corerpc.service.BrokerWriteService;
import org.apache.inlong.tubemq.server.Server;
import org.apache.inlong.tubemq.server.broker.BrokerConfig;
import org.apache.inlong.tubemq.server.broker.TubeBroker;
import org.apache.inlong.tubemq.server.broker.metadata.MetadataManager;
import org.apache.inlong.tubemq.server.broker.metadata.TopicMetadata;
import org.apache.inlong.tubemq.server.broker.msgstore.MessageStore;
import org.apache.inlong.tubemq.server.broker.msgstore.MessageStoreManager;
import org.apache.inlong.tubemq.server.broker.msgstore.disk.GetMessageResult;
import org.apache.inlong.tubemq.server.broker.nodeinfo.ConsumerNodeInfo;
import org.apache.inlong.tubemq.server.broker.offset.OffsetHistoryInfo;
import org.apache.inlong.tubemq.server.broker.offset.OffsetService;
import org.apache.inlong.tubemq.server.broker.offset.offsetstorage.OffsetStorageInfo;
import org.apache.inlong.tubemq.server.broker.stats.BrokerSrvStatsHolder;
import org.apache.inlong.tubemq.server.broker.stats.TrafficStatsService;
import org.apache.inlong.tubemq.server.broker.stats.audit.AuditUtils;
import org.apache.inlong.tubemq.server.common.aaaserver.CertificateBrokerHandler;
import org.apache.inlong.tubemq.server.common.aaaserver.CertifiedInfo;
import org.apache.inlong.tubemq.server.common.exception.HeartbeatException;
import org.apache.inlong.tubemq.server.common.heartbeat.HeartbeatManager;
import org.apache.inlong.tubemq.server.common.heartbeat.TimeoutInfo;
import org.apache.inlong.tubemq.server.common.heartbeat.TimeoutListener;
import org.apache.inlong.tubemq.server.common.paramcheck.PBParameterUtils;
import org.apache.inlong.tubemq.server.common.utils.AppendResult;
import org.apache.inlong.tubemq.server.common.utils.RowLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerServiceServer
implements BrokerReadService,
BrokerWriteService,
Server {
    private static final Logger logger = LoggerFactory.getLogger(BrokerServiceServer.class);
    private final TubeBroker tubeBroker;
    private final BrokerConfig tubeConfig;
    private final ConcurrentHashMap<String, ConsumerNodeInfo> consumerRegisterMap = new ConcurrentHashMap();
    private final MetadataManager metadataManager;
    private final OffsetService offsetManager;
    private final MessageStoreManager storeManager;
    private final HeartbeatManager heartbeatManager;
    private final RowLock brokerRowLock;
    private final TrafficStatsService putCounterGroup;
    private final TrafficStatsService getCounterGroup;
    private final CertificateBrokerHandler serverAuthHandler;
    private final ConsumerTimeoutListener consumerListener = new ConsumerTimeoutListener();
    private AtomicBoolean started = new AtomicBoolean(false);

    public BrokerServiceServer(TubeBroker tubeBroker, BrokerConfig tubeConfig) {
        this.tubeConfig = tubeConfig;
        this.tubeBroker = tubeBroker;
        this.metadataManager = tubeBroker.getMetadataManager();
        this.storeManager = tubeBroker.getStoreManager();
        this.offsetManager = tubeBroker.getOffsetManager();
        this.serverAuthHandler = tubeBroker.getServerAuthHandler();
        ServiceStatusHolder.setStatsParameters((int)tubeConfig.getAllowedReadIOExcptCnt(), (int)tubeConfig.getAllowedWriteIOExcptCnt(), (long)tubeConfig.getIoExcptStatsDurationMs());
        AuditUtils.initAudit(tubeConfig.getAuditConfig());
        this.putCounterGroup = new TrafficStatsService("PutCounterGroup", "Producer", 60000L);
        this.getCounterGroup = new TrafficStatsService("GetCounterGroup", "Consumer", 60000L);
        this.heartbeatManager = new HeartbeatManager();
        this.brokerRowLock = new RowLock("Broker-RowLock", this.tubeConfig.getRowLockWaitDurMs());
        this.heartbeatManager.regConsumerCheckBusiness(this.tubeConfig.getConsumerRegTimeoutMs(), this.consumerListener);
    }

    @Override
    public void start() throws Exception {
        RpcConfig rpcWriteConfig = new RpcConfig();
        rpcWriteConfig.put("rpc.netty.send.buffer", (Object)this.tubeConfig.getSocketSendBuffer());
        rpcWriteConfig.put("rpc.netty.receive.buffer", (Object)this.tubeConfig.getSocketRecvBuffer());
        rpcWriteConfig.put("rpc.netty.worker.count", (Object)this.tubeConfig.getTcpWriteServiceThread());
        this.tubeBroker.getRpcServiceFactory().publishService(BrokerWriteService.class, (Object)this, this.tubeConfig.getPort(), rpcWriteConfig);
        RpcConfig rpcReadConfig = new RpcConfig();
        rpcReadConfig.put("rpc.netty.send.buffer", (Object)this.tubeConfig.getSocketSendBuffer());
        rpcReadConfig.put("rpc.netty.receive.buffer", (Object)this.tubeConfig.getSocketRecvBuffer());
        rpcReadConfig.put("rpc.netty.worker.count", (Object)this.tubeConfig.getTcpReadServiceThread());
        this.tubeBroker.getRpcServiceFactory().publishService(BrokerReadService.class, (Object)this, this.tubeConfig.getPort(), rpcReadConfig);
        if (this.tubeConfig.isTlsEnable()) {
            TLSConfig tlsConfig = this.tubeConfig.getTlsConfig();
            RpcConfig rpcTLSWriteConfig = new RpcConfig();
            rpcTLSWriteConfig.put("tcp.tls", (Object)true);
            rpcTLSWriteConfig.put("rpc.netty.send.buffer", (Object)this.tubeConfig.getSocketSendBuffer());
            rpcTLSWriteConfig.put("rpc.netty.receive.buffer", (Object)this.tubeConfig.getSocketRecvBuffer());
            rpcTLSWriteConfig.put("rpc.netty.worker.count", (Object)this.tubeConfig.getTlsWriteServiceThread());
            rpcTLSWriteConfig.put("tls.keystore.path", (Object)tlsConfig.getTlsKeyStorePath());
            rpcTLSWriteConfig.put("tls.keystore.password", (Object)tlsConfig.getTlsKeyStorePassword());
            rpcTLSWriteConfig.put("tls.twoway.authentic", (Object)tlsConfig.isTlsTwoWayAuthEnable());
            if (tlsConfig.isTlsTwoWayAuthEnable()) {
                rpcTLSWriteConfig.put("tls.truststore.path", (Object)tlsConfig.getTlsTrustStorePath());
                rpcTLSWriteConfig.put("tls.truststore.password", (Object)tlsConfig.getTlsTrustStorePassword());
            }
            this.tubeBroker.getRpcServiceFactory().publishService(BrokerWriteService.class, (Object)this, this.tubeConfig.getTlsPort(), rpcTLSWriteConfig);
            RpcConfig rpcTLSReadConfig = new RpcConfig();
            rpcTLSReadConfig.put("rpc.netty.worker.count", (Object)this.tubeConfig.getTlsReadServiceThread());
            rpcTLSReadConfig.put("tcp.tls", (Object)true);
            rpcTLSReadConfig.put("rpc.netty.send.buffer", (Object)this.tubeConfig.getSocketSendBuffer());
            rpcTLSReadConfig.put("rpc.netty.receive.buffer", (Object)this.tubeConfig.getSocketRecvBuffer());
            rpcTLSReadConfig.put("tls.keystore.path", (Object)tlsConfig.getTlsKeyStorePath());
            rpcTLSReadConfig.put("tls.keystore.password", (Object)tlsConfig.getTlsKeyStorePassword());
            rpcTLSReadConfig.put("tls.twoway.authentic", (Object)tlsConfig.isTlsTwoWayAuthEnable());
            if (tlsConfig.isTlsTwoWayAuthEnable()) {
                rpcTLSReadConfig.put("tls.truststore.path", (Object)tlsConfig.getTlsTrustStorePath());
                rpcTLSReadConfig.put("tls.truststore.password", (Object)tlsConfig.getTlsTrustStorePassword());
            }
            this.tubeBroker.getRpcServiceFactory().publishService(BrokerReadService.class, (Object)this, this.tubeConfig.getTlsPort(), rpcTLSReadConfig);
        }
        this.started.set(true);
    }

    @Override
    public void stop() {
        if (!this.started.compareAndSet(true, false)) {
            return;
        }
        this.heartbeatManager.stop();
        this.putCounterGroup.close(-1L);
        this.getCounterGroup.close(-1L);
        AuditUtils.closeAudit();
        logger.info("BrokerService server stopped");
    }

    public Map<String, ConsumerNodeInfo> getConsumerRegisterMap() {
        return this.consumerRegisterMap;
    }

    public ConsumerNodeInfo getConsumerNodeInfo(String storeKey) {
        return this.consumerRegisterMap.get(storeKey);
    }

    public Long getConsumerRegisterTime(String consumerId, String partitionStr) {
        TimeoutInfo timeoutInfo = this.heartbeatManager.getConsumerRegMap().get(this.getHeartbeatNodeId(consumerId, partitionStr));
        if (timeoutInfo == null) {
            return null;
        }
        return timeoutInfo.getTimeoutTime() - this.heartbeatManager.getConsumerTimeoutDlt();
    }

    public ClientBroker.GetMessageResponseB2C getMessagesC2B(ClientBroker.GetMessageRequestC2B request, String rmtAddress, boolean overtls) throws Throwable {
        long startTime = System.currentTimeMillis();
        ClientBroker.GetMessageResponseB2C.Builder builder = ClientBroker.GetMessageResponseB2C.newBuilder();
        builder.setSuccess(false);
        builder.setCurrOffset(-1L);
        builder.setEscFlowCtrl(false);
        builder.setCurrDataDlt(-1L);
        builder.setMinLimitTime(0);
        if (!this.started.get() || ServiceStatusHolder.isReadServiceStop()) {
            builder.setErrCode(503);
            builder.setErrMsg("Read StoreService temporary unavailable!");
            return builder.build();
        }
        ProcessResult result = new ProcessResult();
        StringBuilder strBuffer = new StringBuilder(512);
        if (!PBParameterUtils.checkClientId(request.getClientId(), strBuffer, result)) {
            builder.setErrCode(result.getErrCode());
            builder.setErrMsg(result.getErrMsg());
            return builder.build();
        }
        String clientId = (String)result.getRetData();
        if (!PBParameterUtils.checkGroupName(request.getGroupName(), strBuffer, result)) {
            builder.setErrCode(result.getErrCode());
            builder.setErrMsg(result.getErrMsg());
            return builder.build();
        }
        String groupName = (String)result.getRetData();
        if (!PBParameterUtils.getTopicNameParameter(request.getTopicName(), this.metadataManager, strBuffer, result)) {
            builder.setErrCode(result.getErrCode());
            builder.setErrMsg(result.getErrMsg());
            return builder.build();
        }
        String topicName = (String)result.getRetData();
        int partitionId = request.getPartitionId();
        boolean isEscFlowCtrl = request.hasEscFlowCtrl() && request.getEscFlowCtrl();
        String partStr = this.getPartStr(groupName, topicName, partitionId);
        String consumerId = null;
        ConsumerNodeInfo consumerNodeInfo = this.consumerRegisterMap.get(partStr);
        if (consumerNodeInfo != null) {
            consumerId = consumerNodeInfo.getConsumerId();
        }
        if (consumerId == null) {
            logger.warn(strBuffer.append("[UnRegistered Consumer]").append(clientId).append("#").append(partStr).toString());
            strBuffer.delete(0, strBuffer.length());
            builder.setErrCode(411);
            builder.setErrMsg(strBuffer.append("UnRegistered Consumer:").append(clientId).append(", you have to register firstly!").toString());
            return builder.build();
        }
        if (!clientId.equals(consumerId)) {
            strBuffer.append("[Duplicated Request] Partition=").append(partStr).append(" of Broker=").append(this.tubeConfig.getBrokerId()).append(" has been consumed by ").append(consumerId).append(";Current consumer ").append(clientId);
            logger.warn(strBuffer.toString());
            builder.setErrCode(412);
            builder.setErrMsg(strBuffer.toString());
            return builder.build();
        }
        String rmtAddrInfo = consumerNodeInfo.getRmtAddrInfo();
        try {
            this.heartbeatManager.updConsumerNode(this.getHeartbeatNodeId(clientId, partStr));
        }
        catch (HeartbeatException e) {
            logger.warn(strBuffer.append("[Invalid Request]").append(clientId).append("#").append(topicName).append(":").append(partitionId).toString());
            builder.setErrCode(411);
            builder.setErrMsg(e.getMessage());
            return builder.build();
        }
        Integer topicStatusId = this.metadataManager.getClosedTopicStatusId(topicName);
        if (topicStatusId != null && topicStatusId > 1) {
            strBuffer.append("[Partition Closed] Partition has been closed, for topic=").append(topicName).append(",partitionId=").append(partitionId).append(" of Broker=").append(this.tubeConfig.getBrokerId());
            logger.warn(strBuffer.toString());
            builder.setErrCode(403);
            builder.setErrMsg(strBuffer.toString());
            return builder.build();
        }
        boolean isGetStore = false;
        MessageStore dataStore = null;
        try {
            dataStore = this.storeManager.getOrCreateMessageStore(topicName, partitionId);
            isGetStore = true;
            GetMessageResult msgResult = this.getMessages(dataStore, consumerNodeInfo, groupName, topicName, partitionId, request.getLastPackConsumed(), request.getManualCommitOffset(), clientId, this.tubeConfig.getHostName(), rmtAddrInfo, isEscFlowCtrl, strBuffer);
            if (msgResult.isSuccess) {
                long endTime = System.currentTimeMillis();
                consumerNodeInfo.setLastProcInfo(endTime, msgResult.lastRdDataOffset, msgResult.totalMsgSize);
                this.getCounterGroup.add(msgResult.tmpCounters);
                AuditUtils.addConsumeRecord(msgResult.tmpCounters);
                builder.setEscFlowCtrl(false);
                builder.setRequireSlow(msgResult.isSlowFreq);
                builder.setSuccess(true);
                builder.setErrCode(200);
                builder.setCurrOffset(msgResult.reqOffset);
                builder.setCurrDataDlt(msgResult.waitTime);
                builder.setErrMsg("OK!");
                builder.addAllMessages(msgResult.transferedMessageList);
                builder.setMaxOffset(msgResult.getMaxOffset());
                BrokerSrvStatsHolder.updGetMsgLatency(endTime - startTime);
                return builder.build();
            }
            builder.setErrCode(msgResult.getRetCode());
            builder.setErrMsg(msgResult.getErrInfo());
            builder.setMinLimitTime((int)msgResult.waitTime);
            return builder.build();
        }
        catch (Throwable ee) {
            strBuffer.delete(0, strBuffer.length());
            builder.setErrCode(500);
            if (isGetStore) {
                strBuffer.append("[GetMessage] Throwable error while getMessage,").append(ee.getMessage()).append(", position is").append(this.tubeConfig.getBrokerId()).append(":").append(topicName).append(":").append(partitionId);
                logger.error(strBuffer.toString(), ee);
                builder.setErrMsg(ee.getMessage() == null ? strBuffer.toString() : ee.getMessage());
            } else {
                builder.setErrMsg(strBuffer.append("Get the store of topic ").append(topicName).append(" in partition ").append(partitionId).append(" failure!").toString());
            }
            return builder.build();
        }
    }

    private GetMessageResult getMessages(MessageStore msgStore, ConsumerNodeInfo consumerNodeInfo, String group, String topic, int partitionId, boolean lastConsumed, boolean isManualCommitOffset, String sentAddr, String brokerAddr, String rmtAddrInfo, boolean isEscFlowCtrl, StringBuilder sb) throws IOException {
        long requestOffset = this.offsetManager.getOffset(msgStore, group, topic, partitionId, isManualCommitOffset, lastConsumed, sb);
        if (requestOffset < 0L) {
            return new GetMessageResult(false, 404, -requestOffset, 0, "The request offset reached maxOffset!");
        }
        long maxDataOffset = msgStore.getDataMaxOffset();
        int reqSwitch = this.getRealQryPriorityId(consumerNodeInfo);
        int msgDataSizeLimit = consumerNodeInfo.getCurrentAllowedSize(msgStore.getStoreKey(), this.metadataManager.getFlowCtrlRuleHandler(), maxDataOffset, this.storeManager.getMaxMsgTransferSize(), isEscFlowCtrl);
        if (msgDataSizeLimit <= 0) {
            if (consumerNodeInfo.isSupportLimit()) {
                return new GetMessageResult(false, 452, requestOffset, 0, -msgDataSizeLimit, "RpcServer consume speed limit!");
            }
            return new GetMessageResult(false, 404, requestOffset, 0, "RpcServer consume speed limit!");
        }
        try {
            String baseKey = sb.append(topic).append("#").append(brokerAddr).append("#").append(sentAddr).append("#").append(rmtAddrInfo).append("#").append(group).append("#").append(partitionId).toString();
            sb.delete(0, sb.length());
            GetMessageResult msgQueryResult = msgStore.getMessages(reqSwitch, requestOffset, partitionId, consumerNodeInfo, baseKey, msgDataSizeLimit, 0L);
            this.offsetManager.bookOffset(group, topic, partitionId, msgQueryResult.lastReadOffset, isManualCommitOffset, msgQueryResult.transferedMessageList.isEmpty(), sb);
            msgQueryResult.setWaitTime(maxDataOffset - msgQueryResult.lastRdDataOffset);
            return msgQueryResult;
        }
        catch (Throwable e1) {
            sb.delete(0, sb.length());
            logger.warn(sb.append("[Store Manager] get message failure, requestOffset=").append(requestOffset).append(",group=").append(group).append(",topic=").append(topic).append(",partitionId=").append(partitionId).toString(), e1);
            sb.delete(0, sb.length());
            return new GetMessageResult(false, 500, requestOffset, 0, sb.append("Get message failure, errMsg=").append(e1.getMessage()).toString());
        }
    }

    public StringBuilder getMessageSnapshot(String topicName, int partitionId, int msgCount, Set<String> filterCondSet, StringBuilder sb) throws Exception {
        MessageStore dataStore = null;
        long startTime = System.currentTimeMillis();
        if (!this.started.get() || ServiceStatusHolder.isReadServiceStop()) {
            sb.append("{\"result\":false,\"errCode\":").append(503).append(",\"errMsg\":\"Read StoreService temporary unavailable!\"}");
            return sb;
        }
        try {
            if (partitionId == -1) {
                Collection<MessageStore> msgStores = this.storeManager.getMessageStoresByTopic(topicName);
                if (msgStores == null || msgStores.isEmpty()) {
                    sb.append("{\"result\":false,\"errCode\":400,\"errMsg\":\"").append("Invalid parameter: not found the store by topicName(").append(topicName).append(")!\"}");
                    return sb;
                }
                for (MessageStore msgStore : msgStores) {
                    dataStore = msgStore;
                    if (dataStore == null) continue;
                    partitionId = msgStore.getStoreId() * 10000;
                    break;
                }
                if (dataStore == null) {
                    sb.append("{\"result\":false,\"errCode\":400,\"errMsg\":\"").append("Invalid parameter: all store is null by topicName(").append(topicName).append(")!\"}");
                    return sb;
                }
            } else {
                dataStore = this.storeManager.getOrCreateMessageStore(topicName, partitionId);
                if (dataStore == null) {
                    sb.append("{\"result\":false,\"errCode\":400,\"errMsg\":\"").append("Invalid parameter: not found the store by topicName + partitionId(").append(topicName).append(":").append(partitionId).append(")!\"}");
                    return sb;
                }
            }
            GetMessageResult getMessageResult = this.storeManager.getMessages(dataStore, topicName, partitionId, msgCount, filterCondSet);
            BrokerSrvStatsHolder.updGetMsgLatency(System.currentTimeMillis() - startTime);
            if (getMessageResult.transferedMessageList == null || getMessageResult.transferedMessageList.isEmpty()) {
                sb.append("{\"result\":false,\"errCode\":401,\"errMsg\":\"").append("Could not find message at position by topic (").append(topicName).append(")!\"}");
                return sb;
            }
            List<ClientBroker.TransferedMessage> tmpMsgList = getMessageResult.transferedMessageList;
            List messageList = DataConverterUtil.convertMessage((String)topicName, tmpMsgList);
            int i = 0;
            sb.append("{\"result\":true,\"errCode\":0,\"errMsg\":\"Success!\",\"dataSet\":[");
            for (int startPos = Math.max(messageList.size() - msgCount, 0); startPos < messageList.size(); ++startPos) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append("{\"index\":").append(i++).append(",\"data\":\"").append(new String(Base64.encodeBase64((byte[])((Message)messageList.get(startPos)).getData()))).append("\",\"attr\":\"").append(((Message)messageList.get(startPos)).getAttribute()).append("\"}");
            }
            sb.append("]}");
            return sb;
        }
        catch (Throwable ee) {
            sb.append("{\"result\":false,\"errCode\":501,\"errMsg\":\"Get Message failure, exception is ").append(ee.getMessage()).append("\"}");
            return sb;
        }
    }

    public ClientBroker.SendMessageResponseB2P sendMessageP2B(ClientBroker.SendMessageRequestP2B request, String rmtAddress, boolean overtls) throws Throwable {
        byte[] msgData;
        int dataLength;
        ProcessResult result = new ProcessResult();
        long startTime = System.currentTimeMillis();
        StringBuilder strBuffer = new StringBuilder(512);
        ClientBroker.SendMessageResponseB2P.Builder builder = ClientBroker.SendMessageResponseB2P.newBuilder();
        builder.setSuccess(false);
        if (!this.started.get() || ServiceStatusHolder.isWriteServiceStop()) {
            builder.setErrCode(503);
            builder.setErrMsg("Write StoreService temporary unavailable!");
            return builder.build();
        }
        if (!this.serverAuthHandler.identityValidUserInfo(request.getAuthInfo(), true, result)) {
            builder.setErrCode(result.getErrCode());
            builder.setErrMsg(result.getErrMsg());
            return builder.build();
        }
        CertifiedInfo certifiedInfo = (CertifiedInfo)result.getRetData();
        if (!PBParameterUtils.checkClientId(request.getClientId(), strBuffer, result)) {
            builder.setErrCode(result.getErrCode());
            builder.setErrMsg(result.getErrMsg());
            return builder.build();
        }
        int partitionId = request.getPartitionId();
        if (!PBParameterUtils.getTopicNamePartIdInfo(true, request.getTopicName(), partitionId, this.metadataManager, strBuffer, result)) {
            builder.setErrCode(result.getErrCode());
            builder.setErrMsg(result.getErrMsg());
            return builder.build();
        }
        TopicMetadata topicMetadata = (TopicMetadata)result.getRetData();
        String topicName = topicMetadata.getTopic();
        String msgType = null;
        int msgTypeCode = -1;
        if (TStringUtils.isNotBlank((String)request.getMsgType())) {
            msgType = request.getMsgType().trim();
            msgTypeCode = msgType.hashCode();
        }
        if ((dataLength = (msgData = request.getData().toByteArray()).length) <= 0) {
            builder.setErrCode(400);
            builder.setErrMsg("data length is zero!");
            return builder.build();
        }
        if (dataLength > topicMetadata.getMaxMsgSize()) {
            builder.setErrCode(400);
            builder.setErrMsg(strBuffer.append("data length over max length, allowed max length is ").append(topicMetadata.getMaxMsgSize()).append(", data length is ").append(dataLength).toString());
            return builder.build();
        }
        int checkSum = CheckSum.crc32((byte[])msgData);
        if (request.getCheckSum() != -1 && checkSum != request.getCheckSum()) {
            builder.setErrCode(403);
            builder.setErrMsg(strBuffer.append("Checksum msg data failure: ").append(request.getCheckSum()).append(" of ").append(topicName).append(" not equal to the data's checksum of ").append(checkSum).toString());
            return builder.build();
        }
        if (!this.serverAuthHandler.validProduceAuthorizeInfo(certifiedInfo.getUserName(), topicName, msgType, rmtAddress, result)) {
            builder.setErrCode(result.getErrCode());
            builder.setErrMsg(result.getErrMsg());
            return builder.build();
        }
        try {
            MessageStore store = this.storeManager.getOrCreateMessageStore(topicName, partitionId);
            AppendResult appendResult = new AppendResult();
            if (store.appendMsg(appendResult, dataLength, checkSum, msgData, msgTypeCode, request.getFlag(), partitionId, request.getSentAddr())) {
                String baseKey = strBuffer.append(topicName).append("#").append(AddressUtils.intToIp((int)request.getSentAddr())).append("#").append(this.tubeConfig.getHostName()).append("#").append(request.getPartitionId()).append("#").append(request.getMsgTime()).toString();
                this.putCounterGroup.add(baseKey, 1L, dataLength);
                AuditUtils.addProduceRecord(topicName, request.getMsgType(), request.getMsgTime(), 1L, dataLength);
                builder.setSuccess(true);
                builder.setRequireAuth(certifiedInfo.isReAuth());
                builder.setErrCode(200);
                builder.setErrMsg(String.valueOf(appendResult.getMsgId()));
                builder.setMessageId(appendResult.getMsgId());
                builder.setAppendTime(appendResult.getAppendTime());
                builder.setAppendOffset(appendResult.getAppendIndexOffset());
                BrokerSrvStatsHolder.updSendMsgLatency(System.currentTimeMillis() - startTime);
                return builder.build();
            }
            builder.setErrCode(419);
            builder.setErrMsg(strBuffer.append("Put message failed from ").append(this.tubeConfig.getHostName()).append(", server receive message overflow!").toString());
            return builder.build();
        }
        catch (Throwable ex) {
            logger.error("Put message failed ", ex);
            strBuffer.delete(0, strBuffer.length());
            builder.setSuccess(false);
            builder.setErrCode(500);
            builder.setErrMsg(strBuffer.append("Put message failed from ").append(this.tubeConfig.getHostName()).append(" ").append(ex.getMessage() != null ? ex.getMessage() : " ").toString());
            return builder.build();
        }
    }

    public void appendGroupOffsetInfo(Map<String, OffsetHistoryInfo> groupOffsetMap, int brokerAddrId, long storeTime, int retryCnt, long waitRetryMs, StringBuilder strBuff) {
        if (groupOffsetMap == null || groupOffsetMap.isEmpty()) {
            return;
        }
        int msgFlag = 1;
        AppendResult appendResult = new AppendResult();
        String sendTime = DateTimeConvertUtils.ms2yyyyMMddHHmm((long)storeTime);
        for (Map.Entry<String, OffsetHistoryInfo> entry : groupOffsetMap.entrySet()) {
            if (entry == null || entry.getKey() == null || entry.getValue() == null) continue;
            int msgTypeCode = entry.getKey().hashCode();
            int partitionId = Math.abs(msgTypeCode) % 10;
            entry.getValue().buildRecordInfo(strBuff, storeTime);
            byte[] dataValue = StringUtils.getBytesUtf8((String)strBuff.toString());
            strBuff.delete(0, strBuff.length());
            strBuff.append("$msgType$").append("=").append(msgTypeCode).append(",").append("$msgTime$").append("=").append(sendTime).append(",").append("$groupName$").append("=").append(entry.getKey());
            byte[] attrData = StringUtils.getBytesUtf8((String)strBuff.toString());
            strBuff.delete(0, strBuff.length());
            ByteBuffer rcdBuff = ByteBuffer.allocate(4 + attrData.length + dataValue.length);
            rcdBuff.putInt(attrData.length);
            rcdBuff.put(attrData);
            rcdBuff.put(dataValue);
            byte[] msgData = rcdBuff.array();
            int msgLength = msgData.length;
            int checkSum = CheckSum.crc32((byte[])msgData);
            try {
                MessageStore msgStore = this.storeManager.getOrCreateMessageStore("__offset_history__", partitionId);
                if (msgStore.appendMsg2(appendResult, msgLength, checkSum, msgData, msgTypeCode, msgFlag, partitionId, brokerAddrId, storeTime, retryCnt, waitRetryMs)) {
                    String baseKey = strBuff.append("__offset_history__").append("#").append(this.tubeConfig.getHostName()).append("#").append(this.tubeConfig.getHostName()).append("#").append(partitionId).append("#").append(sendTime).toString();
                    this.putCounterGroup.add(baseKey, 1L, msgLength);
                    AuditUtils.addProduceRecord("__offset_history__", entry.getKey(), sendTime, 1L, msgLength);
                    strBuff.delete(0, strBuff.length());
                    continue;
                }
                logger.warn("Put history offset overflow !");
            }
            catch (Throwable ex) {
                strBuff.delete(0, strBuff.length());
                logger.error("Put history offset failed ", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientBroker.RegisterResponseB2C consumerRegisterC2B(ClientBroker.RegisterRequestC2B request, String rmtAddress, boolean overtls) throws Throwable {
        ProcessResult result = new ProcessResult();
        ClientBroker.RegisterResponseB2C.Builder builder = ClientBroker.RegisterResponseB2C.newBuilder();
        builder.setSuccess(false);
        builder.setCurrOffset(-1L);
        if (!this.started.get()) {
            builder.setErrCode(503);
            builder.setErrMsg("StoreService temporary unavailable!");
            return builder.build();
        }
        if (!this.serverAuthHandler.identityValidUserInfo(request.getAuthInfo(), false, result)) {
            builder.setErrCode(result.getErrCode());
            builder.setErrMsg(result.getErrMsg());
            return builder.build();
        }
        CertifiedInfo certifiedInfo = (CertifiedInfo)result.getRetData();
        StringBuilder strBuffer = new StringBuilder(512);
        if (!PBParameterUtils.checkClientId(request.getClientId(), strBuffer, result)) {
            builder.setErrCode(result.getErrCode());
            builder.setErrMsg(result.getErrMsg());
            return builder.build();
        }
        String clientId = (String)result.getRetData();
        if (!PBParameterUtils.getTopicNameParameter(request.getTopicName(), this.metadataManager, strBuffer, result)) {
            builder.setErrCode(result.getErrCode());
            builder.setErrMsg(result.getErrMsg());
            return builder.build();
        }
        String topicName = (String)result.getRetData();
        if (!PBParameterUtils.checkGroupName(request.getGroupName(), strBuffer, result)) {
            builder.setErrCode(result.getErrCode());
            builder.setErrMsg(result.getErrMsg());
            return builder.build();
        }
        String groupName = (String)result.getRetData();
        boolean isRegister = request.getOpType() == 31;
        HashSet<String> filterCondSet = new HashSet<String>();
        if (request.getFilterCondStrList() != null && !request.getFilterCondStrList().isEmpty()) {
            for (String filterCond : request.getFilterCondStrList()) {
                if (!TStringUtils.isNotBlank((String)filterCond)) continue;
                filterCondSet.add(filterCond.trim());
            }
        }
        if (!this.serverAuthHandler.validConsumeAuthorizeInfo(certifiedInfo.getUserName(), groupName, topicName, filterCondSet, isRegister, rmtAddress, result)) {
            builder.setErrCode(result.getErrCode());
            builder.setErrMsg(result.getErrMsg());
            return builder.build();
        }
        Integer lid = null;
        Integer partLock = null;
        String partStr = this.getPartStr(groupName, topicName, request.getPartitionId());
        try {
            block26: {
                block25: {
                    lid = this.brokerRowLock.getLock(null, StringUtils.getBytesUtf8((String)clientId), true);
                    try {
                        partLock = this.brokerRowLock.getLock(null, StringUtils.getBytesUtf8((String)partStr), true);
                        if (request.getOpType() != 31) break block25;
                        ClientBroker.RegisterResponseB2C registerResponseB2C = this.inProcessConsumerRegister(clientId, groupName, topicName, partStr, filterCondSet, rmtAddress, overtls, request, builder, strBuffer);
                        if (partLock != null) {
                            this.brokerRowLock.releaseRowLock(partLock);
                        }
                        return registerResponseB2C;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (partLock != null) {
                                this.brokerRowLock.releaseRowLock(partLock);
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            strBuffer.delete(0, strBuffer.length());
                            String message = "Failed to lock.";
                            logger.warn(message, (Throwable)e);
                            builder.setErrCode(400);
                            builder.setErrMsg(strBuffer.append(message).append(e.getMessage()).toString());
                            ClientBroker.RegisterResponseB2C registerResponseB2C = builder.build();
                            return registerResponseB2C;
                        }
                    }
                }
                if (request.getOpType() != 32) break block26;
                ClientBroker.RegisterResponseB2C registerResponseB2C = this.inProcessConsumerUnregister(clientId, groupName, topicName, partStr, request, overtls, builder, strBuffer);
                if (partLock != null) {
                    this.brokerRowLock.releaseRowLock(partLock);
                }
                return registerResponseB2C;
            }
            String message = strBuffer.append("Invalid request:").append(request.getOpType()).toString();
            logger.info(message);
            builder.setErrCode(400);
            builder.setErrMsg(message);
            ClientBroker.RegisterResponseB2C registerResponseB2C = builder.build();
            if (partLock != null) {
                this.brokerRowLock.releaseRowLock(partLock);
            }
            return registerResponseB2C;
        }
        finally {
            if (lid != null) {
                this.brokerRowLock.releaseRowLock(lid);
            }
        }
    }

    private ClientBroker.RegisterResponseB2C inProcessConsumerRegister(String clientId, String groupName, String topicName, String partStr, Set<String> filterCondSet, String msgRcvFrom, boolean overtls, ClientBroker.RegisterRequestC2B request, ClientBroker.RegisterResponseB2C.Builder builder, StringBuilder strBuffer) {
        String consumerId = null;
        ConsumerNodeInfo consumerNodeInfo = this.consumerRegisterMap.get(partStr);
        if (consumerNodeInfo != null) {
            consumerId = consumerNodeInfo.getConsumerId();
        }
        if (TStringUtils.isEmpty(consumerId) || consumerId.equals(clientId)) {
            long reqOffset = request.hasCurrOffset() ? request.getCurrOffset() : -1L;
            long reqSessionTime = request.hasSessionTime() ? request.getSessionTime() : -1L;
            String reqSessionKey = request.hasSessionKey() ? request.getSessionKey() : null;
            int reqQryPriorityId = request.hasQryPriorityId() ? request.getQryPriorityId() : -2;
            consumerNodeInfo = new ConsumerNodeInfo(this.storeManager, reqQryPriorityId, groupName, clientId, filterCondSet, reqSessionKey, reqSessionTime, true, partStr, msgRcvFrom);
            if (this.consumerRegisterMap.put(partStr, consumerNodeInfo) == null) {
                BrokerSrvStatsHolder.incConsumeOnlineCnt();
            }
            this.heartbeatManager.regConsumerNode(this.getHeartbeatNodeId(clientId, partStr), clientId, partStr);
            MessageStore dataStore = null;
            try {
                dataStore = this.storeManager.getOrCreateMessageStore(topicName, request.getPartitionId());
                if (dataStore == null) {
                    builder.setErrCode(403);
                    builder.setErrMsg(strBuffer.append("Topic ").append(topicName).append("-").append(request.getPartitionId()).append(" not existed, please check your configure").toString());
                    return builder.build();
                }
            }
            catch (Throwable e0) {
                strBuffer.delete(0, strBuffer.length());
                String message = "Register broker failure!";
                logger.warn(message, e0);
                builder.setErrCode(500);
                builder.setErrMsg(strBuffer.append(message).append(", exception is ").append(e0.getMessage()).toString());
                return builder.build();
            }
            OffsetStorageInfo offsetInfo = this.offsetManager.loadOffset(dataStore, groupName, topicName, request.getPartitionId(), request.getReadStatus(), reqOffset, strBuffer);
            logger.info(strBuffer.append("[Consumer Register]").append(clientId).append("#").append(partStr).append("#").append(offsetInfo).append(", reqOffset=").append(reqOffset).append(", reqQryPriorityId=").append(reqQryPriorityId).append(", isOverTLS=").append(overtls).toString());
            builder.setSuccess(true);
            builder.setErrCode(200);
            builder.setErrMsg("OK!");
            builder.setCurrOffset(offsetInfo.getOffset());
            if (this.getRealQryPriorityId(consumerNodeInfo) <= 1) {
                builder.setMaxOffset(dataStore.getFileIndexMaxOffset());
            } else {
                builder.setMaxOffset(dataStore.getIndexMaxOffset());
            }
            return builder.build();
        }
        TimeoutInfo timeoutInfo = this.heartbeatManager.getConsumerRegMap().get(this.getHeartbeatNodeId(consumerId, partStr));
        if (timeoutInfo == null || System.currentTimeMillis() >= timeoutInfo.getTimeoutTime()) {
            if (this.consumerRegisterMap.remove(partStr) != null) {
                BrokerSrvStatsHolder.decConsumeOnlineCnt(true);
            }
            strBuffer.append("[Duplicated Register] Remove Invalid Consumer Register ").append(consumerId).append("#").append(partStr);
        } else {
            strBuffer.append("[Duplicated Register] Partition ").append(this.tubeConfig.getBrokerId()).append("#").append(partStr).append(" has been registered by ").append(consumerId);
        }
        logger.warn(strBuffer.toString());
        builder.setErrCode(410);
        builder.setErrMsg(strBuffer.toString());
        return builder.build();
    }

    private ClientBroker.RegisterResponseB2C inProcessConsumerUnregister(String clientId, String groupName, String topicName, String partStr, ClientBroker.RegisterRequestC2B request, boolean overtls, ClientBroker.RegisterResponseB2C.Builder builder, StringBuilder strBuffer) {
        logger.info(strBuffer.append("[Consumer Unregister]").append(clientId).append(", isOverTLS=").append(overtls).toString());
        strBuffer.delete(0, strBuffer.length());
        ConsumerNodeInfo consumerNodeInfo = this.consumerRegisterMap.get(partStr);
        if (consumerNodeInfo == null) {
            logger.warn(strBuffer.append("[UnRegistered Consumer2]").append(clientId).append("#").append(partStr).toString());
            strBuffer.delete(0, strBuffer.length());
            builder.setErrCode(411);
            builder.setErrMsg(strBuffer.append("UnRegistered Consumer ").append(clientId).append(", you have to register firstly!").toString());
            return builder.build();
        }
        if (!clientId.equals(consumerNodeInfo.getConsumerId())) {
            String message = strBuffer.append("[Duplicated Request]").append("Partition ").append(partStr).append(" has been consumed by ").append(consumerNodeInfo.getConsumerId()).append(";Current consumer ").append(clientId).toString();
            logger.warn(message);
            builder.setErrCode(412);
            builder.setErrMsg(strBuffer.append(", broker=").append(this.tubeConfig.getHostName()).toString());
            return builder.build();
        }
        try {
            int readStatus = request.getReadStatus();
            long updatedOffset = this.offsetManager.commitOffset(groupName, topicName, request.getPartitionId(), readStatus == 0);
            logger.info(strBuffer.append("[Unregister Offset] update lastOffset, ").append(groupName).append(" topic:").append(topicName).append(" partition:").append(request.getPartitionId()).append(" updatedOffset:").append(updatedOffset).toString());
            strBuffer.delete(0, strBuffer.length());
            if (this.consumerRegisterMap.remove(partStr) != null) {
                BrokerSrvStatsHolder.decConsumeOnlineCnt(false);
            }
            this.heartbeatManager.unRegConsumerNode(this.getHeartbeatNodeId(clientId, partStr));
        }
        catch (Exception e) {
            strBuffer.delete(0, strBuffer.length());
            String message = strBuffer.append("Unregister consumer:").append(clientId).append(" failed.").toString();
            logger.warn(message, (Throwable)e);
            builder.setErrCode(500);
            builder.setErrMsg(strBuffer.append(" exception is ").append(e.getMessage()).toString());
            return builder.build();
        }
        builder.setSuccess(true);
        builder.setErrCode(200);
        builder.setErrMsg("OK!");
        return builder.build();
    }

    public ClientBroker.HeartBeatResponseB2C consumerHeartbeatC2B(ClientBroker.HeartBeatRequestC2B request, String rmtAddress, boolean overtls) throws Throwable {
        ProcessResult result = new ProcessResult();
        StringBuilder strBuffer = new StringBuilder(512);
        ClientBroker.HeartBeatResponseB2C.Builder builder = ClientBroker.HeartBeatResponseB2C.newBuilder();
        builder.setSuccess(false);
        if (!this.started.get()) {
            builder.setErrCode(503);
            builder.setErrMsg("StoreService temporary unavailable!");
            return builder.build();
        }
        if (!this.serverAuthHandler.identityValidUserInfo(request.getAuthInfo(), false, result)) {
            builder.setErrCode(result.getErrCode());
            builder.setErrMsg(result.getErrMsg());
            return builder.build();
        }
        CertifiedInfo certifiedInfo = (CertifiedInfo)result.getRetData();
        if (!PBParameterUtils.checkClientId(request.getClientId(), strBuffer, result)) {
            builder.setErrCode(result.getErrCode());
            builder.setErrMsg(result.getErrMsg());
            return builder.build();
        }
        String clientId = (String)result.getRetData();
        if (!PBParameterUtils.checkGroupName(request.getGroupName(), strBuffer, result)) {
            builder.setErrCode(result.getErrCode());
            builder.setErrMsg(result.getErrMsg());
            return builder.build();
        }
        String groupName = (String)result.getRetData();
        int reqQryPriorityId = request.hasQryPriorityId() ? request.getQryPriorityId() : -2;
        List partitions = DataConverterUtil.convertPartitionInfo((List)request.getPartitionInfoList());
        boolean isAuthorized = false;
        ArrayList<String> failureInfo = new ArrayList<String>();
        for (Partition partition : partitions) {
            int partitionId;
            String topic = partition.getTopic();
            String partStr = this.getPartStr(groupName, topic, partitionId = partition.getPartitionId());
            ConsumerNodeInfo consumerNodeInfo = this.consumerRegisterMap.get(partStr);
            if (consumerNodeInfo == null) {
                failureInfo.add(strBuffer.append(411).append(":").append(partition).toString());
                strBuffer.delete(0, strBuffer.length());
                logger.warn(strBuffer.append("[Heartbeat Check] UnRegistered Consumer:").append(clientId).append("#").append(partStr).toString());
                strBuffer.delete(0, strBuffer.length());
                continue;
            }
            if (!clientId.equals(consumerNodeInfo.getConsumerId())) {
                failureInfo.add(strBuffer.append(412).append(":").append(partition).toString());
                strBuffer.delete(0, strBuffer.length());
                strBuffer.append("[Heartbeat Check] Duplicated partition: Partition ").append(partStr).append(" has been consumed by ").append(consumerNodeInfo.getConsumerId()).append(";Current consumer ").append(clientId);
                logger.warn(strBuffer.toString());
                strBuffer.delete(0, strBuffer.length());
                continue;
            }
            if (!isAuthorized) {
                if (!this.serverAuthHandler.validConsumeAuthorizeInfo(certifiedInfo.getUserName(), groupName, topic, consumerNodeInfo.getFilterCondStrs(), true, rmtAddress, result)) {
                    builder.setErrCode(result.getErrCode());
                    builder.setErrMsg(result.getErrMsg());
                    return builder.build();
                }
                isAuthorized = true;
            }
            try {
                this.heartbeatManager.updConsumerNode(this.getHeartbeatNodeId(clientId, partStr));
            }
            catch (HeartbeatException e) {
                failureInfo.add(strBuffer.append(411).append(":").append(partition).toString());
                strBuffer.delete(0, strBuffer.length());
                logger.warn(strBuffer.append("[Heartbeat Check] Invalid Request").append(clientId).append("#").append(topic).append(":").append(partitionId).toString());
                strBuffer.delete(0, strBuffer.length());
                continue;
            }
            if (consumerNodeInfo.getQryPriorityId() == reqQryPriorityId) continue;
            consumerNodeInfo.setQryPriorityId(reqQryPriorityId);
        }
        builder.setRequireAuth(certifiedInfo.isReAuth());
        builder.setSuccess(true);
        builder.setErrCode(200);
        builder.setHasPartFailure(false);
        if (!failureInfo.isEmpty()) {
            builder.setHasPartFailure(true);
            builder.addAllFailureInfo(failureInfo);
        }
        builder.setErrMsg("OK!");
        return builder.build();
    }

    public ClientBroker.CommitOffsetResponseB2C consumerCommitC2B(ClientBroker.CommitOffsetRequestC2B request, String rmtAddress, boolean overtls) throws Throwable {
        ClientBroker.CommitOffsetResponseB2C.Builder builder;
        long startTime;
        block12: {
            startTime = System.currentTimeMillis();
            builder = ClientBroker.CommitOffsetResponseB2C.newBuilder();
            builder.setSuccess(false);
            builder.setCurrOffset(-1L);
            if (!this.started.get()) {
                builder.setErrCode(503);
                builder.setErrMsg("StoreService temporary unavailable!");
                return builder.build();
            }
            ProcessResult result = new ProcessResult();
            StringBuilder strBuffer = new StringBuilder(512);
            if (!PBParameterUtils.checkClientId(request.getClientId(), strBuffer, result)) {
                builder.setErrCode(result.getErrCode());
                builder.setErrMsg(result.getErrMsg());
                return builder.build();
            }
            String clientId = (String)result.getRetData();
            if (!PBParameterUtils.checkGroupName(request.getGroupName(), strBuffer, result)) {
                builder.setErrCode(result.getErrCode());
                builder.setErrMsg(result.getErrMsg());
                return builder.build();
            }
            String groupName = (String)result.getRetData();
            int partitionId = request.getPartitionId();
            if (!PBParameterUtils.getTopicNamePartIdInfo(false, request.getTopicName(), partitionId, this.metadataManager, strBuffer, result)) {
                builder.setErrCode(result.getErrCode());
                builder.setErrMsg(result.getErrMsg());
                return builder.build();
            }
            TopicMetadata topicMetadata = (TopicMetadata)result.getRetData();
            String topicName = topicMetadata.getTopic();
            String partStr = this.getPartStr(groupName, topicName, partitionId);
            ConsumerNodeInfo consumerNodeInfo = this.consumerRegisterMap.get(partStr);
            if (consumerNodeInfo == null) {
                builder.setErrCode(401);
                builder.setErrMsg("The partition not registered by consumers");
                logger.error(strBuffer.append("[consumerCommitC2B error] partition not registered by consumers: commit consumer is: ").append(clientId).append(", partition is : ").append(partStr).toString());
                return builder.build();
            }
            boolean isConsumed = true;
            if (request.hasLastPackConsumed()) {
                isConsumed = request.getLastPackConsumed();
            }
            if (clientId.equals(consumerNodeInfo.getConsumerId())) {
                try {
                    long currOffset = this.offsetManager.commitOffset(groupName, topicName, partitionId, isConsumed);
                    MessageStore dataStore = this.storeManager.getOrCreateMessageStore(topicName, partitionId);
                    if (dataStore == null) {
                        builder.setErrCode(403);
                        builder.setErrMsg(strBuffer.append("Topic ").append(topicName).append("-").append(request.getPartitionId()).append(" not existed, please check your configure").toString());
                        return builder.build();
                    }
                    builder.setSuccess(true);
                    builder.setErrCode(200);
                    builder.setErrMsg("OK!");
                    builder.setCurrOffset(currOffset);
                    if (this.getRealQryPriorityId(consumerNodeInfo) <= 1) {
                        builder.setMaxOffset(dataStore.getFileIndexMaxOffset());
                        break block12;
                    }
                    builder.setMaxOffset(dataStore.getIndexMaxOffset());
                }
                catch (Exception e) {
                    builder.setErrMsg(e.getMessage());
                    builder.setErrCode(500);
                    logger.error("[commitOffset error]", (Throwable)e);
                }
            } else {
                builder.setErrCode(401);
                builder.setErrMsg(strBuffer.append("The partition has been registered by other consumer: ").append(consumerNodeInfo.getConsumerId()).toString());
                strBuffer.delete(0, strBuffer.length());
                logger.error(strBuffer.append("[consumerCommitC2B error] partition has been registered by").append(" other consumer: commit consumer is: ").append(clientId).append(", registered consumer is: ").append(consumerNodeInfo.getConsumerId()).append(", partition is : ").append(partStr).toString());
            }
        }
        BrokerSrvStatsHolder.updConfirmLatency(System.currentTimeMillis() - startTime);
        return builder.build();
    }

    private String getPartStr(String group, String topic, int partitionId) {
        return new StringBuilder(512).append(group).append(":").append(topic).append(":").append(partitionId).toString();
    }

    private String getHeartbeatNodeId(String consumerId, String partStr) {
        return new StringBuilder(512).append(consumerId).append("#").append(partStr).toString();
    }

    private int getRealQryPriorityId(ConsumerNodeInfo consumerNodeInfo) {
        return consumerNodeInfo.getQryPriorityId() <= 0 ? (this.metadataManager.getFlowCtrlRuleHandler().getQryPriorityId() <= 0 ? 300 : this.metadataManager.getFlowCtrlRuleHandler().getQryPriorityId()) : consumerNodeInfo.getQryPriorityId();
    }

    public class ConsumerTimeoutListener
    implements TimeoutListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onTimeout(String nodeId, TimeoutInfo nodeInfo) {
            Integer lid;
            block15: {
                ConsumerNodeInfo consumerNodeInfo;
                Integer partLock;
                lid = null;
                StringBuilder strBuffer = new StringBuilder(512);
                try {
                    lid = BrokerServiceServer.this.brokerRowLock.getLock(null, StringUtils.getBytesUtf8((String)nodeInfo.getSecondKey()), true);
                    partLock = null;
                    try {
                        partLock = BrokerServiceServer.this.brokerRowLock.getLock(null, StringUtils.getBytesUtf8((String)nodeInfo.getThirdKey()), true);
                        consumerNodeInfo = (ConsumerNodeInfo)BrokerServiceServer.this.consumerRegisterMap.get(nodeInfo.getThirdKey());
                        if (consumerNodeInfo == null) {
                            if (partLock != null) {
                                BrokerServiceServer.this.brokerRowLock.releaseRowLock(partLock);
                            }
                            if (lid == null) return;
                            BrokerServiceServer.this.brokerRowLock.releaseRowLock(lid);
                            return;
                        }
                    }
                    catch (IOException e1) {
                        try {
                            logger.warn("Failed to lock.", (Throwable)e1);
                            if (partLock != null) {
                                BrokerServiceServer.this.brokerRowLock.releaseRowLock(partLock);
                            }
                            break block15;
                        }
                        catch (Throwable throwable) {
                            if (partLock == null) throw throwable;
                            BrokerServiceServer.this.brokerRowLock.releaseRowLock(partLock);
                            throw throwable;
                        }
                    }
                }
                catch (IOException e2) {
                    try {
                        logger.warn("Failed to lock.", (Throwable)e2);
                        if (lid == null) return;
                        BrokerServiceServer.this.brokerRowLock.releaseRowLock(lid);
                        return;
                    }
                    catch (Throwable throwable) {
                        if (lid == null) throw throwable;
                        BrokerServiceServer.this.brokerRowLock.releaseRowLock(lid);
                        throw throwable;
                    }
                }
                {
                    if (consumerNodeInfo.getConsumerId().equalsIgnoreCase(nodeInfo.getSecondKey())) {
                        if (BrokerServiceServer.this.consumerRegisterMap.remove(nodeInfo.getThirdKey()) != null) {
                            BrokerSrvStatsHolder.decConsumeOnlineCnt(true);
                        }
                        String[] groupTopicPart = consumerNodeInfo.getPartStr().split(":");
                        long updatedOffset = BrokerServiceServer.this.offsetManager.commitOffset(groupTopicPart[0], groupTopicPart[1], Integer.parseInt(groupTopicPart[2]), false);
                        logger.info(strBuffer.append("[Consumer-Partition Timeout]").append(nodeId).append(",updatedOffset=").append(updatedOffset).toString());
                    }
                    if (partLock == null) break block15;
                    BrokerServiceServer.this.brokerRowLock.releaseRowLock(partLock);
                }
            }
            if (lid == null) return;
            BrokerServiceServer.this.brokerRowLock.releaseRowLock(lid);
        }
    }
}

