/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.connector.source.lib.util;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import javax.annotation.Nullable;
import org.apache.flink.api.connector.source.SplitEnumerator;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.api.connector.source.lib.util.IteratorSourceSplit;
import org.apache.flink.util.Preconditions;

public class IteratorSourceEnumerator<SplitT extends IteratorSourceSplit<?, ?>>
implements SplitEnumerator<SplitT, Collection<SplitT>> {
    private final SplitEnumeratorContext<SplitT> context;
    private final Queue<SplitT> remainingSplits;

    public IteratorSourceEnumerator(SplitEnumeratorContext<SplitT> context, Collection<SplitT> splits) {
        this.context = Preconditions.checkNotNull(context);
        this.remainingSplits = new ArrayDeque<SplitT>(splits);
    }

    @Override
    public void start() {
    }

    @Override
    public void close() {
    }

    @Override
    public void handleSplitRequest(int subtaskId, @Nullable String requesterHostname) {
        IteratorSourceSplit nextSplit = (IteratorSourceSplit)this.remainingSplits.poll();
        if (nextSplit != null) {
            this.context.assignSplit(nextSplit, subtaskId);
        } else {
            this.context.signalNoMoreSplits(subtaskId);
        }
    }

    @Override
    public void addSplitsBack(List<SplitT> splits, int subtaskId) {
        this.remainingSplits.addAll(splits);
    }

    @Override
    public Collection<SplitT> snapshotState(long checkpointId) throws Exception {
        return this.remainingSplits;
    }

    @Override
    public void addReader(int subtaskId) {
    }
}

