/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.source;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.socket.nio.NioDatagramChannel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.flume.Context;
import org.apache.flume.conf.Configurable;
import org.apache.inlong.dataproxy.config.ConfigManager;
import org.apache.inlong.dataproxy.source.BaseSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleUdpSource
extends BaseSource
implements Configurable {
    private static final Logger logger = LoggerFactory.getLogger(SimpleUdpSource.class);
    private Bootstrap bootstrap;

    @Override
    public void configure(Context context) {
        logger.info("Source {} context is {}", (Object)this.getName(), (Object)context);
        super.configure(context);
    }

    @Override
    public void startSource() {
        logger.info("start " + this.getCachedSrcName());
        this.bootstrap = new Bootstrap();
        this.bootstrap.channel(NioDatagramChannel.class);
        if (this.conLinger >= 0) {
            this.bootstrap.option(ChannelOption.SO_LINGER, (Object)this.conLinger);
        }
        this.bootstrap.option(ChannelOption.SO_BACKLOG, (Object)this.conBacklog);
        this.bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)this.reuseAddress);
        this.bootstrap.option(ChannelOption.SO_RCVBUF, (Object)this.maxRcvBufferSize);
        this.bootstrap.option(ChannelOption.SO_SNDBUF, (Object)this.maxSendBufferSize);
        this.bootstrap.handler((ChannelHandler)this.getChannelInitializerFactory());
        try {
            this.channelFuture = this.srcHost == null ? this.bootstrap.bind((SocketAddress)new InetSocketAddress(this.srcPort)).sync() : this.bootstrap.bind((SocketAddress)new InetSocketAddress(this.srcHost, this.srcPort)).sync();
        }
        catch (Exception e) {
            logger.error("Source {} bind ({}:{}) error, program will exit! e = {}", new Object[]{this.getCachedSrcName(), this.srcHost, this.srcPort, e});
            System.exit(-1);
        }
        ConfigManager.getInstance().addSourceReportInfo(this.srcHost, String.valueOf(this.srcPort), this.getProtocolName().toUpperCase());
        logger.info("Source {} started at ({}:{})!", new Object[]{this.getCachedSrcName(), this.srcHost, this.srcPort});
    }

    @Override
    public void stop() {
        super.stop();
    }

    @Override
    public String getProtocolName() {
        return "udp";
    }
}

