/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.sink.mq;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.StringUtils;
import org.apache.flume.Channel;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.EventDeliveryException;
import org.apache.flume.Sink;
import org.apache.flume.Transaction;
import org.apache.flume.conf.Configurable;
import org.apache.flume.event.SimpleEvent;
import org.apache.flume.sink.AbstractSink;
import org.apache.inlong.common.monitor.LogCounter;
import org.apache.inlong.dataproxy.config.CommonConfigHolder;
import org.apache.inlong.dataproxy.config.ConfigManager;
import org.apache.inlong.dataproxy.config.holder.ConfigUpdateCallback;
import org.apache.inlong.dataproxy.sink.mq.BatchPackManager;
import org.apache.inlong.dataproxy.sink.mq.MessageQueueZoneProducer;
import org.apache.inlong.dataproxy.sink.mq.MessageQueueZoneSinkContext;
import org.apache.inlong.dataproxy.sink.mq.MessageQueueZoneWorker;
import org.apache.inlong.dataproxy.sink.mq.PackProfile;
import org.apache.inlong.dataproxy.utils.BufferQueue;
import org.apache.inlong.sdk.commons.protocol.ProxyEvent;
import org.apache.inlong.sdk.commons.protocol.ProxyPackEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageQueueZoneSink
extends AbstractSink
implements Configurable,
ConfigUpdateCallback {
    private static final Logger logger = LoggerFactory.getLogger(MessageQueueZoneSink.class);
    private static final LogCounter logCounter = new LogCounter(10, 100000, 30000);
    private final long MQ_CLUSTER_STATUS_CHECK_DUR_MS = 2000L;
    private String cachedSinkName;
    private Channel cachedMsgChannel;
    private Context parentContext;
    private MessageQueueZoneSinkContext context;
    private final List<MessageQueueZoneWorker> workers = new ArrayList<MessageQueueZoneWorker>();
    private BatchPackManager dispatchManager;
    private final BufferQueue<PackProfile> dispatchQueue = new BufferQueue(CommonConfigHolder.getInstance().getMaxBufferQueueSizeKb());
    private ScheduledExecutorService scheduledPool;
    private MessageQueueZoneProducer zoneProducer;
    private final ReentrantLock reentrantLock = new ReentrantLock();
    private final Condition condition = this.reentrantLock.newCondition();
    private final AtomicLong lastNotifyTime = new AtomicLong(0L);
    private Thread configListener;
    private volatile boolean isShutdown = false;
    private volatile boolean mqClusterStarted = false;

    public void configure(Context context) {
        this.cachedSinkName = this.getName();
        logger.info("{} start to configure, context:{}.", (Object)this.cachedSinkName, (Object)context.toString());
        this.parentContext = context;
    }

    public void start() {
        if (this.getChannel() == null) {
            logger.error("{}'s channel is null", (Object)this.cachedSinkName);
        }
        this.cachedMsgChannel = this.getChannel();
        try {
            ConfigManager.getInstance().regMetaConfigChgCallback(this);
            this.context = new MessageQueueZoneSinkContext(this, this.parentContext, this.cachedMsgChannel);
            this.context.start();
            this.dispatchManager = new BatchPackManager(this, this.parentContext);
            this.scheduledPool = Executors.newScheduledThreadPool(2);
            this.scheduledPool.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    MessageQueueZoneSink.this.dispatchManager.setNeedOutputOvertimeData();
                    MessageQueueZoneSink.this.zoneProducer.clearExpiredProducers();
                }
            }, this.dispatchManager.getDispatchTimeout(), this.dispatchManager.getDispatchTimeout(), TimeUnit.MILLISECONDS);
            this.zoneProducer = new MessageQueueZoneProducer(this, this.context);
            this.zoneProducer.start();
            this.configListener = new Thread(new ConfigChangeProcessor());
            this.configListener.setName(this.cachedSinkName + "-configure-listener");
            this.configListener.start();
            for (int i = 0; i < this.context.getMaxThreads(); ++i) {
                MessageQueueZoneWorker zoneWorker = new MessageQueueZoneWorker(this, i, this.context.getProcessInterval(), this.zoneProducer);
                zoneWorker.start();
                this.workers.add(zoneWorker);
            }
        }
        catch (Exception e) {
            logger.error("{} start failure", (Object)this.cachedSinkName, (Object)e);
        }
        super.start();
    }

    public void stop() {
        this.isShutdown = true;
        if (this.configListener != null) {
            try {
                this.configListener.interrupt();
                this.configListener.join();
                this.configListener = null;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        for (MessageQueueZoneWorker worker : this.workers) {
            try {
                worker.close();
            }
            catch (Throwable e) {
                logger.error("{} stop Zone worker failure", (Object)this.cachedSinkName, (Object)e);
            }
        }
        this.context.close();
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sink.Status process() throws EventDeliveryException {
        while (!this.mqClusterStarted) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e1) {
                return Sink.Status.BACKOFF;
            }
            catch (Throwable e1) {
            }
        }
        this.dispatchManager.outputOvertimeData();
        tx.begin();
        try (Transaction tx = this.cachedMsgChannel.getTransaction();){
            SimpleEvent simpleEvent;
            Event event = this.cachedMsgChannel.take();
            if (event == null) {
                tx.commit();
                Sink.Status status = Sink.Status.BACKOFF;
                return status;
            }
            this.context.fileMetricIncSumStats("sink.event.take.success");
            if (event instanceof ProxyEvent) {
                ProxyEvent proxyEvent = (ProxyEvent)event;
                this.dispatchManager.addEvent(proxyEvent);
                tx.commit();
                Sink.Status status = Sink.Status.READY;
                return status;
            }
            if (event instanceof ProxyPackEvent) {
                ProxyPackEvent packEvent = (ProxyPackEvent)event;
                this.dispatchManager.addPackEvent(packEvent);
                tx.commit();
                Sink.Status status = Sink.Status.READY;
                return status;
            }
            if (event instanceof SimpleEvent) {
                SimpleEvent simpleEvent2 = (SimpleEvent)event;
                this.dispatchManager.addSimpleEvent(simpleEvent2);
                tx.commit();
                Sink.Status status = Sink.Status.READY;
                return status;
            }
            if (StringUtils.isEmpty((CharSequence)((CharSequence)event.getHeaders().get("msgEnType")))) {
                String groupId = (String)event.getHeaders().get("inlongGroupId");
                String streamId = (String)event.getHeaders().get("inlongStreamId");
                String msgTimeStr = (String)event.getHeaders().get("msgTime");
                String sourceIp = (String)event.getHeaders().get("sourceIp");
                String sourceTimeStr = (String)event.getHeaders().get("sourceTime");
                if (groupId != null && streamId != null && msgTimeStr != null && sourceIp != null && sourceTimeStr != null) {
                    ProxyEvent proxyEvent = new ProxyEvent(groupId, streamId, msgTimeStr, sourceIp, sourceTimeStr, event.getHeaders(), event.getBody());
                    this.dispatchManager.addEvent(proxyEvent);
                    this.context.fileMetricIncSumStats("sink.file.v1.take.success");
                } else {
                    this.context.fileMetricIncSumStats("sink.event.v1.malformed");
                }
            } else {
                simpleEvent = new SimpleEvent();
                simpleEvent.setBody(event.getBody());
                simpleEvent.setHeaders(event.getHeaders());
                this.dispatchManager.addSimpleEvent(simpleEvent);
                this.context.fileMetricIncSumStats("sink.file.v0.take.success");
            }
            tx.commit();
            simpleEvent = Sink.Status.READY;
            return simpleEvent;
        }
    }

    public String getCachedSinkName() {
        return this.cachedSinkName;
    }

    public boolean isMqClusterStarted() {
        return this.mqClusterStarted;
    }

    public void setMQClusterStarted() {
        this.mqClusterStarted = true;
    }

    public void acquireAndOfferDispatchedRecord(PackProfile record) {
        this.dispatchQueue.acquire(record.getSize());
        this.dispatchQueue.offer(record);
    }

    public void offerDispatchRecord(PackProfile record) {
        this.dispatchQueue.offer(record);
    }

    public PackProfile pollDispatchedRecord() {
        return this.dispatchQueue.pollRecord();
    }

    public PackProfile takeDispatchedRecord() {
        return this.dispatchQueue.takeRecord();
    }

    public void releaseAcquiredSizePermit(PackProfile record) {
        this.dispatchQueue.release(record.getSize());
    }

    public int getDispatchQueueSize() {
        return this.dispatchQueue.size();
    }

    public int getDispatchAvailablePermits() {
        return this.dispatchQueue.availablePermits();
    }

    @Override
    public void update() {
        if (this.zoneProducer == null) {
            return;
        }
        this.reentrantLock.lock();
        try {
            this.lastNotifyTime.set(System.currentTimeMillis());
            this.condition.signal();
        }
        finally {
            this.reentrantLock.unlock();
        }
    }

    private class ConfigChangeProcessor
    implements Runnable {
        private ConfigChangeProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            logger.info("{} config-change processor start!", (Object)MessageQueueZoneSink.this.cachedSinkName);
            while (!MessageQueueZoneSink.this.isShutdown) {
                long lastCheckTime;
                MessageQueueZoneSink.this.reentrantLock.lock();
                try {
                    MessageQueueZoneSink.this.condition.await();
                }
                catch (InterruptedException e1) {
                    logger.info("{} config-change processor meet interrupt, break!", (Object)MessageQueueZoneSink.this.cachedSinkName);
                    break;
                }
                finally {
                    MessageQueueZoneSink.this.reentrantLock.unlock();
                }
                if (MessageQueueZoneSink.this.zoneProducer == null) continue;
                do {
                    lastCheckTime = MessageQueueZoneSink.this.lastNotifyTime.get();
                    MessageQueueZoneSink.this.zoneProducer.reloadMetaConfig();
                } while (lastCheckTime != MessageQueueZoneSink.this.lastNotifyTime.get());
            }
            logger.info("{} config-change processor exit!", (Object)MessageQueueZoneSink.this.cachedSinkName);
        }
    }
}

