/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.config.holder;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.dataproxy.config.holder.SourceReportInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceReportConfigHolder {
    public static final Logger LOG = LoggerFactory.getLogger(SourceReportConfigHolder.class);
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Map<String, SourceReportInfo> sourceConfMap = new HashMap<String, SourceReportInfo>();
    private String ipSet = "";
    private String portSet = "";
    private String protocolTypeSet = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSourceInfo(String sourceIp, String sourcePort, String protocolType) {
        if (StringUtils.isEmpty((CharSequence)sourceIp) || StringUtils.isEmpty((CharSequence)sourcePort) || StringUtils.isEmpty((CharSequence)protocolType)) {
            LOG.warn("[Source Report Holder] found empty parameter!, add values is {}, {}, {}", new Object[]{sourceIp, sourcePort, protocolType});
            return;
        }
        String recordKey = sourceIp + "#" + sourcePort + "#" + protocolType;
        SourceReportInfo sourceReportInfo = new SourceReportInfo(sourceIp, sourcePort, protocolType);
        try {
            this.readWriteLock.writeLock().lock();
            if (this.sourceConfMap.putIfAbsent(recordKey, sourceReportInfo) == null) {
                if (this.ipSet.isEmpty()) {
                    this.ipSet = sourceIp;
                    this.portSet = sourcePort;
                    this.protocolTypeSet = protocolType;
                } else {
                    this.ipSet = this.ipSet + "," + sourceIp;
                    this.portSet = this.portSet + "," + sourcePort;
                    this.protocolTypeSet = this.protocolTypeSet + "," + protocolType;
                }
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public SourceReportInfo getSourceReportInfo() {
        try {
            this.readWriteLock.readLock().lock();
            SourceReportInfo sourceReportInfo = new SourceReportInfo(this.ipSet, this.portSet, this.protocolTypeSet);
            return sourceReportInfo;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }
}

