/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.transform.joiner;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.List;
import org.apache.inlong.manager.common.enums.TransformType;
import org.apache.inlong.manager.pojo.stream.StreamField;
import org.apache.inlong.manager.pojo.stream.StreamNode;
import org.apache.inlong.manager.pojo.transform.TransformDefinition;

public class IntervalJoinerDefinition
extends TransformDefinition {
    private StreamNode leftNode;
    private StreamNode rightNode;
    private List<StreamField> leftJoinFields;
    private List<StreamField> rightJoinFields;
    private String leftTimeColumn;
    private String rightTimeColumn;
    private String forwardInterval;
    private String backwardInterval;
    private TimeUnit forwardIntervalUnit;
    private TimeUnit backwardIntervalUnit;

    public IntervalJoinerDefinition(StreamNode leftNode, StreamNode rightNode, List<StreamField> leftJoinFields, List<StreamField> rightJoinFields, String leftTimeColumn, String rightTimeColumn, String forwardInterval, String backwardInterval, TimeUnit forwardIntervalUnit, TimeUnit backwardIntervalUnit) {
        this.transformType = TransformType.INTERVAL_JOINER;
        this.leftNode = leftNode;
        this.rightNode = rightNode;
        this.leftJoinFields = leftJoinFields;
        this.rightJoinFields = rightJoinFields;
        this.leftTimeColumn = leftTimeColumn;
        this.rightTimeColumn = rightTimeColumn;
        this.forwardInterval = forwardInterval;
        this.backwardInterval = backwardInterval;
        this.forwardIntervalUnit = forwardIntervalUnit;
        this.backwardIntervalUnit = backwardIntervalUnit;
    }

    public static IntervalJoinerDefinitionBuilder builder() {
        return new IntervalJoinerDefinitionBuilder();
    }

    public StreamNode getLeftNode() {
        return this.leftNode;
    }

    public StreamNode getRightNode() {
        return this.rightNode;
    }

    public List<StreamField> getLeftJoinFields() {
        return this.leftJoinFields;
    }

    public List<StreamField> getRightJoinFields() {
        return this.rightJoinFields;
    }

    public String getLeftTimeColumn() {
        return this.leftTimeColumn;
    }

    public String getRightTimeColumn() {
        return this.rightTimeColumn;
    }

    public String getForwardInterval() {
        return this.forwardInterval;
    }

    public String getBackwardInterval() {
        return this.backwardInterval;
    }

    public TimeUnit getForwardIntervalUnit() {
        return this.forwardIntervalUnit;
    }

    public TimeUnit getBackwardIntervalUnit() {
        return this.backwardIntervalUnit;
    }

    public void setLeftNode(StreamNode leftNode) {
        this.leftNode = leftNode;
    }

    public void setRightNode(StreamNode rightNode) {
        this.rightNode = rightNode;
    }

    public void setLeftJoinFields(List<StreamField> leftJoinFields) {
        this.leftJoinFields = leftJoinFields;
    }

    public void setRightJoinFields(List<StreamField> rightJoinFields) {
        this.rightJoinFields = rightJoinFields;
    }

    public void setLeftTimeColumn(String leftTimeColumn) {
        this.leftTimeColumn = leftTimeColumn;
    }

    public void setRightTimeColumn(String rightTimeColumn) {
        this.rightTimeColumn = rightTimeColumn;
    }

    public void setForwardInterval(String forwardInterval) {
        this.forwardInterval = forwardInterval;
    }

    public void setBackwardInterval(String backwardInterval) {
        this.backwardInterval = backwardInterval;
    }

    public void setForwardIntervalUnit(TimeUnit forwardIntervalUnit) {
        this.forwardIntervalUnit = forwardIntervalUnit;
    }

    public void setBackwardIntervalUnit(TimeUnit backwardIntervalUnit) {
        this.backwardIntervalUnit = backwardIntervalUnit;
    }

    @Override
    public String toString() {
        return "IntervalJoinerDefinition(leftNode=" + this.getLeftNode() + ", rightNode=" + this.getRightNode() + ", leftJoinFields=" + this.getLeftJoinFields() + ", rightJoinFields=" + this.getRightJoinFields() + ", leftTimeColumn=" + this.getLeftTimeColumn() + ", rightTimeColumn=" + this.getRightTimeColumn() + ", forwardInterval=" + this.getForwardInterval() + ", backwardInterval=" + this.getBackwardInterval() + ", forwardIntervalUnit=" + (Object)((Object)this.getForwardIntervalUnit()) + ", backwardIntervalUnit=" + (Object)((Object)this.getBackwardIntervalUnit()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IntervalJoinerDefinition)) {
            return false;
        }
        IntervalJoinerDefinition other = (IntervalJoinerDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StreamNode this$leftNode = this.getLeftNode();
        StreamNode other$leftNode = other.getLeftNode();
        if (this$leftNode == null ? other$leftNode != null : !((Object)this$leftNode).equals(other$leftNode)) {
            return false;
        }
        StreamNode this$rightNode = this.getRightNode();
        StreamNode other$rightNode = other.getRightNode();
        if (this$rightNode == null ? other$rightNode != null : !((Object)this$rightNode).equals(other$rightNode)) {
            return false;
        }
        List<StreamField> this$leftJoinFields = this.getLeftJoinFields();
        List<StreamField> other$leftJoinFields = other.getLeftJoinFields();
        if (this$leftJoinFields == null ? other$leftJoinFields != null : !((Object)this$leftJoinFields).equals(other$leftJoinFields)) {
            return false;
        }
        List<StreamField> this$rightJoinFields = this.getRightJoinFields();
        List<StreamField> other$rightJoinFields = other.getRightJoinFields();
        if (this$rightJoinFields == null ? other$rightJoinFields != null : !((Object)this$rightJoinFields).equals(other$rightJoinFields)) {
            return false;
        }
        String this$leftTimeColumn = this.getLeftTimeColumn();
        String other$leftTimeColumn = other.getLeftTimeColumn();
        if (this$leftTimeColumn == null ? other$leftTimeColumn != null : !this$leftTimeColumn.equals(other$leftTimeColumn)) {
            return false;
        }
        String this$rightTimeColumn = this.getRightTimeColumn();
        String other$rightTimeColumn = other.getRightTimeColumn();
        if (this$rightTimeColumn == null ? other$rightTimeColumn != null : !this$rightTimeColumn.equals(other$rightTimeColumn)) {
            return false;
        }
        String this$forwardInterval = this.getForwardInterval();
        String other$forwardInterval = other.getForwardInterval();
        if (this$forwardInterval == null ? other$forwardInterval != null : !this$forwardInterval.equals(other$forwardInterval)) {
            return false;
        }
        String this$backwardInterval = this.getBackwardInterval();
        String other$backwardInterval = other.getBackwardInterval();
        if (this$backwardInterval == null ? other$backwardInterval != null : !this$backwardInterval.equals(other$backwardInterval)) {
            return false;
        }
        TimeUnit this$forwardIntervalUnit = this.getForwardIntervalUnit();
        TimeUnit other$forwardIntervalUnit = other.getForwardIntervalUnit();
        if (this$forwardIntervalUnit == null ? other$forwardIntervalUnit != null : !((Object)((Object)this$forwardIntervalUnit)).equals((Object)other$forwardIntervalUnit)) {
            return false;
        }
        TimeUnit this$backwardIntervalUnit = this.getBackwardIntervalUnit();
        TimeUnit other$backwardIntervalUnit = other.getBackwardIntervalUnit();
        return !(this$backwardIntervalUnit == null ? other$backwardIntervalUnit != null : !((Object)((Object)this$backwardIntervalUnit)).equals((Object)other$backwardIntervalUnit));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof IntervalJoinerDefinition;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        StreamNode $leftNode = this.getLeftNode();
        result = result * 59 + ($leftNode == null ? 43 : ((Object)$leftNode).hashCode());
        StreamNode $rightNode = this.getRightNode();
        result = result * 59 + ($rightNode == null ? 43 : ((Object)$rightNode).hashCode());
        List<StreamField> $leftJoinFields = this.getLeftJoinFields();
        result = result * 59 + ($leftJoinFields == null ? 43 : ((Object)$leftJoinFields).hashCode());
        List<StreamField> $rightJoinFields = this.getRightJoinFields();
        result = result * 59 + ($rightJoinFields == null ? 43 : ((Object)$rightJoinFields).hashCode());
        String $leftTimeColumn = this.getLeftTimeColumn();
        result = result * 59 + ($leftTimeColumn == null ? 43 : $leftTimeColumn.hashCode());
        String $rightTimeColumn = this.getRightTimeColumn();
        result = result * 59 + ($rightTimeColumn == null ? 43 : $rightTimeColumn.hashCode());
        String $forwardInterval = this.getForwardInterval();
        result = result * 59 + ($forwardInterval == null ? 43 : $forwardInterval.hashCode());
        String $backwardInterval = this.getBackwardInterval();
        result = result * 59 + ($backwardInterval == null ? 43 : $backwardInterval.hashCode());
        TimeUnit $forwardIntervalUnit = this.getForwardIntervalUnit();
        result = result * 59 + ($forwardIntervalUnit == null ? 43 : ((Object)((Object)$forwardIntervalUnit)).hashCode());
        TimeUnit $backwardIntervalUnit = this.getBackwardIntervalUnit();
        result = result * 59 + ($backwardIntervalUnit == null ? 43 : ((Object)((Object)$backwardIntervalUnit)).hashCode());
        return result;
    }

    public static class IntervalJoinerDefinitionBuilder {
        private StreamNode leftNode;
        private StreamNode rightNode;
        private List<StreamField> leftJoinFields;
        private List<StreamField> rightJoinFields;
        private String leftTimeColumn;
        private String rightTimeColumn;
        private String forwardInterval;
        private String backwardInterval;
        private TimeUnit forwardIntervalUnit;
        private TimeUnit backwardIntervalUnit;

        IntervalJoinerDefinitionBuilder() {
        }

        public IntervalJoinerDefinitionBuilder leftNode(StreamNode leftNode) {
            this.leftNode = leftNode;
            return this;
        }

        public IntervalJoinerDefinitionBuilder rightNode(StreamNode rightNode) {
            this.rightNode = rightNode;
            return this;
        }

        public IntervalJoinerDefinitionBuilder leftJoinFields(List<StreamField> leftJoinFields) {
            this.leftJoinFields = leftJoinFields;
            return this;
        }

        public IntervalJoinerDefinitionBuilder rightJoinFields(List<StreamField> rightJoinFields) {
            this.rightJoinFields = rightJoinFields;
            return this;
        }

        public IntervalJoinerDefinitionBuilder leftTimeColumn(String leftTimeColumn) {
            this.leftTimeColumn = leftTimeColumn;
            return this;
        }

        public IntervalJoinerDefinitionBuilder rightTimeColumn(String rightTimeColumn) {
            this.rightTimeColumn = rightTimeColumn;
            return this;
        }

        public IntervalJoinerDefinitionBuilder forwardInterval(String forwardInterval) {
            this.forwardInterval = forwardInterval;
            return this;
        }

        public IntervalJoinerDefinitionBuilder backwardInterval(String backwardInterval) {
            this.backwardInterval = backwardInterval;
            return this;
        }

        public IntervalJoinerDefinitionBuilder forwardIntervalUnit(TimeUnit forwardIntervalUnit) {
            this.forwardIntervalUnit = forwardIntervalUnit;
            return this;
        }

        public IntervalJoinerDefinitionBuilder backwardIntervalUnit(TimeUnit backwardIntervalUnit) {
            this.backwardIntervalUnit = backwardIntervalUnit;
            return this;
        }

        public IntervalJoinerDefinition build() {
            return new IntervalJoinerDefinition(this.leftNode, this.rightNode, this.leftJoinFields, this.rightJoinFields, this.leftTimeColumn, this.rightTimeColumn, this.forwardInterval, this.backwardInterval, this.forwardIntervalUnit, this.backwardIntervalUnit);
        }

        public String toString() {
            return "IntervalJoinerDefinition.IntervalJoinerDefinitionBuilder(leftNode=" + this.leftNode + ", rightNode=" + this.rightNode + ", leftJoinFields=" + this.leftJoinFields + ", rightJoinFields=" + this.rightJoinFields + ", leftTimeColumn=" + this.leftTimeColumn + ", rightTimeColumn=" + this.rightTimeColumn + ", forwardInterval=" + this.forwardInterval + ", backwardInterval=" + this.backwardInterval + ", forwardIntervalUnit=" + (Object)((Object)this.forwardIntervalUnit) + ", backwardIntervalUnit=" + (Object)((Object)this.backwardIntervalUnit) + ")";
        }
    }

    @JsonFormat
    public static enum TimeUnit {
        SECOND,
        MINUTE,
        HOUR;

    }
}

