/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.source.tubemq;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.TreeSet;
import org.apache.inlong.common.enums.MessageWrapType;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonTypeDefine;
import org.apache.inlong.manager.pojo.source.SourceRequest;
import org.apache.inlong.manager.pojo.source.StreamSource;
import org.apache.inlong.manager.pojo.source.tubemq.TubeMQSourceRequest;

@ApiModel(value="TubeMQ source info")
@JsonTypeDefine(value="TUBEMQ")
public class TubeMQSource
extends StreamSource {
    @ApiModelProperty(value="Master RPC of the TubeMQ")
    private String masterRpc;
    @ApiModelProperty(value="Topic of the TubeMQ")
    private String topic;
    @ApiModelProperty(value="Group of the TubeMQ")
    private String consumeGroup;
    @ApiModelProperty(value="Session key of the TubeMQ")
    private String sessionKey;
    @ApiModelProperty(value="Data separator")
    private String dataSeparator;
    @ApiModelProperty(value="Tid of the TubeMQ")
    private TreeSet<String> streamId;
    @ApiModelProperty(value="The message body wrap  wrap type, including: RAW, INLONG_MSG_V0, INLONG_MSG_V1, etc")
    private String wrapType;

    public TubeMQSource() {
        this.setSourceType("TUBEMQ");
    }

    @Override
    public SourceRequest genSourceRequest() {
        return (SourceRequest)CommonBeanUtils.copyProperties((Object)this, TubeMQSourceRequest::new);
    }

    private static String $default$wrapType() {
        return MessageWrapType.INLONG_MSG_V0.getName();
    }

    protected TubeMQSource(TubeMQSourceBuilder<?, ?> b) {
        super((StreamSource.StreamSourceBuilder<?, ?>)b);
        this.masterRpc = ((TubeMQSourceBuilder)b).masterRpc;
        this.topic = ((TubeMQSourceBuilder)b).topic;
        this.consumeGroup = ((TubeMQSourceBuilder)b).consumeGroup;
        this.sessionKey = ((TubeMQSourceBuilder)b).sessionKey;
        this.dataSeparator = ((TubeMQSourceBuilder)b).dataSeparator;
        this.streamId = ((TubeMQSourceBuilder)b).streamId;
        this.wrapType = ((TubeMQSourceBuilder)b).wrapType$set ? ((TubeMQSourceBuilder)b).wrapType$value : TubeMQSource.$default$wrapType();
    }

    public static TubeMQSourceBuilder<?, ?> builder() {
        return new TubeMQSourceBuilderImpl();
    }

    public String getMasterRpc() {
        return this.masterRpc;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getConsumeGroup() {
        return this.consumeGroup;
    }

    public String getSessionKey() {
        return this.sessionKey;
    }

    public String getDataSeparator() {
        return this.dataSeparator;
    }

    public TreeSet<String> getStreamId() {
        return this.streamId;
    }

    public String getWrapType() {
        return this.wrapType;
    }

    public void setMasterRpc(String masterRpc) {
        this.masterRpc = masterRpc;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setConsumeGroup(String consumeGroup) {
        this.consumeGroup = consumeGroup;
    }

    public void setSessionKey(String sessionKey) {
        this.sessionKey = sessionKey;
    }

    public void setDataSeparator(String dataSeparator) {
        this.dataSeparator = dataSeparator;
    }

    public void setStreamId(TreeSet<String> streamId) {
        this.streamId = streamId;
    }

    public void setWrapType(String wrapType) {
        this.wrapType = wrapType;
    }

    public TubeMQSource(String masterRpc, String topic, String consumeGroup, String sessionKey, String dataSeparator, TreeSet<String> streamId, String wrapType) {
        this.masterRpc = masterRpc;
        this.topic = topic;
        this.consumeGroup = consumeGroup;
        this.sessionKey = sessionKey;
        this.dataSeparator = dataSeparator;
        this.streamId = streamId;
        this.wrapType = wrapType;
    }

    @Override
    public String toString() {
        return "TubeMQSource(super=" + super.toString() + ", masterRpc=" + this.getMasterRpc() + ", topic=" + this.getTopic() + ", consumeGroup=" + this.getConsumeGroup() + ", sessionKey=" + this.getSessionKey() + ", dataSeparator=" + this.getDataSeparator() + ", streamId=" + this.getStreamId() + ", wrapType=" + this.getWrapType() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TubeMQSource)) {
            return false;
        }
        TubeMQSource other = (TubeMQSource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$masterRpc = this.getMasterRpc();
        String other$masterRpc = other.getMasterRpc();
        if (this$masterRpc == null ? other$masterRpc != null : !this$masterRpc.equals(other$masterRpc)) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        String this$consumeGroup = this.getConsumeGroup();
        String other$consumeGroup = other.getConsumeGroup();
        if (this$consumeGroup == null ? other$consumeGroup != null : !this$consumeGroup.equals(other$consumeGroup)) {
            return false;
        }
        String this$sessionKey = this.getSessionKey();
        String other$sessionKey = other.getSessionKey();
        if (this$sessionKey == null ? other$sessionKey != null : !this$sessionKey.equals(other$sessionKey)) {
            return false;
        }
        String this$dataSeparator = this.getDataSeparator();
        String other$dataSeparator = other.getDataSeparator();
        if (this$dataSeparator == null ? other$dataSeparator != null : !this$dataSeparator.equals(other$dataSeparator)) {
            return false;
        }
        TreeSet<String> this$streamId = this.getStreamId();
        TreeSet<String> other$streamId = other.getStreamId();
        if (this$streamId == null ? other$streamId != null : !((Object)this$streamId).equals(other$streamId)) {
            return false;
        }
        String this$wrapType = this.getWrapType();
        String other$wrapType = other.getWrapType();
        return !(this$wrapType == null ? other$wrapType != null : !this$wrapType.equals(other$wrapType));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TubeMQSource;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $masterRpc = this.getMasterRpc();
        result = result * 59 + ($masterRpc == null ? 43 : $masterRpc.hashCode());
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        String $consumeGroup = this.getConsumeGroup();
        result = result * 59 + ($consumeGroup == null ? 43 : $consumeGroup.hashCode());
        String $sessionKey = this.getSessionKey();
        result = result * 59 + ($sessionKey == null ? 43 : $sessionKey.hashCode());
        String $dataSeparator = this.getDataSeparator();
        result = result * 59 + ($dataSeparator == null ? 43 : $dataSeparator.hashCode());
        TreeSet<String> $streamId = this.getStreamId();
        result = result * 59 + ($streamId == null ? 43 : ((Object)$streamId).hashCode());
        String $wrapType = this.getWrapType();
        result = result * 59 + ($wrapType == null ? 43 : $wrapType.hashCode());
        return result;
    }

    private static final class TubeMQSourceBuilderImpl
    extends TubeMQSourceBuilder<TubeMQSource, TubeMQSourceBuilderImpl> {
        private TubeMQSourceBuilderImpl() {
        }

        @Override
        protected TubeMQSourceBuilderImpl self() {
            return this;
        }

        @Override
        public TubeMQSource build() {
            return new TubeMQSource(this);
        }
    }

    public static abstract class TubeMQSourceBuilder<C extends TubeMQSource, B extends TubeMQSourceBuilder<C, B>>
    extends StreamSource.StreamSourceBuilder<C, B> {
        private String masterRpc;
        private String topic;
        private String consumeGroup;
        private String sessionKey;
        private String dataSeparator;
        private TreeSet<String> streamId;
        private boolean wrapType$set;
        private String wrapType$value;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B masterRpc(String masterRpc) {
            this.masterRpc = masterRpc;
            return (B)this.self();
        }

        public B topic(String topic) {
            this.topic = topic;
            return (B)this.self();
        }

        public B consumeGroup(String consumeGroup) {
            this.consumeGroup = consumeGroup;
            return (B)this.self();
        }

        public B sessionKey(String sessionKey) {
            this.sessionKey = sessionKey;
            return (B)this.self();
        }

        public B dataSeparator(String dataSeparator) {
            this.dataSeparator = dataSeparator;
            return (B)this.self();
        }

        public B streamId(TreeSet<String> streamId) {
            this.streamId = streamId;
            return (B)this.self();
        }

        public B wrapType(String wrapType) {
            this.wrapType$value = wrapType;
            this.wrapType$set = true;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "TubeMQSource.TubeMQSourceBuilder(super=" + super.toString() + ", masterRpc=" + this.masterRpc + ", topic=" + this.topic + ", consumeGroup=" + this.consumeGroup + ", sessionKey=" + this.sessionKey + ", dataSeparator=" + this.dataSeparator + ", streamId=" + this.streamId + ", wrapType$value=" + this.wrapType$value + ")";
        }
    }
}

