/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.source.iceberg;

import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.pojo.source.iceberg.IcebergSourceRequest;

public class IcebergSourceDTO {
    @ApiModelProperty(value="Iceberg data uri")
    private String uri;
    @ApiModelProperty(value="Iceberg data warehouse dir")
    private String warehouse;
    @ApiModelProperty(value="Database name")
    private String database;
    @ApiModelProperty(value="Table name")
    private String tableName;
    @ApiModelProperty(value="PrimaryKey")
    private String primaryKey;

    public static IcebergSourceDTO getFromRequest(IcebergSourceRequest request, String extParams) {
        IcebergSourceDTO dto = StringUtils.isNotBlank((CharSequence)extParams) ? IcebergSourceDTO.getFromJson(extParams) : new IcebergSourceDTO();
        return (IcebergSourceDTO)CommonBeanUtils.copyProperties((Object)request, (Object)dto, (boolean)true);
    }

    public static IcebergSourceDTO getFromJson(@NotNull String extParams) {
        try {
            return (IcebergSourceDTO)JsonUtils.parseObject((String)extParams, IcebergSourceDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_INCORRECT, String.format("parse extParams of IcebergSource failure: %s", e.getMessage()));
        }
    }

    public static IcebergSourceDTOBuilder builder() {
        return new IcebergSourceDTOBuilder();
    }

    public String getUri() {
        return this.uri;
    }

    public String getWarehouse() {
        return this.warehouse;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setWarehouse(String warehouse) {
        this.warehouse = warehouse;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IcebergSourceDTO)) {
            return false;
        }
        IcebergSourceDTO other = (IcebergSourceDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$uri = this.getUri();
        String other$uri = other.getUri();
        if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
            return false;
        }
        String this$warehouse = this.getWarehouse();
        String other$warehouse = other.getWarehouse();
        if (this$warehouse == null ? other$warehouse != null : !this$warehouse.equals(other$warehouse)) {
            return false;
        }
        String this$database = this.getDatabase();
        String other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        return !(this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IcebergSourceDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
        String $warehouse = this.getWarehouse();
        result = result * 59 + ($warehouse == null ? 43 : $warehouse.hashCode());
        String $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : $database.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        return result;
    }

    public String toString() {
        return "IcebergSourceDTO(uri=" + this.getUri() + ", warehouse=" + this.getWarehouse() + ", database=" + this.getDatabase() + ", tableName=" + this.getTableName() + ", primaryKey=" + this.getPrimaryKey() + ")";
    }

    public IcebergSourceDTO() {
    }

    public IcebergSourceDTO(String uri, String warehouse, String database, String tableName, String primaryKey) {
        this.uri = uri;
        this.warehouse = warehouse;
        this.database = database;
        this.tableName = tableName;
        this.primaryKey = primaryKey;
    }

    public static class IcebergSourceDTOBuilder {
        private String uri;
        private String warehouse;
        private String database;
        private String tableName;
        private String primaryKey;

        IcebergSourceDTOBuilder() {
        }

        public IcebergSourceDTOBuilder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public IcebergSourceDTOBuilder warehouse(String warehouse) {
            this.warehouse = warehouse;
            return this;
        }

        public IcebergSourceDTOBuilder database(String database) {
            this.database = database;
            return this;
        }

        public IcebergSourceDTOBuilder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public IcebergSourceDTOBuilder primaryKey(String primaryKey) {
            this.primaryKey = primaryKey;
            return this;
        }

        public IcebergSourceDTO build() {
            return new IcebergSourceDTO(this.uri, this.warehouse, this.database, this.tableName, this.primaryKey);
        }

        public String toString() {
            return "IcebergSourceDTO.IcebergSourceDTOBuilder(uri=" + this.uri + ", warehouse=" + this.warehouse + ", database=" + this.database + ", tableName=" + this.tableName + ", primaryKey=" + this.primaryKey + ")";
        }
    }
}

