/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sort.node.provider;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.fieldtype.strategy.FieldTypeMappingStrategy;
import org.apache.inlong.manager.common.fieldtype.strategy.OracleFieldTypeStrategy;
import org.apache.inlong.manager.pojo.sink.oracle.OracleSink;
import org.apache.inlong.manager.pojo.sort.node.base.ExtractNodeProvider;
import org.apache.inlong.manager.pojo.sort.node.base.LoadNodeProvider;
import org.apache.inlong.manager.pojo.source.oracle.OracleSource;
import org.apache.inlong.manager.pojo.stream.StreamField;
import org.apache.inlong.manager.pojo.stream.StreamNode;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.constant.OracleConstant;
import org.apache.inlong.sort.protocol.node.ExtractNode;
import org.apache.inlong.sort.protocol.node.LoadNode;
import org.apache.inlong.sort.protocol.node.extract.OracleExtractNode;
import org.apache.inlong.sort.protocol.node.load.OracleLoadNode;
import org.apache.inlong.sort.protocol.transformation.FieldRelation;

public class OracleProvider
implements ExtractNodeProvider,
LoadNodeProvider {
    private static final FieldTypeMappingStrategy FIELD_TYPE_MAPPING_STRATEGY = new OracleFieldTypeStrategy();

    @Override
    public Boolean accept(String streamType) {
        return "ORACLE".equals(streamType);
    }

    @Override
    public ExtractNode createExtractNode(StreamNode streamNodeInfo) {
        OracleSource source = (OracleSource)streamNodeInfo;
        List<FieldInfo> fieldInfos = this.parseStreamFieldInfos(source.getFieldList(), source.getSourceName(), FIELD_TYPE_MAPPING_STRATEGY);
        Map<String, String> properties = this.parseProperties(source.getProperties());
        OracleConstant.ScanStartUpMode scanStartupMode = StringUtils.isBlank((CharSequence)source.getScanStartupMode()) ? null : OracleConstant.ScanStartUpMode.forName((String)source.getScanStartupMode());
        return new OracleExtractNode(source.getSourceName(), source.getSourceName(), fieldInfos, null, properties, source.getPrimaryKey(), source.getHostname(), source.getUsername(), source.getPassword(), source.getDatabase(), source.getSchemaName(), source.getTableName(), source.getPort(), scanStartupMode);
    }

    @Override
    public LoadNode createLoadNode(StreamNode nodeInfo, Map<String, StreamField> constantFieldMap) {
        OracleSink oracleSink = (OracleSink)nodeInfo;
        Map<String, String> properties = this.parseProperties(oracleSink.getProperties());
        List<FieldInfo> fieldInfos = this.parseSinkFieldInfos(oracleSink.getSinkFieldList(), oracleSink.getSinkName(), FIELD_TYPE_MAPPING_STRATEGY);
        List<FieldRelation> fieldRelations = this.parseSinkFields(oracleSink.getSinkFieldList(), constantFieldMap);
        return new OracleLoadNode(oracleSink.getSinkName(), oracleSink.getSinkName(), fieldInfos, fieldRelations, null, null, null, properties, oracleSink.getJdbcUrl(), oracleSink.getUsername(), oracleSink.getPassword(), oracleSink.getTableName(), oracleSink.getPrimaryKey());
    }
}

