/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.node;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.apache.inlong.manager.common.validation.SaveValidation;
import org.apache.inlong.manager.common.validation.UpdateByIdValidation;
import org.apache.inlong.manager.common.validation.UpdateByKeyValidation;
import org.hibernate.validator.constraints.Length;

@ApiModel(value="Data node request")
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, visible=true, property="type")
public abstract class DataNodeRequest {
    @ApiModelProperty(value="Primary key")
    @NotNull(groups={UpdateByIdValidation.class}, message="id cannot be null")
    private @NotNull(groups={UpdateByIdValidation.class}, message="id cannot be null") Integer id;
    @ApiModelProperty(value="Data node name")
    @Pattern(regexp="^[A-Za-z0-9_-]{1,128}$", message="only supports letters, numbers, '-', or '_'")
    private @Pattern(regexp="^[A-Za-z0-9_-]{1,128}$", message="only supports letters, numbers, '-', or '_'") String name;
    @ApiModelProperty(value="Data node display name, just for display")
    @Length(min=1, max=128, message="length must be between 1 and 128")
    private @Length(min=1, max=128, message="length must be between 1 and 128") String displayName;
    @ApiModelProperty(value="Data node type, including MYSQL, HIVE, KAFKA, ES, etc.")
    @NotBlank(message="node type cannot be blank")
    @Length(max=20, message="length must be less than or equal to 20")
    private @NotBlank(message="node type cannot be blank") @Length(max=20, message="length must be less than or equal to 20") String type;
    @ApiModelProperty(value="Data node URL")
    @Length(max=512, message="length must be less than or equal to 512")
    @Pattern(regexp="^((?!\\s).)*$", message="not supports blank in url")
    private @Length(max=512, message="length must be less than or equal to 512") @Pattern(regexp="^((?!\\s).)*$", message="not supports blank in url") String url;
    @ApiModelProperty(value="Data node username")
    @Length(max=128, message="length must be less than or equal to 128")
    private @Length(max=128, message="length must be less than or equal to 128") String username;
    @ApiModelProperty(value="Data node token if needed")
    @Length(max=512, message="length must be less than or equal to 512")
    private @Length(max=512, message="length must be less than or equal to 512") String token;
    @ApiModelProperty(value="Extended params")
    @Length(min=1, max=16384, message="length must be between 1 and 16384")
    private @Length(min=1, max=16384, message="length must be between 1 and 16384") String extParams;
    @ApiModelProperty(value="Description of the data node")
    @Length(max=256, message="length must be less than or equal to 256")
    private @Length(max=256, message="length must be less than or equal to 256") String description;
    @ApiModelProperty(value="Inlong tenant to which the data node belongs", hidden=true)
    private String tenant;
    @ApiModelProperty(value="Name of responsible person, separated by commas")
    @NotBlank(groups={SaveValidation.class}, message="inCharges cannot be blank")
    @Length(max=512, message="length must be less than or equal to 512")
    private @NotBlank(groups={SaveValidation.class}, message="inCharges cannot be blank") @Length(max=512, message="length must be less than or equal to 512") String inCharges;
    @ApiModelProperty(value="Version number")
    @NotNull(groups={UpdateByIdValidation.class, UpdateByKeyValidation.class}, message="version cannot be null")
    private @NotNull(groups={UpdateByIdValidation.class, UpdateByKeyValidation.class}, message="version cannot be null") Integer version;

    public Integer getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getType() {
        return this.type;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getToken() {
        return this.token;
    }

    public String getExtParams() {
        return this.extParams;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTenant() {
        return this.tenant;
    }

    public String getInCharges() {
        return this.inCharges;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setExtParams(String extParams) {
        this.extParams = extParams;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public void setInCharges(String inCharges) {
        this.inCharges = inCharges;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataNodeRequest)) {
            return false;
        }
        DataNodeRequest other = (DataNodeRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$version = this.getVersion();
        Integer other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        String this$extParams = this.getExtParams();
        String other$extParams = other.getExtParams();
        if (this$extParams == null ? other$extParams != null : !this$extParams.equals(other$extParams)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$tenant = this.getTenant();
        String other$tenant = other.getTenant();
        if (this$tenant == null ? other$tenant != null : !this$tenant.equals(other$tenant)) {
            return false;
        }
        String this$inCharges = this.getInCharges();
        String other$inCharges = other.getInCharges();
        return !(this$inCharges == null ? other$inCharges != null : !this$inCharges.equals(other$inCharges));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataNodeRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        String $extParams = this.getExtParams();
        result = result * 59 + ($extParams == null ? 43 : $extParams.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $tenant = this.getTenant();
        result = result * 59 + ($tenant == null ? 43 : $tenant.hashCode());
        String $inCharges = this.getInCharges();
        result = result * 59 + ($inCharges == null ? 43 : $inCharges.hashCode());
        return result;
    }

    public String toString() {
        return "DataNodeRequest(id=" + this.getId() + ", name=" + this.getName() + ", displayName=" + this.getDisplayName() + ", type=" + this.getType() + ", url=" + this.getUrl() + ", username=" + this.getUsername() + ", token=" + this.getToken() + ", extParams=" + this.getExtParams() + ", description=" + this.getDescription() + ", tenant=" + this.getTenant() + ", inCharges=" + this.getInCharges() + ", version=" + this.getVersion() + ")";
    }

    public DataNodeRequest() {
    }

    public DataNodeRequest(Integer id, String name, String displayName, String type, String url, String username, String token, String extParams, String description, String tenant, String inCharges, Integer version) {
        this.id = id;
        this.name = name;
        this.displayName = displayName;
        this.type = type;
        this.url = url;
        this.username = username;
        this.token = token;
        this.extParams = extParams;
        this.description = description;
        this.tenant = tenant;
        this.inCharges = inCharges;
        this.version = version;
    }
}

