// Code generated by protoc-gen-go. DO NOT EDIT.
// source: incubator-yunikorn-scheduler-interface/si.proto

package si

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	descriptor "github.com/golang/protobuf/protoc-gen-go/descriptor"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type TerminationType int32

const (
	TerminationType_STOPPED_BY_RM          TerminationType = 0
	TerminationType_TIMEOUT                TerminationType = 1
	TerminationType_PREEMPTED_BY_SCHEDULER TerminationType = 2
	TerminationType_PLACEHOLDER_REPLACED   TerminationType = 3
)

var TerminationType_name = map[int32]string{
	0: "STOPPED_BY_RM",
	1: "TIMEOUT",
	2: "PREEMPTED_BY_SCHEDULER",
	3: "PLACEHOLDER_REPLACED",
}

var TerminationType_value = map[string]int32{
	"STOPPED_BY_RM":          0,
	"TIMEOUT":                1,
	"PREEMPTED_BY_SCHEDULER": 2,
	"PLACEHOLDER_REPLACED":   3,
}

func (x TerminationType) String() string {
	return proto.EnumName(TerminationType_name, int32(x))
}

func (TerminationType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_bcd2636ebca16c8c, []int{0}
}

// Scheduler can send action to RM.
type UpdateResponse_ActionFromScheduler int32

const (
	// Nothing needs to do
	UpdateResponse_NOACTION UpdateResponse_ActionFromScheduler = 0
	// Something is wrong, RM needs to stop the RM, and re-register with scheduler.
	UpdateResponse_RESYNC UpdateResponse_ActionFromScheduler = 1
)

var UpdateResponse_ActionFromScheduler_name = map[int32]string{
	0: "NOACTION",
	1: "RESYNC",
}

var UpdateResponse_ActionFromScheduler_value = map[string]int32{
	"NOACTION": 0,
	"RESYNC":   1,
}

func (x UpdateResponse_ActionFromScheduler) String() string {
	return proto.EnumName(UpdateResponse_ActionFromScheduler_name, int32(x))
}

func (UpdateResponse_ActionFromScheduler) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_bcd2636ebca16c8c, []int{3, 0}
}

// Action from RM
type UpdateNodeInfo_ActionFromRM int32

const (
	// Update node resources, attributes.
	UpdateNodeInfo_UPDATE UpdateNodeInfo_ActionFromRM = 0
	// Do not allocate new allocations on the node.
	UpdateNodeInfo_DRAIN_NODE UpdateNodeInfo_ActionFromRM = 1
	// Decomission node, it will immediately stop allocations on the node and
	// remove the node from schedulable lists.
	UpdateNodeInfo_DECOMISSION UpdateNodeInfo_ActionFromRM = 2
	// From Draining state to SCHEDULABLE state.
	// If node is not in draining state, error will be thrown
	UpdateNodeInfo_DRAIN_TO_SCHEDULABLE UpdateNodeInfo_ActionFromRM = 3
)

var UpdateNodeInfo_ActionFromRM_name = map[int32]string{
	0: "UPDATE",
	1: "DRAIN_NODE",
	2: "DECOMISSION",
	3: "DRAIN_TO_SCHEDULABLE",
}

var UpdateNodeInfo_ActionFromRM_value = map[string]int32{
	"UPDATE":               0,
	"DRAIN_NODE":           1,
	"DECOMISSION":          2,
	"DRAIN_TO_SCHEDULABLE": 3,
}

func (x UpdateNodeInfo_ActionFromRM) String() string {
	return proto.EnumName(UpdateNodeInfo_ActionFromRM_name, int32(x))
}

func (UpdateNodeInfo_ActionFromRM) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_bcd2636ebca16c8c, []int{21, 0}
}

// container scheduling states
type UpdateContainerSchedulingStateRequest_SchedulingState int32

const (
	// the container is being skipped by the scheduler
	UpdateContainerSchedulingStateRequest_SKIPPED UpdateContainerSchedulingStateRequest_SchedulingState = 0
	// the container is scheduled and it has been assigned to a node
	UpdateContainerSchedulingStateRequest_SCHEDULED UpdateContainerSchedulingStateRequest_SchedulingState = 1
	// the container is reserved on some node, but not yet assigned
	UpdateContainerSchedulingStateRequest_RESERVED UpdateContainerSchedulingStateRequest_SchedulingState = 2
	// scheduler has visited all candidate nodes for this container
	// but non of them could satisfy this container's requirement
	UpdateContainerSchedulingStateRequest_FAILED UpdateContainerSchedulingStateRequest_SchedulingState = 3
)

var UpdateContainerSchedulingStateRequest_SchedulingState_name = map[int32]string{
	0: "SKIPPED",
	1: "SCHEDULED",
	2: "RESERVED",
	3: "FAILED",
}

var UpdateContainerSchedulingStateRequest_SchedulingState_value = map[string]int32{
	"SKIPPED":   0,
	"SCHEDULED": 1,
	"RESERVED":  2,
	"FAILED":    3,
}

func (x UpdateContainerSchedulingStateRequest_SchedulingState) String() string {
	return proto.EnumName(UpdateContainerSchedulingStateRequest_SchedulingState_name, int32(x))
}

func (UpdateContainerSchedulingStateRequest_SchedulingState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_bcd2636ebca16c8c, []int{27, 0}
}

type EventRecord_Type int32

const (
	EventRecord_REQUEST EventRecord_Type = 0
	EventRecord_APP     EventRecord_Type = 1
	EventRecord_NODE    EventRecord_Type = 2
	EventRecord_QUEUE   EventRecord_Type = 3
)

var EventRecord_Type_name = map[int32]string{
	0: "REQUEST",
	1: "APP",
	2: "NODE",
	3: "QUEUE",
}

var EventRecord_Type_value = map[string]int32{
	"REQUEST": 0,
	"APP":     1,
	"NODE":    2,
	"QUEUE":   3,
}

func (x EventRecord_Type) String() string {
	return proto.EnumName(EventRecord_Type_name, int32(x))
}

func (EventRecord_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_bcd2636ebca16c8c, []int{30, 0}
}

//
//service MetricsService {
//}
type RegisterResourceManagerRequest struct {
	// An ID which can uniquely identify a RM **cluster**. (For example, if a RM cluster has multiple manager instances for HA purpose, they should use the same information when do registration).
	// If RM register with the same ID, all previous scheduling state in memory will be cleaned up, and expect RM report full scheduling state after registration.
	RmID string `protobuf:"bytes,1,opt,name=rmID,proto3" json:"rmID,omitempty"`
	// Version of RM scheduler interface client.
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	// Policy group name:
	// This defines which policy to use. Policy should be statically configured. (Think about network security group concept of ec2).
	// Different RMs can refer to the same policyGroup if their static configuration is identical.
	PolicyGroup          string   `protobuf:"bytes,3,opt,name=policyGroup,proto3" json:"policyGroup,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RegisterResourceManagerRequest) Reset()         { *m = RegisterResourceManagerRequest{} }
func (m *RegisterResourceManagerRequest) String() string { return proto.CompactTextString(m) }
func (*RegisterResourceManagerRequest) ProtoMessage()    {}
func (*RegisterResourceManagerRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_bcd2636ebca16c8c, []int{0}
}

func (m *RegisterResourceManagerRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RegisterResourceManagerRequest.Unmarshal(m, b)
}
func (m *RegisterResourceManagerRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RegisterResourceManagerRequest.Marshal(b, m, deterministic)
}
func (m *RegisterResourceManagerRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RegisterResourceManagerRequest.Merge(m, src)
}
func (m *RegisterResourceManagerRequest) XXX_Size() int {
	return xxx_messageInfo_RegisterResourceManagerRequest.Size(m)
}
func (m *RegisterResourceManagerRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RegisterResourceManagerRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RegisterResourceManagerRequest proto.InternalMessageInfo

func (m *RegisterResourceManagerRequest) GetRmID() string {
	if m != nil {
		return m.RmID
	}
	return ""
}

func (m *RegisterResourceManagerRequest) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *RegisterResourceManagerRequest) GetPolicyGroup() string {
	if m != nil {
		return m.PolicyGroup
	}
	return ""
}

// Upon success, scheduler returns RegisterResourceManagerResponse to RM, otherwise RM receives exception.
type RegisterResourceManagerResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RegisterResourceManagerResponse) Reset()         { *m = RegisterResourceManagerResponse{} }
func (m *RegisterResourceManagerResponse) String() string { return proto.CompactTextString(m) }
func (*RegisterResourceManagerResponse) ProtoMessage()    {}
func (*RegisterResourceManagerResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_bcd2636ebca16c8c, []int{1}
}

func (m *RegisterResourceManagerResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RegisterResourceManagerResponse.Unmarshal(m, b)
}
func (m *RegisterResourceManagerResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RegisterResourceManagerResponse.Marshal(b, m, deterministic)
}
func (m *RegisterResourceManagerResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RegisterResourceManagerResponse.Merge(m, src)
}
func (m *RegisterResourceManagerResponse) XXX_Size() int {
	return xxx_messageInfo_RegisterResourceManagerResponse.Size(m)
}
func (m *RegisterResourceManagerResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RegisterResourceManagerResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RegisterResourceManagerResponse proto.InternalMessageInfo

type UpdateRequest struct {
	// New allocation requests or replace existing allocation request (if allocationID is same)
	Asks []*AllocationAsk `protobuf:"bytes,1,rep,name=asks,proto3" json:"asks,omitempty"`
	// Allocations can be released.
	Releases *AllocationReleasesRequest `protobuf:"bytes,2,opt,name=releases,proto3" json:"releases,omitempty"`
	// New node can be scheduled. If a node is notified to be "unscheduable", it needs to be part of this field as well.
	NewSchedulableNodes []*NewNodeInfo `protobuf:"bytes,3,rep,name=newSchedulableNodes,proto3" json:"newSchedulableNodes,omitempty"`
	// Update nodes for existing schedulable nodes.
	// May include:
	// - Node resource changes. (Like grows/shrinks node resource)
	// - Node attribute changes. (Including node-partition concept like YARN, and concept like "local images".
	//
	// Should not include:
	// - Allocation-related changes with the node.
	// - Realtime Utilizations.
	UpdatedNodes []*UpdateNodeInfo `protobuf:"bytes,4,rep,name=updatedNodes,proto3" json:"updatedNodes,omitempty"`
	// ID of RM, this will be used to identify which RM of the request comes from.
	RmID string `protobuf:"bytes,5,opt,name=rmID,proto3" json:"rmID,omitempty"`
	// RM should explicitly add application when allocation request also explictly belongs to application.
	// This is optional if allocation request doesn't belong to a application. (Independent allocation)
	NewApplications []*AddApplicationRequest `protobuf:"bytes,6,rep,name=newApplications,proto3" json:"newApplications,omitempty"`
	// RM can also remove applications, all allocation/allocation requests associated with the application will be removed
	RemoveApplications   []*RemoveApplicationRequest `protobuf:"bytes,7,rep,name=removeApplications,proto3" json:"removeApplications,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *UpdateRequest) Reset()         { *m = UpdateRequest{} }
func (m *UpdateRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateRequest) ProtoMessage()    {}
func (*UpdateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_bcd2636ebca16c8c, []int{2}
}

func (m *UpdateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateRequest.Unmarshal(m, b)
}
func (m *UpdateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateRequest.Marshal(b, m, deterministic)
}
func (m *UpdateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateRequest.Merge(m, src)
}
func (m *UpdateRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateRequest.Size(m)
}
func (m *UpdateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateRequest proto.InternalMessageInfo

func (m *UpdateRequest) GetAsks() []*AllocationAsk {
	if m != nil {
		return m.Asks
	}
	return nil
}

func (m *UpdateRequest) GetReleases() *AllocationReleasesRequest {
	if m != nil {
		return m.Releases
	}
	return nil
}

func (m *UpdateRequest) GetNewSchedulableNodes() []*NewNodeInfo {
	if m != nil {
		return m.NewSchedulableNodes
	}
	return nil
}

func (m *UpdateRequest) GetUpdatedNodes() []*UpdateNodeInfo {
	if m != nil {
		return m.UpdatedNodes
	}
	return nil
}

func (m *UpdateRequest) GetRmID() string {
	if m != nil {
		return m.RmID
	}
	return ""
}

func (m *UpdateRequest) GetNewApplications() []*AddApplicationRequest {
	if m != nil {
		return m.NewApplications
	}
	return nil
}

func (m *UpdateRequest) GetRemoveApplications() []*RemoveApplicationRequest {
	if m != nil {
		return m.RemoveApplications
	}
	return nil
}

type UpdateResponse struct {
	// What RM needs to do, scheduler can send control code to RM when something goes wrong.
	// Don't use/expand this field for other general purposed actions. (Like kill a remote container process).
	Action UpdateResponse_ActionFromScheduler `protobuf:"varint,1,opt,name=action,proto3,enum=si.v1.UpdateResponse_ActionFromScheduler" json:"action,omitempty"`
	// New allocations
	NewAllocations []*Allocation `protobuf:"bytes,2,rep,name=newAllocations,proto3" json:"newAllocations,omitempty"`
	// Released allocations, this could be either ack from scheduler when RM asks to terminate some allocations.
	// Or it could be decision made by scheduler (such as preemption or timeout).
	ReleasedAllocations []*AllocationRelease `protobuf:"bytes,3,rep,name=releasedAllocations,proto3" json:"releasedAllocations,omitempty"`
	// Released allocation asks(placeholder), when the placeholder allocation times out
	ReleasedAllocationAsks []*AllocationAskRelease `protobuf:"bytes,4,rep,name=releasedAllocationAsks,proto3" json:"releasedAllocationAsks,omitempty"`
	// Rejected allocation requests
	RejectedAllocations []*RejectedAllocationAsk `protobuf:"bytes,5,rep,name=rejectedAllocations,proto3" json:"rejectedAllocations,omitempty"`
	// Rejected Applications
	RejectedApplications []*RejectedApplication `protobuf:"bytes,6,rep,name=rejectedApplications,proto3" json:"rejectedApplications,omitempty"`
	// Accepted Applications
	AcceptedApplications []*AcceptedApplication `protobuf:"bytes,7,rep,name=acceptedApplications,proto3" json:"acceptedApplications,omitempty"`
	// Updated Applications
	UpdatedApplications []*UpdatedApplication `protobuf:"bytes,8,rep,name=updatedApplications,proto3" json:"updatedApplications,omitempty"`
	// Rejected Node Registrations
	RejectedNodes []*RejectedNode `protobuf:"bytes,9,rep,name=rejectedNodes,proto3" json:"rejectedNodes,omitempty"`
	// Accepted Node Registrations
	AcceptedNodes        []*AcceptedNode `protobuf:"bytes,10,rep,name=acceptedNodes,proto3" json:"acceptedNodes,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *UpdateResponse) Reset()         { *m = UpdateResponse{} }
func (m *UpdateResponse) String() string { return proto.CompactTextString(m) }
func (*UpdateResponse) ProtoMessage()    {}
func (*UpdateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_bcd2636ebca16c8c, []int{3}
}

func (m *UpdateResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateResponse.Unmarshal(m, b)
}
func (m *UpdateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateResponse.Marshal(b, m, deterministic)
}
func (m *UpdateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateResponse.Merge(m, src)
}
func (m *UpdateResponse) XXX_Size() int {
	return xxx_messageInfo_UpdateResponse.Size(m)
}
func (m *UpdateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateResponse proto.InternalMessageInfo

func (m *UpdateResponse) GetAction() UpdateResponse_ActionFromScheduler {
	if m != nil {
		return m.Action
	}
	return UpdateResponse_NOACTION
}

func (m *UpdateResponse) GetNewAllocations() []*Allocation {
	if m != nil {
		return m.NewAllocations
	}
	return nil
}

func (m *UpdateResponse) GetReleasedAllocations() []*AllocationRelease {
	if m != nil {
		return m.ReleasedAllocations
	}
	return nil
}

func (m *UpdateResponse) GetReleasedAllocationAsks() []*AllocationAskRelease {
	if m != nil {
		return m.ReleasedAllocationAsks
	}
	return nil
}

func (m *UpdateResponse) GetRejectedAllocations() []*RejectedAllocationAsk {
	if m != nil {
		return m.RejectedAllocations
	}
	return nil
}

func (m *UpdateResponse) GetRejectedApplications() []*RejectedApplication {
	if m != nil {
		return m.RejectedApplications
	}
	return nil
}

func (m *UpdateResponse) GetAcceptedApplications() []*AcceptedApplication {
	if m != nil {
		return m.AcceptedApplications
	}
	return nil
}

func (m *UpdateResponse) GetUpdatedApplications() []*UpdatedApplication {
	if m != nil {
		return m.UpdatedApplications
	}
	return nil
}

func (m *UpdateResponse) GetRejectedNodes() []*RejectedNode {
	if m != nil {
		return m.RejectedNodes
	}
	return nil
}

func (m *UpdateResponse) GetAcceptedNodes() []*AcceptedNode {
	if m != nil {
		return m.AcceptedNodes
	}
	return nil
}

type UpdatedApplication struct {
	// The application ID that was updated
	ApplicationID string `protobuf:"bytes,1,opt,name=applicationID,proto3" json:"applicationID,omitempty"`
	// State of the application
	State string `protobuf:"bytes,2,opt,name=state,proto3" json:"state,omitempty"`
	// Timestamp of the state transition
	StateTransitionTimestamp int64 `protobuf:"varint,3,opt,name=stateTransitionTimestamp,proto3" json:"stateTransitionTimestamp,omitempty"`
	// Detailed message
	Message              string   `protobuf:"bytes,4,opt,name=message,proto3" json:"message,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdatedApplication) Reset()         { *m = UpdatedApplication{} }
func (m *UpdatedApplication) String() string { return proto.CompactTextString(m) }
func (*UpdatedApplication) ProtoMessage()    {}
func (*UpdatedApplication) Descriptor() ([]byte, []int) {
	return fileDescriptor_bcd2636ebca16c8c, []int{4}
}

func (m *UpdatedApplication) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdatedApplication.Unmarshal(m, b)
}
func (m *UpdatedApplication) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdatedApplication.Marshal(b, m, deterministic)
}
func (m *UpdatedApplication) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdatedApplication.Merge(m, src)
}
func (m *UpdatedApplication) XXX_Size() int {
	return xxx_messageInfo_UpdatedApplication.Size(m)
}
func (m *UpdatedApplication) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdatedApplication.DiscardUnknown(m)
}

var xxx_messageInfo_UpdatedApplication proto.InternalMessageInfo

func (m *UpdatedApplication) GetApplicationID() string {
	if m != nil {
		return m.ApplicationID
	}
	return ""
}

func (m *UpdatedApplication) GetState() string {
	if m != nil {
		return m.State
	}
	return ""
}

func (m *UpdatedApplication) GetStateTransitionTimestamp() int64 {
	if m != nil {
		return m.StateTransitionTimestamp
	}
	return 0
}

func (m *UpdatedApplication) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

type RejectedApplication struct {
	// The application ID that was rejected
	ApplicationID string `protobuf:"bytes,1,opt,name=applicationID,proto3" json:"applicationID,omitempty"`
	// A human-readable reason message
	Reason               string   `protobuf:"bytes,2,opt,name=reason,proto3" json:"reason,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RejectedApplication) Reset()         { *m = RejectedApplication{} }
func (m *RejectedApplication) String() string { return proto.CompactTextString(m) }
func (*RejectedApplication) ProtoMessage()    {}
func (*RejectedApplication) Descriptor() ([]byte, []int) {
	return fileDescriptor_bcd2636ebca16c8c, []int{5}
}

func (m *RejectedApplication) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RejectedApplication.Unmarshal(m, b)
}
func (m *RejectedApplication) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RejectedApplication.Marshal(b, m, deterministic)
}
func (m *RejectedApplication) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RejectedApplication.Merge(m, src)
}
func (m *RejectedApplication) XXX_Size() int {
	return xxx_messageInfo_RejectedApplication.Size(m)
}
func (m *RejectedApplication) XXX_DiscardUnknown() {
	xxx_messageInfo_RejectedApplication.DiscardUnknown(m)
}

var xxx_messageInfo_RejectedApplication proto.InternalMessageInfo

func (m *RejectedApplication) GetApplicationID() string {
	if m != nil {
		return m.ApplicationID
	}
	return ""
}

func (m *RejectedApplication) GetReason() string {
	if m != nil {
		return m.Reason
	}
	return ""
}

type AcceptedApplication struct {
	// The application ID that was accepted
	ApplicationID        string   `protobuf:"bytes,1,opt,name=applicationID,proto3" json:"applicationID,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AcceptedApplication) Reset()         { *m = AcceptedApplication{} }
func (m *AcceptedApplication) String() string { return proto.CompactTextString(m) }
func (*AcceptedApplication) ProtoMessage()    {}
func (*AcceptedApplication) Descriptor() ([]byte, []int) {
	return fileDescriptor_bcd2636ebca16c8c, []int{6}
}

func (m *AcceptedApplication) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AcceptedApplication.Unmarshal(m, b)
}
func (m *AcceptedApplication) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AcceptedApplication.Marshal(b, m, deterministic)
}
func (m *AcceptedApplication) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AcceptedApplication.Merge(m, src)
}
func (m *AcceptedApplication) XXX_Size() int {
	return xxx_messageInfo_AcceptedApplication.Size(m)
}
func (m *AcceptedApplication) XXX_DiscardUnknown() {
	xxx_messageInfo_AcceptedApplication.DiscardUnknown(m)
}

var xxx_messageInfo_AcceptedApplication proto.InternalMessageInfo

func (m *AcceptedApplication) GetApplicationID() string {
	if m != nil {
		return m.ApplicationID
	}
	return ""
}

type RejectedNode struct {
	// The node ID that was rejected
	NodeID string `protobuf:"bytes,1,opt,name=nodeID,proto3" json:"nodeID,omitempty"`
	// A human-readable reason message
	Reason               string   `protobuf:"bytes,2,opt,name=reason,proto3" json:"reason,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RejectedNode) Reset()         { *m = RejectedNode{} }
func (m *RejectedNode) String() string { return proto.CompactTextString(m) }
func (*RejectedNode) ProtoMessage()    {}
func (*RejectedNode) Descriptor() ([]byte, []int) {
	return fileDescriptor_bcd2636ebca16c8c, []int{7}
}

func (m *RejectedNode) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RejectedNode.Unmarshal(m, b)
}
func (m *RejectedNode) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RejectedNode.Marshal(b, m, deterministic)
}
func (m *RejectedNode) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RejectedNode.Merge(m, src)
}
func (m *RejectedNode) XXX_Size() int {
	return xxx_messageInfo_RejectedNode.Size(m)
}
func (m *RejectedNode) XXX_DiscardUnknown() {
	xxx_messageInfo_RejectedNode.DiscardUnknown(m)
}

var xxx_messageInfo_RejectedNode proto.InternalMessageInfo

func (m *RejectedNode) GetNodeID() string {
	if m != nil {
		return m.NodeID
	}
	return ""
}

func (m *RejectedNode) GetReason() string {
	if m != nil {
		return m.Reason
	}
	return ""
}

type AcceptedNode struct {
	// The node ID that was accepted
	NodeID               string   `protobuf:"bytes,1,opt,name=nodeID,proto3" json:"nodeID,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AcceptedNode) Reset()         { *m = AcceptedNode{} }
func (m *AcceptedNode) String() string { return proto.CompactTextString(m) }
func (*AcceptedNode) ProtoMessage()    {}
func (*AcceptedNode) Descriptor() ([]byte, []int) {
	return fileDescriptor_bcd2636ebca16c8c, []int{8}
}

func (m *AcceptedNode) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AcceptedNode.Unmarshal(m, b)
}
func (m *AcceptedNode) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AcceptedNode.Marshal(b, m, deterministic)
}
func (m *AcceptedNode) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AcceptedNode.Merge(m, src)
}
func (m *AcceptedNode) XXX_Size() int {
	return xxx_messageInfo_AcceptedNode.Size(m)
}
func (m *AcceptedNode) XXX_DiscardUnknown() {
	xxx_messageInfo_AcceptedNode.DiscardUnknown(m)
}

var xxx_messageInfo_AcceptedNode proto.InternalMessageInfo

func (m *AcceptedNode) GetNodeID() string {
	if m != nil {
		return m.NodeID
	}
	return ""
}

type Priority struct {
	// Types that are valid to be assigned to Priority:
	//	*Priority_PriorityValue
	//	*Priority_PriorityClassName
	Priority             isPriority_Priority `protobuf_oneof:"priority"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *Priority) Reset()         { *m = Priority{} }
func (m *Priority) String() string { return proto.CompactTextString(m) }
func (*Priority) ProtoMessage()    {}
func (*Priority) Descriptor() ([]byte, []int) {
	return fileDescriptor_bcd2636ebca16c8c, []int{9}
}

func (m *Priority) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Priority.Unmarshal(m, b)
}
func (m *Priority) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Priority.Marshal(b, m, deterministic)
}
func (m *Priority) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Priority.Merge(m, src)
}
func (m *Priority) XXX_Size() int {
	return xxx_messageInfo_Priority.Size(m)
}
func (m *Priority) XXX_DiscardUnknown() {
	xxx_messageInfo_Priority.DiscardUnknown(m)
}

var xxx_messageInfo_Priority proto.InternalMessageInfo

type isPriority_Priority interface {
	isPriority_Priority()
}

type Priority_PriorityValue struct {
	PriorityValue int32 `protobuf:"varint,1,opt,name=priorityValue,proto3,oneof"`
}

type Priority_PriorityClassName struct {
	PriorityClassName string `protobuf:"bytes,2,opt,name=priorityClassName,proto3,oneof"`
}

func (*Priority_PriorityValue) isPriority_Priority() {}

func (*Priority_PriorityClassName) isPriority_Priority() {}

func (m *Priority) GetPriority() isPriority_Priority {
	if m != nil {
		return m.Priority
	}
	return nil
}

func (m *Priority) GetPriorityValue() int32 {
	if x, ok := m.GetPriority().(*Priority_PriorityValue); ok {
		return x.PriorityValue
	}
	return 0
}

func (m *Priority) GetPriorityClassName() string {
	if x, ok := m.GetPriority().(*Priority_PriorityClassName); ok {
		return x.PriorityClassName
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Priority) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Priority_PriorityValue)(nil),
		(*Priority_PriorityClassName)(nil),
	}
}

// A sparse map of resource to Quantity.
type Resource struct {
	Resources            map[string]*Quantity `protobuf:"bytes,1,rep,name=resources,proto3" json:"resources,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *Resource) Reset()         { *m = Resource{} }
func (m *Resource) String() string { return proto.CompactTextString(m) }
func (*Resource) ProtoMessage()    {}
func (*Resource) Descriptor() ([]byte, []int) {
	return fileDescriptor_bcd2636ebca16c8c, []int{10}
}

func (m *Resource) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Resource.Unmarshal(m, b)
}
func (m *Resource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Resource.Marshal(b, m, deterministic)
}
func (m *Resource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Resource.Merge(m, src)
}
func (m *Resource) XXX_Size() int {
	return xxx_messageInfo_Resource.Size(m)
}
func (m *Resource) XXX_DiscardUnknown() {
	xxx_messageInfo_Resource.DiscardUnknown(m)
}

var xxx_messageInfo_Resource proto.InternalMessageInfo

func (m *Resource) GetResources() map[string]*Quantity {
	if m != nil {
		return m.Resources
	}
	return nil
}

// Quantity includes a single int64 value
type Quantity struct {
	Value                int64    `protobuf:"varint,1,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Quantity) Reset()         { *m = Quantity{} }
func (m *Quantity) String() string { return proto.CompactTextString(m) }
func (*Quantity) ProtoMessage()    {}
func (*Quantity) Descriptor() ([]byte, []int) {
	return fileDescriptor_bcd2636ebca16c8c, []int{11}
}

func (m *Quantity) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Quantity.Unmarshal(m, b)
}
func (m *Quantity) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Quantity.Marshal(b, m, deterministic)
}
func (m *Quantity) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Quantity.Merge(m, src)
}
func (m *Quantity) XXX_Size() int {
	return xxx_messageInfo_Quantity.Size(m)
}
func (m *Quantity) XXX_DiscardUnknown() {
	xxx_messageInfo_Quantity.DiscardUnknown(m)
}

var xxx_messageInfo_Quantity proto.InternalMessageInfo

func (m *Quantity) GetValue() int64 {
	if m != nil {
		return m.Value
	}
	return 0
}

type AllocationAsk struct {
	// Allocation key is used by both of scheduler and RM to track allocations.
	// It doesn't have to be same as RM's internal allocation id (such as Pod name of K8s or ContainerID of YARN).
	// Allocations from the same AllocationAsk which are returned to the RM at the same time will have the same allocationKey.
	// The request is considered an update of the existing AllocationAsk if an ALlocationAsk with the same allocationKey
	// already exists.
	AllocationKey string `protobuf:"bytes,1,opt,name=allocationKey,proto3" json:"allocationKey,omitempty"`
	// The application ID this allocation ask belongs to
	ApplicationID string `protobuf:"bytes,2,opt,name=applicationID,proto3" json:"applicationID,omitempty"`
	// The partition the application belongs to
	PartitionName string `protobuf:"bytes,3,opt,name=partitionName,proto3" json:"partitionName,omitempty"`
	// The amount of resources per ask
	ResourceAsk *Resource `protobuf:"bytes,4,opt,name=resourceAsk,proto3" json:"resourceAsk,omitempty"`
	// Maximum number of allocations
	MaxAllocations int32 `protobuf:"varint,5,opt,name=maxAllocations,proto3" json:"maxAllocations,omitempty"`
	// Priority of ask
	Priority *Priority `protobuf:"bytes,6,opt,name=priority,proto3" json:"priority,omitempty"`
	// Execution timeout: How long this allocation will be terminated (by scheduler)
	// once allocated by scheduler, 0 or negative value means never expire.
	ExecutionTimeoutMilliSeconds int64 `protobuf:"varint,7,opt,name=executionTimeoutMilliSeconds,proto3" json:"executionTimeoutMilliSeconds,omitempty"`
	// A set of tags for this spscific AllocationAsk. Allocation level tags are used in placing this specific
	// ask on nodes in the cluster. These tags are used in the PlacementConstraints.
	// These tags are optional.
	Tags map[string]string `protobuf:"bytes,8,rep,name=tags,proto3" json:"tags,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The name of the TaskGroup this ask belongs to
	TaskGroupName string `protobuf:"bytes,9,opt,name=taskGroupName,proto3" json:"taskGroupName,omitempty"`
	// Is this a placeholder ask (true) or a real ask (false), defaults to false
	// ignored if the taskGroupName is not set
	Placeholder          bool     `protobuf:"varint,10,opt,name=placeholder,proto3" json:"placeholder,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AllocationAsk) Reset()         { *m = AllocationAsk{} }
func (m *AllocationAsk) String() string { return proto.CompactTextString(m) }
func (*AllocationAsk) ProtoMessage()    {}
func (*AllocationAsk) Descriptor() ([]byte, []int) {
	return fileDescriptor_bcd2636ebca16c8c, []int{12}
}

func (m *AllocationAsk) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AllocationAsk.Unmarshal(m, b)
}
func (m *AllocationAsk) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AllocationAsk.Marshal(b, m, deterministic)
}
func (m *AllocationAsk) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AllocationAsk.Merge(m, src)
}
func (m *AllocationAsk) XXX_Size() int {
	return xxx_messageInfo_AllocationAsk.Size(m)
}
func (m *AllocationAsk) XXX_DiscardUnknown() {
	xxx_messageInfo_AllocationAsk.DiscardUnknown(m)
}

var xxx_messageInfo_AllocationAsk proto.InternalMessageInfo

func (m *AllocationAsk) GetAllocationKey() string {
	if m != nil {
		return m.AllocationKey
	}
	return ""
}

func (m *AllocationAsk) GetApplicationID() string {
	if m != nil {
		return m.ApplicationID
	}
	return ""
}

func (m *AllocationAsk) GetPartitionName() string {
	if m != nil {
		return m.PartitionName
	}
	return ""
}

func (m *AllocationAsk) GetResourceAsk() *Resource {
	if m != nil {
		return m.ResourceAsk
	}
	return nil
}

func (m *AllocationAsk) GetMaxAllocations() int32 {
	if m != nil {
		return m.MaxAllocations
	}
	return 0
}

func (m *AllocationAsk) GetPriority() *Priority {
	if m != nil {
		return m.Priority
	}
	return nil
}

func (m *AllocationAsk) GetExecutionTimeoutMilliSeconds() int64 {
	if m != nil {
		return m.ExecutionTimeoutMilliSeconds
	}
	return 0
}

func (m *AllocationAsk) GetTags() map[string]string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *AllocationAsk) GetTaskGroupName() string {
	if m != nil {
		return m.TaskGroupName
	}
	return ""
}

func (m *AllocationAsk) GetPlaceholder() bool {
	if m != nil {
		return m.Placeholder
	}
	return false
}

type AddApplicationRequest struct {
	// The ID of the application, must be unique
	ApplicationID string `protobuf:"bytes,1,opt,name=applicationID,proto3" json:"applicationID,omitempty"`
	// The queue this application is requesting. The scheduler will place the application into a
	// queue according to policy, taking into account the requested queue as per the policy.
	QueueName string `protobuf:"bytes,2,opt,name=queueName,proto3" json:"queueName,omitempty"`
	// The partition the application belongs to
	PartitionName string `protobuf:"bytes,3,opt,name=partitionName,proto3" json:"partitionName,omitempty"`
	// The user group information of the application owner
	Ugi *UserGroupInformation `protobuf:"bytes,4,opt,name=ugi,proto3" json:"ugi,omitempty"`
	// A set of tags for the application. These tags provide application level generic inforamtion.
	// The tags are optional and are used in placing an appliction or scheduling.
	// Application tags are not considered when processing AllocationAsks.
	Tags map[string]string `protobuf:"bytes,5,rep,name=tags,proto3" json:"tags,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Execution timeout: How long this application can be in a running state
	// 0 or negative value means never expire.
	ExecutionTimeoutMilliSeconds int64 `protobuf:"varint,6,opt,name=executionTimeoutMilliSeconds,proto3" json:"executionTimeoutMilliSeconds,omitempty"`
	// The total amount of resources gang placeholders will request
	PlaceholderAsk *Resource `protobuf:"bytes,7,opt,name=placeholderAsk,proto3" json:"placeholderAsk,omitempty"`
	// Gang scheduling style can be hard (the application will fail after placeholder timeout)
	// or soft (after the timeout the application will be scheduled as a normal application)
	GangSchedulingStyle  string   `protobuf:"bytes,8,opt,name=gangSchedulingStyle,proto3" json:"gangSchedulingStyle,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AddApplicationRequest) Reset()         { *m = AddApplicationRequest{} }
func (m *AddApplicationRequest) String() string { return proto.CompactTextString(m) }
func (*AddApplicationRequest) ProtoMessage()    {}
func (*AddApplicationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_bcd2636ebca16c8c, []int{13}
}

func (m *AddApplicationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AddApplicationRequest.Unmarshal(m, b)
}
func (m *AddApplicationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AddApplicationRequest.Marshal(b, m, deterministic)
}
func (m *AddApplicationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddApplicationRequest.Merge(m, src)
}
func (m *AddApplicationRequest) XXX_Size() int {
	return xxx_messageInfo_AddApplicationRequest.Size(m)
}
func (m *AddApplicationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AddApplicationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AddApplicationRequest proto.InternalMessageInfo

func (m *AddApplicationRequest) GetApplicationID() string {
	if m != nil {
		return m.ApplicationID
	}
	return ""
}

func (m *AddApplicationRequest) GetQueueName() string {
	if m != nil {
		return m.QueueName
	}
	return ""
}

func (m *AddApplicationRequest) GetPartitionName() string {
	if m != nil {
		return m.PartitionName
	}
	return ""
}

func (m *AddApplicationRequest) GetUgi() *UserGroupInformation {
	if m != nil {
		return m.Ugi
	}
	return nil
}

func (m *AddApplicationRequest) GetTags() map[string]string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *AddApplicationRequest) GetExecutionTimeoutMilliSeconds() int64 {
	if m != nil {
		return m.ExecutionTimeoutMilliSeconds
	}
	return 0
}

func (m *AddApplicationRequest) GetPlaceholderAsk() *Resource {
	if m != nil {
		return m.PlaceholderAsk
	}
	return nil
}

func (m *AddApplicationRequest) GetGangSchedulingStyle() string {
	if m != nil {
		return m.GangSchedulingStyle
	}
	return ""
}

type RemoveApplicationRequest struct {
	// The ID of the application to remove
	ApplicationID string `protobuf:"bytes,1,opt,name=applicationID,proto3" json:"applicationID,omitempty"`
	// The partition the application belongs to
	PartitionName        string   `protobuf:"bytes,2,opt,name=partitionName,proto3" json:"partitionName,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RemoveApplicationRequest) Reset()         { *m = RemoveApplicationRequest{} }
func (m *RemoveApplicationRequest) String() string { return proto.CompactTextString(m) }
func (*RemoveApplicationRequest) ProtoMessage()    {}
func (*RemoveApplicationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_bcd2636ebca16c8c, []int{14}
}

func (m *RemoveApplicationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RemoveApplicationRequest.Unmarshal(m, b)
}
func (m *RemoveApplicationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RemoveApplicationRequest.Marshal(b, m, deterministic)
}
func (m *RemoveApplicationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RemoveApplicationRequest.Merge(m, src)
}
func (m *RemoveApplicationRequest) XXX_Size() int {
	return xxx_messageInfo_RemoveApplicationRequest.Size(m)
}
func (m *RemoveApplicationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RemoveApplicationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RemoveApplicationRequest proto.InternalMessageInfo

func (m *RemoveApplicationRequest) GetApplicationID() string {
	if m != nil {
		return m.ApplicationID
	}
	return ""
}

func (m *RemoveApplicationRequest) GetPartitionName() string {
	if m != nil {
		return m.PartitionName
	}
	return ""
}

type UserGroupInformation struct {
	// the user name
	User string `protobuf:"bytes,1,opt,name=user,proto3" json:"user,omitempty"`
	// the list of groups of the user, can be empty
	Groups               []string `protobuf:"bytes,2,rep,name=groups,proto3" json:"groups,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UserGroupInformation) Reset()         { *m = UserGroupInformation{} }
func (m *UserGroupInformation) String() string { return proto.CompactTextString(m) }
func (*UserGroupInformation) ProtoMessage()    {}
func (*UserGroupInformation) Descriptor() ([]byte, []int) {
	return fileDescriptor_bcd2636ebca16c8c, []int{15}
}

func (m *UserGroupInformation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UserGroupInformation.Unmarshal(m, b)
}
func (m *UserGroupInformation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UserGroupInformation.Marshal(b, m, deterministic)
}
func (m *UserGroupInformation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UserGroupInformation.Merge(m, src)
}
func (m *UserGroupInformation) XXX_Size() int {
	return xxx_messageInfo_UserGroupInformation.Size(m)
}
func (m *UserGroupInformation) XXX_DiscardUnknown() {
	xxx_messageInfo_UserGroupInformation.DiscardUnknown(m)
}

var xxx_messageInfo_UserGroupInformation proto.InternalMessageInfo

func (m *UserGroupInformation) GetUser() string {
	if m != nil {
		return m.User
	}
	return ""
}

func (m *UserGroupInformation) GetGroups() []string {
	if m != nil {
		return m.Groups
	}
	return nil
}

type Allocation struct {
	// AllocationKey from AllocationAsk
	AllocationKey string `protobuf:"bytes,1,opt,name=allocationKey,proto3" json:"allocationKey,omitempty"`
	// Allocation tags from AllocationAsk
	AllocationTags map[string]string `protobuf:"bytes,2,rep,name=allocationTags,proto3" json:"allocationTags,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// UUID of the allocation
	UUID string `protobuf:"bytes,3,opt,name=UUID,proto3" json:"UUID,omitempty"`
	// Resource for each allocation
	ResourcePerAlloc *Resource `protobuf:"bytes,5,opt,name=resourcePerAlloc,proto3" json:"resourcePerAlloc,omitempty"`
	// Priority of ask
	Priority *Priority `protobuf:"bytes,6,opt,name=priority,proto3" json:"priority,omitempty"`
	// Queue which the allocation belongs to
	QueueName string `protobuf:"bytes,7,opt,name=queueName,proto3" json:"queueName,omitempty"`
	// Node which the allocation belongs to
	NodeID string `protobuf:"bytes,8,opt,name=nodeID,proto3" json:"nodeID,omitempty"`
	// The ID of the application
	ApplicationID string `protobuf:"bytes,9,opt,name=applicationID,proto3" json:"applicationID,omitempty"`
	// Partition of the allocation
	PartitionName string `protobuf:"bytes,10,opt,name=partitionName,proto3" json:"partitionName,omitempty"`
	// The name of the TaskGroup this allocation belongs to
	TaskGroupName string `protobuf:"bytes,11,opt,name=taskGroupName,proto3" json:"taskGroupName,omitempty"`
	// Is this a placeholder allocation (true) or a real allocation (false), defaults to false
	// ignored if the taskGroupName is not set
	Placeholder          bool     `protobuf:"varint,12,opt,name=placeholder,proto3" json:"placeholder,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Allocation) Reset()         { *m = Allocation{} }
func (m *Allocation) String() string { return proto.CompactTextString(m) }
func (*Allocation) ProtoMessage()    {}
func (*Allocation) Descriptor() ([]byte, []int) {
	return fileDescriptor_bcd2636ebca16c8c, []int{16}
}

func (m *Allocation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Allocation.Unmarshal(m, b)
}
func (m *Allocation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Allocation.Marshal(b, m, deterministic)
}
func (m *Allocation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Allocation.Merge(m, src)
}
func (m *Allocation) XXX_Size() int {
	return xxx_messageInfo_Allocation.Size(m)
}
func (m *Allocation) XXX_DiscardUnknown() {
	xxx_messageInfo_Allocation.DiscardUnknown(m)
}

var xxx_messageInfo_Allocation proto.InternalMessageInfo

func (m *Allocation) GetAllocationKey() string {
	if m != nil {
		return m.AllocationKey
	}
	return ""
}

func (m *Allocation) GetAllocationTags() map[string]string {
	if m != nil {
		return m.AllocationTags
	}
	return nil
}

func (m *Allocation) GetUUID() string {
	if m != nil {
		return m.UUID
	}
	return ""
}

func (m *Allocation) GetResourcePerAlloc() *Resource {
	if m != nil {
		return m.ResourcePerAlloc
	}
	return nil
}

func (m *Allocation) GetPriority() *Priority {
	if m != nil {
		return m.Priority
	}
	return nil
}

func (m *Allocation) GetQueueName() string {
	if m != nil {
		return m.QueueName
	}
	return ""
}

func (m *Allocation) GetNodeID() string {
	if m != nil {
		return m.NodeID
	}
	return ""
}

func (m *Allocation) GetApplicationID() string {
	if m != nil {
		return m.ApplicationID
	}
	return ""
}

func (m *Allocation) GetPartitionName() string {
	if m != nil {
		return m.PartitionName
	}
	return ""
}

func (m *Allocation) GetTaskGroupName() string {
	if m != nil {
		return m.TaskGroupName
	}
	return ""
}

func (m *Allocation) GetPlaceholder() bool {
	if m != nil {
		return m.Placeholder
	}
	return false
}

type AllocationReleasesRequest struct {
	// The allocations to release
	AllocationsToRelease []*AllocationRelease `protobuf:"bytes,1,rep,name=allocationsToRelease,proto3" json:"allocationsToRelease,omitempty"`
	// The asks to release
	AllocationAsksToRelease []*AllocationAskRelease `protobuf:"bytes,2,rep,name=allocationAsksToRelease,proto3" json:"allocationAsksToRelease,omitempty"`
	XXX_NoUnkeyedLiteral    struct{}                `json:"-"`
	XXX_unrecognized        []byte                  `json:"-"`
	XXX_sizecache           int32                   `json:"-"`
}

func (m *AllocationReleasesRequest) Reset()         { *m = AllocationReleasesRequest{} }
func (m *AllocationReleasesRequest) String() string { return proto.CompactTextString(m) }
func (*AllocationReleasesRequest) ProtoMessage()    {}
func (*AllocationReleasesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_bcd2636ebca16c8c, []int{17}
}

func (m *AllocationReleasesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AllocationReleasesRequest.Unmarshal(m, b)
}
func (m *AllocationReleasesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AllocationReleasesRequest.Marshal(b, m, deterministic)
}
func (m *AllocationReleasesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AllocationReleasesRequest.Merge(m, src)
}
func (m *AllocationReleasesRequest) XXX_Size() int {
	return xxx_messageInfo_AllocationReleasesRequest.Size(m)
}
func (m *AllocationReleasesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AllocationReleasesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AllocationReleasesRequest proto.InternalMessageInfo

func (m *AllocationReleasesRequest) GetAllocationsToRelease() []*AllocationRelease {
	if m != nil {
		return m.AllocationsToRelease
	}
	return nil
}

func (m *AllocationReleasesRequest) GetAllocationAsksToRelease() []*AllocationAskRelease {
	if m != nil {
		return m.AllocationAsksToRelease
	}
	return nil
}

// Release allocation: this is a bidirectional message. The Terminationtype defines the origin, or creator,
// as per the comment. The confirmation or response from the receiver is the same message with the same
// termination type set.
type AllocationRelease struct {
	// The name of the partition the allocation belongs to
	PartitionName string `protobuf:"bytes,1,opt,name=partitionName,proto3" json:"partitionName,omitempty"`
	// The application the allocation belongs to
	ApplicationID string `protobuf:"bytes,2,opt,name=applicationID,proto3" json:"applicationID,omitempty"`
	// The UUID of the allocation to release, if not set all allocations are released for
	// the applicationID
	UUID string `protobuf:"bytes,3,opt,name=UUID,proto3" json:"UUID,omitempty"`
	// Termination type of the released allocation
	TerminationType TerminationType `protobuf:"varint,4,opt,name=terminationType,proto3,enum=si.v1.TerminationType" json:"terminationType,omitempty"`
	// human-readable message
	Message              string   `protobuf:"bytes,5,opt,name=message,proto3" json:"message,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AllocationRelease) Reset()         { *m = AllocationRelease{} }
func (m *AllocationRelease) String() string { return proto.CompactTextString(m) }
func (*AllocationRelease) ProtoMessage()    {}
func (*AllocationRelease) Descriptor() ([]byte, []int) {
	return fileDescriptor_bcd2636ebca16c8c, []int{18}
}

func (m *AllocationRelease) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AllocationRelease.Unmarshal(m, b)
}
func (m *AllocationRelease) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AllocationRelease.Marshal(b, m, deterministic)
}
func (m *AllocationRelease) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AllocationRelease.Merge(m, src)
}
func (m *AllocationRelease) XXX_Size() int {
	return xxx_messageInfo_AllocationRelease.Size(m)
}
func (m *AllocationRelease) XXX_DiscardUnknown() {
	xxx_messageInfo_AllocationRelease.DiscardUnknown(m)
}

var xxx_messageInfo_AllocationRelease proto.InternalMessageInfo

func (m *AllocationRelease) GetPartitionName() string {
	if m != nil {
		return m.PartitionName
	}
	return ""
}

func (m *AllocationRelease) GetApplicationID() string {
	if m != nil {
		return m.ApplicationID
	}
	return ""
}

func (m *AllocationRelease) GetUUID() string {
	if m != nil {
		return m.UUID
	}
	return ""
}

func (m *AllocationRelease) GetTerminationType() TerminationType {
	if m != nil {
		return m.TerminationType
	}
	return TerminationType_STOPPED_BY_RM
}

func (m *AllocationRelease) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

// Release ask
type AllocationAskRelease struct {
	// Which partition to release the ask from, required.
	PartitionName string `protobuf:"bytes,1,opt,name=partitionName,proto3" json:"partitionName,omitempty"`
	// optional, when this is set, filter allocation key by application id.
	// when application id is set and allocationKey is not set, release all allocations key under the application id.
	ApplicationID string `protobuf:"bytes,2,opt,name=applicationID,proto3" json:"applicationID,omitempty"`
	// optional, when this is set, only release allocation ask by specified
	Allocationkey string `protobuf:"bytes,3,opt,name=allocationkey,proto3" json:"allocationkey,omitempty"`
	// Termination type of the released allocation ask
	TerminationType TerminationType `protobuf:"varint,4,opt,name=terminationType,proto3,enum=si.v1.TerminationType" json:"terminationType,omitempty"`
	// For human-readable message
	Message              string   `protobuf:"bytes,5,opt,name=message,proto3" json:"message,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AllocationAskRelease) Reset()         { *m = AllocationAskRelease{} }
func (m *AllocationAskRelease) String() string { return proto.CompactTextString(m) }
func (*AllocationAskRelease) ProtoMessage()    {}
func (*AllocationAskRelease) Descriptor() ([]byte, []int) {
	return fileDescriptor_bcd2636ebca16c8c, []int{19}
}

func (m *AllocationAskRelease) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AllocationAskRelease.Unmarshal(m, b)
}
func (m *AllocationAskRelease) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AllocationAskRelease.Marshal(b, m, deterministic)
}
func (m *AllocationAskRelease) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AllocationAskRelease.Merge(m, src)
}
func (m *AllocationAskRelease) XXX_Size() int {
	return xxx_messageInfo_AllocationAskRelease.Size(m)
}
func (m *AllocationAskRelease) XXX_DiscardUnknown() {
	xxx_messageInfo_AllocationAskRelease.DiscardUnknown(m)
}

var xxx_messageInfo_AllocationAskRelease proto.InternalMessageInfo

func (m *AllocationAskRelease) GetPartitionName() string {
	if m != nil {
		return m.PartitionName
	}
	return ""
}

func (m *AllocationAskRelease) GetApplicationID() string {
	if m != nil {
		return m.ApplicationID
	}
	return ""
}

func (m *AllocationAskRelease) GetAllocationkey() string {
	if m != nil {
		return m.Allocationkey
	}
	return ""
}

func (m *AllocationAskRelease) GetTerminationType() TerminationType {
	if m != nil {
		return m.TerminationType
	}
	return TerminationType_STOPPED_BY_RM
}

func (m *AllocationAskRelease) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

type NewNodeInfo struct {
	// ID of node, must be unique
	NodeID string `protobuf:"bytes,1,opt,name=nodeID,proto3" json:"nodeID,omitempty"`
	// node attributes
	Attributes map[string]string `protobuf:"bytes,2,rep,name=attributes,proto3" json:"attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Schedulable Resource
	SchedulableResource *Resource `protobuf:"bytes,3,opt,name=schedulableResource,proto3" json:"schedulableResource,omitempty"`
	// Occupied Resource
	OccupiedResource *Resource `protobuf:"bytes,4,opt,name=occupiedResource,proto3" json:"occupiedResource,omitempty"`
	// Allocated resources, this will be added when node registered to RM (recovery)
	ExistingAllocations  []*Allocation `protobuf:"bytes,5,rep,name=existingAllocations,proto3" json:"existingAllocations,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *NewNodeInfo) Reset()         { *m = NewNodeInfo{} }
func (m *NewNodeInfo) String() string { return proto.CompactTextString(m) }
func (*NewNodeInfo) ProtoMessage()    {}
func (*NewNodeInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_bcd2636ebca16c8c, []int{20}
}

func (m *NewNodeInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NewNodeInfo.Unmarshal(m, b)
}
func (m *NewNodeInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NewNodeInfo.Marshal(b, m, deterministic)
}
func (m *NewNodeInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NewNodeInfo.Merge(m, src)
}
func (m *NewNodeInfo) XXX_Size() int {
	return xxx_messageInfo_NewNodeInfo.Size(m)
}
func (m *NewNodeInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_NewNodeInfo.DiscardUnknown(m)
}

var xxx_messageInfo_NewNodeInfo proto.InternalMessageInfo

func (m *NewNodeInfo) GetNodeID() string {
	if m != nil {
		return m.NodeID
	}
	return ""
}

func (m *NewNodeInfo) GetAttributes() map[string]string {
	if m != nil {
		return m.Attributes
	}
	return nil
}

func (m *NewNodeInfo) GetSchedulableResource() *Resource {
	if m != nil {
		return m.SchedulableResource
	}
	return nil
}

func (m *NewNodeInfo) GetOccupiedResource() *Resource {
	if m != nil {
		return m.OccupiedResource
	}
	return nil
}

func (m *NewNodeInfo) GetExistingAllocations() []*Allocation {
	if m != nil {
		return m.ExistingAllocations
	}
	return nil
}

type UpdateNodeInfo struct {
	// ID of node, the node must exist to be updated
	NodeID string `protobuf:"bytes,1,opt,name=nodeID,proto3" json:"nodeID,omitempty"`
	// New attributes of node, which will replace previously reported attribute.
	Attributes map[string]string `protobuf:"bytes,2,rep,name=attributes,proto3" json:"attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// new schedulable resource, scheduler may preempt allocations on the
	// node or schedule more allocations accordingly.
	SchedulableResource *Resource `protobuf:"bytes,3,opt,name=schedulableResource,proto3" json:"schedulableResource,omitempty"`
	// when the scheduler is co-exist with some other schedulers, some node
	// resources might be occupied (allocated) by other schedulers.
	OccupiedResource *Resource `protobuf:"bytes,4,opt,name=occupiedResource,proto3" json:"occupiedResource,omitempty"`
	// Action to perform by the scheduler
	Action               UpdateNodeInfo_ActionFromRM `protobuf:"varint,5,opt,name=action,proto3,enum=si.v1.UpdateNodeInfo_ActionFromRM" json:"action,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *UpdateNodeInfo) Reset()         { *m = UpdateNodeInfo{} }
func (m *UpdateNodeInfo) String() string { return proto.CompactTextString(m) }
func (*UpdateNodeInfo) ProtoMessage()    {}
func (*UpdateNodeInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_bcd2636ebca16c8c, []int{21}
}

func (m *UpdateNodeInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateNodeInfo.Unmarshal(m, b)
}
func (m *UpdateNodeInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateNodeInfo.Marshal(b, m, deterministic)
}
func (m *UpdateNodeInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateNodeInfo.Merge(m, src)
}
func (m *UpdateNodeInfo) XXX_Size() int {
	return xxx_messageInfo_UpdateNodeInfo.Size(m)
}
func (m *UpdateNodeInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateNodeInfo.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateNodeInfo proto.InternalMessageInfo

func (m *UpdateNodeInfo) GetNodeID() string {
	if m != nil {
		return m.NodeID
	}
	return ""
}

func (m *UpdateNodeInfo) GetAttributes() map[string]string {
	if m != nil {
		return m.Attributes
	}
	return nil
}

func (m *UpdateNodeInfo) GetSchedulableResource() *Resource {
	if m != nil {
		return m.SchedulableResource
	}
	return nil
}

func (m *UpdateNodeInfo) GetOccupiedResource() *Resource {
	if m != nil {
		return m.OccupiedResource
	}
	return nil
}

func (m *UpdateNodeInfo) GetAction() UpdateNodeInfo_ActionFromRM {
	if m != nil {
		return m.Action
	}
	return UpdateNodeInfo_UPDATE
}

type RejectedAllocationAsk struct {
	AllocationKey string `protobuf:"bytes,1,opt,name=allocationKey,proto3" json:"allocationKey,omitempty"`
	// The ID of the application
	ApplicationID string `protobuf:"bytes,2,opt,name=applicationID,proto3" json:"applicationID,omitempty"`
	// A human-readable reason message
	Reason               string   `protobuf:"bytes,3,opt,name=reason,proto3" json:"reason,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RejectedAllocationAsk) Reset()         { *m = RejectedAllocationAsk{} }
func (m *RejectedAllocationAsk) String() string { return proto.CompactTextString(m) }
func (*RejectedAllocationAsk) ProtoMessage()    {}
func (*RejectedAllocationAsk) Descriptor() ([]byte, []int) {
	return fileDescriptor_bcd2636ebca16c8c, []int{22}
}

func (m *RejectedAllocationAsk) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RejectedAllocationAsk.Unmarshal(m, b)
}
func (m *RejectedAllocationAsk) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RejectedAllocationAsk.Marshal(b, m, deterministic)
}
func (m *RejectedAllocationAsk) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RejectedAllocationAsk.Merge(m, src)
}
func (m *RejectedAllocationAsk) XXX_Size() int {
	return xxx_messageInfo_RejectedAllocationAsk.Size(m)
}
func (m *RejectedAllocationAsk) XXX_DiscardUnknown() {
	xxx_messageInfo_RejectedAllocationAsk.DiscardUnknown(m)
}

var xxx_messageInfo_RejectedAllocationAsk proto.InternalMessageInfo

func (m *RejectedAllocationAsk) GetAllocationKey() string {
	if m != nil {
		return m.AllocationKey
	}
	return ""
}

func (m *RejectedAllocationAsk) GetApplicationID() string {
	if m != nil {
		return m.ApplicationID
	}
	return ""
}

func (m *RejectedAllocationAsk) GetReason() string {
	if m != nil {
		return m.Reason
	}
	return ""
}

type PredicatesArgs struct {
	// allocation key identifies a container, the predicates function is going to check
	// if this container is eligible to be placed ont to a node.
	AllocationKey string `protobuf:"bytes,1,opt,name=allocationKey,proto3" json:"allocationKey,omitempty"`
	// the node ID the container is assigned to.
	NodeID string `protobuf:"bytes,2,opt,name=nodeID,proto3" json:"nodeID,omitempty"`
	// run the predicates for alloactions (true) or reservations (false)
	Allocate             bool     `protobuf:"varint,3,opt,name=allocate,proto3" json:"allocate,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PredicatesArgs) Reset()         { *m = PredicatesArgs{} }
func (m *PredicatesArgs) String() string { return proto.CompactTextString(m) }
func (*PredicatesArgs) ProtoMessage()    {}
func (*PredicatesArgs) Descriptor() ([]byte, []int) {
	return fileDescriptor_bcd2636ebca16c8c, []int{23}
}

func (m *PredicatesArgs) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PredicatesArgs.Unmarshal(m, b)
}
func (m *PredicatesArgs) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PredicatesArgs.Marshal(b, m, deterministic)
}
func (m *PredicatesArgs) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PredicatesArgs.Merge(m, src)
}
func (m *PredicatesArgs) XXX_Size() int {
	return xxx_messageInfo_PredicatesArgs.Size(m)
}
func (m *PredicatesArgs) XXX_DiscardUnknown() {
	xxx_messageInfo_PredicatesArgs.DiscardUnknown(m)
}

var xxx_messageInfo_PredicatesArgs proto.InternalMessageInfo

func (m *PredicatesArgs) GetAllocationKey() string {
	if m != nil {
		return m.AllocationKey
	}
	return ""
}

func (m *PredicatesArgs) GetNodeID() string {
	if m != nil {
		return m.NodeID
	}
	return ""
}

func (m *PredicatesArgs) GetAllocate() bool {
	if m != nil {
		return m.Allocate
	}
	return false
}

type ReSyncSchedulerCacheArgs struct {
	// a list of assumed allocations, this will be sync'd to scheduler cache.
	AssumedAllocations []*AssumedAllocation `protobuf:"bytes,1,rep,name=assumedAllocations,proto3" json:"assumedAllocations,omitempty"`
	// a list of allocations to forget
	ForgetAllocations    []*ForgotAllocation `protobuf:"bytes,2,rep,name=forgetAllocations,proto3" json:"forgetAllocations,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *ReSyncSchedulerCacheArgs) Reset()         { *m = ReSyncSchedulerCacheArgs{} }
func (m *ReSyncSchedulerCacheArgs) String() string { return proto.CompactTextString(m) }
func (*ReSyncSchedulerCacheArgs) ProtoMessage()    {}
func (*ReSyncSchedulerCacheArgs) Descriptor() ([]byte, []int) {
	return fileDescriptor_bcd2636ebca16c8c, []int{24}
}

func (m *ReSyncSchedulerCacheArgs) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReSyncSchedulerCacheArgs.Unmarshal(m, b)
}
func (m *ReSyncSchedulerCacheArgs) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReSyncSchedulerCacheArgs.Marshal(b, m, deterministic)
}
func (m *ReSyncSchedulerCacheArgs) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReSyncSchedulerCacheArgs.Merge(m, src)
}
func (m *ReSyncSchedulerCacheArgs) XXX_Size() int {
	return xxx_messageInfo_ReSyncSchedulerCacheArgs.Size(m)
}
func (m *ReSyncSchedulerCacheArgs) XXX_DiscardUnknown() {
	xxx_messageInfo_ReSyncSchedulerCacheArgs.DiscardUnknown(m)
}

var xxx_messageInfo_ReSyncSchedulerCacheArgs proto.InternalMessageInfo

func (m *ReSyncSchedulerCacheArgs) GetAssumedAllocations() []*AssumedAllocation {
	if m != nil {
		return m.AssumedAllocations
	}
	return nil
}

func (m *ReSyncSchedulerCacheArgs) GetForgetAllocations() []*ForgotAllocation {
	if m != nil {
		return m.ForgetAllocations
	}
	return nil
}

type AssumedAllocation struct {
	// allocation key used to identify a container.
	AllocationKey string `protobuf:"bytes,1,opt,name=allocationKey,proto3" json:"allocationKey,omitempty"`
	// the node ID the container is assumed to be allocated to, this info is stored in scheduler cache.
	NodeID               string   `protobuf:"bytes,2,opt,name=nodeID,proto3" json:"nodeID,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AssumedAllocation) Reset()         { *m = AssumedAllocation{} }
func (m *AssumedAllocation) String() string { return proto.CompactTextString(m) }
func (*AssumedAllocation) ProtoMessage()    {}
func (*AssumedAllocation) Descriptor() ([]byte, []int) {
	return fileDescriptor_bcd2636ebca16c8c, []int{25}
}

func (m *AssumedAllocation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AssumedAllocation.Unmarshal(m, b)
}
func (m *AssumedAllocation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AssumedAllocation.Marshal(b, m, deterministic)
}
func (m *AssumedAllocation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AssumedAllocation.Merge(m, src)
}
func (m *AssumedAllocation) XXX_Size() int {
	return xxx_messageInfo_AssumedAllocation.Size(m)
}
func (m *AssumedAllocation) XXX_DiscardUnknown() {
	xxx_messageInfo_AssumedAllocation.DiscardUnknown(m)
}

var xxx_messageInfo_AssumedAllocation proto.InternalMessageInfo

func (m *AssumedAllocation) GetAllocationKey() string {
	if m != nil {
		return m.AllocationKey
	}
	return ""
}

func (m *AssumedAllocation) GetNodeID() string {
	if m != nil {
		return m.NodeID
	}
	return ""
}

type ForgotAllocation struct {
	// allocation key used to identify a container.
	AllocationKey        string   `protobuf:"bytes,1,opt,name=allocationKey,proto3" json:"allocationKey,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ForgotAllocation) Reset()         { *m = ForgotAllocation{} }
func (m *ForgotAllocation) String() string { return proto.CompactTextString(m) }
func (*ForgotAllocation) ProtoMessage()    {}
func (*ForgotAllocation) Descriptor() ([]byte, []int) {
	return fileDescriptor_bcd2636ebca16c8c, []int{26}
}

func (m *ForgotAllocation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ForgotAllocation.Unmarshal(m, b)
}
func (m *ForgotAllocation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ForgotAllocation.Marshal(b, m, deterministic)
}
func (m *ForgotAllocation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ForgotAllocation.Merge(m, src)
}
func (m *ForgotAllocation) XXX_Size() int {
	return xxx_messageInfo_ForgotAllocation.Size(m)
}
func (m *ForgotAllocation) XXX_DiscardUnknown() {
	xxx_messageInfo_ForgotAllocation.DiscardUnknown(m)
}

var xxx_messageInfo_ForgotAllocation proto.InternalMessageInfo

func (m *ForgotAllocation) GetAllocationKey() string {
	if m != nil {
		return m.AllocationKey
	}
	return ""
}

type UpdateContainerSchedulingStateRequest struct {
	// application ID
	ApplicartionID string `protobuf:"bytes,1,opt,name=applicartionID,proto3" json:"applicartionID,omitempty"`
	// allocation key used to identify a container.
	AllocationKey string `protobuf:"bytes,2,opt,name=allocationKey,proto3" json:"allocationKey,omitempty"`
	// container scheduling state
	State UpdateContainerSchedulingStateRequest_SchedulingState `protobuf:"varint,3,opt,name=state,proto3,enum=si.v1.UpdateContainerSchedulingStateRequest_SchedulingState" json:"state,omitempty"`
	// an optional plain message to explain why it is in such state
	Reason               string   `protobuf:"bytes,4,opt,name=reason,proto3" json:"reason,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateContainerSchedulingStateRequest) Reset()         { *m = UpdateContainerSchedulingStateRequest{} }
func (m *UpdateContainerSchedulingStateRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateContainerSchedulingStateRequest) ProtoMessage()    {}
func (*UpdateContainerSchedulingStateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_bcd2636ebca16c8c, []int{27}
}

func (m *UpdateContainerSchedulingStateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateContainerSchedulingStateRequest.Unmarshal(m, b)
}
func (m *UpdateContainerSchedulingStateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateContainerSchedulingStateRequest.Marshal(b, m, deterministic)
}
func (m *UpdateContainerSchedulingStateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateContainerSchedulingStateRequest.Merge(m, src)
}
func (m *UpdateContainerSchedulingStateRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateContainerSchedulingStateRequest.Size(m)
}
func (m *UpdateContainerSchedulingStateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateContainerSchedulingStateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateContainerSchedulingStateRequest proto.InternalMessageInfo

func (m *UpdateContainerSchedulingStateRequest) GetApplicartionID() string {
	if m != nil {
		return m.ApplicartionID
	}
	return ""
}

func (m *UpdateContainerSchedulingStateRequest) GetAllocationKey() string {
	if m != nil {
		return m.AllocationKey
	}
	return ""
}

func (m *UpdateContainerSchedulingStateRequest) GetState() UpdateContainerSchedulingStateRequest_SchedulingState {
	if m != nil {
		return m.State
	}
	return UpdateContainerSchedulingStateRequest_SKIPPED
}

func (m *UpdateContainerSchedulingStateRequest) GetReason() string {
	if m != nil {
		return m.Reason
	}
	return ""
}

type UpdateConfigurationRequest struct {
	// New config what needs to be saved
	Configs              string   `protobuf:"bytes,1,opt,name=configs,proto3" json:"configs,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateConfigurationRequest) Reset()         { *m = UpdateConfigurationRequest{} }
func (m *UpdateConfigurationRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateConfigurationRequest) ProtoMessage()    {}
func (*UpdateConfigurationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_bcd2636ebca16c8c, []int{28}
}

func (m *UpdateConfigurationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateConfigurationRequest.Unmarshal(m, b)
}
func (m *UpdateConfigurationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateConfigurationRequest.Marshal(b, m, deterministic)
}
func (m *UpdateConfigurationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateConfigurationRequest.Merge(m, src)
}
func (m *UpdateConfigurationRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateConfigurationRequest.Size(m)
}
func (m *UpdateConfigurationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateConfigurationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateConfigurationRequest proto.InternalMessageInfo

func (m *UpdateConfigurationRequest) GetConfigs() string {
	if m != nil {
		return m.Configs
	}
	return ""
}

type UpdateConfigurationResponse struct {
	// flag that marks the config update success or failure
	Success bool `protobuf:"varint,1,opt,name=success,proto3" json:"success,omitempty"`
	// the old configuration what was changed
	OldConfig string `protobuf:"bytes,2,opt,name=oldConfig,proto3" json:"oldConfig,omitempty"`
	// reason in case of failure
	Reason               string   `protobuf:"bytes,3,opt,name=reason,proto3" json:"reason,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateConfigurationResponse) Reset()         { *m = UpdateConfigurationResponse{} }
func (m *UpdateConfigurationResponse) String() string { return proto.CompactTextString(m) }
func (*UpdateConfigurationResponse) ProtoMessage()    {}
func (*UpdateConfigurationResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_bcd2636ebca16c8c, []int{29}
}

func (m *UpdateConfigurationResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateConfigurationResponse.Unmarshal(m, b)
}
func (m *UpdateConfigurationResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateConfigurationResponse.Marshal(b, m, deterministic)
}
func (m *UpdateConfigurationResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateConfigurationResponse.Merge(m, src)
}
func (m *UpdateConfigurationResponse) XXX_Size() int {
	return xxx_messageInfo_UpdateConfigurationResponse.Size(m)
}
func (m *UpdateConfigurationResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateConfigurationResponse.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateConfigurationResponse proto.InternalMessageInfo

func (m *UpdateConfigurationResponse) GetSuccess() bool {
	if m != nil {
		return m.Success
	}
	return false
}

func (m *UpdateConfigurationResponse) GetOldConfig() string {
	if m != nil {
		return m.OldConfig
	}
	return ""
}

func (m *UpdateConfigurationResponse) GetReason() string {
	if m != nil {
		return m.Reason
	}
	return ""
}

type EventRecord struct {
	// the type of the object associated with the event
	Type EventRecord_Type `protobuf:"varint,1,opt,name=type,proto3,enum=si.v1.EventRecord_Type" json:"type,omitempty"`
	// ID of the object associated with the event
	ObjectID string `protobuf:"bytes,2,opt,name=objectID,proto3" json:"objectID,omitempty"`
	// the group this object belongs to
	// it specifies the application ID for allocations and the queue for applications
	GroupID string `protobuf:"bytes,3,opt,name=groupID,proto3" json:"groupID,omitempty"`
	// the reason of this event
	Reason string `protobuf:"bytes,4,opt,name=reason,proto3" json:"reason,omitempty"`
	// the detailed message as string
	Message string `protobuf:"bytes,5,opt,name=message,proto3" json:"message,omitempty"`
	// timestamp of the event
	TimestampNano        int64    `protobuf:"varint,6,opt,name=timestampNano,proto3" json:"timestampNano,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EventRecord) Reset()         { *m = EventRecord{} }
func (m *EventRecord) String() string { return proto.CompactTextString(m) }
func (*EventRecord) ProtoMessage()    {}
func (*EventRecord) Descriptor() ([]byte, []int) {
	return fileDescriptor_bcd2636ebca16c8c, []int{30}
}

func (m *EventRecord) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EventRecord.Unmarshal(m, b)
}
func (m *EventRecord) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EventRecord.Marshal(b, m, deterministic)
}
func (m *EventRecord) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EventRecord.Merge(m, src)
}
func (m *EventRecord) XXX_Size() int {
	return xxx_messageInfo_EventRecord.Size(m)
}
func (m *EventRecord) XXX_DiscardUnknown() {
	xxx_messageInfo_EventRecord.DiscardUnknown(m)
}

var xxx_messageInfo_EventRecord proto.InternalMessageInfo

func (m *EventRecord) GetType() EventRecord_Type {
	if m != nil {
		return m.Type
	}
	return EventRecord_REQUEST
}

func (m *EventRecord) GetObjectID() string {
	if m != nil {
		return m.ObjectID
	}
	return ""
}

func (m *EventRecord) GetGroupID() string {
	if m != nil {
		return m.GroupID
	}
	return ""
}

func (m *EventRecord) GetReason() string {
	if m != nil {
		return m.Reason
	}
	return ""
}

func (m *EventRecord) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func (m *EventRecord) GetTimestampNano() int64 {
	if m != nil {
		return m.TimestampNano
	}
	return 0
}

var E_SiSecret = &proto.ExtensionDesc{
	ExtendedType:  (*descriptor.FieldOptions)(nil),
	ExtensionType: (*bool)(nil),
	Field:         1059,
	Name:          "si.v1.si_secret",
	Tag:           "varint,1059,opt,name=si_secret",
	Filename:      "incubator-yunikorn-scheduler-interface/si.proto",
}

func init() {
	proto.RegisterEnum("si.v1.TerminationType", TerminationType_name, TerminationType_value)
	proto.RegisterEnum("si.v1.UpdateResponse_ActionFromScheduler", UpdateResponse_ActionFromScheduler_name, UpdateResponse_ActionFromScheduler_value)
	proto.RegisterEnum("si.v1.UpdateNodeInfo_ActionFromRM", UpdateNodeInfo_ActionFromRM_name, UpdateNodeInfo_ActionFromRM_value)
	proto.RegisterEnum("si.v1.UpdateContainerSchedulingStateRequest_SchedulingState", UpdateContainerSchedulingStateRequest_SchedulingState_name, UpdateContainerSchedulingStateRequest_SchedulingState_value)
	proto.RegisterEnum("si.v1.EventRecord_Type", EventRecord_Type_name, EventRecord_Type_value)
	proto.RegisterType((*RegisterResourceManagerRequest)(nil), "si.v1.RegisterResourceManagerRequest")
	proto.RegisterType((*RegisterResourceManagerResponse)(nil), "si.v1.RegisterResourceManagerResponse")
	proto.RegisterType((*UpdateRequest)(nil), "si.v1.UpdateRequest")
	proto.RegisterType((*UpdateResponse)(nil), "si.v1.UpdateResponse")
	proto.RegisterType((*UpdatedApplication)(nil), "si.v1.UpdatedApplication")
	proto.RegisterType((*RejectedApplication)(nil), "si.v1.RejectedApplication")
	proto.RegisterType((*AcceptedApplication)(nil), "si.v1.AcceptedApplication")
	proto.RegisterType((*RejectedNode)(nil), "si.v1.RejectedNode")
	proto.RegisterType((*AcceptedNode)(nil), "si.v1.AcceptedNode")
	proto.RegisterType((*Priority)(nil), "si.v1.Priority")
	proto.RegisterType((*Resource)(nil), "si.v1.Resource")
	proto.RegisterMapType((map[string]*Quantity)(nil), "si.v1.Resource.ResourcesEntry")
	proto.RegisterType((*Quantity)(nil), "si.v1.Quantity")
	proto.RegisterType((*AllocationAsk)(nil), "si.v1.AllocationAsk")
	proto.RegisterMapType((map[string]string)(nil), "si.v1.AllocationAsk.TagsEntry")
	proto.RegisterType((*AddApplicationRequest)(nil), "si.v1.AddApplicationRequest")
	proto.RegisterMapType((map[string]string)(nil), "si.v1.AddApplicationRequest.TagsEntry")
	proto.RegisterType((*RemoveApplicationRequest)(nil), "si.v1.RemoveApplicationRequest")
	proto.RegisterType((*UserGroupInformation)(nil), "si.v1.UserGroupInformation")
	proto.RegisterType((*Allocation)(nil), "si.v1.Allocation")
	proto.RegisterMapType((map[string]string)(nil), "si.v1.Allocation.AllocationTagsEntry")
	proto.RegisterType((*AllocationReleasesRequest)(nil), "si.v1.AllocationReleasesRequest")
	proto.RegisterType((*AllocationRelease)(nil), "si.v1.AllocationRelease")
	proto.RegisterType((*AllocationAskRelease)(nil), "si.v1.AllocationAskRelease")
	proto.RegisterType((*NewNodeInfo)(nil), "si.v1.NewNodeInfo")
	proto.RegisterMapType((map[string]string)(nil), "si.v1.NewNodeInfo.AttributesEntry")
	proto.RegisterType((*UpdateNodeInfo)(nil), "si.v1.UpdateNodeInfo")
	proto.RegisterMapType((map[string]string)(nil), "si.v1.UpdateNodeInfo.AttributesEntry")
	proto.RegisterType((*RejectedAllocationAsk)(nil), "si.v1.RejectedAllocationAsk")
	proto.RegisterType((*PredicatesArgs)(nil), "si.v1.PredicatesArgs")
	proto.RegisterType((*ReSyncSchedulerCacheArgs)(nil), "si.v1.ReSyncSchedulerCacheArgs")
	proto.RegisterType((*AssumedAllocation)(nil), "si.v1.AssumedAllocation")
	proto.RegisterType((*ForgotAllocation)(nil), "si.v1.ForgotAllocation")
	proto.RegisterType((*UpdateContainerSchedulingStateRequest)(nil), "si.v1.UpdateContainerSchedulingStateRequest")
	proto.RegisterType((*UpdateConfigurationRequest)(nil), "si.v1.UpdateConfigurationRequest")
	proto.RegisterType((*UpdateConfigurationResponse)(nil), "si.v1.UpdateConfigurationResponse")
	proto.RegisterType((*EventRecord)(nil), "si.v1.EventRecord")
	proto.RegisterExtension(E_SiSecret)
}

func init() {
	proto.RegisterFile("incubator-yunikorn-scheduler-interface/si.proto", fileDescriptor_bcd2636ebca16c8c)
}

var fileDescriptor_bcd2636ebca16c8c = []byte{
	// 2114 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x59, 0xcd, 0x72, 0xdb, 0xc8,
	0xf1, 0x17, 0xf8, 0x21, 0x92, 0x4d, 0x89, 0xa2, 0x86, 0xb2, 0xcd, 0xd5, 0xfa, 0xef, 0xd5, 0x1f,
	0xb5, 0x56, 0x29, 0xd9, 0x32, 0xbd, 0x56, 0xaa, 0xb2, 0xeb, 0x8f, 0xa4, 0x02, 0x89, 0xd0, 0x4a,
	0xb1, 0x44, 0xd2, 0x43, 0x72, 0xab, 0x36, 0x17, 0x15, 0x04, 0x8e, 0x68, 0x58, 0x24, 0xc0, 0x9d,
	0x01, 0x64, 0xab, 0x72, 0xcb, 0x39, 0xb7, 0x1c, 0xf2, 0x00, 0xa9, 0xe4, 0x90, 0x5c, 0xf3, 0x00,
	0xc9, 0x13, 0xe4, 0x92, 0x47, 0xc8, 0x35, 0x4f, 0x90, 0x4b, 0x6a, 0x06, 0x03, 0x10, 0x5f, 0xb4,
	0xe8, 0xec, 0xa6, 0x2a, 0x37, 0x4c, 0xcf, 0xaf, 0x7b, 0x66, 0xba, 0x7f, 0xd3, 0xd3, 0x33, 0x80,
	0xc7, 0x96, 0x6d, 0x7a, 0x17, 0x86, 0xeb, 0xd0, 0x47, 0x37, 0x9e, 0x6d, 0x5d, 0x39, 0xd4, 0x7e,
	0xc4, 0xcc, 0xd7, 0x64, 0xe4, 0x4d, 0x08, 0x7d, 0x64, 0xd9, 0x2e, 0xa1, 0x97, 0x86, 0x49, 0x1e,
	0x33, 0xab, 0x35, 0xa3, 0x8e, 0xeb, 0xa0, 0x22, 0xb3, 0x5a, 0xd7, 0x4f, 0xb6, 0x77, 0xc6, 0x8e,
	0x33, 0x9e, 0x90, 0xc7, 0x42, 0x78, 0xe1, 0x5d, 0x3e, 0x1e, 0x11, 0x66, 0x52, 0x6b, 0xe6, 0x3a,
	0xd4, 0x07, 0xaa, 0x33, 0x78, 0x80, 0xc9, 0xd8, 0x62, 0x2e, 0xa1, 0x98, 0x30, 0xc7, 0xa3, 0x26,
	0x39, 0x33, 0x6c, 0x63, 0xcc, 0x9b, 0xdf, 0x7a, 0x84, 0xb9, 0x08, 0x41, 0x81, 0x4e, 0x4f, 0xda,
	0x4d, 0x65, 0x47, 0xd9, 0xab, 0x60, 0xf1, 0x8d, 0x9a, 0x50, 0xba, 0x26, 0x94, 0x59, 0x8e, 0xdd,
	0xcc, 0x09, 0x71, 0xd0, 0x44, 0x3b, 0x50, 0x9d, 0x39, 0x13, 0xcb, 0xbc, 0xf9, 0x8a, 0x3a, 0xde,
	0xac, 0x99, 0x17, 0xbd, 0x51, 0x91, 0xfa, 0xff, 0xf0, 0xc9, 0xc2, 0x11, 0xd9, 0xcc, 0xb1, 0x19,
	0x51, 0x7f, 0x9f, 0x87, 0xf5, 0xe1, 0x6c, 0x64, 0xb8, 0x24, 0x98, 0xc4, 0x1e, 0x14, 0x0c, 0x76,
	0xc5, 0x9a, 0xca, 0x4e, 0x7e, 0xaf, 0xba, 0xbf, 0xd5, 0x12, 0xcb, 0x6b, 0x69, 0x93, 0x89, 0x63,
	0x1a, 0xae, 0xe5, 0xd8, 0x1a, 0xbb, 0xc2, 0x02, 0x81, 0x5e, 0x40, 0x99, 0x92, 0x09, 0x31, 0x18,
	0x61, 0x62, 0x6e, 0xd5, 0xfd, 0x9d, 0x14, 0x1a, 0x4b, 0x80, 0xb4, 0x8e, 0x43, 0x0d, 0xd4, 0x86,
	0x86, 0x4d, 0xde, 0xf6, 0x7d, 0xd7, 0x1a, 0x17, 0x13, 0xd2, 0x71, 0x46, 0x84, 0x35, 0xf3, 0x62,
	0x58, 0x24, 0x0d, 0x75, 0xc8, 0x5b, 0x2e, 0x3e, 0xb1, 0x2f, 0x1d, 0x9c, 0x05, 0x47, 0x4f, 0x61,
	0xcd, 0x13, 0xd3, 0x1f, 0xf9, 0xea, 0x05, 0xa1, 0x7e, 0x47, 0xaa, 0xfb, 0x2b, 0x0b, 0x2d, 0xc4,
	0xa0, 0xa1, 0xb7, 0x8b, 0x11, 0x6f, 0x1f, 0xc1, 0x86, 0x4d, 0xde, 0x6a, 0xb3, 0xd9, 0xc4, 0xf2,
	0xe7, 0xcf, 0x9a, 0xab, 0xc2, 0xe2, 0xfd, 0x60, 0x65, 0xa3, 0x51, 0xa4, 0x37, 0x58, 0x55, 0x52,
	0x09, 0x75, 0x01, 0x51, 0x32, 0x75, 0xae, 0x49, 0xcc, 0x54, 0x49, 0x98, 0xfa, 0x44, 0x9a, 0xc2,
	0x49, 0x40, 0x60, 0x2d, 0x43, 0x55, 0xfd, 0xcd, 0x2a, 0xd4, 0x82, 0x38, 0xf9, 0xa1, 0x43, 0x1a,
	0xac, 0x1a, 0x26, 0xef, 0x15, 0x7c, 0xa9, 0xed, 0xff, 0x20, 0xb6, 0xe8, 0x00, 0xd6, 0xd2, 0x04,
	0xe6, 0x88, 0x3a, 0xd3, 0x7e, 0x40, 0x63, 0x2c, 0x15, 0xd1, 0x53, 0xa8, 0xf1, 0x99, 0x87, 0xd1,
	0xe2, 0x71, 0xe4, 0x53, 0xdc, 0x4c, 0xc7, 0x31, 0x01, 0x44, 0x3f, 0x87, 0x86, 0x0c, 0xe5, 0x28,
	0xaa, 0xef, 0x87, 0xaf, 0xb9, 0x88, 0x07, 0x38, 0x4b, 0x09, 0xf5, 0xe1, 0x6e, 0x5a, 0xac, 0x71,
	0x12, 0xfa, 0xe1, 0xfc, 0x38, 0x93, 0x84, 0xd2, 0xe2, 0x02, 0x55, 0xd4, 0xe1, 0x13, 0x7c, 0x43,
	0x4c, 0x37, 0x3e, 0xc1, 0x62, 0x2c, 0x9c, 0x38, 0x85, 0xe0, 0x96, 0xb3, 0x14, 0x51, 0x07, 0xb6,
	0x42, 0x71, 0x9a, 0x1f, 0xdb, 0x49, 0x83, 0x91, 0xb0, 0x66, 0xea, 0x71, 0x7b, 0x86, 0x69, 0x92,
	0x59, 0xd2, 0x5e, 0x29, 0x66, 0x4f, 0x4b, 0x43, 0x70, 0xa6, 0x1e, 0x7a, 0x09, 0x0d, 0x49, 0xef,
	0x98, 0xb9, 0xb2, 0x30, 0xf7, 0x51, 0x8c, 0x1b, 0x31, 0x6b, 0x59, 0x5a, 0xe8, 0x29, 0xac, 0x07,
	0x93, 0xf6, 0xf7, 0x55, 0x45, 0x98, 0x69, 0x24, 0x56, 0xc9, 0xfb, 0x70, 0x1c, 0xc9, 0x55, 0x83,
	0xf9, 0xf9, 0xaa, 0x10, 0x53, 0xd5, 0x22, 0x7d, 0x38, 0x8e, 0x54, 0x1f, 0x43, 0x23, 0x83, 0xad,
	0x68, 0x0d, 0xca, 0x9d, 0xae, 0x76, 0x38, 0x38, 0xe9, 0x76, 0xea, 0x2b, 0x08, 0x60, 0x15, 0xeb,
	0xfd, 0x6f, 0x3a, 0x87, 0x75, 0x45, 0xfd, 0x83, 0x02, 0x28, 0xbd, 0x24, 0xf4, 0x29, 0xac, 0x1b,
	0xf3, 0x66, 0x98, 0x50, 0xe3, 0x42, 0xb4, 0x05, 0x45, 0xe6, 0x1a, 0x2e, 0x91, 0x79, 0xd5, 0x6f,
	0xa0, 0x67, 0xd0, 0x14, 0x1f, 0x03, 0x6a, 0xd8, 0xcc, 0xe2, 0xd0, 0x81, 0x35, 0x25, 0xcc, 0x35,
	0xa6, 0x7e, 0x8a, 0xcd, 0xe3, 0x85, 0xfd, 0x3c, 0x57, 0x4f, 0x09, 0x63, 0xc6, 0x98, 0x34, 0x0b,
	0x7e, 0xae, 0x96, 0x4d, 0xb5, 0x0f, 0x8d, 0x0c, 0x66, 0x2c, 0x39, 0xd1, 0xbb, 0xb0, 0x4a, 0x89,
	0xc1, 0xc2, 0x13, 0x40, 0xb6, 0xd4, 0xe7, 0xdc, 0x5d, 0x29, 0x26, 0x2c, 0x67, 0x54, 0xfd, 0x29,
	0xac, 0x45, 0xa3, 0xc8, 0x07, 0xb1, 0x79, 0x9e, 0x0c, 0xe0, 0xb2, 0xb5, 0x70, 0xf0, 0x5d, 0x58,
	0x8b, 0x86, 0x72, 0x91, 0xbe, 0x6a, 0x43, 0xb9, 0x47, 0x2d, 0x87, 0x5a, 0xee, 0x0d, 0xda, 0x85,
	0xf5, 0x99, 0xfc, 0xfe, 0xda, 0x98, 0x78, 0x44, 0x40, 0x8b, 0xc7, 0x2b, 0x38, 0x2e, 0x46, 0x2d,
	0xd8, 0x0c, 0x04, 0x87, 0x13, 0x83, 0xb1, 0x8e, 0x31, 0x95, 0x51, 0x3a, 0x5e, 0xc1, 0xe9, 0xae,
	0x03, 0x80, 0x72, 0x20, 0x54, 0x7f, 0xab, 0x40, 0x39, 0x38, 0xec, 0xd0, 0x0b, 0xa8, 0x50, 0xf9,
	0x1d, 0x1c, 0x68, 0x0f, 0x42, 0x0a, 0xfb, 0xf2, 0xf0, 0x83, 0xe9, 0xb6, 0x4b, 0x6f, 0xf0, 0x5c,
	0x61, 0xfb, 0x0c, 0x6a, 0xf1, 0x4e, 0x54, 0x87, 0xfc, 0x15, 0xb9, 0x91, 0x2b, 0xe4, 0x9f, 0xe8,
	0x21, 0x14, 0xaf, 0xc5, 0x52, 0xfc, 0x03, 0x70, 0x43, 0x5a, 0x7f, 0xe5, 0x19, 0xb6, 0x6b, 0xb9,
	0x37, 0xd8, 0xef, 0x7d, 0x96, 0xfb, 0x52, 0x51, 0x77, 0xa0, 0x1c, 0x88, 0x39, 0xf7, 0xae, 0x43,
	0x0f, 0xe4, 0x25, 0x4a, 0xfd, 0x55, 0x01, 0xd6, 0x63, 0x99, 0x48, 0xc4, 0x32, 0x14, 0xbc, 0x0c,
	0x87, 0x8e, 0x0b, 0xd3, 0x11, 0xcf, 0x65, 0xd1, 0xe8, 0x53, 0x58, 0x9f, 0x19, 0xd4, 0x15, 0x9c,
	0x15, 0x1e, 0xf5, 0x2b, 0x86, 0xb8, 0x10, 0x3d, 0x81, 0x6a, 0xe0, 0x01, 0x8d, 0x5d, 0x09, 0x1e,
	0xcf, 0x97, 0x15, 0xb8, 0x03, 0x47, 0x31, 0x68, 0x17, 0x6a, 0x53, 0xe3, 0x5d, 0x3c, 0xc9, 0x2a,
	0x7b, 0x45, 0x9c, 0x90, 0xa2, 0xcf, 0xe6, 0x61, 0x6a, 0xae, 0xc6, 0xec, 0x06, 0x0c, 0xc1, 0x21,
	0x00, 0x1d, 0xc0, 0x7d, 0xf2, 0x8e, 0x98, 0x5e, 0xb0, 0xc3, 0x1c, 0xcf, 0x3d, 0xb3, 0x26, 0x13,
	0xab, 0x4f, 0x4c, 0xc7, 0x1e, 0xf1, 0x34, 0xc9, 0x1d, 0xf7, 0x5e, 0x0c, 0xda, 0x87, 0x82, 0x6b,
	0x8c, 0x83, 0x1c, 0xf8, 0x20, 0xeb, 0x14, 0x69, 0x0d, 0x8c, 0xb1, 0x8c, 0xbc, 0xc0, 0x72, 0x2f,
	0xb9, 0x06, 0xbb, 0x12, 0x05, 0x94, 0xf0, 0x52, 0xc5, 0xf7, 0x52, 0x4c, 0x28, 0x6a, 0xaf, 0x89,
	0x61, 0x92, 0xd7, 0xce, 0x64, 0x44, 0x68, 0x13, 0x76, 0x94, 0xbd, 0x32, 0x8e, 0x8a, 0xb6, 0xbf,
	0x80, 0x4a, 0x68, 0x3a, 0x83, 0x37, 0x5b, 0x51, 0xde, 0x54, 0xa2, 0x34, 0xf9, 0x7b, 0x1e, 0xee,
	0x64, 0x56, 0x19, 0x4b, 0x66, 0x8b, 0xfb, 0x50, 0xf9, 0xd6, 0x23, 0x1e, 0x99, 0x6f, 0x1a, 0x3c,
	0x17, 0x2c, 0x49, 0x82, 0x47, 0x90, 0xf7, 0xc6, 0x96, 0x0c, 0x7e, 0x70, 0xfa, 0x0e, 0x19, 0xa1,
	0xc2, 0x03, 0xbc, 0x96, 0xa2, 0x53, 0x7f, 0x6a, 0x1c, 0x87, 0x9e, 0x49, 0x3f, 0xfb, 0x67, 0xeb,
	0xee, 0xfb, 0x4a, 0xa5, 0x94, 0xbf, 0x6f, 0x8b, 0xf3, 0xea, 0x12, 0x71, 0xfe, 0x02, 0x6a, 0x11,
	0xd7, 0x73, 0xda, 0x96, 0xb2, 0x69, 0x9b, 0x80, 0xa1, 0xcf, 0xa1, 0x31, 0x36, 0xec, 0xb1, 0x3c,
	0x6a, 0x2c, 0x7b, 0xdc, 0x77, 0x6f, 0x26, 0xa4, 0x59, 0x16, 0x3e, 0xc9, 0xea, 0xfa, 0xcf, 0xc3,
	0x7a, 0x09, 0xcd, 0x45, 0x05, 0xdf, 0x92, 0x81, 0x4d, 0x85, 0x2e, 0x97, 0x11, 0x3a, 0xf5, 0x00,
	0xb6, 0xb2, 0x02, 0xc5, 0xab, 0x5d, 0x8f, 0x11, 0x1a, 0xdc, 0x2d, 0xf8, 0x37, 0xcf, 0xd9, 0x63,
	0x8e, 0xf3, 0xcb, 0xbe, 0x0a, 0x96, 0x2d, 0xf5, 0xd7, 0x05, 0x80, 0xf9, 0x2e, 0x59, 0x32, 0x09,
	0x9d, 0x41, 0x6d, 0x2e, 0xe0, 0x3e, 0x92, 0xb5, 0xe4, 0xc3, 0xd4, 0xb6, 0x8b, 0x7c, 0xce, 0xd9,
	0x90, 0x50, 0xe6, 0xf3, 0x1d, 0x0e, 0x4f, 0xda, 0x92, 0x9f, 0xe2, 0x1b, 0x3d, 0x87, 0x7a, 0x90,
	0x77, 0x7a, 0x84, 0x0a, 0x2b, 0x22, 0xd5, 0x64, 0x44, 0x3a, 0x05, 0xfc, 0xb0, 0xec, 0x13, 0xdb,
	0x44, 0xa5, 0xe4, 0x26, 0x9a, 0x9f, 0x75, 0xe5, 0xd8, 0x59, 0x99, 0x8a, 0x63, 0x65, 0xa9, 0x38,
	0x42, 0xd6, 0x16, 0x4c, 0xe5, 0xa1, 0xea, 0x12, 0x79, 0x68, 0x2d, 0x9d, 0x87, 0x34, 0x68, 0x64,
	0xb8, 0xfb, 0x83, 0xa8, 0xfb, 0x17, 0x05, 0x3e, 0x5a, 0x78, 0xa3, 0x43, 0xa7, 0xb0, 0x35, 0x0f,
	0x1d, 0x1b, 0x38, 0xb2, 0x5f, 0x1e, 0xb7, 0x8b, 0x6f, 0x02, 0x99, 0x5a, 0x68, 0x08, 0xf7, 0x8c,
	0x58, 0x1d, 0x3f, 0x37, 0x98, 0xbb, 0xfd, 0x2e, 0xb0, 0x48, 0x57, 0xfd, 0x9b, 0x02, 0x9b, 0xa9,
	0x29, 0xa4, 0x23, 0xa1, 0x2c, 0x88, 0xc4, 0x12, 0xa7, 0x6b, 0x16, 0x5f, 0x7f, 0x06, 0x1b, 0x2e,
	0xa1, 0x53, 0xcb, 0xf6, 0x9d, 0x7f, 0x33, 0xf3, 0xeb, 0xc2, 0xda, 0xfe, 0x5d, 0xb9, 0x88, 0x41,
	0xbc, 0x17, 0x27, 0xe1, 0xd1, 0x8a, 0xb2, 0x18, 0xaf, 0x28, 0xff, 0xa1, 0xc0, 0x56, 0x96, 0x0f,
	0xbe, 0xd7, 0x45, 0xc5, 0x76, 0x3e, 0xe7, 0x4b, 0x3e, 0xb9, 0xf3, 0x39, 0x73, 0xfe, 0x9b, 0xcb,
	0xfc, 0x67, 0x0e, 0xaa, 0x91, 0x47, 0x80, 0x85, 0x65, 0xea, 0x01, 0x80, 0xe1, 0xba, 0xd4, 0xba,
	0xf0, 0x5c, 0x12, 0x64, 0x1e, 0x35, 0xfd, 0x88, 0xd0, 0xd2, 0x42, 0x90, 0x9f, 0x76, 0x22, 0x5a,
	0x48, 0x83, 0x06, 0x9b, 0xbf, 0x2f, 0x04, 0xa9, 0x44, 0xac, 0x39, 0x23, 0xc3, 0x64, 0x61, 0x79,
	0x86, 0x72, 0x4c, 0xd3, 0x9b, 0x59, 0x64, 0x14, 0xea, 0x2f, 0x28, 0xa1, 0x52, 0x40, 0x74, 0x08,
	0x0d, 0xf2, 0xce, 0x62, 0xae, 0x65, 0x8f, 0xd3, 0x37, 0xd6, 0x8c, 0x2b, 0x79, 0x16, 0x7a, 0xfb,
	0x27, 0xb0, 0x91, 0x58, 0xe3, 0x07, 0xed, 0xf5, 0xbf, 0xe6, 0x83, 0x77, 0x86, 0x5b, 0x5d, 0xae,
	0x67, 0xb8, 0xfc, 0x61, 0xe6, 0xc3, 0xcb, 0xff, 0xb4, 0xd7, 0x9f, 0x85, 0xcf, 0x28, 0x45, 0x41,
	0x5a, 0x75, 0xc1, 0x12, 0xc2, 0x8b, 0x29, 0x3e, 0x0b, 0xde, 0x4f, 0xbe, 0xab, 0xb3, 0x87, 0xfc,
	0x0e, 0x35, 0x37, 0xcb, 0xaf, 0xb6, 0xc3, 0x5e, 0x5b, 0x1b, 0xe8, 0xf5, 0x15, 0x54, 0x03, 0x68,
	0x63, 0xed, 0xa4, 0x73, 0xde, 0xe9, 0xb6, 0xf5, 0xba, 0x82, 0x36, 0xa0, 0xda, 0xd6, 0x0f, 0xbb,
	0x67, 0x27, 0xfd, 0x3e, 0xbf, 0x07, 0xe7, 0x50, 0x13, 0xb6, 0x7c, 0xc0, 0xa0, 0x7b, 0xde, 0x3f,
	0x3c, 0xd6, 0xdb, 0xc3, 0x53, 0xed, 0xe0, 0x54, 0xaf, 0xe7, 0xd5, 0x5f, 0xc2, 0x9d, 0xcc, 0x77,
	0x8d, 0xef, 0xf5, 0x36, 0x31, 0xbf, 0x17, 0xe6, 0x63, 0xf7, 0xc2, 0x37, 0x50, 0xeb, 0x51, 0x32,
	0xe2, 0x40, 0xc2, 0x34, 0xea, 0x57, 0xd4, 0x4b, 0x8c, 0x3a, 0x67, 0x59, 0x2e, 0xc6, 0xb2, 0x6d,
	0x28, 0x4b, 0xa0, 0xcf, 0x89, 0x32, 0x0e, 0xdb, 0xea, 0x9f, 0x14, 0x5e, 0x54, 0xf5, 0x6f, 0x6c,
	0x33, 0x7c, 0x2c, 0x38, 0x34, 0xcc, 0xd7, 0x44, 0x0c, 0x7b, 0x0c, 0xc8, 0x60, 0xcc, 0x9b, 0xc6,
	0x9f, 0x7f, 0x12, 0xa7, 0x52, 0x12, 0x80, 0x33, 0x74, 0x90, 0x0e, 0x9b, 0x97, 0x0e, 0x1d, 0x13,
	0x37, 0xfd, 0x50, 0x76, 0x4f, 0x1a, 0x3a, 0x72, 0xe8, 0xd8, 0x89, 0xf4, 0xe3, 0xb4, 0x86, 0xfa,
	0x0a, 0x36, 0x53, 0xe3, 0x7d, 0x37, 0xe7, 0xa8, 0x5f, 0x42, 0x3d, 0x39, 0xf2, 0x72, 0x16, 0xd5,
	0x3f, 0xe6, 0xe0, 0xa1, 0xcf, 0xf0, 0x43, 0xc7, 0x76, 0x0d, 0xcb, 0x26, 0x34, 0x5a, 0xea, 0x46,
	0xde, 0x83, 0x77, 0xa1, 0x26, 0x23, 0x4f, 0x63, 0xd5, 0x69, 0x42, 0x9a, 0x1e, 0x37, 0x97, 0xb5,
	0x12, 0x1c, 0x3c, 0xba, 0xe4, 0xc5, 0x66, 0x7b, 0x11, 0xdb, 0x6c, 0xb7, 0x4c, 0xa5, 0x95, 0x14,
	0xcb, 0x27, 0x9b, 0x39, 0x15, 0x0b, 0x31, 0x2a, 0x7e, 0x05, 0x1b, 0x09, 0x0d, 0x54, 0x85, 0x52,
	0xff, 0xe5, 0x49, 0xaf, 0xa7, 0xb7, 0xeb, 0x2b, 0x68, 0x1d, 0x2a, 0x72, 0xe3, 0xe8, 0xed, 0xba,
	0x82, 0xd6, 0xa0, 0x8c, 0xf5, 0xbe, 0x8e, 0xbf, 0xd6, 0xdb, 0xf5, 0x1c, 0xdf, 0x8b, 0x47, 0xda,
	0x09, 0xef, 0xc9, 0xab, 0x3f, 0x86, 0xed, 0x70, 0x82, 0x97, 0xd6, 0xd8, 0xa3, 0xb1, 0xea, 0xbd,
	0x09, 0x25, 0x53, 0xc8, 0x99, 0xf4, 0x4c, 0xd0, 0x54, 0xa7, 0xf0, 0x71, 0xa6, 0x9e, 0x7c, 0xc0,
	0x6d, 0x42, 0x89, 0x79, 0xa6, 0x49, 0x98, 0xaf, 0x58, 0xc6, 0x41, 0x93, 0x97, 0x9f, 0xce, 0x64,
	0xe4, 0x6b, 0x05, 0x77, 0xb8, 0x50, 0xb0, 0x70, 0xeb, 0xfd, 0x4b, 0x81, 0xaa, 0x7e, 0x4d, 0x6c,
	0x17, 0x13, 0xd3, 0xa1, 0x23, 0xf4, 0x19, 0x14, 0x5c, 0x7e, 0x18, 0xfb, 0xcf, 0xc3, 0x01, 0x55,
	0x23, 0x88, 0x96, 0x38, 0x8d, 0x05, 0x88, 0xef, 0x33, 0xe7, 0x82, 0x27, 0x8d, 0x90, 0x64, 0x61,
	0x9b, 0x4f, 0x54, 0xdc, 0x0c, 0xc2, 0xf2, 0x26, 0x68, 0x2e, 0x72, 0xfd, 0xe2, 0x03, 0x5d, 0xd4,
	0xb5, 0xc1, 0x83, 0x59, 0xc7, 0xb0, 0x1d, 0x79, 0xc1, 0x8b, 0x0b, 0xd5, 0x27, 0x50, 0x10, 0x85,
	0x41, 0x15, 0x4a, 0x58, 0x7f, 0x35, 0xd4, 0xfb, 0x83, 0xfa, 0x0a, 0x2a, 0x41, 0x5e, 0xeb, 0xf5,
	0xea, 0x0a, 0x2a, 0x43, 0x41, 0x64, 0xc5, 0x1c, 0xaa, 0x40, 0xf1, 0xd5, 0x50, 0x1f, 0xea, 0xf5,
	0xfc, 0x0f, 0xc7, 0xb0, 0x91, 0xa8, 0x33, 0xd0, 0x26, 0xac, 0xf7, 0x07, 0x5d, 0x1e, 0xed, 0xf3,
	0x83, 0x6f, 0xce, 0xf1, 0x59, 0x7d, 0x85, 0x1b, 0x1c, 0x9c, 0x9c, 0xe9, 0xdd, 0xe1, 0xa0, 0xae,
	0xa0, 0x6d, 0xb8, 0xdb, 0xc3, 0xba, 0x7e, 0xd6, 0x1b, 0xf8, 0x88, 0x80, 0x0d, 0xd8, 0x4f, 0xaf,
	0xbd, 0x53, 0xed, 0x50, 0x3f, 0xee, 0x9e, 0xb6, 0x75, 0x7c, 0x8e, 0x75, 0xd1, 0x6a, 0xd7, 0xf3,
	0xfb, 0x7f, 0x56, 0xa0, 0x32, 0x7f, 0x9c, 0x7c, 0x03, 0xf7, 0x16, 0xfc, 0x63, 0x41, 0x0f, 0xc3,
	0xc3, 0xe7, 0x7d, 0x7f, 0x7d, 0xb6, 0x77, 0x6f, 0x83, 0xc9, 0x5f, 0x35, 0x2b, 0xe8, 0x39, 0xac,
	0xfa, 0x7c, 0x42, 0x5b, 0x89, 0xb7, 0x7e, 0xdf, 0xd2, 0x9d, 0xcc, 0x3f, 0x00, 0xea, 0xca, 0x9e,
	0xf2, 0xb9, 0xf2, 0xec, 0x39, 0x54, 0x98, 0x75, 0xce, 0x88, 0x49, 0x89, 0x8b, 0xfe, 0xaf, 0xe5,
	0xff, 0xae, 0x6a, 0x05, 0xbf, 0xab, 0x5a, 0x47, 0x16, 0x99, 0x8c, 0xba, 0x33, 0x3f, 0xb9, 0xfd,
	0xae, 0xec, 0x67, 0x5a, 0xc6, 0xaf, 0xd8, 0x94, 0xb8, 0x07, 0x85, 0x5f, 0xe4, 0x98, 0x75, 0xb1,
	0x2a, 0xd0, 0x3f, 0xfa, 0x77, 0x00, 0x00, 0x00, 0xff, 0xff, 0xab, 0x5b, 0xe8, 0x94, 0x24, 0x1b,
	0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// SchedulerClient is the client API for Scheduler service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SchedulerClient interface {
	// Register a RM, if it is a reconnect from previous RM the call will
	// trigger a cleanup of all in-memory data and resync with RM.
	RegisterResourceManager(ctx context.Context, in *RegisterResourceManagerRequest, opts ...grpc.CallOption) (*RegisterResourceManagerResponse, error)
	// Update Scheduler status (this includes node status update, allocation request
	// updates, etc. And receive updates from scheduler for allocation changes,
	// any required status changes, etc.
	Update(ctx context.Context, opts ...grpc.CallOption) (Scheduler_UpdateClient, error)
}

type schedulerClient struct {
	cc *grpc.ClientConn
}

func NewSchedulerClient(cc *grpc.ClientConn) SchedulerClient {
	return &schedulerClient{cc}
}

func (c *schedulerClient) RegisterResourceManager(ctx context.Context, in *RegisterResourceManagerRequest, opts ...grpc.CallOption) (*RegisterResourceManagerResponse, error) {
	out := new(RegisterResourceManagerResponse)
	err := c.cc.Invoke(ctx, "/si.v1.Scheduler/RegisterResourceManager", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *schedulerClient) Update(ctx context.Context, opts ...grpc.CallOption) (Scheduler_UpdateClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Scheduler_serviceDesc.Streams[0], "/si.v1.Scheduler/Update", opts...)
	if err != nil {
		return nil, err
	}
	x := &schedulerUpdateClient{stream}
	return x, nil
}

type Scheduler_UpdateClient interface {
	Send(*UpdateRequest) error
	Recv() (*UpdateResponse, error)
	grpc.ClientStream
}

type schedulerUpdateClient struct {
	grpc.ClientStream
}

func (x *schedulerUpdateClient) Send(m *UpdateRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *schedulerUpdateClient) Recv() (*UpdateResponse, error) {
	m := new(UpdateResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// SchedulerServer is the server API for Scheduler service.
type SchedulerServer interface {
	// Register a RM, if it is a reconnect from previous RM the call will
	// trigger a cleanup of all in-memory data and resync with RM.
	RegisterResourceManager(context.Context, *RegisterResourceManagerRequest) (*RegisterResourceManagerResponse, error)
	// Update Scheduler status (this includes node status update, allocation request
	// updates, etc. And receive updates from scheduler for allocation changes,
	// any required status changes, etc.
	Update(Scheduler_UpdateServer) error
}

// UnimplementedSchedulerServer can be embedded to have forward compatible implementations.
type UnimplementedSchedulerServer struct {
}

func (*UnimplementedSchedulerServer) RegisterResourceManager(ctx context.Context, req *RegisterResourceManagerRequest) (*RegisterResourceManagerResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RegisterResourceManager not implemented")
}
func (*UnimplementedSchedulerServer) Update(srv Scheduler_UpdateServer) error {
	return status.Errorf(codes.Unimplemented, "method Update not implemented")
}

func RegisterSchedulerServer(s *grpc.Server, srv SchedulerServer) {
	s.RegisterService(&_Scheduler_serviceDesc, srv)
}

func _Scheduler_RegisterResourceManager_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RegisterResourceManagerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SchedulerServer).RegisterResourceManager(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/si.v1.Scheduler/RegisterResourceManager",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SchedulerServer).RegisterResourceManager(ctx, req.(*RegisterResourceManagerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Scheduler_Update_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(SchedulerServer).Update(&schedulerUpdateServer{stream})
}

type Scheduler_UpdateServer interface {
	Send(*UpdateResponse) error
	Recv() (*UpdateRequest, error)
	grpc.ServerStream
}

type schedulerUpdateServer struct {
	grpc.ServerStream
}

func (x *schedulerUpdateServer) Send(m *UpdateResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *schedulerUpdateServer) Recv() (*UpdateRequest, error) {
	m := new(UpdateRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _Scheduler_serviceDesc = grpc.ServiceDesc{
	ServiceName: "si.v1.Scheduler",
	HandlerType: (*SchedulerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "RegisterResourceManager",
			Handler:    _Scheduler_RegisterResourceManager_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Update",
			Handler:       _Scheduler_Update_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "incubator-yunikorn-scheduler-interface/si.proto",
}
