@rem
@rem Copyright 2015 the original author or authors.
@rem
@rem Licensed under the Apache License, Version 2.0 (the "License");
@rem you may not use this file except in compliance with the License.
@rem You may obtain a copy of the License at
@rem
@rem      https://www.apache.org/licenses/LICENSE-2.0
@rem
@rem Unless required by applicable law or agreed to in writing, software
@rem distributed under the License is distributed on an "AS IS" BASIS,
@rem WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
@rem See the License for the specific language governing permissions and
@rem limitations under the License.
@rem

@if "%DEBUG%"=="" @echo off
@rem ##########################################################################
@rem
@rem  eth-faucet startup script for Windows
@rem
@rem ##########################################################################

@rem Set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" setlocal

set DIRNAME=%~dp0
if "%DIRNAME%"=="" set DIRNAME=.
set APP_BASE_NAME=%~n0
set APP_HOME=%DIRNAME%..

@rem Resolve any "." and ".." in APP_HOME to make it shorter.
for %%i in ("%APP_HOME%") do set APP_HOME=%%~fi

@rem Add default JVM options here. You can also use JAVA_OPTS and ETH_FAUCET_OPTS to pass JVM options to this script.
set DEFAULT_JVM_OPTS=

@rem Find java.exe
if defined JAVA_HOME goto findJavaFromJavaHome

set JAVA_EXE=java.exe
%JAVA_EXE% -version >NUL 2>&1
if %ERRORLEVEL% equ 0 goto execute

echo.
echo ERROR: JAVA_HOME is not set and no 'java' command could be found in your PATH.
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:findJavaFromJavaHome
set JAVA_HOME=%JAVA_HOME:"=%
set JAVA_EXE=%JAVA_HOME%/bin/java.exe

if exist "%JAVA_EXE%" goto execute

echo.
echo ERROR: JAVA_HOME is set to an invalid directory: %JAVA_HOME%
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:execute
@rem Setup the command line

set CLASSPATH=%APP_HOME%\lib\tuweni-eth-faucet-2.3.1.jar;%APP_HOME%\lib\jackson-module-kotlin-2.11.4.jar;%APP_HOME%\lib\webjars-locator-0.40.jar;%APP_HOME%\lib\tuweni-wallet-2.3.1.jar;%APP_HOME%\lib\tuweni-jsonrpc-2.3.1.jar;%APP_HOME%\lib\tuweni-eth-2.3.1.jar;%APP_HOME%\lib\spring-boot-starter-webflux-2.4.3.jar;%APP_HOME%\lib\spring-boot-starter-web-2.4.3.jar;%APP_HOME%\lib\spring-boot-starter-json-2.4.3.jar;%APP_HOME%\lib\jackson-datatype-jdk8-2.11.4.jar;%APP_HOME%\lib\jackson-datatype-jsr310-2.11.4.jar;%APP_HOME%\lib\jackson-module-parameter-names-2.11.4.jar;%APP_HOME%\lib\jackson-databind-2.13.3.jar;%APP_HOME%\lib\vertx-lang-kotlin-4.1.2.jar;%APP_HOME%\lib\vertx-lang-kotlin-coroutines-4.1.2.jar;%APP_HOME%\lib\vertx-web-4.1.2.jar;%APP_HOME%\lib\vertx-web-client-4.1.2.jar;%APP_HOME%\lib\vertx-web-common-4.1.2.jar;%APP_HOME%\lib\vertx-auth-common-4.1.2.jar;%APP_HOME%\lib\vertx-bridge-common-4.1.2.jar;%APP_HOME%\lib\vertx-core-4.1.2.jar;%APP_HOME%\lib\bcprov-jdk15on-1.66.jar;%APP_HOME%\lib\tuweni-merkle-trie-2.3.1.jar;%APP_HOME%\lib\tuweni-kv-2.3.1.jar;%APP_HOME%\lib\tuweni-concurrent-coroutines-2.3.1.jar;%APP_HOME%\lib\kotlinx-coroutines-jdk8-1.6.0.jar;%APP_HOME%\lib\kotlin-reflect-1.6.10.jar;%APP_HOME%\lib\tuweni-net-2.3.1.jar;%APP_HOME%\lib\tuweni-crypto-2.3.1.jar;%APP_HOME%\lib\tuweni-units-2.3.1.jar;%APP_HOME%\lib\tuweni-rlp-2.3.1.jar;%APP_HOME%\lib\tuweni-bytes-2.3.1.jar;%APP_HOME%\lib\tuweni-concurrent-2.3.1.jar;%APP_HOME%\lib\tuweni-app-commons-2.3.1.jar;%APP_HOME%\lib\tuweni-io-2.3.1.jar;%APP_HOME%\lib\kotlin-stdlib-jdk8-1.6.10.jar;%APP_HOME%\lib\spring-boot-starter-thymeleaf-2.4.1.jar;%APP_HOME%\lib\spring-boot-starter-security-2.4.3.jar;%APP_HOME%\lib\spring-boot-starter-oauth2-client-2.4.3.jar;%APP_HOME%\lib\spring-boot-starter-2.4.3.jar;%APP_HOME%\lib\bootstrap-4.1.3.jar;%APP_HOME%\lib\spring-boot-starter-logging-2.4.3.jar;%APP_HOME%\lib\logback-classic-1.2.3.jar;%APP_HOME%\lib\jackson-annotations-2.11.4.jar;%APP_HOME%\lib\webjars-locator-core-0.46.jar;%APP_HOME%\lib\jackson-core-2.11.4.jar;%APP_HOME%\lib\spring-boot-starter-reactor-netty-2.4.3.jar;%APP_HOME%\lib\reactor-netty-http-1.0.4.jar;%APP_HOME%\lib\reactor-netty-core-1.0.4.jar;%APP_HOME%\lib\netty-handler-proxy-4.1.59.Final.jar;%APP_HOME%\lib\netty-codec-http2-4.1.59.Final.jar;%APP_HOME%\lib\netty-codec-http-4.1.59.Final.jar;%APP_HOME%\lib\netty-resolver-dns-native-macos-4.1.59.Final-osx-x86_64.jar;%APP_HOME%\lib\netty-resolver-dns-4.1.59.Final.jar;%APP_HOME%\lib\netty-handler-4.1.59.Final.jar;%APP_HOME%\lib\netty-codec-socks-4.1.59.Final.jar;%APP_HOME%\lib\netty-codec-dns-4.1.59.Final.jar;%APP_HOME%\lib\netty-codec-4.1.59.Final.jar;%APP_HOME%\lib\netty-transport-native-epoll-4.1.59.Final-linux-x86_64.jar;%APP_HOME%\lib\netty-transport-native-unix-common-4.1.59.Final.jar;%APP_HOME%\lib\netty-transport-4.1.59.Final.jar;%APP_HOME%\lib\netty-buffer-4.1.59.Final.jar;%APP_HOME%\lib\netty-resolver-4.1.59.Final.jar;%APP_HOME%\lib\netty-common-4.1.59.Final.jar;%APP_HOME%\lib\spring-webflux-5.3.4.jar;%APP_HOME%\lib\spring-webmvc-5.3.4.jar;%APP_HOME%\lib\spring-security-oauth2-client-5.4.5.jar;%APP_HOME%\lib\spring-security-web-5.4.5.jar;%APP_HOME%\lib\spring-security-oauth2-jose-5.4.5.jar;%APP_HOME%\lib\spring-security-oauth2-core-5.4.5.jar;%APP_HOME%\lib\spring-web-5.3.4.jar;%APP_HOME%\lib\kotlinx-coroutines-core-jvm-1.4.2.jar;%APP_HOME%\lib\kotlin-stdlib-jdk7-1.6.10.jar;%APP_HOME%\lib\kotlin-stdlib-1.6.20.jar;%APP_HOME%\lib\thymeleaf-spring5-3.0.12.RELEASE.jar;%APP_HOME%\lib\thymeleaf-extras-java8time-3.0.4.RELEASE.jar;%APP_HOME%\lib\spring-boot-autoconfigure-2.4.3.jar;%APP_HOME%\lib\spring-boot-2.4.3.jar;%APP_HOME%\lib\spring-boot-starter-tomcat-2.4.3.jar;%APP_HOME%\lib\jakarta.annotation-api-1.3.5.jar;%APP_HOME%\lib\spring-security-config-5.4.5.jar;%APP_HOME%\lib\spring-security-core-5.4.5.jar;%APP_HOME%\lib\spring-context-5.3.4.jar;%APP_HOME%\lib\spring-aop-5.3.4.jar;%APP_HOME%\lib\spring-beans-5.3.4.jar;%APP_HOME%\lib\spring-expression-5.3.4.jar;%APP_HOME%\lib\spring-core-5.3.4.jar;%APP_HOME%\lib\snakeyaml-1.27.jar;%APP_HOME%\lib\jakarta.mail-1.6.5.jar;%APP_HOME%\lib\jquery-3.0.0.jar;%APP_HOME%\lib\popper.js-1.14.3.jar;%APP_HOME%\lib\commons-lang3-3.11.jar;%APP_HOME%\lib\concurrency-limits-core-0.3.6.jar;%APP_HOME%\lib\thymeleaf-3.0.12.RELEASE.jar;%APP_HOME%\lib\log4j-to-slf4j-2.13.3.jar;%APP_HOME%\lib\jul-to-slf4j-1.7.30.jar;%APP_HOME%\lib\slf4j-api-1.7.30.jar;%APP_HOME%\lib\framework-1.3.2.jar;%APP_HOME%\lib\framework-internal-1.3.2.jar;%APP_HOME%\lib\guava-31.0.1-jre.jar;%APP_HOME%\lib\jsr305-3.0.2.jar;%APP_HOME%\lib\error_prone_annotations-2.15.0.jar;%APP_HOME%\lib\opentelemetry-sdk-metrics-1.2.0-alpha.jar;%APP_HOME%\lib\opentelemetry-api-metrics-1.2.0-alpha.jar;%APP_HOME%\lib\logback-core-1.2.3.jar;%APP_HOME%\lib\reactor-core-3.4.3.jar;%APP_HOME%\lib\kotlin-stdlib-common-1.6.10.jar;%APP_HOME%\lib\annotations-16.0.3.jar;%APP_HOME%\lib\spring-jcl-5.3.4.jar;%APP_HOME%\lib\tomcat-embed-websocket-9.0.43.jar;%APP_HOME%\lib\tomcat-embed-core-9.0.43.jar;%APP_HOME%\lib\jakarta.el-3.0.3.jar;%APP_HOME%\lib\jakarta.activation-1.2.2.jar;%APP_HOME%\lib\oauth2-oidc-sdk-8.36.jar;%APP_HOME%\lib\nimbus-jose-jwt-8.20.2.jar;%APP_HOME%\lib\classgraph-4.8.69.jar;%APP_HOME%\lib\jnr-ffi-2.1.9.jar;%APP_HOME%\lib\opentelemetry-sdk-common-1.2.0.jar;%APP_HOME%\lib\opentelemetry-semconv-1.2.0-alpha.jar;%APP_HOME%\lib\opentelemetry-api-1.2.0.jar;%APP_HOME%\lib\javax.persistence-api-2.2.jar;%APP_HOME%\lib\commons-net-3.8.0.jar;%APP_HOME%\lib\reactive-streams-1.0.3.jar;%APP_HOME%\lib\attoparser-2.0.5.RELEASE.jar;%APP_HOME%\lib\unbescape-1.1.6.RELEASE.jar;%APP_HOME%\lib\log4j-api-2.13.3.jar;%APP_HOME%\lib\jcip-annotations-1.0-1.jar;%APP_HOME%\lib\content-type-2.1.jar;%APP_HOME%\lib\json-smart-2.3.jar;%APP_HOME%\lib\lang-tag-1.4.4.jar;%APP_HOME%\lib\commons-codec-1.14.jar;%APP_HOME%\lib\jffi-1.2.17.jar;%APP_HOME%\lib\jffi-1.2.17-native.jar;%APP_HOME%\lib\asm-commons-5.0.3.jar;%APP_HOME%\lib\asm-analysis-5.0.3.jar;%APP_HOME%\lib\asm-util-5.0.3.jar;%APP_HOME%\lib\asm-tree-5.0.3.jar;%APP_HOME%\lib\accessors-smart-1.2.jar;%APP_HOME%\lib\asm-5.0.4.jar;%APP_HOME%\lib\jnr-a64asm-1.0.0.jar;%APP_HOME%\lib\jnr-x86asm-1.0.2.jar;%APP_HOME%\lib\failureaccess-1.0.1.jar;%APP_HOME%\lib\listenablefuture-9999.0-empty-to-avoid-conflict-with-guava.jar;%APP_HOME%\lib\checker-qual-3.12.0.jar;%APP_HOME%\lib\j2objc-annotations-1.3.jar;%APP_HOME%\lib\opentelemetry-context-1.2.0.jar


@rem Execute eth-faucet
"%JAVA_EXE%" %DEFAULT_JVM_OPTS% %JAVA_OPTS% %ETH_FAUCET_OPTS%  -classpath "%CLASSPATH%" org.apache.tuweni.faucet.FaucetApplicationKt %*

:end
@rem End local scope for the variables with windows NT shell
if %ERRORLEVEL% equ 0 goto mainEnd

:fail
rem Set variable ETH_FAUCET_EXIT_CONSOLE if you need the _script_ return code instead of
rem the _cmd.exe /c_ return code!
set EXIT_CODE=%ERRORLEVEL%
if %EXIT_CODE% equ 0 set EXIT_CODE=1
if not ""=="%ETH_FAUCET_EXIT_CONSOLE%" exit %EXIT_CODE%
exit /b %EXIT_CODE%

:mainEnd
if "%OS%"=="Windows_NT" endlocal

:omega
